/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt;

import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.ItemSelectable;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import symantec.itools.awt.CompareCells;
import symantec.itools.awt.Matrix;
import symantec.itools.awt.MatrixEnumeration;
import symantec.itools.awt.multiList.Cell;
import symantec.itools.awt.multiList.CompareTextAndImageCells;
import symantec.itools.awt.multiList.TextAndImageCell;
import symantec.itools.beans.PropertyChangeSupport;
import symantec.itools.beans.VetoableChangeSupport;
import symantec.itools.lang.OS;
import symantec.itools.util.GeneralUtils;

public class MultiList
extends Panel
implements Serializable,
ItemSelectable {
    public static final long CLICKTHRESHOLD = 250L;
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    protected static final int BORDER = 1;
    protected static final int RESIZE_FUDGE_FACTOR = 3;
    static Color thirtyThreePercentGray = new Color(0x212121);
    static Color sixtySixPercentGray = new Color(0x434343);
    protected Color colorBg = Color.white;
    protected Color colorFg = Color.black;
    protected Color colorHBg = OS.isMacintosh() ? new Color(0, 0, 128) : SystemColor.textHighlight;
    protected Color colorHFg = OS.isMacintosh() ? Color.white : SystemColor.textHighlightText;
    protected Color headingBg = Color.lightGray;
    protected Color headingFg = Color.black;
    protected boolean allowSorting = true;
    protected boolean focusIndicatedVisually = true;
    protected boolean multiSelect = false;
    protected boolean allowResizingOfColumns = true;
    protected String[] headings;
    protected boolean headingVisible = true;
    protected int headingHeight;
    protected Font headingFont;
    protected int[] splitters;
    protected int[] columnAlignments;
    protected int defaultColumnAlignment = 0;
    protected int[] columnSizes;
    protected int columnClicked = -1;
    protected int lastColumnClicked = -1;
    protected int memoryClick = -1;
    protected int selectedRow = -1;
    protected BitSet highlightedRows = new BitSet();
    protected Matrix cells = new Matrix();
    protected Font cellFont;
    protected int cellHeight;
    protected int cellAscent;
    protected int cellDescent;
    protected int topRow;
    protected int cachedHeight = -1;
    protected int cachedWidth = -1;
    protected int cachedLastSplitter = -1;
    protected int dragColumn = -1;
    protected int xDragLast = -1;
    protected int sbVPosition;
    protected int sbHPosition;
    protected int verticalScrollbarWidth;
    protected int scrollbarHeight;
    protected int hScrollbarLineIncrement = 4;
    protected int minColumnWidth = 10;
    protected transient long clickTime;
    protected String actionCommand = "RowSelected:";
    protected Scrollbar verticalScrollbar;
    protected Scrollbar horizontalScrollbar;
    protected CompareCells defaultColumnSorter = new CompareTextAndImageCells();
    protected Hashtable columnCompareCellsRoutines = new Hashtable();
    protected ActionListener actionListener;
    protected ItemListener itemListener;
    protected FocusListener focusListener;
    private Mouse mouse;
    private MouseMotion mouseMotion;
    private Key key;
    private Focus focus;
    private Adjustment adjustment;
    private VetoableChangeSupport vetos = new VetoableChangeSupport(this);
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);
    protected transient boolean isDragging = false;
    protected transient boolean clickedInHeadings = false;
    protected transient boolean sbVShow = false;
    protected transient boolean sbHShow = false;
    protected transient boolean forceRedraw = false;
    protected transient boolean forceColumnSizeRecalc = false;
    protected transient boolean forceFullRedraw = false;
    protected transient boolean isSuppressRedraw = false;
    protected transient boolean redrawWasSupressed = false;
    protected transient boolean hasFocus = false;
    protected transient Image offscreenImage;
    protected transient Graphics offscreenImageGraphics;
    protected static transient boolean isSun1_1;

    public MultiList() {
        this(0, false, Color.white);
    }

    public MultiList(int cols) {
        this(cols, false, Color.white);
    }

    public MultiList(int cols, boolean multi) {
        this(cols, multi, Color.white);
    }

    public MultiList(int cols, boolean multi, Color bg) {
        this.internalCreateColumns(cols);
        this.multiSelect = multi;
        super.setLayout(null);
        Font defaultFont = new Font("Helvetica", 0, 12);
        try {
            this.setHeadingFont(defaultFont);
            this.setCellFont(defaultFont);
        }
        catch (PropertyVetoException propertyVetoException) {}
        this.colorBg = bg;
        this.setBackground(this.colorBg);
        this.verticalScrollbar = new Scrollbar(1);
        this.verticalScrollbar.hide();
        this.add(this.verticalScrollbar);
        this.horizontalScrollbar = new Scrollbar(0);
        this.horizontalScrollbar.hide();
        this.add(this.horizontalScrollbar);
    }

    public void setMultipleMode(boolean b) throws PropertyVetoException {
        if (this.multiSelect != b) {
            Boolean oldValue = new Boolean(this.multiSelect);
            Boolean newValue = new Boolean(b);
            this.vetos.fireVetoableChange("multipleMode", oldValue, newValue);
            this.multiSelect = b;
            if (!this.multiSelect) {
                int[] selectedRows = this.getSelectedRows();
                int i = 1;
                while (i < selectedRows.length) {
                    this.deselectRow(selectedRows[i]);
                    ++i;
                }
            }
            this.changes.firePropertyChange("multipleMode", oldValue, newValue);
        }
    }

    public boolean isMultipleMode() {
        return this.multiSelect;
    }

    public void setFocusIndicatedVisually(boolean b) throws PropertyVetoException {
        if (this.focusIndicatedVisually != b) {
            Boolean oldValue = new Boolean(this.focusIndicatedVisually);
            Boolean newValue = new Boolean(b);
            this.vetos.fireVetoableChange("focusIndicatedVisually", oldValue, newValue);
            this.focusIndicatedVisually = b;
            this.changes.firePropertyChange("focusIndicatedVisually", oldValue, newValue);
            this.repaintFocus();
        }
    }

    public boolean isFocusIndicatedVisually() {
        return this.focusIndicatedVisually;
    }

    public void setNumberOfCols(int i) throws PropertyVetoException {
        Integer newValue;
        Integer oldValue = new Integer(this.getNumberOfCols());
        if (!oldValue.equals(newValue = new Integer(i))) {
            this.vetos.fireVetoableChange("numberOfCols", oldValue, newValue);
            this.internalCreateColumns(0);
            this.resizeHeadings(i);
            this.forceColumnSizeRecalc = true;
            this.changes.firePropertyChange("numberOfCols", oldValue, newValue);
            this.triggerRedraw();
        }
    }

    public void setColumns(int i) throws PropertyVetoException {
        this.setNumberOfCols(i);
    }

    public int getNumberOfCols() {
        return this.headings.length;
    }

    public int getNumberOfRows() {
        return this.cells.rows();
    }

    public void setHeadingVisible(boolean b) throws PropertyVetoException {
        if (this.headingVisible != b) {
            Boolean oldValue = new Boolean(this.headingVisible);
            Boolean newValue = new Boolean(b);
            this.vetos.fireVetoableChange("headingVisible", oldValue, newValue);
            this.headingVisible = b;
            this.changes.firePropertyChange("headingVisible", oldValue, newValue);
            if (this.headingVisible) {
                this.calculateHeadingHeight();
            } else {
                this.headingHeight = 0;
            }
            this.forceFullRedraw = true;
            this.triggerRedraw();
        }
    }

    public boolean isHeadingVisible() {
        return this.headingVisible;
    }

    public String getHeading(int i) {
        return this.headings[i];
    }

    public void setHeading(String h, int i) throws PropertyVetoException {
        String oldValue = this.headings[i];
        if (!GeneralUtils.objectsEqual(oldValue, h)) {
            String newValue = h;
            this.vetos.fireVetoableChange("heading", oldValue, newValue);
            this.headings[i] = h;
            this.changes.firePropertyChange("heading", oldValue, newValue);
            this.triggerRedraw();
        }
    }

    public void setHeading(String h, int i, int pixels) throws PropertyVetoException {
        String oldValue = this.headings[i];
        if (!GeneralUtils.objectsEqual(oldValue, h)) {
            String newValue = h;
            this.vetos.fireVetoableChange("heading", oldValue, newValue);
            this.headings[i] = h;
            this.splitters[i + 1] = pixels;
            if (this.columnSizes == null) {
                this.columnSizes = new int[this.headings.length];
            }
            int j = 0;
            while (j < this.headings.length) {
                this.columnSizes[j] = this.splitters[j + 1] - this.splitters[j];
                ++j;
            }
            this.changes.firePropertyChange("heading", oldValue, newValue);
            this.triggerRedraw();
        }
    }

    public String[] getHeadings() {
        return this.headings;
    }

    public void setHeadings(String[] list) throws PropertyVetoException {
        boolean wasSuppressingRedraw = this.setSupressRedraw(true);
        try {
            list = this.tokenizeStringArrayIfNeeded(list);
            String[] oldValue = this.getHeadings();
            this.vetos.fireVetoableChange("headings", oldValue, list);
            if (list.length == 0) {
                this.internalCreateColumns(0);
            } else {
                this.calcHeadings(list);
            }
            this.changes.firePropertyChange("headings", oldValue, list);
        }
        finally {
            Object var4_4 = null;
            this.forceColumnSizeRecalc = true;
            this.triggerRedraw();
            this.setSupressRedraw(wasSuppressingRedraw);
        }
    }

    public Font getHeadingFont() {
        return this.headingFont;
    }

    public void setHeadingFont(Font newFont) throws PropertyVetoException {
        if (!GeneralUtils.objectsEqual(this.headingFont, newFont)) {
            Font oldValue = this.getHeadingFont();
            this.vetos.fireVetoableChange("headingFont", oldValue, newFont);
            this.headingFont = newFont;
            this.changes.firePropertyChange("headingFont", oldValue, newFont);
            if (this.headingVisible) {
                this.calculateHeadingHeight();
                this.triggerRedraw();
            }
        }
    }

    public Font getCellFont() {
        return this.cellFont;
    }

    public void setCellFont(Font f) throws PropertyVetoException {
        if (!GeneralUtils.objectsEqual(this.cellFont, f)) {
            Font oldValue = this.cellFont;
            this.vetos.fireVetoableChange("cellFont", oldValue, f);
            this.cellFont = f;
            FontMetrics fontMetrics = this.getFontMetrics(f);
            this.cellAscent = fontMetrics.getAscent();
            this.cellDescent = fontMetrics.getDescent();
            this.cellHeight = fontMetrics.getHeight();
            this.changes.firePropertyChange("cellFont", oldValue, f);
            this.triggerRedraw();
        }
    }

    public void setHeadingColors(Color fg, Color bg) throws PropertyVetoException {
        boolean wasSupressingRedraw = this.setSupressRedraw(true);
        try {
            this.setHeadingFg(fg);
            this.setHeadingBg(bg);
        }
        finally {
            Object var5_4 = null;
            this.triggerRedraw();
            this.setSupressRedraw(wasSupressingRedraw);
        }
    }

    public Color getHeadingFg() {
        return this.headingFg;
    }

    public void setHeadingFg(Color c) throws PropertyVetoException {
        if (!GeneralUtils.objectsEqual(this.headingFg, c)) {
            Color oldValue = this.headingFg;
            this.vetos.fireVetoableChange("headingFg", oldValue, c);
            this.headingFg = c;
            this.changes.firePropertyChange("headingFg", oldValue, c);
            this.triggerRedraw();
        }
    }

    public Color getHeadingBg() {
        return this.headingBg;
    }

    public void setHeadingBg(Color c) throws PropertyVetoException {
        if (!GeneralUtils.objectsEqual(this.headingBg, c)) {
            Color oldValue = this.headingBg;
            this.vetos.fireVetoableChange("headingBg", oldValue, c);
            this.headingBg = c;
            this.changes.firePropertyChange("headingBg", oldValue, c);
            this.triggerRedraw();
        }
    }

    public void setCellColors(Color fg, Color bg) throws PropertyVetoException {
        boolean wasSupressingRedraw = this.setSupressRedraw(true);
        try {
            this.setCellFg(fg);
            this.setCellBg(bg);
        }
        finally {
            Object var5_4 = null;
            this.triggerRedraw();
            this.setSupressRedraw(wasSupressingRedraw);
        }
    }

    public Color getCellFg() {
        return this.colorFg;
    }

    public void setCellFg(Color c) throws PropertyVetoException {
        if (!GeneralUtils.objectsEqual(this.colorFg, c)) {
            Color oldValue = this.colorFg;
            this.vetos.fireVetoableChange("cellFg", oldValue, c);
            this.colorFg = c;
            this.changes.firePropertyChange("cellFg", oldValue, c);
            this.triggerRedraw();
        }
    }

    public void setCellBg(Color c) throws PropertyVetoException {
        if (!GeneralUtils.objectsEqual(this.colorBg, c)) {
            Color oldValue = this.colorBg;
            this.vetos.fireVetoableChange("cellBg", oldValue, c);
            this.colorBg = c;
            this.changes.firePropertyChange("cellBg", oldValue, c);
            this.triggerRedraw();
        }
    }

    public Color getCellBg() {
        return this.colorBg;
    }

    public void setColumnAlignments(String[] list) throws PropertyVetoException {
        if (list != null && list.length == 0) {
            list = null;
        }
        list = this.tokenizeStringArrayIfNeeded(list);
        String[] oldValue = this.getColumnAlignments();
        this.vetos.fireVetoableChange("columnAlignments", oldValue, list);
        if (list != null) {
            this.columnAlignments = new int[list.length];
            int i = 0;
            while (i < list.length) {
                String listElem = list[i];
                int alignment = this.defaultColumnAlignment;
                if (listElem != null) {
                    if (listElem.equalsIgnoreCase("Left")) {
                        alignment = 0;
                    } else if (listElem.equalsIgnoreCase("Center")) {
                        alignment = 1;
                    } else if (listElem.equalsIgnoreCase("Right")) {
                        alignment = 2;
                    }
                }
                this.columnAlignments[i] = alignment;
                ++i;
            }
        } else {
            this.columnAlignments = null;
        }
        this.changes.firePropertyChange("columnAlignments", oldValue, list);
        this.triggerRedraw();
    }

    public String[] getColumnAlignments() {
        if (this.columnAlignments == null) {
            return null;
        }
        String[] list = new String[this.columnAlignments.length];
        int i = 0;
        while (i < list.length) {
            String alignString;
            switch (this.getColumnAlignment(i)) {
                default: {
                    alignString = "Left";
                    break;
                }
                case 1: {
                    alignString = "Center";
                    break;
                }
                case 2: {
                    alignString = "Right";
                }
            }
            list[i] = alignString;
            ++i;
        }
        return list;
    }

    public void setColumnAlignment(int column, int alignment) throws PropertyVetoException {
        this.rangeCheckAlignment(alignment);
        this.rangeCheckColumn(column);
        Integer oldValue = new Integer(this.getColumnAlignment(column));
        Integer newValue = new Integer(alignment);
        this.vetos.fireVetoableChange("columnAlignment", oldValue, newValue);
        if (this.columnAlignments == null) {
            this.columnAlignments = new int[this.headings.length];
            int i = 0;
            while (i < this.headings.length) {
                this.columnAlignments[i] = -1;
                ++i;
            }
        }
        this.columnAlignments[column] = alignment;
        this.changes.firePropertyChange("columnAlignment", oldValue, newValue);
        this.triggerRedraw();
    }

    public int getColumnAlignment(int column) {
        int columnAlignment;
        if (this.columnAlignments != null && column < this.columnAlignments.length && (columnAlignment = this.columnAlignments[column]) != -1) {
            return this.columnAlignments[column];
        }
        return this.getDefaultColumnAlignment();
    }

    public int getDefaultColumnAlignment() {
        return this.defaultColumnAlignment;
    }

    public void setDefaultColumnAlignment(int newDefaultColumnAlignment) throws PropertyVetoException {
        this.rangeCheckAlignment(newDefaultColumnAlignment);
        if (this.defaultColumnAlignment != newDefaultColumnAlignment) {
            Integer oldValue = new Integer(this.defaultColumnAlignment);
            Integer newValue = new Integer(newDefaultColumnAlignment);
            this.vetos.fireVetoableChange("defaultColumnAlignment", oldValue, newValue);
            this.defaultColumnAlignment = newDefaultColumnAlignment;
            this.changes.firePropertyChange("defaultColumnAlignment", oldValue, newValue);
            this.triggerRedraw();
        }
    }

    public void setColumnSizes(String[] list) throws PropertyVetoException {
        boolean wasSuppressingRedraw = this.setSupressRedraw(true);
        try {
            if (list != null && list.length == 0) {
                list = null;
            }
            list = this.tokenizeStringArrayIfNeeded(list);
            String[] oldValue = this.getColumnSizes();
            this.vetos.fireVetoableChange("columnSizes", oldValue, list);
            if (list != null) {
                this.columnSizes = new int[list.length];
                int total = 0;
                int i = 0;
                while (i < list.length) {
                    int stringValue = 10;
                    try {
                        String listElem = list[i];
                        if (listElem != null) {
                            stringValue = Integer.parseInt(listElem);
                        }
                    }
                    catch (Exception exception) {}
                    this.columnSizes[i] = stringValue;
                    if (this.splitters.length > i + 1) {
                        this.splitters[i + 1] = total += this.columnSizes[i];
                    }
                    ++i;
                }
                if (this.splitters.length > 1) {
                    this.splitters[0] = 0;
                }
            } else {
                this.columnSizes = null;
                this.adjustHeadings();
            }
            this.changes.firePropertyChange("columnSizes", oldValue, list);
        }
        finally {
            Object var4_8 = null;
            this.triggerRedraw();
            this.setSupressRedraw(wasSuppressingRedraw);
        }
    }

    public String[] getColumnSizes() {
        return this.intArrayToStringArray(this.columnSizes);
    }

    public int getColumnSize(int i) {
        return this.splitters[i + 1];
    }

    public void setSelectedRow(int row) throws IllegalArgumentException {
        if (row < 0 || row > this.cells.rows() - 1) {
            throw new IllegalArgumentException(String.valueOf(row) + " is not a valid row number");
        }
        this.selectRow(row);
    }

    public int getSelectedRow() {
        int[] selected = this.getSelectedRows();
        if (selected.length == 1) {
            return selected[0];
        }
        return -1;
    }

    public void selectAll() {
        if (!this.multiSelect) {
            return;
        }
        int numRows = this.getNumberOfRows();
        int i = 0;
        while (i < numRows) {
            this.selectRow(i);
            ++i;
        }
    }

    public void deselectAll() {
        int[] selectedRows = this.getSelectedRows();
        int i = 0;
        while (i < selectedRows.length) {
            this.deselectRow(selectedRows[i]);
            ++i;
        }
    }

    public int[] getSelectedRows() {
        int size = this.highlightedRows.size();
        int count = 0;
        int i = 0;
        while (i < size) {
            if (this.highlightedRows.get(i)) {
                ++count;
            }
            ++i;
        }
        int[] selections = new int[count];
        count = 0;
        int i2 = 0;
        while (i2 < size) {
            if (this.highlightedRows.get(i2)) {
                selections[count++] = i2;
            }
            ++i2;
        }
        return selections;
    }

    public Object[] getSelectedObjects() {
        int[] temp = this.getSelectedRows();
        int length = temp.length;
        Object[] newArray = new Integer[length];
        int i = 0;
        while (i < length) {
            newArray[i] = new Integer(temp[i]);
            ++i;
        }
        return newArray;
    }

    public void setMinColumnWidth(int size) throws PropertyVetoException {
        if (this.minColumnWidth != size && size > 0) {
            Integer oldValue = new Integer(this.minColumnWidth);
            Integer newValue = new Integer(size);
            this.vetos.fireVetoableChange("minColumnWidth", oldValue, newValue);
            this.minColumnWidth = size;
            this.changes.firePropertyChange("minColumnWidth", oldValue, newValue);
        }
    }

    public boolean setSupressRedraw(boolean supressRedraw) {
        boolean wasSupressingRedraw = this.isSuppressRedraw;
        this.isSuppressRedraw = supressRedraw;
        if (this.isSuppressRedraw != wasSupressingRedraw && !this.isSuppressRedraw && this.redrawWasSupressed) {
            this.redrawWasSupressed = false;
            this.triggerRedraw();
        }
        return wasSupressingRedraw;
    }

    protected void resizeHeadings(int column) {
        if (column == this.headings.length) {
            return;
        }
        int columnsToAdd = column - this.headings.length;
        String[] newHeadings = new String[this.headings.length + columnsToAdd];
        int[] newSplitters = new int[newHeadings.length + 1];
        int i = 0;
        while (i < newHeadings.length) {
            if (i < this.headings.length) {
                newHeadings[i] = this.headings[i];
                newSplitters[i + 1] = this.splitters[i + 1];
            } else {
                newHeadings[i] = "Column " + (i + 1);
                newSplitters[i + 1] = newSplitters[i] + this.getMinColumnWidth();
            }
            ++i;
        }
        this.headings = newHeadings;
        this.splitters = newSplitters;
    }

    public void setListItems(String[] items) throws PropertyVetoException {
        boolean wasSuppressingRedraw = this.setSupressRedraw(true);
        try {
            String[] oldValue = this.getListItems();
            this.vetos.fireVetoableChange("listItems", oldValue, items);
            this.clear();
            int row = 0;
            while (row < items.length) {
                String s = items[row];
                if (s == null) {
                    s = "";
                }
                int len = s.length();
                int start = 0;
                int col = 0;
                int end = 0;
                while (end <= len) {
                    if (end == len || s.charAt(end) == ';') {
                        this.addCell(row, col++, s.substring(start, end), null);
                        start = end + 1;
                        if (col > this.headings.length) {
                            this.resizeHeadings(col);
                        }
                    }
                    ++end;
                }
                while (col < this.headings.length) {
                    this.addCell(row, col++, "", null);
                }
                ++row;
            }
            this.changes.firePropertyChange("listItems", oldValue, this.getListItems());
        }
        finally {
            Object var4_10 = null;
            this.triggerRedraw();
            this.setSupressRedraw(wasSuppressingRedraw);
        }
    }

    public String[] getListItems() {
        Vector v = new Vector();
        boolean lastNull = false;
        String[] items = new String[this.cells.rows()];
        int row = 0;
        while (row < this.cells.rows()) {
            String rowString = "";
            int col = 0;
            while (col < this.headings.length) {
                String s = this.getCellText(row, col);
                if (col != 0) {
                    rowString = String.valueOf(rowString) + ";";
                }
                rowString = String.valueOf(rowString) + (s != null ? s : "");
                ++col;
            }
            items[row] = rowString;
            ++row;
        }
        return items;
    }

    public void setAllowSorting(boolean b) throws PropertyVetoException {
        if (this.allowSorting != b) {
            Boolean oldValue = new Boolean(this.allowSorting);
            Boolean newValue = new Boolean(b);
            this.vetos.fireVetoableChange("allowSorting", oldValue, newValue);
            this.allowSorting = b;
            this.changes.firePropertyChange("allowSorting", oldValue, newValue);
        }
    }

    public boolean isAllowSorting() {
        return this.allowSorting;
    }

    public void setAllowResizingOfColumns(boolean allowResizing) throws PropertyVetoException {
        if (this.allowResizingOfColumns != allowResizing) {
            Boolean oldValue = new Boolean(this.allowResizingOfColumns);
            Boolean newValue = new Boolean(allowResizing);
            this.vetos.fireVetoableChange("allowResizingOfColumns", oldValue, newValue);
            this.allowResizingOfColumns = allowResizing;
            this.changes.firePropertyChange("allowResizingOfColumns", oldValue, newValue);
        }
    }

    public boolean isAllowResizingOfColumns() {
        return this.allowResizingOfColumns;
    }

    public int getMinColumnWidth() {
        return this.minColumnWidth;
    }

    public void adjustHeadings() {
        if (this.headings.length == 0) {
            this.internalCreateColumns(0);
            this.triggerRedraw();
        } else {
            Dimension d = this.size();
            int w = 0;
            int width = (d.width - this.verticalScrollbarWidth) / this.headings.length;
            int r = d.width - this.verticalScrollbarWidth - this.headings.length * width;
            this.splitters[0] = 0;
            int i = 0;
            while (i < this.headings.length) {
                this.splitters[i + 1] = w += width + (i < r ? 1 : 0);
                ++i;
            }
        }
    }

    public void createColumns(int i) {
        this.internalCreateColumns(i);
        this.triggerRedraw();
    }

    protected void internalCreateColumns(int i) {
        this.headings = new String[i];
        this.splitters = new int[i + 1];
        this.columnAlignments = null;
        this.columnSizes = null;
    }

    public void clear() {
        this.cells.removeAllElements();
        this.xDragLast = -1;
        this.isDragging = false;
        this.selectedRow = -1;
        this.highlightedRows = new BitSet();
        this.topRow = 0;
        this.sbVPosition = 0;
        this.triggerRedraw();
    }

    public void removeRow(int row) {
        int numRows = this.cells.rows();
        if (row < 0 || row > numRows - 1) {
            return;
        }
        this.cells.removeRow(row);
        if (this.highlightedRows.get(row)) {
            this.highlightedRows.clear(row);
        }
        int i = row + 1;
        while (i < numRows) {
            if (this.highlightedRows.get(i)) {
                this.highlightedRows.clear(i);
                this.highlightedRows.set(i - 1);
            }
            ++i;
        }
        this.triggerRedraw();
    }

    public CompareCells getColumnSorter(int column) {
        CompareCells compareCellsFunc = (CompareCells)this.columnCompareCellsRoutines.get(new Integer(column));
        if (compareCellsFunc == null) {
            compareCellsFunc = this.getDefaultColumnSorter();
        }
        return compareCellsFunc;
    }

    public void setColumnSorter(int column, CompareCells compare) {
        this.columnCompareCellsRoutines.put(new Integer(column), compare);
    }

    public CompareCells getDefaultColumnSorter() {
        return this.defaultColumnSorter;
    }

    public void setDefaultColumnSorter(CompareCells newDefaultSorter) {
        this.defaultColumnSorter = newDefaultSorter;
    }

    public void addTextCell(int r, int c, String s) {
        if (s == null) {
            s = new String("");
        }
        TextAndImageCell cell = new TextAndImageCell(this, s);
        this.addCellImpl(r, c, cell);
    }

    public void addImageCell(int r, int c, Image i) {
        TextAndImageCell cell = new TextAndImageCell(this, i);
        this.addCellImpl(r, c, cell);
    }

    public void addCell(int r, int c, String s, Image i) {
        TextAndImageCell cell = new TextAndImageCell(this, s, i);
        this.addCellImpl(r, c, cell);
    }

    public void addCell(int row, int column, Cell cell) {
        this.addCellImpl(row, column, cell);
    }

    protected void addCellImpl(int row, int column, Cell cell) {
        this.cells.updateElement(row, column, cell);
        this.triggerRedraw();
    }

    public String getCellText(int r, int c) {
        try {
            TextAndImageCell cell = (TextAndImageCell)this.cells.elementAt(r, c);
            if (cell != null) {
                return cell.getText();
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
        }
        catch (ClassCastException classCastException) {}
        return "";
    }

    public Image getCellImage(int r, int c) {
        try {
            TextAndImageCell cell = (TextAndImageCell)this.cells.elementAt(r, c);
            if (cell != null) {
                return cell.getImage();
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
        }
        catch (ClassCastException classCastException) {}
        return null;
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        if (this.offscreenImage == null) {
            this.redraw();
        }
        if (this.offscreenImage != null) {
            Font f = g.getFont();
            if (f == null) {
                f = this.headingFont;
                ((Component)this).setFont(f);
                return;
            }
            Dimension s = this.size();
            if (this.cachedWidth != s.width || this.cachedHeight != s.height || this.forceRedraw) {
                this.redraw();
            }
            int heightMinusScrollbar = s.height - this.scrollbarHeight;
            int widthMinusScrollbar = s.width - this.verticalScrollbarWidth;
            g.translate(-this.sbHPosition, 0);
            if (this.sbVShow && this.sbHShow) {
                g.setColor(Color.lightGray);
                g.fillRect(this.sbHPosition + widthMinusScrollbar, heightMinusScrollbar, this.verticalScrollbarWidth, this.scrollbarHeight);
                g.setColor(Color.black);
                g.drawRect(this.sbHPosition + widthMinusScrollbar - 1, heightMinusScrollbar - 1, this.verticalScrollbarWidth, this.scrollbarHeight);
            }
            g.clipRect(this.sbHPosition, 0, widthMinusScrollbar, heightMinusScrollbar);
            g.drawImage(this.offscreenImage, 0, 0, this);
            g.setColor(Color.black);
            g.drawRect(this.sbHPosition, 0, widthMinusScrollbar - 1, heightMinusScrollbar - 1);
        }
    }

    protected void rangeCheckColumn(int column) {
        if (column < 0 || column > this.headings.length - 1) {
            throw new IllegalArgumentException("Column out of range : " + column);
        }
    }

    protected void rangeCheckAlignment(int alignment) {
        if (alignment != 0 && alignment != 1 && alignment != 2) {
            throw new IllegalArgumentException(String.valueOf(alignment) + " must be either LEFT, CENTER, or RIGHT");
        }
    }

    protected void calcVerticalScrollbarPosition(boolean minusHorizontalScrollbar) {
        Dimension s = this.size();
        if (this.cells.rows() * this.cellHeight > s.height - this.headingHeight - 1 - (this.headingHeight > 0 ? 0 : 1) - (minusHorizontalScrollbar ? this.scrollbarHeight : 0)) {
            this.sbVShow = true;
            this.verticalScrollbarWidth = this.verticalScrollbar.preferredSize().width - 1;
        } else {
            this.sbVShow = false;
            this.verticalScrollbarWidth = 0;
        }
        if (this.columnSizes == null && (this.forceColumnSizeRecalc || this.cachedWidth != s.width - this.verticalScrollbarWidth)) {
            this.adjustHeadings();
        }
        this.forceColumnSizeRecalc = false;
    }

    public void redraw() {
        Dimension s = this.size();
        this.forceRedraw = false;
        if (s.width == 0 || s.height == 0) {
            return;
        }
        this.calcVerticalScrollbarPosition(false);
        int lastSplitter = this.splitters[this.splitters.length - 1];
        if (lastSplitter > s.width - this.verticalScrollbarWidth) {
            this.sbHShow = true;
            this.scrollbarHeight = this.horizontalScrollbar.preferredSize().height - 1;
            this.calcVerticalScrollbarPosition(true);
        } else {
            this.sbHShow = false;
            this.scrollbarHeight = 0;
        }
        if (!this.sbVShow) {
            this.sbVPosition = 0;
        }
        if (!this.sbHShow) {
            this.sbHPosition = 0;
        }
        int imageWidth = Math.max(lastSplitter, s.width + this.sbHPosition);
        if (this.offscreenImage == null || this.offscreenImageGraphics == null || this.cachedWidth != imageWidth || this.cachedHeight != s.height || this.cachedLastSplitter != lastSplitter || this.offscreenImage.getWidth(this) != imageWidth || this.forceFullRedraw) {
            this.forceFullRedraw = false;
            if (this.offscreenImage != null) {
                this.offscreenImage.flush();
                this.offscreenImage = null;
            }
            this.offscreenImage = this.createImage(imageWidth, s.height);
            this.cachedWidth = s.width;
            this.cachedHeight = s.height;
            this.cachedLastSplitter = lastSplitter;
            if (this.offscreenImageGraphics != null) {
                this.offscreenImageGraphics.dispose();
                this.offscreenImageGraphics = null;
            }
            if (this.offscreenImage != null) {
                this.offscreenImageGraphics = this.offscreenImage.getGraphics();
            }
        }
        if (this.offscreenImageGraphics != null) {
            this.offscreenImageGraphics.setColor(this.colorBg);
            this.offscreenImageGraphics.fillRect(0, 0, this.offscreenImage.getWidth(this), s.height);
        }
        int numRows = this.cells.rows();
        if (this.sbVShow) {
            int vis = this.getNumVisibleRows();
            this.verticalScrollbar.reshape(s.width - this.verticalScrollbarWidth, 0, this.verticalScrollbarWidth, s.height - this.scrollbarHeight);
            this.verticalScrollbar.setValues(this.sbVPosition, vis, 0, numRows - (isSun1_1 ? 0 : vis));
            this.verticalScrollbar.setPageIncrement(vis - 1);
            this.verticalScrollbar.show();
        } else {
            this.topRow = 0;
            this.verticalScrollbar.hide();
        }
        if (this.sbHShow) {
            this.horizontalScrollbar.reshape(0, s.height - this.scrollbarHeight, s.width - this.verticalScrollbarWidth, this.scrollbarHeight);
            this.horizontalScrollbar.setValues(this.sbHPosition, s.width - this.verticalScrollbarWidth, 0, lastSplitter - (isSun1_1 ? 0 : s.width - this.verticalScrollbarWidth));
            this.horizontalScrollbar.setPageIncrement(s.width - this.verticalScrollbarWidth);
            this.horizontalScrollbar.setLineIncrement(this.hScrollbarLineIncrement);
            this.horizontalScrollbar.show();
        } else {
            this.horizontalScrollbar.hide();
        }
        if (this.offscreenImageGraphics != null && this.headings.length > 0) {
            int count;
            this.drawHeading(false);
            if (lastSplitter > 0) {
                this.offscreenImageGraphics.clipRect(0, 0, lastSplitter, s.height);
            }
            int n = count = this.cellHeight > 0 ? this.getNumVisibleRows() : 0;
            if (count > numRows) {
                count = numRows;
            }
            this.offscreenImageGraphics.setFont(this.cellFont);
            this.drawRows(this.topRow, count, false);
        }
    }

    public void changeSelection(int newSelection, int meta) {
        int[] selRows;
        int numberOfRows;
        boolean wasSuppressingRedraw = this.setSupressRedraw(true);
        try {
            block13: {
                numberOfRows = this.getNumberOfRows();
                if (newSelection < numberOfRows && newSelection > -1) break block11;
                selRows = this.getSelectedRows();
                if (!this.multiSelect) break block12;
                if ((meta & 1) == 1) break block13;
                if ((meta & 2) != 2) break block14;
            }
            Object var5_6 = null;
            this.triggerRedraw();
            this.setSupressRedraw(wasSuppressingRedraw);
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            this.triggerRedraw();
            this.setSupressRedraw(wasSuppressingRedraw);
            throw throwable;
        }
        {
            block12: {
                block14: {
                    return;
                }
                this.deselectEvent(newSelection, selRows);
            }
            this.highlightedRows = new BitSet();
            this.paintSelection(selRows);
            this.repaint();
        }
        Object var5_7 = null;
        this.triggerRedraw();
        this.setSupressRedraw(wasSuppressingRedraw);
        {
            block11: {
                return;
            }
            if (this.multiSelect) {
                this.multiSel(newSelection, meta);
            } else {
                this.singleSel(newSelection, meta);
            }
            if (newSelection < this.topRow) {
                this.topRow = newSelection;
                if (this.topRow < 0) {
                    this.topRow = 0;
                }
                this.sbVPosition = this.topRow;
                this.verticalScrollbar.setValue(this.sbVPosition);
                this.triggerRedraw();
            }
            if (newSelection - this.topRow + 1 > this.getNumVisibleRows()) {
                ++this.topRow;
                if (this.topRow > numberOfRows - 1) {
                    this.topRow = newSelection;
                }
                this.sbVPosition = this.topRow;
                this.verticalScrollbar.setValue(this.sbVPosition);
                this.triggerRedraw();
            }
            this.selectedRow = newSelection;
            this.drawRows(this.selectedRow, 1, true);
        }
        Object var5_8 = null;
        this.triggerRedraw();
        this.setSupressRedraw(wasSuppressingRedraw);
    }

    public synchronized void addNotify() {
        super.addNotify();
        if (this.mouse == null) {
            this.mouse = new Mouse();
            this.addMouseListener(this.mouse);
        }
        if (this.mouseMotion == null) {
            this.mouseMotion = new MouseMotion();
            this.addMouseMotionListener(this.mouseMotion);
        }
        if (this.key == null) {
            this.key = new Key();
            this.addKeyListener(this.key);
        }
        if (this.adjustment == null) {
            this.adjustment = new Adjustment();
            this.verticalScrollbar.addAdjustmentListener(this.adjustment);
            this.horizontalScrollbar.addAdjustmentListener(this.adjustment);
        }
        if (this.focus == null) {
            this.focus = new Focus();
            this.addFocusListener(this.focus);
        }
    }

    public synchronized void removeNotify() {
        if (this.mouse != null) {
            this.removeMouseListener(this.mouse);
            this.mouse = null;
        }
        if (this.mouseMotion != null) {
            this.removeMouseMotionListener(this.mouseMotion);
            this.mouseMotion = null;
        }
        if (this.key != null) {
            this.removeKeyListener(this.key);
            this.key = null;
        }
        if (this.adjustment != null) {
            this.verticalScrollbar.removeAdjustmentListener(this.adjustment);
            this.horizontalScrollbar.removeAdjustmentListener(this.adjustment);
            this.adjustment = null;
        }
        if (this.focus != null) {
            this.removeFocusListener(this.focus);
            this.focus = null;
        }
        super.removeNotify();
    }

    private void multiSel(int newSelection, int meta) {
        if ((meta & 2) == 2) {
            if (this.highlightedRows.get(newSelection)) {
                this.deselectRow(newSelection);
            } else {
                this.removeSelectionBorder();
                this.selectRow(newSelection);
            }
        } else if ((meta & 1) == 1) {
            if (this.selectedRow == -1) {
                this.selectedRow = newSelection;
            }
            int i = Math.min(this.selectedRow, newSelection);
            while (i <= Math.max(this.selectedRow, newSelection)) {
                if (i >= 0) {
                    this.highlightedRows.set(i);
                }
                ++i;
            }
            this.sourceItemEvent(1);
            this.selectedRow = -1;
            this.paintSelection(this.getSelectedRows());
        } else {
            int[] selRows = this.getSelectedRows();
            this.deselectEvent(newSelection, selRows);
            this.highlightedRows = new BitSet();
            this.removeSelectionBorder();
            this.selectedRow = -1;
            this.paintSelection(selRows);
            this.selectRow(newSelection);
        }
    }

    private void singleSel(int newSelection, int meta) {
        if (this.selectedRow >= 0 && this.highlightedRows.get(this.selectedRow)) {
            if (this.selectedRow != newSelection) {
                this.deselectRow(this.selectedRow);
                this.selectRow(newSelection);
            } else if ((meta & 2) == 2) {
                this.deselectRow(this.selectedRow);
            }
        } else {
            this.removeSelectionBorder();
            this.selectRow(newSelection);
        }
    }

    private void deselectEvent(int newSelection, int[] selRows) {
        int numberSelected = selRows.length;
        if (numberSelected > 1 || numberSelected == 1 && this.selectedRow != newSelection) {
            this.sourceItemEvent(2);
        }
    }

    protected void paintSelection(int[] selRows) {
        int i = 0;
        while (i < selRows.length) {
            int selectedRow = selRows[i];
            if (selectedRow - this.sbVPosition >= 0 && selectedRow - this.sbVPosition <= this.getNumVisibleRows() + 1) {
                this.drawRows(selectedRow, 1, true);
            }
            ++i;
        }
    }

    public void selectRow(int row) {
        if (!this.highlightedRows.get(row)) {
            int selectedRow;
            if (!this.multiSelect && (selectedRow = this.getSelectedRow()) != -1 && selectedRow != row) {
                this.deselectRow(selectedRow);
            }
            this.highlightedRows.set(row);
            this.sourceItemEvent(1);
            this.drawRows(row, 1, true);
        }
    }

    public void deselectRow(int row) {
        if (this.highlightedRows.get(row)) {
            this.highlightedRows.clear(row);
            this.sourceItemEvent(2);
            if (row == this.selectedRow) {
                this.removeSelectionBorder();
            } else {
                this.drawRows(row, 1, true);
            }
        }
    }

    protected void removeSelectionBorder() {
        if (this.selectedRow != -1) {
            int saveSelectedRow = this.selectedRow;
            this.selectedRow = -1;
            this.drawRows(saveSelectedRow, 1, true);
            this.selectedRow = saveSelectedRow;
        }
    }

    public synchronized Dimension preferredSize() {
        return new Dimension(175, 125);
    }

    public synchronized Dimension minimumSize() {
        return new Dimension(50, 50);
    }

    public void addActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, l);
    }

    public void removeActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, l);
    }

    public void addItemListener(ItemListener l) {
        this.itemListener = AWTEventMulticaster.add(this.itemListener, l);
    }

    public void removeItemListener(ItemListener l) {
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, l);
    }

    protected void sourceItemEvent(int eventType) {
        if (this.itemListener != null) {
            this.itemListener.itemStateChanged(new ItemEvent(this, 701, this, eventType));
        }
    }

    protected void repaintFocus() {
        if (this.selectedRow != -1) {
            this.drawRows(this.selectedRow, 1, true);
        }
        this.paintSelection(this.getSelectedRows());
    }

    protected void sourceActionEvent(int selectedRow) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, String.valueOf(this.actionCommand) + selectedRow));
        }
    }

    protected int getNumVisibleRows() {
        return (this.size().height - this.headingHeight - this.scrollbarHeight - 1 - (this.headingHeight > 0 ? 0 : 1)) / this.cellHeight;
    }

    protected void drawRows(int cellRow, int numRowsToDraw, boolean toRepaint) {
        int visibleRowIndex = cellRow - this.sbVPosition;
        if (visibleRowIndex < 0 || visibleRowIndex > this.getNumVisibleRows() - 1) {
            return;
        }
        MatrixEnumeration e = this.cells.elements();
        Cell c = null;
        if (cellRow > 0) {
            c = (Cell)e.advanceTo(cellRow);
        }
        while (e.hasMoreElements() || c != null) {
            int x = 1;
            boolean rowIsSelected = this.highlightedRows.get(cellRow);
            int topOfCell = this.headingHeight + (this.headingHeight > 0 ? 0 : 1) + visibleRowIndex * this.cellHeight;
            int cols = this.headings.length;
            int i = 0;
            while (i < cols) {
                int w = this.splitters[i + 1] - this.splitters[i];
                this.offscreenImageGraphics.setColor(rowIsSelected ? this.colorHBg : this.colorBg);
                this.offscreenImageGraphics.fillRect(x, topOfCell, w + 4, this.cellHeight);
                this.offscreenImageGraphics.setColor(rowIsSelected ? this.colorHFg : this.colorFg);
                if (c == null) {
                    c = (Cell)e.nextElement();
                }
                if (c != null && e.currRow() == cellRow && e.currCol() == i) {
                    c.drawCell(this.offscreenImageGraphics, this.getColumnAlignment(i), this.splitters[i] + 3, topOfCell, w, this.cellHeight, this.cellAscent);
                    c = null;
                }
                if (c != null && e.currRow() < cellRow) {
                    c = null;
                }
                x = this.splitters[i + 1] - 3;
                ++i;
            }
            if (this.hasFocus & this.focusIndicatedVisually && cellRow == this.selectedRow) {
                Rectangle r1 = this.offscreenImageGraphics.getClipRect();
                this.offscreenImageGraphics.setColor(this.colorBg);
                this.offscreenImageGraphics.setXORMode(Color.gray);
                this.offscreenImageGraphics.drawRect(1, topOfCell, r1.width - 3, this.cellHeight - 1);
                this.offscreenImageGraphics.setPaintMode();
            }
            if (toRepaint) {
                Rectangle r1 = this.offscreenImageGraphics.getClipRect();
                this.repaint(0, topOfCell, r1.width, this.cellHeight);
            }
            if (--numRowsToDraw == 0) break;
            ++cellRow;
            ++visibleRowIndex;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changes.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changes.removePropertyChangeListener(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        this.vetos.addVetoableChangeListener(listener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        this.vetos.removeVetoableChangeListener(listener);
    }

    public void setLayout(LayoutManager mgr) {
    }

    public boolean isFocusTraversable() {
        return true;
    }

    protected void drawColumnHeading(Rectangle columnHeadingRect, boolean isSelected) {
        if (OS.isMacintosh()) {
            this.offscreenImageGraphics.setColor(Color.black);
            this.offscreenImageGraphics.drawRect(columnHeadingRect.x, columnHeadingRect.y, columnHeadingRect.width - 1, columnHeadingRect.height - 1);
            this.offscreenImageGraphics.setColor(isSelected ? Color.gray : this.headingBg);
            this.offscreenImageGraphics.fillRect(columnHeadingRect.x + 2, columnHeadingRect.y + 2, columnHeadingRect.width - 4, columnHeadingRect.height - 4);
            if (isSelected) {
                this.offscreenImageGraphics.setColor(Color.black);
            }
            this.offscreenImageGraphics.drawLine(columnHeadingRect.x + 1, columnHeadingRect.y + columnHeadingRect.height - 2, columnHeadingRect.x + 1, columnHeadingRect.y + columnHeadingRect.height - 2);
            this.offscreenImageGraphics.drawLine(columnHeadingRect.x + columnHeadingRect.width - 2, columnHeadingRect.y + 1, columnHeadingRect.x + columnHeadingRect.width - 2, columnHeadingRect.y + 1);
            this.offscreenImageGraphics.setColor(isSelected ? thirtyThreePercentGray : Color.white);
            this.offscreenImageGraphics.drawLine(columnHeadingRect.x + 1, columnHeadingRect.y + 1, columnHeadingRect.x + 1, columnHeadingRect.y + columnHeadingRect.height - 3);
            this.offscreenImageGraphics.drawLine(columnHeadingRect.x + 2, columnHeadingRect.y + 1, columnHeadingRect.x + columnHeadingRect.width - 3, columnHeadingRect.y + 1);
            this.offscreenImageGraphics.setColor(isSelected ? sixtySixPercentGray : Color.gray);
            this.offscreenImageGraphics.drawLine(columnHeadingRect.x + 2, columnHeadingRect.y + columnHeadingRect.height - 2, columnHeadingRect.x + columnHeadingRect.width - 2, columnHeadingRect.y + columnHeadingRect.height - 2);
            this.offscreenImageGraphics.drawLine(columnHeadingRect.x + columnHeadingRect.width - 2, columnHeadingRect.y + 2, columnHeadingRect.x + columnHeadingRect.width - 2, columnHeadingRect.y + columnHeadingRect.height - 2);
        } else {
            ++columnHeadingRect.x;
            ++columnHeadingRect.y;
            columnHeadingRect.width -= 2;
            columnHeadingRect.height -= 2;
            this.draw3DBox(columnHeadingRect, !isSelected);
            this.offscreenImageGraphics.setColor(this.headingBg);
            this.offscreenImageGraphics.fillRect(columnHeadingRect.x + 1, columnHeadingRect.y + 1, columnHeadingRect.width - 1, columnHeadingRect.height - 1);
        }
    }

    protected void draw3DBox(Rectangle r, boolean up) {
        int x0 = r.x;
        int y0 = r.y;
        int x1 = r.x + r.width;
        int y1 = r.y + r.height;
        this.offscreenImageGraphics.setColor(up ? Color.black : Color.white);
        this.offscreenImageGraphics.drawLine(x1, y0, x1, y1);
        this.offscreenImageGraphics.drawLine(x1 + 1, y0, x1 + 1, y1);
        this.offscreenImageGraphics.drawLine(x0, y1, x1, y1);
        this.offscreenImageGraphics.drawLine(x0, y1 + 1, x1, y1 + 1);
        this.offscreenImageGraphics.setColor(up ? Color.white : Color.gray);
        this.offscreenImageGraphics.drawLine(x0, y0, x1 - 2, y0);
        this.offscreenImageGraphics.drawLine(x0, y0, x0, y1 - 1);
    }

    protected void calculateHeadingHeight() {
        FontMetrics fontMetrics = this.getFontMetrics(this.headingFont);
        this.headingHeight = fontMetrics.getHeight() + fontMetrics.getLeading() + 7;
    }

    protected void drawHeading(boolean down) {
        if (!this.headingVisible) {
            return;
        }
        if (this.headings.length > 0) {
            Font saveFont = this.offscreenImageGraphics.getFont();
            this.offscreenImageGraphics.setFont(this.headingFont);
            FontMetrics fontMetrics = this.offscreenImageGraphics.getFontMetrics();
            int currSplitter = this.splitters[0];
            int i = 0;
            while (i < this.headings.length) {
                int nextSplitter = this.splitters[i + 1];
                int currHeadingWidth = nextSplitter - currSplitter;
                Rectangle columnHeaderRect = new Rectangle(currSplitter, 0, currHeadingWidth, this.headingHeight);
                boolean clickingInCurrColumn = this.columnClicked == i;
                this.drawColumnHeading(columnHeaderRect, clickingInCurrColumn);
                String currHeading = this.headings[i];
                if (currHeading != null) {
                    this.offscreenImageGraphics.setColor(this.headingFg);
                    int stringWidth = fontMetrics.stringWidth(currHeading);
                    int w = currHeadingWidth - 3;
                    int shift = down && clickingInCurrColumn ? 1 : 0;
                    int stringBaseline = this.headingHeight - 6 + shift;
                    switch (this.getColumnAlignment(i)) {
                        case 0: {
                            this.offscreenImageGraphics.drawString(currHeading, currSplitter + 8 + shift, stringBaseline);
                            break;
                        }
                        case 1: {
                            if (stringWidth > w) {
                                this.offscreenImageGraphics.drawString(currHeading, currSplitter + 8 + shift, stringBaseline);
                                break;
                            }
                            this.offscreenImageGraphics.drawString(currHeading, currSplitter + (w - stringWidth) / 2 + shift, stringBaseline);
                            break;
                        }
                        case 2: {
                            if (stringWidth > w) {
                                this.offscreenImageGraphics.drawString(currHeading, currSplitter + 8 + shift, stringBaseline);
                                break;
                            }
                            this.offscreenImageGraphics.drawString(currHeading, currSplitter + w - stringWidth - 6 + shift, stringBaseline);
                            break;
                        }
                    }
                    if (clickingInCurrColumn) {
                        this.offscreenImageGraphics.drawLine(columnHeaderRect.x + 1, this.headingHeight - 1, nextSplitter - 3, this.headingHeight - 1);
                    }
                    currSplitter = nextSplitter - 1;
                }
                ++i;
            }
            this.offscreenImageGraphics.setFont(saveFont);
        }
        Dimension dim = this.size();
        int lastSplitter = this.splitters[this.splitters.length - 1];
        if (lastSplitter < this.sbHPosition + dim.width - this.verticalScrollbarWidth) {
            Rectangle fillerHeaderRect = new Rectangle(lastSplitter - 1, 0, this.sbHPosition + dim.width - this.verticalScrollbarWidth - lastSplitter + 1, this.headingHeight);
            this.drawColumnHeading(fillerHeaderRect, false);
        }
    }

    protected String[] intArrayToStringArray(int[] intArray) {
        if (intArray == null) {
            return null;
        }
        String[] list = new String[intArray.length];
        int i = 0;
        while (i < intArray.length) {
            String intString = "";
            try {
                intString = String.valueOf(intArray[i]);
            }
            catch (Exception exception) {}
            list[i] = intString;
            ++i;
        }
        return list;
    }

    protected int[] getColumnSizesFromSplitters() {
        int[] splitterColumnSizes = new int[this.headings.length];
        int i = 0;
        while (i < this.headings.length) {
            splitterColumnSizes[i] = this.splitters[i + 1] - this.splitters[i];
            ++i;
        }
        return splitterColumnSizes;
    }

    protected void triggerRedraw() {
        if (!this.isSuppressRedraw) {
            this.forceRedraw = true;
            this.repaint();
        } else {
            this.redrawWasSupressed = true;
        }
    }

    protected String[] tokenizeStringArrayIfNeeded(String[] list) {
        if (list != null && list.length == 1 && list[0].indexOf(";") != -1) {
            StringTokenizer tokenizer = new StringTokenizer(list[0], ";");
            int numColumns = tokenizer.countTokens();
            String[] convertedList = new String[numColumns];
            int currCol = 0;
            while (tokenizer.hasMoreTokens()) {
                String columnHeader;
                convertedList[currCol] = columnHeader = tokenizer.nextToken();
                ++currCol;
            }
            list = convertedList;
        }
        return list;
    }

    protected void calcHeadings(String[] list) {
        block5: {
            this.headings = new String[list.length];
            this.splitters = new int[list.length + 1];
            int i = 0;
            while (i < list.length) {
                try {
                    this.setHeading(list[i], i);
                }
                catch (PropertyVetoException propertyVetoException) {}
                ++i;
            }
            if (this.columnSizes == null) break block5;
            try {
                this.setColumnSizes(this.intArrayToStringArray(this.columnSizes));
            }
            catch (PropertyVetoException propertyVetoException) {}
        }
    }

    static {
        String vendor = System.getProperty("java.vendor");
        String version = System.getProperty("java.version");
        isSun1_1 = vendor.startsWith("Sun Microsystems Inc.") && (version.startsWith("11") || version.startsWith("1.1"));
    }

    class Mouse
    extends MouseAdapter
    implements Serializable {
        public void mousePressed(MouseEvent e) {
            long clickSpeed;
            int x = e.getX();
            int y = e.getY();
            MultiList.this.requestFocus();
            MultiList.this.clickedInHeadings = false;
            if (y < MultiList.this.headingHeight) {
                int i;
                if (MultiList.this.allowResizingOfColumns) {
                    i = 1;
                    while (i < MultiList.this.splitters.length - 1) {
                        int currSplitter = MultiList.this.splitters[i];
                        if (x < Math.min(currSplitter - MultiList.this.sbHPosition + 3, MultiList.this.size().width - MultiList.this.verticalScrollbarWidth) && x > currSplitter - MultiList.this.sbHPosition - 3) {
                            MultiList.this.dragColumn = i;
                            MultiList.this.isDragging = true;
                            MultiList.this.offscreenImageGraphics.setClip(0, 0, Math.max(MultiList.this.splitters[MultiList.this.splitters.length - 1], MultiList.this.size().width + MultiList.this.sbHPosition), MultiList.this.size().height);
                            MultiList.this.mouseMotion.mouseDragged(e);
                            return;
                        }
                        ++i;
                    }
                }
                if (MultiList.this.allowSorting) {
                    i = 0;
                    while (i < MultiList.this.headings.length) {
                        if (x > MultiList.this.splitters[i] - MultiList.this.sbHPosition && x < MultiList.this.splitters[i + 1] - MultiList.this.sbHPosition) {
                            MultiList.this.clickedInHeadings = true;
                            MultiList.this.columnClicked = i;
                            MultiList.this.drawHeading(true);
                            MultiList.this.repaint();
                            return;
                        }
                        ++i;
                    }
                }
                return;
            }
            Dimension size = MultiList.this.getSize();
            if (x >= size.width - MultiList.this.verticalScrollbarWidth || y >= size.height - MultiList.this.scrollbarHeight) {
                return;
            }
            int clickedInRow = (y - MultiList.this.headingHeight) / MultiList.this.cellHeight + MultiList.this.topRow;
            if (clickedInRow < 0 || clickedInRow > MultiList.this.cells.rows() - 1) {
                return;
            }
            int oldRowSelect = MultiList.this.selectedRow;
            MultiList.this.changeSelection(clickedInRow, e.getModifiers());
            long when = e.getWhen();
            if ((MultiList.this.selectedRow == oldRowSelect || oldRowSelect < 0) && (clickSpeed = when - MultiList.this.clickTime) < 250L) {
                MultiList.this.sourceActionEvent(MultiList.this.selectedRow);
            }
            MultiList.this.clickTime = when;
        }

        public void mouseReleased(MouseEvent e) {
            int x = e.getX();
            if (MultiList.this.isDragging) {
                if (x < 0) {
                    x = 0;
                }
                boolean splittersChanged = false;
                MultiList.this.xDragLast = Math.max(MultiList.this.splitters[MultiList.this.dragColumn - 1] + MultiList.this.minColumnWidth, x + MultiList.this.sbHPosition);
                int splitterDelta = MultiList.this.xDragLast - MultiList.this.splitters[MultiList.this.dragColumn];
                int i = MultiList.this.dragColumn + 1;
                while (i < MultiList.this.splitters.length) {
                    int splitterWas = MultiList.this.splitters[i];
                    int n = i;
                    MultiList.this.splitters[n] = MultiList.this.splitters[n] + splitterDelta;
                    if (splitterWas != MultiList.this.splitters[i]) {
                        splittersChanged = true;
                    }
                    ++i;
                }
                if (MultiList.this.splitters[MultiList.this.dragColumn] != MultiList.this.xDragLast) {
                    MultiList.this.splitters[MultiList.this.dragColumn] = MultiList.this.xDragLast;
                    splittersChanged = true;
                }
                MultiList.this.xDragLast = -1;
                MultiList.this.isDragging = false;
                if (e.getY() > MultiList.this.headingHeight) {
                    MultiList.this.setCursor(new Cursor(0));
                }
                if (splittersChanged && MultiList.this.columnSizes == null) {
                    try {
                        MultiList.this.setColumnSizes(MultiList.this.intArrayToStringArray(MultiList.this.getColumnSizesFromSplitters()));
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                }
                MultiList.this.triggerRedraw();
                return;
            }
            if (MultiList.this.columnClicked != -1) {
                CompareCells compareCellsFunc = MultiList.this.getColumnSorter(MultiList.this.columnClicked);
                compareCellsFunc.setCurrentBitSet(MultiList.this.highlightedRows);
                compareCellsFunc.setSelectedRow(MultiList.this.selectedRow);
                if (MultiList.this.columnClicked == MultiList.this.lastColumnClicked) {
                    compareCellsFunc.reverse();
                }
                MultiList.this.cells.sort(compareCellsFunc, MultiList.this.columnClicked);
                MultiList.this.selectedRow = compareCellsFunc.getSelectedRow();
                MultiList.this.lastColumnClicked = MultiList.this.columnClicked;
                MultiList.this.columnClicked = -1;
                MultiList.this.triggerRedraw();
            }
        }

        public void mouseExited(MouseEvent e) {
            if (MultiList.this.getCursor().getType() != 0 && !MultiList.this.isDragging) {
                MultiList.this.setCursor(new Cursor(0));
            }
        }

        Mouse() {
            MultiList.this = MultiList.this;
        }
    }

    class MouseMotion
    implements MouseMotionListener,
    Serializable {
        public void mouseMoved(MouseEvent e) {
            if (MultiList.this.allowResizingOfColumns) {
                int newCursor;
                boolean isCloseEnough = false;
                if (e.getY() < MultiList.this.headingHeight) {
                    int x = e.getX();
                    int i = 1;
                    while (i < MultiList.this.splitters.length - 1) {
                        int currSplitter = MultiList.this.splitters[i];
                        if (x < Math.min(currSplitter - MultiList.this.sbHPosition + 3, MultiList.this.size().width - MultiList.this.verticalScrollbarWidth) && x > currSplitter - MultiList.this.sbHPosition - 3) {
                            isCloseEnough = true;
                            break;
                        }
                        ++i;
                    }
                }
                int n = newCursor = isCloseEnough ? 10 : 0;
                if (newCursor != MultiList.this.getCursor().getType()) {
                    MultiList.this.setCursor(new Cursor(newCursor));
                }
            }
        }

        public void mouseDragged(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            Dimension s = MultiList.this.size();
            if (!MultiList.this.isDragging) {
                if (MultiList.this.clickedInHeadings) {
                    if (MultiList.this.columnClicked > -1) {
                        int min = MultiList.this.columnClicked == 0 ? 0 : MultiList.this.splitters[MultiList.this.columnClicked] - MultiList.this.sbHPosition;
                        int max = MultiList.this.columnClicked == MultiList.this.headings.length - 1 ? s.width : MultiList.this.splitters[MultiList.this.columnClicked + 1] - MultiList.this.sbHPosition;
                        if (x < min || x > max || y > MultiList.this.headingHeight || y < 0) {
                            MultiList.this.memoryClick = MultiList.this.columnClicked;
                            MultiList.this.columnClicked = -1;
                            MultiList.this.drawHeading(false);
                            Graphics g = MultiList.this.getGraphics();
                            MultiList.this.paint(g);
                        }
                    } else if (MultiList.this.memoryClick > -1) {
                        int min = MultiList.this.memoryClick == 0 ? 0 : MultiList.this.splitters[MultiList.this.memoryClick] - MultiList.this.sbHPosition;
                        int max = MultiList.this.memoryClick == MultiList.this.headings.length - 1 ? s.width : MultiList.this.splitters[MultiList.this.memoryClick + 1] - MultiList.this.sbHPosition;
                        if (x > min && x < max && y < MultiList.this.headingHeight && y > 0) {
                            MultiList.this.columnClicked = MultiList.this.memoryClick;
                            MultiList.this.memoryClick = -1;
                            MultiList.this.drawHeading(true);
                            Graphics g = MultiList.this.getGraphics();
                            MultiList.this.paint(g);
                        }
                    }
                }
            } else {
                if (x < 0) {
                    x = 0;
                }
                if (x + MultiList.this.sbHPosition < MultiList.this.splitters[MultiList.this.dragColumn - 1] + MultiList.this.minColumnWidth) {
                    return;
                }
                int x1 = Math.min(x, MultiList.this.xDragLast - MultiList.this.sbHPosition);
                int x2 = Math.max(x, MultiList.this.xDragLast - MultiList.this.sbHPosition);
                MultiList.this.offscreenImageGraphics.setColor(MultiList.this.colorBg);
                MultiList.this.offscreenImageGraphics.setXORMode(Color.gray);
                MultiList.this.offscreenImageGraphics.drawLine(MultiList.this.xDragLast, 0, MultiList.this.xDragLast, s.height);
                MultiList.this.offscreenImageGraphics.drawLine(x + MultiList.this.sbHPosition, 0, x + MultiList.this.sbHPosition, s.height);
                MultiList.this.offscreenImageGraphics.setColor(MultiList.this.getForeground());
                MultiList.this.offscreenImageGraphics.setPaintMode();
                MultiList.this.xDragLast = x + MultiList.this.sbHPosition;
                MultiList.this.repaint(x1, 0, x2 - x1 + 1, MultiList.this.size().height);
            }
        }

        MouseMotion() {
            MultiList.this = MultiList.this;
        }
    }

    class Key
    extends KeyAdapter
    implements Serializable {
        public void keyPressed(KeyEvent e) {
            int modifiers = e.getModifiers();
            switch (e.getKeyCode()) {
                case 40: {
                    if (MultiList.this.selectedRow >= MultiList.this.cells.rows() - 1) break;
                    MultiList.this.changeSelection(MultiList.this.selectedRow + 1, modifiers);
                    break;
                }
                case 34: {
                    MultiList.this.changeSelection(Math.min(MultiList.this.selectedRow + MultiList.this.getNumVisibleRows(), MultiList.this.cells.rows() - 1), modifiers);
                    break;
                }
                case 38: {
                    if (MultiList.this.selectedRow <= 0) break;
                    MultiList.this.changeSelection(MultiList.this.selectedRow - 1, modifiers);
                    break;
                }
                case 33: {
                    MultiList.this.changeSelection(Math.max(MultiList.this.selectedRow - MultiList.this.getNumVisibleRows(), 0), modifiers);
                    break;
                }
                case 39: {
                    int max = MultiList.this.horizontalScrollbar.getMaximum() - (isSun1_1 ? MultiList.this.size().width - MultiList.this.verticalScrollbarWidth : 0);
                    if (!MultiList.this.sbHShow || MultiList.this.sbHPosition >= max) break;
                    MultiList.this.horizontalScrollbar.setValue(Math.min(MultiList.this.sbHPosition += MultiList.this.hScrollbarLineIncrement, max));
                    MultiList.this.repaint();
                    break;
                }
                case 37: {
                    if (MultiList.this.sbHPosition <= 0) break;
                    MultiList.this.horizontalScrollbar.setValue(Math.max(MultiList.this.sbHPosition -= MultiList.this.hScrollbarLineIncrement, 0));
                    MultiList.this.repaint();
                    break;
                }
                case 10: {
                    if (MultiList.this.selectedRow <= -1) break;
                    MultiList.this.sourceActionEvent(MultiList.this.selectedRow);
                    break;
                }
            }
        }

        Key() {
            MultiList.this = MultiList.this;
        }
    }

    class Adjustment
    implements AdjustmentListener,
    Serializable {
        public void adjustmentValueChanged(AdjustmentEvent e) {
            if (e.getSource() == MultiList.this.verticalScrollbar) {
                if (MultiList.this.topRow != MultiList.this.verticalScrollbar.getValue()) {
                    MultiList.this.sbVPosition = MultiList.this.topRow = MultiList.this.verticalScrollbar.getValue();
                    MultiList.this.triggerRedraw();
                }
            } else if (e.getSource() == MultiList.this.horizontalScrollbar && MultiList.this.sbHPosition != MultiList.this.horizontalScrollbar.getValue()) {
                MultiList.this.sbHPosition = MultiList.this.horizontalScrollbar.getValue();
                MultiList.this.triggerRedraw();
            }
        }

        Adjustment() {
            MultiList.this = MultiList.this;
        }
    }

    class Focus
    implements FocusListener,
    Serializable {
        public void focusGained(FocusEvent e) {
            MultiList.this.hasFocus = true;
            MultiList.this.repaintFocus();
        }

        public void focusLost(FocusEvent e) {
            MultiList.this.hasFocus = false;
            MultiList.this.repaintFocus();
        }

        Focus() {
            MultiList.this = MultiList.this;
        }
    }
}

