/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.FilteredImageSource;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.URL;
import symantec.itools.awt.ButtonBase;
import symantec.itools.awt.image.DarkenFilter;
import symantec.itools.awt.image.FadeFilter;
import symantec.itools.beans.PropertyChangeSupport;
import symantec.itools.beans.VetoableChangeSupport;

public class ImageButton
extends ButtonBase {
    public static final int IMAGE_TILED = 0;
    public static final int IMAGE_CENTERED = 1;
    public static final int IMAGE_SCALED_TO_FIT = 2;
    public static final int IMAGE_NORMAL = 3;
    protected int imageStyle;
    protected URL imageURL;
    protected transient Image enabledImage;
    protected transient Image disabledImage;
    protected transient Image pressedImage;
    private StyleVeto styleVeto;
    private VetoableChangeSupport vetos = new VetoableChangeSupport(this);
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);

    public ImageButton() {
        try {
            this.setImageStyle(1);
        }
        catch (PropertyVetoException propertyVetoException) {}
    }

    public void setImageURL(URL u) throws PropertyVetoException {
        MediaTracker mt;
        Image image;
        URL oldValue = this.imageURL;
        this.vetos.fireVetoableChange("ImageURL", oldValue, u);
        this.enabledImage = null;
        if (this.disabledImage != null) {
            this.disabledImage.flush();
        }
        this.disabledImage = null;
        if (this.pressedImage != null) {
            this.pressedImage.flush();
        }
        this.pressedImage = null;
        this.imageURL = u;
        if (this.imageURL != null && (image = this.getToolkit().getImage(this.imageURL)) != null && (mt = new MediaTracker(this)) != null) {
            try {
                mt.addImage(image, 0);
                mt.waitForAll();
            }
            catch (InterruptedException interruptedException) {}
            if (mt.isErrorAny()) {
                System.err.println("Error loading image " + image.toString());
                return;
            }
            this.enabledImage = image;
            this.disabledImage = this.createImage(new FilteredImageSource(image.getSource(), new FadeFilter(0.333)));
            this.pressedImage = this.createImage(new FilteredImageSource(image.getSource(), new DarkenFilter(0.25)));
            this.changes.firePropertyChange("ImageURL", oldValue, u);
        }
        this.repaint();
    }

    public URL getImageURL() {
        return this.imageURL;
    }

    public void setImageStyle(int newStyle) throws PropertyVetoException {
        if (newStyle != this.imageStyle) {
            Integer oldValue = new Integer(this.imageStyle);
            Integer newValue = new Integer(newStyle);
            this.vetos.fireVetoableChange("ImageStyle", oldValue, newValue);
            this.imageStyle = newStyle;
            this.repaint();
            this.changes.firePropertyChange("ImageStyle", oldValue, newValue);
        }
    }

    public int getImageStyle() {
        return this.imageStyle;
    }

    public void setScaleMode(boolean flag) throws PropertyVetoException {
        if (flag) {
            this.setImageStyle(2);
        } else {
            this.setImageStyle(3);
        }
    }

    public boolean isScaleMode() {
        return this.getImageStyle() == 2;
    }

    public boolean getScaleMode() {
        return this.isScaleMode();
    }

    public void setCenterMode(boolean flag) throws PropertyVetoException {
        if (flag) {
            this.setImageStyle(1);
        } else {
            this.setImageStyle(3);
        }
    }

    public boolean isCenterMode() {
        return this.getImageStyle() == 1;
    }

    public boolean getCenterMode() {
        return this.isCenterMode();
    }

    public boolean isValidImageStyle(int i) {
        switch (i) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    public Dimension getPreferredSize() {
        Dimension defaultSize = super.getPreferredSize();
        if (this.enabledImage == null) {
            return defaultSize;
        }
        return new Dimension(defaultSize.width + this.enabledImage.getWidth(this), defaultSize.height + this.enabledImage.getHeight(this));
    }

    public synchronized void addNotify() {
        super.addNotify();
        if (this.styleVeto == null) {
            this.styleVeto = new StyleVeto();
            this.addImageStyleListener(this.styleVeto);
        }
    }

    public synchronized void removeNotify() {
        if (this.styleVeto != null) {
            this.removeImageStyleListener(this.styleVeto);
            this.styleVeto = null;
        }
        super.removeNotify();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        super.addPropertyChangeListener(listener);
        this.changes.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        super.removePropertyChangeListener(listener);
        this.changes.removePropertyChangeListener(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        super.addVetoableChangeListener(listener);
        this.vetos.addVetoableChangeListener(listener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        super.removeVetoableChangeListener(listener);
        this.vetos.removeVetoableChangeListener(listener);
    }

    public void addImageStyleListener(PropertyChangeListener listener) {
        this.changes.addPropertyChangeListener("ImageStyle", listener);
    }

    public void removeImageStyleListener(PropertyChangeListener listener) {
        this.changes.removePropertyChangeListener("ImageStyle", listener);
    }

    public void addImageStyleListener(VetoableChangeListener listener) {
        this.vetos.addVetoableChangeListener("ImageStyle", listener);
    }

    public void removeImageStyleListener(VetoableChangeListener listener) {
        this.vetos.removeVetoableChangeListener("ImageStyle", listener);
    }

    protected void updateButtonImage() {
        super.updateButtonImage();
        Image img = this.pressed ? this.pressedImage : (this.isEnabled() ? this.enabledImage : this.disabledImage);
        Dimension s = this.size();
        int x = this.bevel + 1 + this.pressedAdjustment;
        int y = this.bevel + 1 + this.pressedAdjustment;
        int w = s.width - this.bevel - this.bevel - 2;
        int h = s.height - this.bevel - this.bevel - 2;
        if (img == null) {
            this.buttonImageGraphics.clearRect(x, y, w, h);
            return;
        }
        int imageWidth = img.getWidth(this);
        int imageHeight = img.getHeight(this);
        switch (this.imageStyle) {
            default: {
                this.buttonImageGraphics.drawImage(img, x + (w - imageWidth) / 2, y + (h - imageHeight) / 2, this);
                break;
            }
            case 0: {
                int numHImages = w / imageWidth;
                if (w % imageWidth != 0) {
                    ++numHImages;
                }
                int numVImages = h / imageHeight;
                if (h % imageHeight != 0) {
                    ++numVImages;
                }
                int vOff = y;
                int vCount = 0;
                while (vCount < numVImages) {
                    int hOff = x;
                    int hCount = 0;
                    while (hCount < numHImages) {
                        this.buttonImageGraphics.drawImage(img, hOff, vOff, imageWidth, imageHeight, this);
                        hOff += imageWidth;
                        ++hCount;
                    }
                    vOff += imageHeight;
                    ++vCount;
                }
                break;
            }
            case 2: {
                this.buttonImageGraphics.drawImage(img, x, y, w, h, this);
                break;
            }
            case 3: {
                this.buttonImageGraphics.drawImage(img, x, y, this);
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        MediaTracker mt;
        Image image;
        in.defaultReadObject();
        if (this.imageURL != null && (image = this.getToolkit().getImage(this.imageURL)) != null && (mt = new MediaTracker(this)) != null) {
            try {
                mt.addImage(image, 0);
                mt.waitForAll();
            }
            catch (InterruptedException interruptedException) {}
            if (mt.isErrorAny()) {
                System.err.println("Error loading image " + image.toString());
                return;
            }
            this.enabledImage = image;
            this.disabledImage = this.createImage(new FilteredImageSource(image.getSource(), new FadeFilter(0.333)));
            this.pressedImage = this.createImage(new FilteredImageSource(image.getSource(), new DarkenFilter(0.25)));
        }
    }

    class StyleVeto
    implements VetoableChangeListener,
    Serializable {
        public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
            int i = (Integer)e.getNewValue();
            if (!ImageButton.this.isValidImageStyle(i)) {
                throw new PropertyVetoException("Invalid image style: " + i, e);
            }
        }

        StyleVeto() {
            ImageButton.this = ImageButton.this;
        }
    }
}

