UNIT Unit2;

INTERFACE

USES
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, FileCtrl, ExtCtrls, Buttons, ComCtrls;

TYPE
  TfrmExtract = CLASS(TForm)
    BitBtn1				: TBitBtn;
    BitBtn2				: TBitBtn;
    Button3				: TButton;
    DirectoryListBox1	: TDirectoryListBox;
    DriveComboBox1		: TDriveComboBox;
    CheckBox1				: TCheckBox;
    Edit1					: TEdit;
    Label1					: TLabel;
    Label2					: TLabel;
    RadioGroup1			: TRadioGroup;
    RadioGroup2			: TRadioGroup;
    FileListBox1: TFileListBox;

    PROCEDURE BitBtn1Click(Sender: TObject);
    PROCEDURE Button3Click(Sender: TObject);
    PROCEDURE DirectoryListBox1Change(Sender: TObject);
    PROCEDURE FormActivate(Sender: TObject);
    PROCEDURE RadioGroup1Click(Sender: TObject);
  PRIVATE
  PUBLIC
  END;


VAR
  frmExtract: TfrmExtract;


IMPLEMENTATION


USES Main;

{$R *.DFM}

{-------------------------------------------------------------}
PROCEDURE TfrmExtract.Button3Click(Sender: TObject);
VAR
	Dir: STRING;
BEGIN
	Dir := DirectoryListBox1.Directory;
	IF SelectDirectory( Dir, [sdAllowCreate, sdPerformCreate, sdPrompt], 0 ) THEN
     DirectoryListBox1.Directory := Dir;
END;
{-------------------------------------------------------------}
PROCEDURE TfrmExtract.DirectoryListBox1Change(Sender: TObject);
BEGIN
  Edit1.Text := DirectoryListBox1.Directory;
END;
{-------------------------------------------------------------}
PROCEDURE TfrmExtract.FormActivate(Sender: TObject);
BEGIN
	IF frmMain.ListView1.Selected = NIL THEN
  	RadioGroup1.ItemIndex := 1
  ELSE
  	RadioGroup1.ItemIndex := 0;

  Edit1.Text := DirectoryListBox1.Directory;
  Edit1.SelLength := Length( Edit1.Text );
END;
{-------------------------------------------------------------}
PROCEDURE TfrmExtract.BitBtn1Click(Sender: TObject);
BEGIN
	IF Edit1.Text <> '' THEN
		IF DirectoryExists( Edit1.Text ) THEN
     BEGIN
     	ModalResult := mrOK;
     	DirectoryListBox1.Directory := Edit1.Text;
     END ELSE BEGIN
     	MessageDlg( 'Directory not found.',
        					mtInformation,
                       [ mbOK ],
                       0);
                       
     	Edit1.SelStart := 0;
        Edit1.SelLength := Length( Edit1.Text );
     END;

END;
{-------------------------------------------------------------}
PROCEDURE TfrmExtract.RadioGroup1Click(Sender: TObject);
BEGIN
	IF ( RadioGroup1.ItemIndex = 0 ) AND
  		( frmMain.ListView1.Selected = NIL ) THEN
  	RadioGroup1.ItemIndex := 1;
END;
{-------------------------------------------------------------}

END.

