UNIT Unit1;


INTERFACE


USES
	Windows, SysUtils, Classes, Controls, Forms,	Dialogs, StdCtrls,
	ComCtrls, FileCtrl, Graphics, Buttons, ExtCtrls, Menus, AwkGbls,
  AwkMain, AwkTypes, Err_Msgs, Zipper;


TYPE
	TfrmAddFiles = CLASS( TForm )
		OpenDialog1		: TOpenDialog;
    	lstFileSpec		: TListBox;

     (* Buttons *)
		btnAddDir		: TButton;
		btnPassword		: TButton;
     btnOK				: TBitBtn;
    	btnClose			: TBitBtn;
    	btnSelectDir	: TBitBtn;
    	BitBtn1			: TBitBtn;

     (* Edit controls *)
		edtFileSpec		: TEdit;
		edtDefaultDir	: TEdit;
    	edtDirFileSpec	: TEdit;

     (* Labels & misc *)
		Label1			: TLabel;
    	Label2			: TLabel;
		Panel1			: TPanel;

     (* Switch radio buttons (members
     	stored in items property *)
		rgSwitch			: TRadioGroup;

     (* Directory selection group *)
		GroupBox1		: TGroupBox;
		ckbRecurseDirs	: TCheckBox;
		ckbStoreDirs	: TCheckBox;

     (* SkipFiles group *)
    	GroupBox2		: TGroupBox;
    	ckbArchive		: TCheckBox;
    	ckbReadOnly		: TCheckBox;
    	ckbHidden		: TCheckBox;
    	ckbSysFile		: TCheckBox;
    	ckbVolumeID		: TCheckBox;

    	PopupMenu1		: TPopupMenu;
    	RemoveSelected1: TMenuItem;
    	RemoveAll1		: TMenuItem;

     (* Methods Selection *)
    	rgMethod			: TRadioGroup;
   	rbStore			: TRadioButton;
    	rbDeflate		: TRadioButton;
    	rbFuse			: TRadioButton;
     rbFrozen			: TRadioButton;
     rbFastest		: TRadioButton;

     (* Compressor selection *)
    	Panel2			: TPanel;
     rbBh				: TRadioButton;
     rbArj				: TRadioButton;
     rbGZip			: TRadioButton;
     rbLha				: TRadioButton;
     rbZip				: TRadioButton;
     rbTar				: TRadioButton;
     rbZoo				: TRadioButton;


		PROCEDURE FormActivate( Sender: TObject );
		PROCEDURE rgSwitchClick( Sender: TObject );

		PROCEDURE InitializeNewCompressComponent;
		PROCEDURE SetSkipFilesState;
		PROCEDURE SetCompressMethodState;

		PROCEDURE ckbRecurseDirsClick( Sender: TObject );
		PROCEDURE ckbStoreDirsClick( Sender: TObject );

		PROCEDURE btnOKClick( Sender: TObject );
		PROCEDURE btnAddFilesClick( Sender: TObject );
		PROCEDURE btnAddDirClick( Sender: TObject );
		PROCEDURE btnCloseClick( Sender: TObject );
		PROCEDURE btnPasswordClick( Sender: TObject );
		PROCEDURE btnSelectDirClick( Sender: TObject );

    	PROCEDURE PopupMenu1Popup( Sender: TObject );
    	PROCEDURE MethodButtonsClick(Sender: TObject);
    	PROCEDURE DefineCompressorClick(Sender: TObject);

    	PROCEDURE edtDefaultDirKeyPress( Sender: TObject; VAR Key: CHAR );
		PROCEDURE edtFileSpecKeyPress( Sender: TObject; VAR Key: CHAR );
    	PROCEDURE edtDirFileSpecExit(Sender: TObject);
    	PROCEDURE edtFileSpecEnter(Sender: TObject);
    	PROCEDURE ckbArchiveClick(Sender: TObject);
    	PROCEDURE ckbReadOnlyClick(Sender: TObject);
    	PROCEDURE ckbHiddenClick(Sender: TObject);
    	PROCEDURE ckbSysFileClick(Sender: TObject);
    	PROCEDURE ckbVolumeIDClick(Sender: TObject);
	PRIVATE
		FUNCTION  AddToList: BOOLEAN;
	PUBLIC
	END;



VAR
	frmAddFiles: TfrmAddFiles;



IMPLEMENTATION



USES
	Main;


{$R *.DFM}


{-------------------------------------------------------------}

										(* assign the ItemIndex of rgSwitch
											( option buttons ) to the Switch property *)

PROCEDURE TfrmAddFiles.rgSwitchClick( Sender: TObject );
BEGIN
	CompressComponent.Switch := TSwitch( rgSwitch.ItemIndex );
END;
{-------------------------------------------------------------}

										(* assign the checked value of the CheckBox
											to RecurseDirs property *)
PROCEDURE TfrmAddFiles.ckbRecurseDirsClick( Sender: TObject );
BEGIN
	CompressComponent.RecurseDirs := ckbRecurseDirs.Checked;
END;
{-------------------------------------------------------------}

										(* assign the checked value of the CheckBox
											to StoreDirs property *)
PROCEDURE TfrmAddFiles.ckbStoreDirsClick( Sender: TObject );
BEGIN
	CompressComponent.StoreDirs := ckbStoreDirs.Checked;
END;
{-------------------------------------------------------------}
PROCEDURE TfrmAddFiles.btnOKClick( Sender: TObject );
BEGIN

	IF edtFileSpec.Text <> '' THEN
  	IF MessageDlg( 'Add file: ' + edtFileSpec.Text,
     		mtConfirmation,
           [ mbYes, mbNo ],
           0 ) = mrYes THEN

     	IF lstFileSpec.Items.Indexof( edtFileSpec.Text ) = -1 THEN
        BEGIN
  			lstFileSpec.Items.Insert( 0, edtFileSpec.Text );
        	lstFileSpec.ItemIndex := 0;
        END;


	edtFileSpec.Text := '';


	IF lstFileSpec.Items.Count > 0 THEN
	BEGIN

    CompressComponent.FileSpec.Assign( lstFileSpec.Items );
    ModalResult := mrOK;

  END;

END;
{-------------------------------------------------------------}

										(* Add Files Button *)
PROCEDURE TfrmAddFiles.btnAddFilesClick( Sender: TObject );

VAR
	i: INTEGER;

BEGIN

  IF edtFileSpec.Text <> '' THEN
		OpenDialog1.FileName := ExtractFilename( edtFileSpec.Text )
  ELSE
		OpenDialog1.FileName := '*.*';

	OpenDialog1.Title := 'Select file( s ) to add ( Ctrl+Click or Shift+Click )';

	IF OpenDialog1.Execute THEN
		FOR i := 0 to OpenDialog1.Files.Count - 1 DO
     	IF lstFileSpec.Items.Indexof( OpenDialog1.Files[i] ) = -1 THEN
        BEGIN
        	lstFileSpec.Items.Insert( 0, OpenDialog1.Files[i] );
        	lstFileSpec.ItemIndex := 0;
        END;

  IF lstFileSpec.Items.Count > 0 THEN
  	btnOK.Enabled := TRUE;
     
  edtFileSpec.Setfocus;

END;
{-------------------------------------------------------------}

										(* Add Directory Button *)
PROCEDURE TfrmAddFiles.btnAddDirClick( Sender: TObject );
VAR
	Dir, Spec: STRING;
BEGIN

  Dir := edtDefaultDir.Text;

	//IF SelectDirectory( Dir, [sdAllowCreate, sdPerformCreate, sdPrompt], -1 ) THEN
	IF SelectDirectory( Dir, [sdPrompt], -1 ) THEN
  BEGIN

		SetCurrentDir( Dir );
     edtDefaultDir.Text := Dir;

     Dir := AppendDirTail( Dir );
     Spec := Dir + ExtractFilename( edtDirFileSpec.Text );

     IF lstFileSpec.Items.Indexof( Spec ) = -1 THEN
     BEGIN
     	lstFileSpec.Items.Insert( 0, Spec );
        lstFileSpec.ItemIndex := 0;
  		btnOK.Enabled := TRUE;
     END;

     edtFileSpec.Setfocus;

  END;

END;
{-------------------------------------------------------------}

										(* Close Button *)
PROCEDURE TfrmAddFiles.btnCloseClick( Sender: TObject );
BEGIN
	Close;
	ModalResult := mrCancel;
END;
{-------------------------------------------------------------}

										(* Password Button *)
PROCEDURE TfrmAddFiles.btnPasswordClick( Sender: TObject );
VAR
  PW			,
	FirstPW	: STRING;
  Prompt	,
  Caption	: STRING;
  i		 	: INTEGER;
  Protect	: BOOLEAN;
BEGIN

	Protect := TRUE;
  									(* Get password input twice.  Second time is
                             	for verification *)
	FOR i := 1 TO 2 DO
  BEGIN

     IF Protect THEN
     BEGIN

        CASE i OF
           1:	BEGIN
                 Caption := 'Security Encryption...';
                 Prompt  := 'Enter Password:';
              END;
           2:	BEGIN
                 FirstPW := PW;
                 Caption := 'Verify Password...';
                 Prompt  := 'Re-enter Password:';
              END;
        END;

        PW := '';
        WHILE ( PW = '' ) DO
           IF NOT InputQuery( Caption, Prompt, PW ) THEN
           BEGIN
              Protect := FALSE;		(* Cancel selected *)
              Break;
           END;
     END;
  END;


  IF Protect THEN
     IF CompareStr( FirstPW, PW ) <> 0 THEN
     BEGIN
        MessageDlg( 'Password verification failed.'#13#13 +
        				'Please retry...', mtInformation, [ mbOK ], 0 );
        Protect := False;
     END;


	IF Protect THEN
  BEGIN
     CompressComponent.Password := FirstPW;
     btnPassword.Caption := 'PROTECTED';
  END ELSE BEGIN
     CompressComponent.Password := '';
     btnPassword.Caption := '&Password';
  END;

END;
{-------------------------------------------------------------}
PROCEDURE TfrmAddFiles.InitializeNewCompressComponent;
BEGIN

  (* Check/Uncheck SkipFiles *)
	SetSkipFilesState;


  (* Check/Uncheck compression active method *)
  SetCompressMethodState;


  (* Set check state of properties RecurseDirs & StoreDirs *)
	ckbRecurseDirs.Checked 	:= CompressComponent.RecurseDirs;
	ckbStoreDirs.Checked 	:= CompressComponent.StoreDirs;


  (* Set index of active switch *)
	IF CompressComponent.Switch > swMove THEN
		CompressComponent.Switch := swAdd;

	rgSwitch.ItemIndex := Ord( CompressComponent.Switch );


  (* If the active component's DefaultDir is blank, set to current dir *)
	IF ( CompressComponent.DefaultDir = '' ) OR
			( NOT DirectoryExists( CompressComponent.DefaultDir ) ) THEN
		CompressComponent.DefaultDir := GetCurrentDir;

  edtDefaultDir.Text := CompressComponent.DefaultDir;


  (* Clear the components FileSpec property *)
  CompressComponent.FileSpec.Clear;


  (* Clear the ListBox *)
	lstFileSpec.Clear;


  (* Disable OK when ListBox is blank *)
  btnOK.Enabled := FALSE;


  (* Set focus to edit control FileSpec *)
	edtFileSpec.SetFocus;

  
  (* If component supports password encryption,
     set buttons enabled property, else disable *)
  WITH CompressComponent DO
  	btnPassword.Enabled := IsPasswordSupported( ArcType );

END;
{-------------------------------------------------------------}
PROCEDURE TfrmAddFiles.SetSkipFilesState;
BEGIN
  (* Check/uncheck SkipFiles selections *)
  ckbArchive.Checked  := CompressComponent.FileAttribute.ftArchive;
  ckbReadOnly.Checked := CompressComponent.FileAttribute.ftReadOnly;
  ckbHidden.Checked   := CompressComponent.FileAttribute.ftHidden;
  ckbSysFile.Checked  := CompressComponent.FileAttribute.ftSysFile;
  ckbVolumeID.Checked := CompressComponent.FileAttribute.ftVolumeID;
END;
{-------------------------------------------------------------}
PROCEDURE TfrmAddFiles.SetCompressMethodState;
BEGIN

  (* Uncheck ALL methods *)
  rbStore.Checked 	:= FALSE;  (* stored always enabled *)
  rbDeflate.Checked := FALSE;
  rbFuse.Checked 	:= FALSE;
  rbFrozen.Checked 	:= FALSE;
  rbFastest.Checked := FALSE;

  (* Enable / Disable Compression Method radio buttons *)
  rbStore.Enabled 	:= ( mtStore 	IN CompressComponent.CompressMethodState );
  rbDeflate.Enabled := ( mtDeflate IN CompressComponent.CompressMethodState );
  rbFuse.Enabled 	:= ( mtFuse 	IN CompressComponent.CompressMethodState );
  rbFrozen.Enabled	:= ( mtFrozen 	IN CompressComponent.CompressMethodState );
  rbFastest.Enabled	:= ( mtFastest	IN CompressComponent.CompressMethodState );

  (* Set the compression method according to the CompressMethod
  	propety in the CompressComponent object *)
  CASE CompressComponent.CompressMethod OF
  	mtStore		: rbStore.Checked 	:= TRUE;
     mtDeflate	: rbDeflate.Checked 	:= TRUE;
     mtFuse		: rbFuse.Checked 		:= TRUE;
     mtFrozen 	: rbFrozen.Checked   := TRUE;
     mtFastest	: rbFastest.Checked  := TRUE;
  END;

END;
{-------------------------------------------------------------}
PROCEDURE TfrmAddFiles.FormActivate( Sender: TObject );
VAR
	Ext: STRING;
BEGIN

	Caption := frmMain.OpenDialog1.Filename;

	IF ( CompressComponent = NIL ) OR
  		( CompressComponent.ArchiveFile = '' ) THEN
  BEGIN

     (* Enable/disable archive type radio buttons *)
     WITH CompressComponent DO	(* IsArcCompressable *)
     BEGIN
        rbArj.Enabled 	:= IsArcCompressable( atARJ  );
        rbBh.Enabled 	:= IsArcCompressable( atBH   );
        rbGZip.Enabled := IsArcCompressable( atGZIP );
        rbLha.Enabled 	:= IsArcCompressable( atLHA  );
        rbTar.Enabled 	:= IsArcCompressable( atTAR  );
        rbZip.Enabled 	:= IsArcCompressable( atZIP  );
        rbZoo.Enabled 	:= IsArcCompressable( atZOO  );
     END;

     Ext := Uppercase( ExtractFileExt( frmMain.OpenDialog1.Filename ) );

     (* Check file extensions first to associate archive type desired *)
     IF Ext = '.BH' THEN
			DefineCompressorClick( rbBh )
     ELSE IF Ext = '.ZIP' THEN
			DefineCompressorClick( rbZip )
     ELSE IF ( Ext = '.LZH' ) OR ( Ext = '.LHA' ) THEN
			DefineCompressorClick( rbLha )
     ELSE IF Ext = '.ZOO' THEN
			DefineCompressorClick( rbZoo )
     ELSE
     								(* Use tag stored in frmMain (default=BH) *)
  		DefineCompressorClick( frmMain );

  END ELSE BEGIN

     (* Since an archive was previously used, enable ONLY that type *)
     rbArj.Enabled 	:= FALSE;
     rbBh.Enabled 	:= FALSE;
     rbGZip.Enabled := FALSE;
     rbLha.Enabled 	:= FALSE;
     rbTar.Enabled 	:= FALSE;
     rbZip.Enabled 	:= FALSE;
     rbZoo.Enabled 	:= FALSE;

     								(* If archive has previously been open
     									then ArcType is retained. *)
  	CASE frmMain.ZipTV1.ArcType OF

     	atBH	: 	BEGIN
        				DefineCompressorClick( rbBh );
                    rbBh.Enabled := TRUE;
        			END;

        atZIP	: 	BEGIN
        				DefineCompressorClick( rbZip );
                    rbZip.Enabled := TRUE;
        			END;

        atLHA,
        atLZH	: 	BEGIN
        				DefineCompressorClick( rbLha );
                    rbLha.Enabled := TRUE;
        			END;

        atZOO	: 	BEGIN
        				DefineCompressorClick( rbZoo );
                    rbZoo.Enabled := TRUE;
        			END;
     ELSE
     	EXIT;
     END;

  END;

END;
{-------------------------------------------------------------}
FUNCTION TfrmAddFiles.AddToList: BOOLEAN;

VAR
	Dir: STRING;

BEGIN

	RESULT := FALSE;

	IF edtFileSpec.Text <> '' THEN
	BEGIN

		Dir := edtDefaultDir.Text;

		IF Pos( '\', edtFileSpec.Text ) = 0 THEN
		BEGIN

			IF NOT DirectoryExists( Dir ) THEN
        BEGIN
        	MessageDlg( Dir + ' does not exist', mtWarning, [ mbOK ], 0 );
           edtDefaultDir.SetFocus;
        	EXIT;
        END;

			IF Pos( ':', edtFileSpec.Text ) > 0 THEN
				edtFileSpec.Text := Copy( edtFileSpec.Text, Pos( ':', edtFileSpec.Text ) + 1, LENGTH( edtFileSpec.Text ) );

			IF Dir[ Length( Dir ) ] = '\' THEN
				SetLength( Dir, Length( Dir ) - 1 );

			IF ( Dir <> '' ) AND
					DirectoryExists( Dir ) THEN
				edtFileSpec.Text := AppendDirTail( Dir ) + edtFileSpec.Text
			ELSE
				edtFileSpec.Text := AppendDirTail( GetCurrentDir ) + edtFileSpec.Text;

		END;

     IF lstFileSpec.Items.Indexof( edtFileSpec.Text ) = -1 THEN
     BEGIN
        lstFileSpec.Items.Insert( 0, edtFileSpec.Text );
        lstFileSpec.ItemIndex := 0;
        btnOK.Enabled := TRUE;
     END;
     edtFileSpec.Text := '';

	END;

	RESULT := TRUE;

END;
{-------------------------------------------------------------}
PROCEDURE TfrmAddFiles.btnSelectDirClick( Sender: TObject );

VAR
	Dir: STRING;

BEGIN

	SetCurrentDir( CompressComponent.DefaultDir );
	IF SelectDirectory( Dir, [sdAllowCreate, sdPerformCreate, sdPrompt], -1 ) THEN
	BEGIN
		CompressComponent.DefaultDir := Dir;
		SetCurrentDir( Dir );
		edtDefaultDir.Text := CompressComponent.DefaultDir;
	END;

END;
{-------------------------------------------------------------}
PROCEDURE TfrmAddFiles.edtDefaultDirKeyPress( Sender: TObject; VAR Key: CHAR );
BEGIN
	IF Key = #13 THEN
  	edtFileSpec.Setfocus;
END;
{-------------------------------------------------------------}
PROCEDURE TfrmAddFiles.edtFileSpecKeyPress( Sender: TObject; VAR Key: CHAR );
BEGIN
	IF Key = #13 THEN
		IF AddToList THEN
			edtFileSpec.Setfocus;
END;
{-------------------------------------------------------------}
PROCEDURE TfrmAddFiles.PopupMenu1Popup( Sender: TObject );

CONST
	REM_SELECTED = 0;
  REM_ALL = 1;

VAR
	i: INTEGER;

BEGIN

	IF lstFileSpec.items.Count > 0 THEN

     CASE TMenuItem( Sender ).MenuIndex OF

        REM_SELECTED:
        	BEGIN
              FOR i := 0 TO lstFileSpec.Items.Count - 1 DO
                 IF lstFileSpec.Selected[ i ] THEN
                    lstFileSpec.Items.Delete( i );

              IF lstFileSpec.Items.Count = 0 THEN
              	btnOK.Enabled := FALSE;
        	END;

        REM_ALL:
           IF MessageDlg( 'Clear all?',
                             mtConfirmation,
                             [ mbYes, mbNo ],
                             0 ) = mrYes THEN
           BEGIN
              lstFileSpec.Clear;
  				btnOK.Enabled := FALSE;
           END;


     END;

END;
{-------------------------------------------------------------}
(** Assign the CompressMethod property **)
(* We placed the (ord)inal value of the members of TCompressMethod
   in the TAG property of the CompressMethodState radio-buttons.
   Acts as an array of radio buttons.

   Ie... TCompressMethod = ( mtStore, mtDeflate, mtFuse....
         rbStore.Tag 	= 0
         rbDeflate.Tag = 1
         rbFuse.Tag 	= 2
         ...etc

    *)
PROCEDURE TfrmAddFiles.MethodButtonsClick(Sender: TObject);
VAR
	CompressMethodIndex: BYTE;
BEGIN

  CompressMethodIndex := TRadioButton( Sender ).TAG;
  CompressComponent.CompressMethod := TCompressMethod( CompressMethodIndex );

END;
{-------------------------------------------------------------}
(* Assign the variable CompressComponent (type TCompBase) the
   desired compression component dropped on the form

   All radio buttons 'tag' property have a stored value that
   this routine checks to verify which was selected.

   If 'New' is selected from the main form (frmMain) retrieve
   the previous archive type used from the stored value in
   frmMain's tag property... else retreive the value of the
   tag property from the radio button selected on this form.

   After radio button is selected, store the selected buttons
   tag value in frmMain.tag property so the last archive type
   used can be set automatically when this form is once again
   activated.

   *)
PROCEDURE TfrmAddFiles.DefineCompressorClick(Sender: TObject);

VAR
	Tag: INTEGER;

CONST
	cArj 		 = 1;
	cBlakHole = 2;
  cGZip 	 = 3;
  cLha		 = 4;
  cTar		 = 5;
  cZip      = 6;
  cZoo      = 7;

BEGIN

  IF ( Sender IS TRadioButton ) THEN

  										(* Clicked a radio button *)
		Tag := TRadioButton( Sender ).Tag

  ELSE
  										(* Called from FormActivate event *)
  	Tag := TForm( Sender ).Tag;



  CASE Tag OF
     //cArj 		:;		(* Component to be added in future versions *)
     cBlakHole: 	BEGIN
     					CompressComponent := frmMain.BlakHole1;
                    rbBh.Checked := TRUE;
                 END;
     //cGZip 	:;			(* Component to be added in future versions *)
     cLha		:			(* Component to be added in future versions *)
     				BEGIN
     					CompressComponent := frmMain.Lha1;
                    rbLha.Checked := TRUE;
                 END;
     //cTar		:;		(* Component to be added in future versions *)
     cZip     : 	BEGIN
     					CompressComponent := frmMain.Zip1;
                    rbZip.Checked := TRUE;
                 END;
     //cZoo     :;		(* Component to be added in future versions *)
  ELSE

  	(* Default *)
     CompressComponent := frmMain.BlakHole1;
     rbBh.Checked := TRUE;
     Tag := rbBh.Tag;

  END;

  (* Store the tag in frmMain *)
  frmMain.Tag := Tag;

  (* Reset form controls to match compression components properties *)
	InitializeNewCompressComponent;

END;
{-------------------------------------------------------------}
PROCEDURE TfrmAddFiles.edtDirFileSpecExit(Sender: TObject);
BEGIN
	IF edtDirFileSpec.Text = '' THEN
  	edtDirFileSpec.Text := '*.*';
END;
{-------------------------------------------------------------}
PROCEDURE TfrmAddFiles.edtFileSpecEnter(Sender: TObject);
BEGIN
	IF edtFileSpec.Text = '' THEN
  	edtFileSpec.Text := '*.*';

	edtFileSpec.SelStart := 0;
  edtFileSpec.SelLength := Length( edtFileSpec.Text );
END;
{-------------------------------------------------------------}
(* Archive CheckBox - Set compression component FileType.ftArchive property *)
PROCEDURE TfrmAddFiles.ckbArchiveClick(Sender: TObject);
BEGIN
	CompressComponent.FileAttribute.ftArchive := ckbArchive.Checked;
END;
{-------------------------------------------------------------}
(* ReadOnly CheckBox - Set compression component FileType.ftReadOnly property *)
PROCEDURE TfrmAddFiles.ckbReadOnlyClick(Sender: TObject);
BEGIN
	CompressComponent.FileAttribute.ftReadOnly := ckbReadOnly.Checked;
END;
{-------------------------------------------------------------}
(* Hidden CheckBox - Set compression component FileType.ftHidden property *)
PROCEDURE TfrmAddFiles.ckbHiddenClick(Sender: TObject);
BEGIN
	CompressComponent.FileAttribute.ftHidden := ckbHidden.Checked;
END;
{-------------------------------------------------------------}
(* SysFile CheckBox - Set compression component FileType.ftSysFile property *)
PROCEDURE TfrmAddFiles.ckbSysFileClick(Sender: TObject);
BEGIN
	CompressComponent.FileAttribute.ftSysFile := ckbSysFile.Checked;
END;
{-------------------------------------------------------------}
(* VolumeID CheckBox - Set compression component FileType.ftVolumeID property *)
PROCEDURE TfrmAddFiles.ckbVolumeIDClick(Sender: TObject);
BEGIN
	CompressComponent.FileAttribute.ftVolumeID := ckbVolumeID.Checked;
END;
{-------------------------------------------------------------}



END.

