{$D-}
(*
  
  ZipTV component for data compression.
  Microchip Data Systems, Carl Bunton
  http://www.conventric.net/~twojags
  TwoJags@cris.com

	Demo application source for the TUnSFX component in the ZipTV
  compression component suite for Delphi.

  Converts several SFX archives types back to their original archive
  state prior to adding the executable stub.

  *)

UNIT Unit1;

INTERFACE

USES
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, UnSFX, AwkMain, ComCtrls, Buttons;

TYPE
  TForm1 = CLASS( TForm )
    UnSFX1			: TUnSFX;
    OpenDialog1	: TOpenDialog;
    StatusBar1	: TStatusBar;

    BitBtn1		: TBitBtn;
    BitBtn2		: TBitBtn;
    btnOpenArchive: TBitBtn;

    edtArchiveFile: TEdit;
    edtOutFilename: TEdit;

    Label1			: TLabel;
    Label2			: TLabel;

    PROCEDURE btnOpenArchiveClick(Sender: TObject);
    PROCEDURE BitBtn1Click(Sender: TObject);
    PROCEDURE UnSFX1Error(Sender: TObject; FN, VolumeID: STRING;
      	ECode: Integer);
    PROCEDURE UnSFX1FileExists(Sender: TObject; FN: string;
      	FileDate: TDateTime; var Accept: Boolean);  (* Ok button *)
  PRIVATE
    { Private declarations }
  PUBLIC
    { Public declarations }
  END;


VAR
  Form1: TForm1;


IMPLEMENTATION

{$R *.DFM}



{-------------------------------------------------------------}
PROCEDURE TForm1.btnOpenArchiveClick(Sender: TObject);
BEGIN
	OpenDialog1.Options := [
  		ofFileMustExist,
        ofPathMustExist,
        ofHideReadOnly
        ];

	IF OpenDialog1.Execute THEN
 	BEGIN
  	UnSFX1.ArchiveFile  := OpenDialog1.Filename;
  	edtArchiveFile.Text := UnSFX1.ArchiveFile;
     edtOutFilename.Text := UnSFX1.OutFilename;
  END;
END;
{-------------------------------------------------------------}
(* Ok button *)
PROCEDURE TForm1.BitBtn1Click(Sender: TObject);
BEGIN
	UnSFX1.ArchiveFile := edtArchiveFile.Text;
  UnSFX1.OutFilename := edtOutFilename.Text;
	UnSFX1.Activate;
  IF FileExists( edtOutFilename.Text ) THEN
  	MessageDlg( 'Finished', mtInformation, [ mbOK ], 0 );
END;
{-------------------------------------------------------------}
PROCEDURE TForm1.UnSFX1Error(Sender: TObject; FN, VolumeID: STRING;
  ECode: Integer);
BEGIN
	MessageDlg( LoadStr( ECode ), mtInformation, [ mbOk ], 0 );
END;
{-------------------------------------------------------------}
PROCEDURE TForm1.UnSFX1FileExists(Sender: TObject; FN: STRING;
  FileDate: TDateTime; var Accept: Boolean);
BEGIN
	IF MessageDlg( FN + ' already exists, overwrite?' + #13#13'OnFileExists Event...', mtInformation, [mbYes,mbNo], 0 ) = mrNo THEN
  	Accept := FALSE;
END;
{-------------------------------------------------------------}

END.

