(**********************************************************************

	Copyright 1998, Microchip Data Systems / Carl Bunton

  Under license agreement, this source module may be used only on a
  single computer.

  No partion of this module may be reproduced, copied, revised, edited,
  or transmited via electronic means except in compiled format.

  Web-site:  http://www.concentric.net/~twojags
  Email:     TwoJags@cris.com

**********************************************************************)


(**********************************************************************

TUnRAR for the ZipTV compression component package for Delphi is not
included in ZipTV solely due to the fact it uses an external DLL to
extract files.



Incorporating TUnRAR in ZipTV (Delphi 2):
  1. Copy UnRAR.PAS in the directory where the ZipTV package was installed.
  2. Copy UnRAR.DLL in your \windows\system directory.

  3.
  	To install into ZipTV's package:
  		a.	RegPack.PAS: add UnRar in the "USES" clause.
     	b. RegPack.PAS: in the "Register Procedure", add "UnRar.Register".

  	To install as a singular component (ZipTV must be installed):
  		a. Copy this unit into the directory where ZipTV was installed.
     	b. Menu 'Component', submenu 'Install'
     	c. Button 'Add', button 'Browse'
     	d. Find and select this file 'UnRAR.PAS'
     	e. Button 'ok'

  4. AwkGbls.PAS: Const "Decompress_ArcType", add the following line:
  	atRAR..atRarExe.
  5. Rebuild your library. (menu 'Component', submenu 'Rebuild Library')

  6. Edit the ZPTVDEMO demo program (in zptvdemo.zip) as follows:
  	a. Main.PAS: Drop a UnRAR component on the form.
     b. Main.PAS: unrem all occurances of atRar & atRarExe.
     c. Main.Pas: unrem all occurances of UnRAR1.
     d. AwkGbls.PAS: unrem atRAR..atRarExe from const "Decompress_ArcType".



Incorporating TUnRAR in ZipTV (Delphi 3):
  1. Copy UnRAR.PAS in the directory where the ZipTV package was installed.
  2. Copy UnRAR.DLL in your \windows\system directory.

  3a. In Delphi's IDE, menu 'Component', submenu 'Install Component..'
  3b. Tab 'Into existing package'

          I. Edit Box 'Unit file name': Button 'Browse'.  Find and select
             this unit 'UnRAR.PAS'.
         II. Edit Box 'Search path': make sure the path that contains this
             unit file is included in this path.
        III. Edit Box 'Package file name': Button 'Browse'.  Find and select
             ZipTV's package file 'TZipTV.DPK'.

  4. Button 'Ok'
  5. When asked to save 'TZipTV.DPK' answer Yes.

  6. AwkGbls.PAS: Const "Decompress_ArcType", add the following line:
  	atRAR..atRarExe.

  7. Edit the ZPTVDEMO demo program (in zptvdemo.zip) as follows:
  	a. Main.PAS: Drop a UnRAR component on the form.
     b. Main.PAS: unrem all occurances of atRar & atRarExe.
     c. Main.Pas: unrem all occurances of UnRAR1.
     d. AwkGbls.PAS: unrem atRAR..atRarExe from const "Decompress_ArcType".


**********************************************************************
**********************************************************************
	Making TUnRAR compatible with the TZipCheck, TZipSearch and
  TTurboSearch components.
**********************************************************************

  Installation into the ZipTV component package is required prior to
  exercising the following steps!

  ZipCheck.PAS & ZipSrch.PAS
  	a. Add UnRAR to the USES clause.
  	b. Unrem the following line:
  	   //atRar, atRarExe	: zcUnBASE := TUnRAR.Create ( NIL );

  AwkGbls.PAS
  	The const defination for 'Verify_ArcType' unrem the following
     line:
     //atRAR..atRarExe;

  	The const defination for 'Search_ArcType' unrem the following
     line:
     //atRAR..atRarExe;


*************************     -NOTES-       **************************

1. TUnRAR requires the installation of the ZipTV compression package.
They can be downloaded from the web-site listed at the top of this
page header.

2. The 'Password' property in TUnRAR is not compatible with the
'Passwords' property other decompression components in ZipTV.  This
property is of type STRING instead of type TStringList.  This should
be only a very minor inconvience of entering a single password versus
a list of passwords.

**********************************************************************

If there are any problems installing this component, don't hesitate to
contact me:

Carl Bunton
email: twojags@concentric.net

**********************************************************************)



(**********************************************************************
Version 1.41 2/27/98
	- Added support for use with the TZipSearch component
  - Added Password property	 	( encrypted archives untested )
	- Added OnGetPassword event 	( encrypted archives untested )
  - Added ProgressNotify property
  - Added OnProgress event		( minimal support )
  - Connected the OnFileExists event
  - Now extracts to stored directories when 'UseStoredDirs' property
  is true.

Version 1.40 2/23/98
	- Added support for use with the TZipCheck component
	  in the ZipTV package.
  - Finished installing events compatible with the other decompression
    components in the ZipTV package.

Version 1.30 (beta) 01/24/98
	- Requires ZipTV version 1.30+
	- There may be an event or two that currently aren't connected.
**********************************************************************)
UNIT UnRAR;

INTERFACE

USES
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Dsgnintf, AwkMain, AwkTypes, AwkGbls, Err_Msgs;

TYPE
  TChangeVolProc   = Function(ArcName: PCHAR; Mode: INTEGER):INTEGER; CDECL;
  TProcessDataProc = Function(Addr: PChar; Size: INTEGER):INTEGER; CDECL;
  TOnNextVol       = PROCEDURE( Sender: TObject; ArcName: STRING; Cancel: BOOLEAN ) OF OBJECT;


  TUnRAR = CLASS(TUnBase)
  PRIVATE
     FOnNextVol: TOnNextVol;
     FPassword: STRING;

		FUNCTION  OutProcessFileError(Error: INTEGER): INTEGER;
		PROCEDURE ExtractFile(ArcName:PCHAR; Mode:INTEGER);
  PROTECTED
  PUBLIC
		CONSTRUCTOR Create( AOwner: TComponent ); OVERRIDE;
		DESTRUCTOR Destroy; OVERRIDE;

		PROCEDURE ExtractIT; OVERRIDE;
  PUBLISHED
		PROPERTY  ArcType;
		PROPERTY  FileSpec;
		//PROPERTY  Passwords;
     PROPERTY  Password: STRING READ FPassword WRITE FPassword;
		PROPERTY  ProgressNotify;
		PROPERTY  UseStoredDirs;
		PROPERTY  ExtractDir;

		PROPERTY  OnActivate;
		PROPERTY  OnDeactivate;
		PROPERTY  OnProgress;
		PROPERTY  OnGetPassword;
		PROPERTY  OnBegin;
		PROPERTY  OnEnd;
		PROPERTY  OnFileExists;
		PROPERTY  OnError;
     PROPERTY  OnNextVol: TOnNextVol READ FOnNextVol Write FOnNextVol;
  END;



{-$DEFINE DEBUG}


FUNCTION RAROpenArchive(VAR ArchiveData:RAROpenArchiveData):THandle;
         STDCALL; EXTERNAL 'unrar.dll';
FUNCTION RARCloseArchive(hArcData:THandle):INTEGER;
         STDCALL; EXTERNAL 'unrar.dll';
FUNCTION RARReadHeader(hArcData:THandle;  VAR  HeaderData:RARHeaderData):INTEGER;
         STDCALL; EXTERNAL 'unrar.dll';
FUNCTION RARProcessFile(hArcData:THandle; Operation:INTEGER; DestPath, DestName:PChar):INTEGER;
         STDCALL; EXTERNAL 'unrar.dll';
PROCEDURE RARSetChangeVolProc(hArcData:THandle; CVP:TChangeVolProc);
         STDCALL; EXTERNAL 'unrar.dll';
PROCEDURE RARSetProcessDataProc(hArcData:THandle; PDP:TProcessDataProc);
         STDCALL; EXTERNAL 'unrar.dll';
PROCEDURE RARSetPassword(hArcData:THandle; Password:PChar);
         STDCALL; EXTERNAL 'unrar.dll';



FUNCTION ChangeVolProc(ArcName: PChar; Mode: INTEGER): INTEGER; CDECL;
FUNCTION ProcessDataProc(Addr:PChar; Size:integer): INTEGER;  CDECL;




PROCEDURE Register;


IMPLEMENTATION

CONST
	MHD_MULT_VOL       = 1;
	MHD_COMMENT        = 2;
	MHD_LOCK           = 4;
	MHD_SOLID          = 8;
	MHD_PACK_COMMENT   = 16;
	MHD_AV             = 32;
	MHD_PROTECT        = 64;

	LHD_SPLIT_BEFORE   = 1;
	LHD_SPLIT_AFTER    = 2;
	LHD_PASSWORD       = 4;
	LHD_COMMENT        = 8;
	LHD_SOLID          = 16;


CONST
  ERAR_END_ARCHIVE    = 10;
  ERAR_NO_MEMORY      = 11;
  ERAR_BAD_DATA       = 12;
  ERAR_BAD_ARCHIVE    = 13;
  ERAR_UNKNOWN_FORMAT = 14;
  ERAR_EOPEN          = 15;
  ERAR_ECREATE        = 16;
  ERAR_ECLOSE         = 17;
  ERAR_EREAD          = 18;
  ERAR_EWRITE         = 19;
  ERAR_SMALL_BUF      = 20;

  RAR_OM_LIST         =  0;
  RAR_OM_EXTRACT      =  1;

  RAR_SKIP            =  0;
  RAR_TEST            =  1;
  RAR_EXTRACT         =  2;

  RAR_VOL_ASK         =  0;
  RAR_VOL_NOTIFY      =  1;

CONST
 CEXTRACT	= 0;
 CTEST		= 1;
 CPRINT		= 2;



VAR
	Me: TUnRAR;
 	HeaderData: RARHeaderData;



{-------------------------------------------------------------}
PROCEDURE Register;
BEGIN
  RegisterComponents('ZipTV', [TUnRAR]);
	RegisterPropertyEditor( TypeInfo( STRING ),TUnRAR,'About', TAboutShow );
	//RegisterPropertyEditor( TypeInfo( STRING ),TUnRAR,'ExtractDir', TShowDir );
	RegisterPropertyEditor( TypeInfo( STRING ),TUnRAR,'ArchiveFile', TOpenShow );
END;
{-------------------------------------------------------------}
CONSTRUCTOR TUnRAR.Create(AOwner: TComponent);
BEGIN
	INHERITED Create(AOwner);
END;
{-------------------------------------------------------------}
DESTRUCTOR TUnRAR.Destroy;
BEGIN
	INHERITED Destroy;
END;
{-------------------------------------------------------------}
FUNCTION ProcessDataProc(Addr:PCHAR; Size:INTEGER): INTEGER;
BEGIN

	(* this function is currently not used *)
  Dec( Bytes_To_Go, Size );

  IF CalcProgress( False, PMode, Percent, HeaderData.UnpackedSize - Bytes_To_Go, HeaderData.UnpackedSize ) THEN
  	DoProgress( Percent );

  (* Access is not required with TZipCheck (ExtToVerify) because
     the status (crc pass/fail) is passed to TZipCheck via the
     OnEnd event in the 'ExtractFile' procedure *)
  IF ( ExtractMethod <> ExtToFile ) AND ( ExtractMethod <> ExtToVerify ) THEN
    Write_Buf( Addr^, Size );

  ProcessDataProc := 1;

END;
{-------------------------------------------------------------}
FUNCTION TUnRAR.OutProcessFileError(Error: INTEGER): INTEGER;
VAR
	RC: INTEGER;
BEGIN

  CASE Error OF
     ERAR_NO_MEMORY		  : RC := E_MEMERR;
     ERAR_EOPEN			  : RC := E_FOPEN;
     ERAR_BAD_ARCHIVE	  : RC := E_INVALIDARC;
     ERAR_BAD_DATA		  : RC := E_BADHEADR;
     ERAR_UNKNOWN_FORMAT : RC := E_INVALIDARC;
     ERAR_ECREATE		  : RC := E_FWRITE;
     ERAR_ECLOSE			  : RC := E_FCLOSE;
     ERAR_EREAD			  : RC := E_FREAD;
     ERAR_EWRITE			  : RC := E_FWRITE;
  ELSE
  	RC := 0;		(* satisfy compiler *)
  END;

  RESULT := RC;

END;
{-------------------------------------------------------------}
FUNCTION ChangeVolProc(ArcName: PChar; Mode: INTEGER): INTEGER;
VAR
  Cancel: BOOLEAN;
BEGIN

  Result := 1;

  IF Mode = RAR_VOL_ASK THEN
  	IF Assigned( Me.OnNextVol ) THEN
     BEGIN
     	Cancel := TRUE;
     	Me.OnNextVol( Me, StrPas( ArcName ), Cancel );
        IF Cancel THEN
        	Result := 0;
     END;

END;
{-------------------------------------------------------------}
PROCEDURE TUnRAR.ExtractFile(ArcName:PCHAR; Mode:INTEGER);
VAR
	ModoOp,
	RHCode,
  PFCode: INTEGER;
 	hArcData: THandle;
 	//HeaderData: RARHeaderData;
 	OpenArchiveData: RAROpenArchiveData;
  CmtBuf: ARRAY[1..16384] OF CHAR;
  Accept: BOOLEAN;
  IsFilespecWild: BOOLEAN;
BEGIN

  Me := Self;
	RecNum := 0;

	TRY

		IF ( ArchiveFile = '' ) THEN
			RaiseError( E_RAISE, ArchiveFile, '0', E_INVALIDFN )
		ELSE
			IF NOT ( ArcType in [ atRar, atRarExe ] ) THEN
				RaiseError( E_RAISE, ArchiveFile, '0', E_INVALIDARC );


     IF assigned( OnActivate ) THEN
        OnActivate( TObject( Self ) );

     TRY

        OpenArchiveData.ArcName 	:= ArcName;
        OpenArchiveData.CmtBuf		:=	@CmtBuf[ 1 ];
        OpenArchiveData.CmtBufSize	:=	SizeOf( CmtBuf );
        OpenArchiveData.OpenMode	:=	RAR_OM_EXTRACT;

        hArcData := RAROpenArchive( OpenArchiveData );
        IF OpenArchiveData.OpenResult <> 0 THEN
           RaiseError( E_RAISE,
           					ArcName,
              				'0',
              				OutProcessFileError( OpenArchiveData.OpenResult )
                          );

  		//IF OpenArchiveData.CmtState = 1 THEN
  		//	ShowComment(@CmtBuf[1]);	{ShowComment(CmtBuf:PCHAR);}

     	RARSetProcessDataProc(hArcData,ProcessDataProc);
  		RARSetChangeVolProc( hArcData, ChangeVolProc );

    		HeaderData.CmtBuf	:= NIL;

      	TRY

           Cancel := FALSE;
           IsFilespecWild := IsWildCard( FileSpec );

           IF Mode = CExtract THEN
              ModoOP := RAR_EXTRACT
           ELSE
           	ModoOP := RAR_TEST;

           RHCode := RARReadHeader(hArcData, HeaderData);
           WHILE RHCode = 0 DO
           BEGIN

           	IF Cancel THEN BREAK;

              FFilename := Trim( HeaderData.FileName1 );
              SetLength( FFilename, Pos( #0, HeaderData.Filename1 ) - 1 );


              IF ( ( HeaderData.ExternalAttr AND faDirectory ) = 0 ) AND
                    WildCard( FFilename, FileSpec, FALSE ) THEN
              BEGIN


                 Accept := true;

                 (* Unlike other components in the ZipTV component package,
                 TUnRAR must ask for a password with each file in the archive. *)
                 IF ( ( HeaderData.HeadFlags AND LHD_PASSWORD ) = LHD_PASSWORD  ) {AND
                 		( Password = '' ) } THEN
                 BEGIN

                    IF assigned( OnGetPassword ) THEN
                    	OnGetPassword( TObject( Self ), Filename, FPassword, Accept );

                    IF Password = '' THEN
                    	Accept := FALSE;

                    IF NOT Accept THEN
                    	EXIT;

                    IF FPassword <> '' THEN
                       RARSetPassword( hArcData, PCHAR( FPassword ) );

                 END;

                 Filename := FFilename;
                 Bytes_To_Go := HeaderData.UnpackedSize;

                 Accept := true;
                 IF ExtractMethod = ExtToFile THEN
                    IF FileExistsFix( Filename ) THEN
                       IF assigned( OnFileExists ) THEN
                          OnFileExists( TObject( Self ),
                             Filename,
                             ConvertDate( HeaderData.FileDate ),
                             Accept );

                 IF Accept THEN
                    IF assigned( OnBegin ) THEN
                       OnBegin( TObject( Self ), Filename, RecNum + 1, Accept );

                 IF Accept THEN
                 BEGIN

                    PFCode := RARProcessFile(hArcData,
                                               ModoOP,
                                               PCHAR( ExtractFilePath( FFilename ) ),
                                               PCHAR( FFilename )
                                               );
                    IF PFCode <> 0 THEN
                    BEGIN

                       RaiseErrorStr( Filename, '0', OutProcessFileError( PFCode ) );
                       IF assigned( OnEnd ) THEN
                          OnEnd( TObject( self ),	Filename, FALSE )

                    END ELSE
                                (* If we reach this area, extraction, test,
                                   or print was successful. *)
                       IF assigned( OnEnd ) THEN
                          OnEnd( TObject( self ),	Filename, TRUE );


                    IF NOT IsFilespecWild THEN
                       Break;

                 END ELSE BEGIN

                    IF NOT IsFilespecWild THEN
                       Break
                    ELSE
                       (* The current header did not match the FileSpec property,
                          the below line effectively advances the filepointer
                          without performing any other function *)
                       {PFCode := }RARProcessFile( hArcData, RAR_SKIP, NIL, NIL );

                 END;

              END ELSE

                 (* The current header did not match the FileSpec property,
                    the below line effectively advances the filepointer
                    without performing any other function *)
                 {PFCode := }RARProcessFile( hArcData, RAR_SKIP, NIL, NIL );

              RHCode := RARReadHeader(hArcData, HeaderData);

           END;

           IF ( RHCode = ERAR_BAD_DATA ) THEN
              RaiseError( E_RAISE, Filename, '0', E_BADHEADR );

        FINALLY

           {PFCode := }RARCloseArchive( hArcData );

        END;

		FINALLY

			IF assigned( OnDeactivate ) THEN
				OnDeactivate( TObject( Self ) );

		END;

	EXCEPT

		ON E: E_RAISE DO
     	;
			{MessageDlg( E.Message,mtinformation,[ mbOk ],0 );}

	END;

END;
{-------------------------------------------------------------}
PROCEDURE TUnRAR.ExtractIT;
VAR
	s: STRING;
BEGIN

	DoProgress := RetProgress;		(* RetProgress is class UnBASE *)
	(* convert ProgressNotify from set to numeral *)
	PMode := ( ord( ProgressNotify ) + 1 ) * 5;

	s := FArchiveFile;
  IF ExtractMethod = ExtToFile THEN
		ExtractFile( @s[ 1 ], CExtract )
  ELSE
		ExtractFile( @s[ 1 ], CTest );

END;
{-------------------------------------------------------------}

END.

