{$D-}
(***********************************************************
	Requires the ZipTV compression component package (version 1.32+).
  ZipTV can be downloaded from the following web-site:
  www.concentric.net/~twojags
***********************************************************)

(*
  This demo performs decompression searches on the following archive
  types when found in the directory:

  	ARC, Arc SFX, Arj, Arj SFX, BlakHole, BlakHole SFX, CAB,
     GZip, Lha, Lha SFX, Lzh, Lzh SFX, PAK, TAR, ZIP (.9 - 2.5),
     Zip SFX (.9 - 2.5), Zip (2.5+), Zip SFX (2.5+), ZOO.

     The TUnRAR decompression component is available for download
     from our web-site.  The RAR format can also be added to the
     above list when this component is installed.

     ************************************************************

     Any notable enhancements to this demo would be much appreciated
     for posting on our web-site.  Include your name/email and date
     below.

     ************************************************************

     Original version: 2/5/98 by Carl Bunton twojags@cris.com

     ************************************************************
*)
UNIT Main;

INTERFACE

USES
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, AwkMain, FileCtrl, ComCtrls, Err_Msgs, ExtCtrls, ZipSrch, TrboSrch;

TYPE
  TForm1 = CLASS(TForm)
    	pbxLed		: TPaintBox;
    	imgLed		: TImage;
    	TreeView1	: TTreeView;
    	StatusBar1	: TStatusBar;
    	DrvComboBox1: TDriveComboBox;
    	FileListBox1: TFileListBox;
    	TurboSearch1: TTurboSearch;
    	DirListBox1	: TDirectoryListBox;

    	GroupBox1	: TGroupBox;
    	GroupBox2	: TGroupBox;

    	ckbArchive	: TCheckBox;
    	ckbReadOnly	: TCheckBox;
    	ckbHidden	: TCheckBox;
    	ckbSysFile	: TCheckBox;
    	ckbVolumeID	: TCheckBox;

    	RadioGroup1	: TRadioGroup;
    	RadioGroup2	: TRadioGroup;
    	RadioGroup3	: TRadioGroup;

    	pnlStatus	: TPanel;
    	Panel1		: TPanel;
    	Panel2		: TPanel;
    	Panel3		: TPanel;
    	Panel4		: TPanel;

    	Label1		: TLabel;
    	Label2		: TLabel;
    	Label4		: TLabel;
    	Label5		: TLabel;

    	Edit1			: TEdit;
    	Edit2			: TEdit;
    	Edit3			: TEdit;
    	Edit4			: TEdit;
    	Edit5			: TEdit;

    	Button1		: TButton;
    	Button2		: TButton;

    	PROCEDURE Button1Click(Sender: TObject);
		PROCEDURE ApplicationBusy;
		PROCEDURE ApplicationWaiting;

	  	PROCEDURE DoSearch;
    	PROCEDURE SetFileType(Sender: TObject);
    	PROCEDURE FormActivate(Sender: TObject);
    	PROCEDURE Edit5Change(Sender: TObject);
    	PROCEDURE FileListBox1DblClick(Sender: TObject);
    	PROCEDURE pbxLedClick(Sender: TObject);
    	PROCEDURE pbxLedPaint(Sender: TObject);
		PROCEDURE SetLedColor(lColor: TColor);
    	PROCEDURE Button2Click(Sender: TObject);
    	PROCEDURE pbxLedMouseMove(Sender: TObject; Shift: TShiftState; X,Y: INTEGER);
    	PROCEDURE TurboSearch1ElaspedTime(Sender: TObject; ElaspedTime: Real);
    	PROCEDURE TurboSearch1Error(Sender: TObject; FN, VolumeID: STRING; ECode: Integer);
    	PROCEDURE TurboSearch1FileChange(Sender: TObject; SearchFile, SearchText: STRING);
    	PROCEDURE TurboSearch1Finish(Sender: TObject; Files, Matches, Bytes: Integer);
    	PROCEDURE TurboSearch1GetPassword(Sender: TObject; FN: STRING;
      	VAR Password: STRING; VAR TryAgain: Boolean);
    	PROCEDURE TurboSearch1NextVolume(Sender: TObject; VAR Dir, FN: STRING;
      	VolumeID: STRING; VAR Cancel: Boolean);

  PRIVATE
    { Private declarations }
  PUBLIC
    { Public declarations }
  END;



VAR
  Form1: TForm1;

	TotalDiskFiles,				(* disk files searched *)
  TotalDecompressedFiles,		(* files decompressed and searched *)
  TotalBytes: INTEGER;			(* bytes searched *)
  TotalTime: REAL;				(* search time (seconds) *)




IMPLEMENTATION



{$R *.DFM}




{-------------------------------------------------------------}
(* "Search these files" button *)
PROCEDURE TForm1.Button1Click(Sender: TObject);
BEGIN
	TurboSearch1.FileSpec := Edit5.Text;
  DoSearch;
END;
{-------------------------------------------------------------}
PROCEDURE TForm1.ApplicationBusy;
BEGIN
  Screen.Cursor := crHourGlass;
  SetLedColor( clRed );
END;
{-------------------------------------------------------------}
PROCEDURE TForm1.ApplicationWaiting;
BEGIN
  Screen.Cursor := crDefault;
  SetLedColor( clGreen );
END;
{-------------------------------------------------------------}
(* PROCEDURE - called from Button1Click & FileListBox1DblClick *)
PROCEDURE TForm1.DoSearch;
VAR
	SearchRec : TSearchRec;
  DosError  : INTEGER;
  Dir		 : STRING;
  RootNode  : TTreeNode;
  j			 : INTEGER;
BEGIN

  TreeView1.Items.Clear;

  TotalDecompressedFiles 	:= 0;
  TotalDiskFiles 			:= 0;
  TotalBytes 					:= 0;
  TotalTime 					:= 0.0;

  ApplicationBusy;
  TRY

     (******** Set properties from forms visual controls *********)

                                (* Search all files in the directory.
                                   This will include RawData searches
                                   for normal files and decompression
                                   searches for supported archives.
                                   Unsupported archives are searched
                                   as RawData *)
     CASE RadioGroup3.ItemIndex OF
        0:	TurboSearch1.SearchType := stAllFiles;
        1: TurboSearch1.SearchType := stRawData;
     END;

                                (* Mode: smAsc, smBin, smDec, smHex, smOct *)
     TurboSearch1.SearchMode := TztvSearchMode( RadioGroup1.ItemIndex );

                                (* Search will be case sensitive *)
     TurboSearch1.SearchCase := TztvSearchCase( RadioGroup2.ItemIndex );

                                (* STRING to search *)
     TurboSearch1.SearchText := Edit1.Text;

                                (* Set beginning/ending search offsets *)
     TurboSearch1.OffsetBegin := StrToInt( Edit3.Text );
     TurboSearch1.OffsetEnd := StrToInt( Edit4.Text );
     (************ *************** *************** *************)



     (************     Directory Search Loop       *************)

                                (* Append dir char *)
     Dir := DirListBox1.Directory;
     IF Dir[ Length( Dir ) ] <> '\' THEN
        Dir := Dir + '\';

     DosError := FindFirst( Dir + ExtractFilename( TurboSearch1.FileSpec ),
                             TurboSearch1.FileAttribute.ftFileAttr,
                             SearchRec );

     TRY

        TurboSearch1.FileSpec 	:= Edit2.Text;
        TurboSearch1.Cancel		:= False;

        WHILE DosError = 0 DO
        BEGIN

                                (* Assign the ArchiveFile property *)
           TurboSearch1.ArchiveFile := SearchRec.Name;
           IF TurboSearch1.Cancel THEN Break;

                                (* Activate the search and fill treeview control *)
           IF TurboSearch1.Search THEN
           BEGIN
              TreeView1.Items.BeginUpdate;

              RootNode := TreeView1.Items.Add( TreeView1.TopItem, TurboSearch1.ArchiveFile );
              FOR j := 0 TO Pred( TurboSearch1.CompressedFileList.Count ) DO
                 TreeView1.Items.AddChild(RootNode, TurboSearch1.CompressedFileList.Strings[ j ]);

              TreeView1.Items.EndUpdate;
           END;

                                (* Get the next file in directory *)
           DosError := FindNext( SearchRec );

        END;

     FINALLY

        SysUtils.FindClose( SearchRec );
        StatusBar1.SimpleText := '';

     END;
     (************ ********** Finish up ********** *************)

  FINALLY
  	ApplicationWaiting;
  END;

  MessageDlg( 'Disk Files Searched = ' + IntToStr( TotalDiskFiles ) +
  				#13'Files decompressed = ' + IntToStr( TotalDecompressedFiles ) +
  				#13'Bytes Searched = ' + IntToStr( TotalBytes ) +
              #13#13 + Format( 'Seconds: %g', [ TotalTime ]),
              mtInformation,
              [ mbOK ],
              0 );

	(************ *************** *************** *************)

END;
{-------------------------------------------------------------}
(* PROCEDURE - define the attribute for FindFirst and FileListBox *)
PROCEDURE TForm1.SetFileType(Sender: TObject);
VAR
	FT: TFileType;
BEGIN

	(* Delphi's FileType property (TFileType) is not compatible with
  	FindFirst function, but the FileAttribute property in ZipTV is.
     FT is used for visual display of the FileListBox, and
     TurboSearch1.FileAttribute for use with FindFirst *)

  (*	ZipTV's ftFileAttr property is recalculated each time individul
     boolean FileAttribute properties are defined.  ftFileAttr is
     the actual variable used with FindFirst/Next in this unit. *)
  WITH TurboSearch1.FileAttribute DO
  BEGIN
     ftArchive  := ckbArchive.Checked;
     ftReadOnly := ckbReadOnly.Checked;
     ftHidden   := ckbHidden.Checked;
     ftSysFile  := ckbSysFile.Checked;
     ftVolumeID := ckbVolumeID.Checked;
  END;

  (* Set the FileListBox FileType property to display files matching
  	selected file attributes *)
	IF ckbArchive.Checked 	THEN FT :=      [ ftArchive ];
	IF ckbReadOnly.Checked 	THEN FT := FT + [ ftReadOnly ];
	IF ckbHidden.Checked 	THEN FT := FT + [ ftHidden ];
	IF ckbSysFile.Checked 	THEN FT := FT + [ ftSystem ];
	IF ckbVolumeID.Checked 	THEN FT := FT + [ ftVolumeID ];
	FileListBox1.FileType := FT;

END;
{-------------------------------------------------------------}
(* Edit5 control - OnChange event *)
PROCEDURE TForm1.Edit5Change(Sender: TObject);
BEGIN
	FileListBox1.Mask := Edit5.Text;
END;
{-------------------------------------------------------------}
(* Form - OnActivate event *)
PROCEDURE TForm1.FormActivate(Sender: TObject);
BEGIN
	(* Assign visual form objects from TurboSearch1's properties *)
	Edit1.Text := TurboSearch1.SearchText;
	Edit2.Text := TurboSearch1.FileSpec;
  Edit3.Text := IntToStr( TurboSearch1.OffsetBegin );
  Edit4.Text := IntToStr( TurboSearch1.OffsetEnd   );
	RadioGroup1.ItemIndex := Ord( TurboSearch1.SearchMode );
	RadioGroup2.ItemIndex := Ord( TurboSearch1.SearchCase );
	SetFileType( Sender );
END;
{-------------------------------------------------------------}
(* OnElaspedTime event - collect total time *)
PROCEDURE TForm1.TurboSearch1ElaspedTime(Sender: TObject;
  ElaspedTime: Real);
BEGIN
	TotalTime := TotalTime + ElaspedTime;
END;
{-------------------------------------------------------------}
PROCEDURE TForm1.FileListBox1DblClick(Sender: TObject);
BEGIN
	TurboSearch1.FileSpec := ExtractFilename( FileListBox1.Filename );
  DoSearch;
END;
{-------------------------------------------------------------}
PROCEDURE TForm1.pbxLedClick(Sender: TObject);
BEGIN
	StatusBar1.SimpleText := 'Aborting...';
  TurboSearch1.Cancel := True;
END;
{-------------------------------------------------------------}
PROCEDURE TForm1.pbxLedPaint(Sender: TObject);
BEGIN
	WITH Sender AS TPaintBox DO
	 Canvas.Draw( ( Width - imgLed.Width ) DIV 2,
					( Height - imgLed.Height ) DIV 2,
              imgLed.Picture.Graphic );
END;
{-------------------------------------------------------------}
(* Change colors of little light in corner of form *)
PROCEDURE TForm1.SetLedColor(lColor: TColor);
BEGIN
	WITH imgLed.Canvas DO
	BEGIN
		Brush.Color := lColor;
		FloodFill( 6, 6, Pixels[ 6, 6 ], fsSurface );
	END;
	pbxLed.Repaint;
END;
{-------------------------------------------------------------}
PROCEDURE TForm1.Button2Click(Sender: TObject);
BEGIN
	StatusBar1.SimpleText := 'Aborting...';
  TurboSearch1.Cancel := True;
	Close;
END;
{-------------------------------------------------------------}
PROCEDURE TForm1.pbxLedMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: INTEGER);
BEGIN
	Screen.Cursor := crDefault;
END;
{-------------------------------------------------------------}
(* For a continous operation, write this information out to a file
   instead of a dialog display *)
PROCEDURE TForm1.TurboSearch1Error(Sender: TObject; FN, VolumeID: STRING;
  ECode: Integer);
BEGIN
										(* If ecode < M_ENCRYPT then error codes
                             	passed that are considered GENERAL
                                MESSAGES are not displayed.  See
                                Err_Msgs.Pas & Err_Msgs.RC for review. *)
	IF Ecode < M_ENCRYPT THEN
     MessageDlg( ExtractFilename( FN ) +
                 #13'Error#: ' + IntToStr( Ecode ) +
                 #13'Error : ' + LoadStr( Ecode ),
                 mtInformation,
                 [mbOk],
                 0 );

END;
{-------------------------------------------------------------}
(* OnFileChange event - activated with each new file (and each
   compressed file) *)
PROCEDURE TForm1.TurboSearch1FileChange(Sender: TObject; SearchFile,
  SearchText: STRING);
BEGIN

  (*	In the status bar, display both TurboSearch1.ArchiveFile and the
     parameter SearchFile.  This is because if TurboSearch1.Archive is
     a supported archive SearchFile will be the filename of the
     compressed file being searched as a decompression search.  If
     TurboSearch1.Archive is not an archive, TurboSearch1.Archive and
     SearchFile will be equal. *)

	StatusBar1.SimpleText := 'Searching: ' +
  									TurboSearch1.ArchiveFile +
                             ' --> ' +
                             SearchFile;

  Application.ProcessMessages;

END;
{-------------------------------------------------------------}
(* OnFinish event - activated when finished searching each file.
   Collect total information *)
PROCEDURE TForm1.TurboSearch1Finish(Sender: TObject; Files, Matches,
  Bytes: Integer);
BEGIN

  IF Files > 0 THEN
  BEGIN
                             (* Number of files decompressed *)
     WITH TurboSearch1 DO
     BEGIN

        IF ( ( ( SearchType =
        stAllFiles ) OR
               ( SearchType = stArcsOnly ) ) AND
               IsArcSearchable( ArcType ) ) THEN

           Inc( TotalDecompressedFiles, Files );

     END;

     (* The LengthOfFile property is set internally when ArchiveFile is
        assigned.  If Bytes > LengthOfFile, account for decompression
        bytes searched. *)
  	IF Bytes > TurboSearch1.LengthOfFile THEN
			Inc( TotalBytes, Bytes )
     ELSE
  		Inc( TotalBytes, TurboSearch1.LengthOfFile );

        							(* Count total number of files scanned *)
  	Inc( TotalDiskFiles );

  END;

END;
{-------------------------------------------------------------}
(* OnGetPassword event - enter the password for password
   encrypted archives *)
PROCEDURE TForm1.TurboSearch1GetPassword(Sender: TObject; FN: STRING;
  	VAR Password: STRING; VAR TryAgain: Boolean);
BEGIN

  (* InputQuery is a Delphi function *)
	IF NOT InputQuery( 'Encrypted file...', 'Enter password', Password ) THEN
  	TryAgain := False;

END;
{-------------------------------------------------------------}
PROCEDURE TForm1.TurboSearch1NextVolume(Sender: TObject; VAR Dir,
  	FN: STRING; VolumeID: STRING; VAR Cancel: Boolean);
BEGIN
	;
END;
{-------------------------------------------------------------}

END.

