{$D-}
(*
  ******************************************************************

   Click on light when RED, to cancel the current operation.

  ******************************************************************
*)
UNIT Main;

INTERFACE

USES
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ExtCtrls, AwkMain, ZipCheck, Err_Msgs, ComCtrls,
  Gauges;

TYPE
  TForm1 = CLASS(TForm)
    OpenDialog1		: TOpenDialog;
    ZipCheck1			: TZipCheck;
    ListBox1			: TListBox;
    Panel1				: TPanel;

    btnOpenArchive	: TBitBtn;
    btnOK				: TBitBtn;
    btnClose			: TBitBtn;

    Label2				: TLabel;
    Label3				: TLabel;
    edtArchiveFile	: TEdit;
    edtFileSpec		: TEdit;
    pnlStatus: TPanel;
    pbxLed: TPaintBox;
    gauProgress: TGauge;
    StatusBar1: TStatusBar;
    imgLed: TImage;

	  PROCEDURE pbxLedPaint( Sender: TObject );
	  PROCEDURE SetLedColor( lColor : TColor );
    PROCEDURE btnCloseClick(Sender: TObject);
    PROCEDURE btnOpenArchiveClick(Sender: TObject);
    PROCEDURE FormActivate(Sender: TObject);
    PROCEDURE btnOKClick(Sender: TObject);
    PROCEDURE edtArchiveFileChange(Sender: TObject);
    PROCEDURE ZipCheck1Status(Sender: TObject; FN: STRING; PassFail: BOOLEAN);
    PROCEDURE ZipCheck1Error(Sender: TObject; FN, VolumeID: STRING; ECode: INTEGER);
    PROCEDURE ZipCheck1GetPassword(Sender: TObject; FN: STRING; VAR Password: STRING;
    			VAR TryAgain: BOOLEAN);
    PROCEDURE ZipCheck1Begin(Sender: TObject; FN: STRING);
    PROCEDURE ZipCheck1Deactivate(Sender: TObject);
    PROCEDURE ZipCheck1Progress(Sender: TObject; FN: STRING; Progress: BYTE);
    PROCEDURE ZipCheck1Activate(Sender: TObject);
    PROCEDURE pbxLedClick(Sender: TObject);
    PROCEDURE ZipCheck1NextVolume(Sender: TObject; VAR Dir, FN: STRING;
      		VolumeID: STRING; VAR Cancel: BOOLEAN);
	  FUNCTION  FIXEDLENGTHSTR (InInt : Integer) : ShortString;
  PRIVATE
    { Private declarations }
  PUBLIC
    { Public declarations }
  END;


VAR
  Form1: TForm1;


IMPLEMENTATION



{$R *.DFM}


{-------------------------------------------------------------}
FUNCTION TForm1.FIXEDLENGTHSTR (InInt : Integer) : ShortString;
VAR
	OutStr: ShortString;
BEGIN
	OutStr := '               ' + InttoStr (InInt);
	RESULT := Copy( OutStr, Length( OutStr ) - 9, Length( OutStr ) );
END;
{-------------------------------------------------------------}
PROCEDURE TForm1.btnOpenArchiveClick(Sender: TObject);
BEGIN

	OpenDialog1.Filter := LoadStr( F_TZIPTV );  (* see F_TZIPTV in err_msgs.rc and err_msgs.pas *)
	OpenDialog1.Options := [ ofHideReadOnly, ofFileMustExist, ofPathMustExist ];

	IF OpenDialog1.Execute THEN
  BEGIN
		edtArchiveFile.Text := OpenDialog1.Filename;
    	ListBox1.Items.Clear;
  END;

END;
{-------------------------------------------------------------}
PROCEDURE TForm1.FormActivate(Sender: TObject);
BEGIN
	edtFileSpec.Text := ZipCheck1.FileSpec;
END;
{-------------------------------------------------------------}
(* Ok button click event *)
PROCEDURE TForm1.btnOKClick(Sender: TObject);
BEGIN

	Screen.Cursor := crHourGlass;

  TRY
  	ListBox1.Clear;
     ZipCheck1.FileSpec := edtFileSpec.Text;
     ZipCheck1.ArchiveFile := edtArchiveFile.Text;

     IF ZipCheck1.IsArcDecompressable( ZipCheck1.ArcType ) THEN
        ZipCheck1.Activate
     ELSE
        ShowMessage( LoadStr( E_INVALIDARC ) );

     edtArchiveFile.SetFocus;
  FINALLY
  	Screen.Cursor := crDefault;
  END;

END;
{-------------------------------------------------------------}
PROCEDURE TForm1.btnCloseClick(Sender: TObject);
BEGIN
	Close;
END;
{-------------------------------------------------------------}
PROCEDURE TForm1.edtArchiveFileChange(Sender: TObject);
BEGIN
	btnOK.Enabled := edtArchiveFile.Text <> '';
END;
{-------------------------------------------------------------}
(* TZipCheck OnStatus Event - display validation pass/fail *)
PROCEDURE TForm1.ZipCheck1Status(Sender: TObject; FN: STRING; PassFail: BOOLEAN);
VAR
	s: STRING;
BEGIN

	IF PassFail THEN
  	s := FN + ' ...Ok'
  ELSE
  	s := FN + ' ...Failed';

	ListBox1.Items.Add(s);

END;
{-------------------------------------------------------------}
(* TZipCheck OnError event *)
PROCEDURE TForm1.ZipCheck1Error(Sender: TObject; FN, VolumeID: STRING;
  ECode: INTEGER);
BEGIN

	ShowMessage( 'File   : ' + FN + #13 +
  				'Error# : ' + IntToStr( Ecode ) + #13 +
              LoadStr( ECode ) );
              
END;
{-------------------------------------------------------------}
(* TZipCheck OnGetPassword event - request password from user *)
PROCEDURE TForm1.ZipCheck1GetPassword(Sender: TObject; FN: STRING;
  VAR Password: STRING; VAR TryAgain: BOOLEAN);
BEGIN

  (* InputQuery is a Delphi function *)
	IF NOT InputQuery( 'Encrypted file...', 'Enter password', Password ) THEN
  	TryAgain := False;

END;
{-------------------------------------------------------------}
(* OnBegin event - activated prior to verifing a compressed file *)
PROCEDURE TForm1.ZipCheck1Begin(Sender: TObject; FN: STRING);
BEGIN
	StatusBar1.SimpleText := 'Verifying:  ' + FN;
  Application.ProcessMessages;
END;
{-------------------------------------------------------------}
(* OnActivate event - activated prior to verification of any compressed files *)
PROCEDURE TForm1.ZipCheck1Activate(Sender: TObject);
BEGIN
	SetLedColor( clRed );
	gauProgress.Visible := TRUE;
END;
{-------------------------------------------------------------}
(* OnDeactivate event - activated after all files have been verified *)
PROCEDURE TForm1.ZipCheck1Deactivate(Sender: TObject);
BEGIN
	SetLedColor( clGreen );
	gauProgress.Progress := 0;
	StatusBar1.SimpleText := '';
	gauProgress.Visible := FALSE;
END;
{-------------------------------------------------------------}
(* OnProgress event - activated in increments of ProgressNotify property *)
PROCEDURE TForm1.ZipCheck1Progress(Sender: TObject; FN: STRING;
  Progress: BYTE);
BEGIN
	gauProgress.Progress := Progress;
	Application.ProcessMessages;
END;
{-------------------------------------------------------------}
(* Little light in right corner of form *)
PROCEDURE TForm1.pbxLedPaint( Sender: TObject );
BEGIN
	WITH Sender AS TPaintBox DO
	 Canvas.Draw( ( Width - imgLed.Width ) DIV 2,
					( Height - imgLed.Height ) DIV 2, imgLed.Picture.Graphic );
END;
{-------------------------------------------------------------}
(* Change colors of little light in corner of form *)
PROCEDURE TForm1.SetLedColor( lColor : TColor );
BEGIN
	WITH imgLed.Canvas DO
	BEGIN
		Brush.Color := lColor;
		FloodFill( 6, 6, Pixels[ 6, 6 ], fsSurface );
	END;

	pbxLed.Repaint;
END;
{-------------------------------------------------------------}
(* Cancel operation on current archive - see note at top of module *)
PROCEDURE TForm1.pbxLedClick(Sender: TObject);
BEGIN
	StatusBar1.SimpleText := 'Aborting...';
										(* Cancel validity test on this archive  *)
  ZipCheck1.Cancel := TRUE;
END;
{-------------------------------------------------------------}
(* OnNextVolume event ( for ARJ multi-volume archives *)
PROCEDURE TForm1.ZipCheck1NextVolume(Sender: TObject; VAR Dir, FN: STRING;
  VolumeID: STRING; VAR Cancel: BOOLEAN);
BEGIN
  IF NOT InputQuery( 'Enter new drv:\directory...', 'Filename: ' + FN, Dir ) THEN
  	Cancel := TRUE;
END;
{-------------------------------------------------------------}



END.

