//tower.inc v1.1 created by Norm Krumpe (krumpenj@muohio.edu), August 27, 1997.
//To use, first declare any necessary variables (see "tower.txt")
//and THEN, #include "tower.inc"
//

#ifndef (Tower_Unit)
#declare Tower_Unit = box {<-1, 0, -1> <1, 1, 1> texture{pigment {Yellow}}}
#declare Tower_Center = <0, 0, 0>
#declare Tower_UnitHeight = 1
#warning "Tower_Unit not declared.  Using default _Unit, _Center, and _UnitHeight values.\n"
#end

#ifndef (Units)
#declare Units = 2
#warning "Units not declared.  Using 2.\n"
#end

#ifndef (Tower_Center)
#declare Tower_Unit = box {<-1, 0, -1> <1, 1, 1> texture{pigment {Yellow}}}
#declare Tower_Center = <0, 0, 0>
#declare Tower_UnitHeight = 1
#warning "Tower_Center not declared.  Using default _Unit, _Center, and _UnitHeight values.\n"
#end

#ifndef (Tower_UnitHeight)
#declare Tower_Unit = box {<-1, 0, -1> <1, 1, 1> texture{pigment {Yellow}}}
#declare Tower_Center = <0, 0, 0>
#declare Tower_UnitHeight = 1
#warning "Tower_UnitHeight not declared.  Using default _Unit, _Center, and _UnitHeight values.\n"#end

#declare x1 = Tower_Center.x
#declare y1 = Tower_Center.y
#declare z1 = Tower_Center.z
#declare ht = Tower_UnitHeight

#declare unit = object {Tower_Unit translate <-x1, -y1, -z1>}

#ifndef (Tower_DivRotate)
#declare rot = 0
#warning "Tower_DivRotate not declared.  Using 0.\n"
#else
#declare rot = Tower_DivRotate
#end

#ifndef (Tower_BottomScale)
#declare Tower_BottomScale = <1,1,1>
#warning "Tower_BottomScale not declared.  Using <1, 1, 1>\n"
#end

#ifndef (Tower_TopScale)
#declare Tower_TopScale = <1,1,1>
#warning "Tower_TopScale not declared.  Using <1, 1, 1>\n"
#end

#declare bscale = Tower_BottomScale
#if (bscale.x*bscale.y*bscale.z = 0)
#warning "0 found in Tower_BottomScale. Using <1, 1, 1>.\n"
#declare bscale = <1, 1, 1>
#end

#declare tscale = Tower_TopScale
#if (tscale.x*tscale.y*tscale.z = 0)
#warning "0 found in Tower_TopScale. Using <1, 1, 1>.\n"
#declare tscale = <1, 1, 1>
#end

#ifndef (Tower_ScaleType)
#declare Tower_ScaleType = 0
#end

#if (Tower_ScaleType != 0)
#declare Tower_ScaleType = 1
#warning "Tower_ScaleType is 1.\n"
#else
#warning "Tower_ScaleType is 0.\n"
#end

#ifndef (Tower_Space)
#declare Tower_Space = 0
#warning "Tower_Space not declared.  Using 0.\n"
#end

#ifndef (Tower_SpaceType)
#declare Tower_SpaceType = 0
#end

#if (Tower_SpaceType != 0)
#declare Tower_SpaceType = 1
#warning "Tower_SpaceType is 1.\n"
#else
#warning "Tower_SpaceType is 0.\n"
#end

#declare c = 1
#declare tfact = 0
#declare sfact = <1, 1, 1>

#declare bTower =
union
{
#while (c<=Units)

#if (Tower_ScaleType = 0)
#declare sfact =
<
bscale.x + (c-1)*(tscale.x-bscale.x)/(Units-1),
bscale.y + (c-1)*(tscale.y-bscale.y)/(Units-1),
bscale.z + (c-1)*(tscale.z-bscale.z)/(Units-1)
>
#else
#declare sfact =
<bscale.x * pow(tscale.x/bscale.x,(c-1)/(Units-1)),
bscale.y * pow(tscale.y/bscale.y,(c-1)/(Units-1)),
bscale.z * pow(tscale.z/bscale.z,(c-1)/(Units-1))
>
#end

#declare rfact = (c-1)*rot

object
{
unit
scale sfact
rotate <0, rfact, 0>
translate <0, tfact, 0>
}


#if (Tower_SpaceType = 0)
#declare tfact = tfact + ht * sfact.y + Tower_Space
#else
#declare tfact = tfact + ht * sfact.y * (Tower_Space + 1)
#end

#declare c = c+1
#end
}

#if (Tower_SpaceType = 0)
#declare tht = tfact - Tower_Space
#else
#declare tht = tfact - ht * sfact.y * Tower_Space
#end

#ifdef (Tower_Height)
#declare Tower = object {bTower scale (Tower_Height/tht)}
#else
#declare Tower = object {bTower}
#end
