// ----------------------------------------------------
// Persistence of Vision RayTracer version 2 Scene description file
// File: djTest1.pov
// Description: Test file, proof of concept for the "de Jong Box"
// Date: 6/5/94
// Mod:  8/30/94 - Cleanup, moved box to include file
//       6/4/96 - v3.0 using one include file [robbe]
// Author: Eduard Schwan
// Copyright 1994, Eduard Schwan, All Rights Reserved
// ----------------------------------------------------

#include "colors.inc"
#include "textures.inc"


// ----------------------------------------------------
// Regular scene components: camera, light, sky...
// ----------------------------------------------------

// where am I
camera
{
  location  <0.0,  0.2, -8.0> // <X Y Z>
  direction 2.0*z             // which way are we looking <X Y Z>
  up        y                 // which way is +up <X Y Z>
  right     4/3*x             // which way is +right <X Y Z> + aspect ratio
  look_at   <0.0,  0.0,  0.0> // point center of view at this point <X Y Z>
}

// sky sphere
sphere
{
  0*y, 4
  texture {
    pigment {
      gradient y
      color_map {
        [0.0  color red 0.4   blue 0.6]
        [0.5  color red 0.0   blue 0.4]
        [1.0  color green 0.6 blue 0.6]
      }
    } // pig
    finish { ambient 1 diffuse 0 }
  } // tex
  scale 100
}

// floor
plane { y, -1 texture { PinkAlabaster } }

// light
light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
// uncomment the next line to give the light source a visible appearance
  looks_like { sphere { 0*x, 1 pigment { red 1 green 1 } } }
  translate <10, 10, -20>
}


// ----------------------------------------------------
// Declaration of the object to slice in the box.
// It must be named "ObjectToSlice", and should have
// a texture attached to it.  It should be unit-sized.
// ----------------------------------------------------

#declare ObjectToSlice =
// stair stepped idea
cone
{
  <-0.5,-0.9,0.0> 0.5
  <-0.9,0.9,0.0>  0.02
  texture {
    pigment { agate scale 0.2 }
    finish { ambient 0.2 specular 0.7 }
  }
}


// ----------------------------------------------------
// This is the amount to twist the object in the box.
// djb_MaxRot is a rotation in degrees from the top
// to the bottom of the box.
// ----------------------------------------------------

#declare djb_MaxRot = 360+180


// ----------------------------------------------------
// This is the include of the de Jong box slicer.
// ----------------------------------------------------

#declare djb_NSlices=20
#include "djbox.inc"


// ----------------------------------------------------
// Use this one to look at the object by itself
// ----------------------------------------------------

object { ObjectToSlice translate -1.2*x }


// ----------------------------------------------------
// use this one to slice the object into the de Jong box
// ----------------------------------------------------

object { djBox translate +1.2*x }

