// djbox.inc v3.0 - a de Jong box
// POV-Ray version 3 include file
// idea and coding by Mark de Jong <mdj@cts.com> and
// Eduard Schwan <71513.2161@compuserve.com>
// version 3 enhancements by Robert Bihlmeyer <robbe@orcus.priv.at>

// just declare your object (and perhaps override the defaults below)
// before including this file:
// #declare ObjectToSlice = object { ... }

// provide defaults
// you can change the following values by declaring them before #include'ing
#ifndef (djb_MaxRot)
  #declare djb_MaxRot = 360 // difference in degrees between top and bottom
#end

#ifndef (djb_NSlices)
  #declare djb_NSlices = 20 // number of slices
#end

#ifndef (djb_Texture)
  #declare djb_Texture = texture { // texture of the "cut"-areas
                                   pigment { rgb <0,0,0> }
                                 }
#end

#declare djb_Object = object { ObjectToSlice }
#declare djb_1NSlices = 1/djb_NSlices // Don't touch!

#declare djb_Slice =
box
{	// slices overlap by a miniscule amount to avoid see-through effects
  <-1.5,0,-1.5> <1.5,djb_1NSlices+0.00001,1.5>
  translate -0.5*y  scale <1,2,1> // move to bottom of cube
  texture { djb_Texture }
}

#declare djBox = union
{
  #declare djb_Count=0
  #while (djb_Count<=djb_NSlices)
    intersection // a slice
    {
      object { djb_Object rotate djb_Count/djb_NSlices*djb_MaxRot*y }
      object { djb_Slice translate 2*djb_Count/djb_NSlices*y }
    }
    #declare djb_Count=djb_Count+1
  #end
} // djBox union

