// COUNT example file for Motion Control System
// 7/5/95 John Kolesar

// First put all the normal stuff here: ------------------------------------

#include "colors.inc"
#include "textures.inc"

camera {
   location  <0, 2, -10>
   direction <0, 0,  1>
   up        <0, 1,  0>
   right   <4/3, 0,  0>
   look_at   <0, 1, 1>
}

light_source {<10, 30, -50> color White}

// Floor plane
plane { y, 0
   pigment {NeonBlue}
   finish { ambient 0.15 diffuse 0.8 }
}

// Then, declare the objects here. -----------------------------------------

// Ball1
#declare Ball1 = 
  sphere { <0, 0, 0>, 1
   pigment {hexagon color Red color Orange color Yellow scale .25}
   finish { ambient 0.2 diffuse 0.7
            phong 1 phong_size 80
            brilliance 2
          }
         }

// Ball2
#declare Ball2 = 
  sphere { <0, 0, 0>, 1
   pigment {hexagon color Blue color LightBlue color Violet scale .25}
   finish { ambient 0.2 diffuse 0.7
            phong 1 phong_size 80
            brilliance 2
          }
         }

// Then put the MCS #include line here: ------------------------------------

#include "MCS.INC"

// Then place the objects here that will use Count objects: ----------------
// (In this example, SpinY, BounceY and MoveZ are all Count objects)

object { Ball1
   rotate <0, SpinY, 0>
   translate <0, BounceY, 0>
   translate <2, 0, MoveZ>
       }

