// CAMERA example file for Motion Control System
// 7/5/95 John Kolesar

#include "colors.inc"
#include "textures.inc"

#declare Camera1=
camera {
   location  <0, 0, -.00001>
   direction <0, 0,  1>
   up        <0, 1,  0>
   right   <4/3, 0,  0>
   look_at   <0, 0, 1>
}

light_source {<10, 30, -50> color White}

// Sky
sphere { <0, 0, 0>, 1
   pigment { Blue_Sky2
             scale <.2,.09,.1>
             rotate <0,45,0>
           }
   finish {Luminous}
   scale <10000 200 10000>
       }

// Floor plane
plane { y, 0
   pigment {checker color Green color White}
   finish {ambient 0.15 diffuse 0.8 }
   rotate <0,25,0>
   scale <3,3,3>
}

// Ball1
#declare Ball1 = 
  sphere { <0, 0, 0>, 1
   pigment {Red}
   finish {
      ambient 0.2
      diffuse 0.7
      phong 1
      phong_size 80
      brilliance 2
          }
   scale <1,.5,.5>
         }

object { Ball1 translate <20,2,-10>}

#include "mcs.inc"
