// BASIC example file for Motion Control System
// 7/5/95 John Kolesar

#include "colors.inc"
#include "textures.inc"

camera {
   location  <0, 2, -10>
   direction <0, 0,  1>
   up        <0, 1,  0>
   right   <4/3, 0,  0>
   look_at   <0, 1, 0>
}

light_source {<10, 30, -50> color White}

// Sky
sphere { <0, 0, 0>, 1
   pigment { Blue_Sky2
             scale <.2,.09,.1>
             rotate <0,90,0>
           }
   finish {Luminous}
   scale <10000 200 10000>
       }

// Floor plane
plane { y, 0
   pigment {Blue}
   finish {ambient 0.15 diffuse 0.8 }
}

// Ball1
#declare Ball1 = 
  sphere { <0, 0, 0>, 1
   pigment {Red}
   finish {
      ambient 0.2
      diffuse 0.7
      phong 1
      phong_size 80
      brilliance 2
          }
   scale <1,.5,.5>
         }

// Ball1 - Minus Pigment & Phong
#declare Ball1_MPP =
  sphere { <0, 0, 0>, 1
   finish {
      ambient 0.2
      diffuse 0.7
      brilliance 2
          }
   scale <1,.5,.5>
         }

// Ball1 - Minus Texture
#declare Ball1_MT = 
  sphere { <0, 0, 0>, 1
   scale <1,.5,.5>
         }

#include "mcs.inc"
