// Povani example file "bouncing ball"

#include "variable.inc"


camera {
  location  <2.929, -10.894, 6.500>
  direction <0.0,     0.0,  1.4297>
  sky       <0.0,     0.0,  1.0> 
  up        <0.0,     0.0,  1.0> 
  right     <1.3333,  0.0,  0.0>
  look_at   <0.000, -0.214,7.573>
}



//  Light sources : 1 omnidirectional 1 spotlight
light_source {  
  <3.644, -9.110, 9.377>
  color rgb <0.537, 0.529, 0.663>
}

light_source { 
  <1.286, 39.117, 13.128>
  color  rgb <1.000, 1.000, 1.000>
  spotlight
    point_at  <0.771, 38.509, 12.524>
    falloff   73.3 
      radius    53.0  
}

//  The bouncing  ball: ( cange directory where tga : "ball.tga" is located)


sphere {
  <0,0,0>,1
  texture {
    pigment {
     image_map {
       tga "C:\POVRAY3\BALL.TGA"
       map_type 1 
      
     }
     scale <-1,1,1> rotate 90*x
   }
   finish {
     diffuse 0.700
     ambient 0.480
     phong 1.000
     phong_size 100.000
     specular 0.400
     roughness 0.0200
   }
  }
   rotate      <45*sin00,90*sin90,15*sin00>
  translate  <18*lin-9, 20.0, 10.0*bounce+1>
}


box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
     pigment {
     color rgb<1.000, 1.000, 1.000>
   }
   finish {
     diffuse 0.660
     ambient 0.390
        specular 0.400
    
   
   }
  }
  scale <10.0, 30.0, 8.0>
  translate  <0.0, 17.576044, 6.644602>
}






