// Persistence of Vision 3.0 POV-File
// File:	tree01.pov
// Author:	Joachim Puerschel (puerschel@aol.com)

//General -------------------------------------------------------

#version 3.0

global_settings {
  assumed_gamma 2.2
  max_trace_level 5
  adc_bailout 1/128
  max_intersections 64
  number_of_waves 1
}

background { color rgb < 0, 0.15, 0.25 > }

sky_sphere {
  pigment {
    gradient y
    turbulence 0.33
    color_map {
      [0.0, 1.00  color rgb <0, 0.25, 0.6 >
                  color rgb <0, 0.15, 0.4 > ]
    } //end color_map
  } //end pigment
  pigment {
    gradient y
    turbulence 0.38
    color_map {
      [0.00, 0.1   color rgbf <1, 1, 1, 0.6 >
                   color rgbf <1, 1, 1, 0.6 > ]
      [0.10, 0.65  color rgbf <1, 1, 1, 0.6 >
                   color rgbf <1, 1, 1, 0.8 > ]
      [0.65, 1.00  color rgbf <1, 1, 1, 0.8 >
                   color rgbf <1, 1, 1, 1.0 > ]
    } //end color_map
    quick_color rgb 0.5
  } //end pigment
  pigment {
    bozo
    turbulence 0.53
    color_map {
      [0.00, 0.1   color rgbf <1, 1, 1, 0.1 >
                   color rgbf <1, 1, 1, 0.2 > ]
      [0.10, 0.65  color rgbf <1, 1, 1, 0.2 >
                   color rgbf <1, 1, 1, 0.7 > ]
      [0.65, 1.00  color rgbf <1, 1, 1, 0.7 >
                   color rgbf <1, 1, 1, 1.0 > ]
    } //end color_map
    quick_color rgb 0.5
  } //end pigment
}

fog {
  fog_type   2
  distance   300
  color rgbf 1
  fog_offset 0
  fog_alt    5
  turbulence 0.1
  omega 0.4
  lambda 1.25
  scale < 20, 1, 20 >
}

//Camera ---------------------------------------------------------

camera {
  ultra_wide_angle
  angle 50
  location < 0, 10, -180 >
  up y*1
  right x*1.5
  direction z*1
  look_at < 0, 10, 0 >
}

//Light ----------------------------------------------------------

light_source {
  < -10000, 20000, -20000 >
  color rgb 1
}

//Szene ----------------------------------------------------------

plane {
  y, 0
  texture {
    pigment {
      granite
      turbulence 0.4
      lambda 4
      color_map {
        [ 0.0 color rgb < 0.4, 0.3, 0.0 > ]
        [ 1.0 color rgb < 0.3, 0.2, 0.0 > ]
      }
      scale < 0.1, 0.3, 0.1 >
      quick_color rgb 0.5
    }
    normal {
      dents 1
      turbulence 0.2
      lambda 3
      scale < 0.1, 0.1, 0.1 >
    }
    finish {
      ambient 0.05
      diffuse 0.70
      crand 0.055
      phong 0.1
      phong_size 20
      specular 0 //1
      roughness 0.003
      irid {
        0.05
        thickness 0.05
        turbulence 0.7
      }
    }
    rotate y*30
    translate x*3
  }
}

#declare LeaveSize = 1.5    //1-2
#declare LeaveText = 1      //1 or 2
#declare Value1 = 4         //Split Branches (1-6) Default = 5
#declare Value2 = 3         //Split Leaves         Default = 5
#include "tree01.inc"
object { TREE translate x*-20 }

#declare LeaveSize = 1.5    //1-2
#declare LeaveText = 2      //1 or 2
#declare Value1 = 5         //Split Branches (1-6) Default = 5
#declare Value2 = 5         //Split Leaves         Default = 5
#include "tree01.inc"
object { TREE }

#declare LeaveSize = 1.5    //1-2
#declare LeaveText = 2      //1 or 2
#declare Value1 = 6         //Split Branches (1-6) Default = 5
#declare Value2 = 8         //Split Leaves         Default = 5
#include "tree01.inc"
object { TREE translate x*20 }
