// Persistence of Vision 3.0 INC-File
// File:	tree01.inc
// Author:	Joachim Puerschel (puerschel@aol.com)


#ifndef (Value1)        #declare Value1=5                  #end
#ifndef (Value2)        #declare Value2=5                  #end
#ifndef (LeaveText)     #declare LeaveText=1               #end
#ifndef (LeaveSize)     #declare LeaveSize=1               #end
#if (Value1 > 7)        #debug "Value1 is to high.\n"      #end

#declare R1 = seed(0)

#declare TEX001 = //Leaves
texture {
  pigment {
    granite
    turbulence 0.2
    lambda 6
    frequency 1
    color_map {
      [ 0.00 color rgbf < 0.2, 0.9, 0.0, 0.0 > ]
      [ 0.30 color rgbf < 0.7, 0.7, 0.0, 0.0 > ]
      [ 0.35 color rgbf < 1.0, 1.0, 1.0, 1.0 > ]
      [ 1.00 color rgbf < 1.0, 1.0, 1.0, 1.0 > ]
    }
    scale 1/2
  }
  finish {
    ambient 0.05
    diffuse 0.70
  }
}

#declare TEX002 = //Leaves2
texture {
  pigment {
    granite
    turbulence 0.2
    lambda 6
    color_map {
      [ 0.00 color rgbf < 0.2, 0.6, 0.0, 0.0 > ]
      [ 0.10 color rgbf < 0.8, 0.3, 0.0, 0.0 > ]
      [ 0.20 color rgbf < 0.8, 0.9, 0.0, 0.0 > ]
      [ 0.30 color rgbf < 0.2, 0.8, 0.0, 0.0 > ]
      [ 0.35 color rgbf < 1.0, 1.0, 1.0, 1.0 > ]
      [ 1.00 color rgbf < 1.0, 1.0, 1.0, 1.0 > ]
    }
    scale LeaveSize/2
  }
  finish {
    ambient 0.05
    diffuse 0.70
  }
}

#declare TEX003 = //Branches
texture {
  pigment {
    granite
    turbulence 0.2
    lambda 6
    color_map {
      [ 0.0 color rgb < 0.3, 0.15, 0.0 > ]
      [ 0.3 color rgb < 0.1, 0.00, 0.0 > ]
      [ 0.5 color rgb < 0.0, 0.00, 0.0 > ]
      [ 1.0 color rgb < 0.3, 0.15, 0.0 > ]
    }
    scale 0.3
  }
  finish {
    ambient 0.05
    diffuse 0.70
  }
}

#declare LLL1 = //trunk
union {
  cone { <  0.0, -1,  0.0 >, 0.8, < 0, 10, 0 >, 0.4 }
  cone { <  0.2, -1,  0.0 >, 0.8, < 0,  7, 0 >, 0.3 }
  cone { < -0.3, -1, -0.4 >, 0.8, < 0,  5, 0 >, 0.3 }
  cone { < -0.4, -1,  0.0 >, 0.8, < 0,  4, 0 >, 0.3 }
  cone { <  0.4, -1,  0.3 >, 0.8, < 0,  3, 0 >, 0.3 }
  cone { <  0.0, -1,  0.4 >, 0.8, < 0,  8, 0 >, 0.3 }
}

#declare LLL2 = //Branch1
cone { < 0, 0, 0 >, 0.45, < 0, 7, 0 >, 0.1 }

#declare LLL3 = //Branch2
cone { < 0, 0, 0 >, 0.2, < 0, 5, 0 >, 0.1 }

#declare LLL4 = //Branch3
cone { < 0, 0, 0 >, 0.1, < 0, 2, 0 >, 0.05 }

#declare LLL5 = //Branch4
cone { < 0, 0, 0 >, 0.05, < 0, 1, 0 >, 0.0 }

#declare LLL6 = //Leave(s)
triangle {
//  < -0.7, 0.0, 0.0 >, < 0.7, 0.0, 0.0 >, < 0.0, 1.3, 0.0 >
  < -0.4, 0.0, 0.0 >, < 0.4, 0.0, 0.0 >, < 0.0, 0.5, 0.5 >
  #switch (LeaveText)
    #case(1)
      texture { TEX001 }
    #break
    #case(2)
      texture { TEX002 }
    #break
  #end
  scale LeaveSize
}

#debug "\nAssembling a tree ... please be patient.\n"

#declare TREE =
union {//1
  object { LLL1 }
  #declare Count1 = 0
  #while ( Count1 < Value1 )
  union {//2
    object { LLL2 }
    #declare Count2 = 0
    #while ( Count2 < Value1 )
    union {//3
      object { LLL3 }
      #declare Count3 = 0
      #while ( Count3 < Value1 )
      union {//4
        object { LLL4 }
        #declare Count4 = 0
        #while ( Count4 < Value1 )
        union {//5
          object { LLL5 }
          #declare Count5 = 0
          #while ( Count5 < Value2 )
          object {//6
            LLL6
            rotate x*80*(Count5/Value2)
            rotate y*(360/Value2)*Count5
            translate y*(Count5)/Value2
          }//6
          #declare Count5 = Count5+1
          #end
          rotate x*90*rand(R1)
          rotate y*(360/(Value1))*Count4
          translate y*Count4/2
        }//5
        #declare Count4 = Count4+1
        #end
        rotate x*65-(Count3*3)
        rotate y*(360/(Value1))*Count3
        translate y*(Count3)
      }//4
      #declare Count3 = Count3+1
      #end
      rotate x*60-(Count2*3)
      rotate y*(360/(Value1))*Count2
      translate y*(2+Count2)
    }//3
    #declare Count2 = Count2+1
    #end
    rotate x*55-(Count1*3)
    rotate y*(360/Value1)*Count1
    translate y*(5+Count1+rand(R1))
  }//2
  #declare Count1 = Count1+1
  #end
  texture { TEX003 }
}//1
