/***********************************************

  CursesAPI for Win32
  v2.1

  Copyright 1996-1997 Ingen Software, Ltd.
  http://www.ingensoft.com
  (281) 922-4222
 
  utl_windows.c

  All work contained within this file and the associated
  object-code library represents an unpublished work, and 
  is the property of Ingen Software, Ltd.  

  This file is considered confidential, and is only provided
  for the use of authorized parties that have a software 
  license agreement on file with Ingen Software, Ltd.

  Any unauthorized redistribution of the contents of this file, 
  in whole or in part, is in violation of the software license 
  that permits use of this file and the associated object-code
  library.  Such redistribution may be in violation of local,
  federal, and international laws and/or treaties.
 
************************************************/


#include <curses.h>
#include "./util.h"

void fillwin(WINDOW* wWin, chtype cVal)
{
	int x,y;
	int idx;

	getyx(wWin,y,x);

	wmove(wWin,0,0);
	for(idx=0;idx<getmaxx(wWin)*getmaxy(wWin);idx++)
		waddch(wWin,cVal);

	wmove(wWin,y,x);
}

WINDOW* build_window(int rows,int cols,int row,int col,const char* title,int title_justify, chtype attrs,bool boxit)
{
	WINDOW* wWin=newwin(rows,cols,row,col);

	wattrset(wWin,attrs);
	fillwin(wWin,' ');
	if(boxit) box(wWin,0,0);
	if(title){
		int scol;
		
		switch(title_justify)
		{
		case JUSTIFY_LEFT:
			scol=2;
			break;
		case JUSTIFY_RIGHT:
			scol=(cols-(strlen(title)+2))-2;
			break;
		default:
			scol=(cols-(strlen(title)+2))/2;
			break;
		}

		if(scol<0) scol=0;

		mvwprintw(wWin,0,scol," %s ",title);
	}
	wmove(wWin,0,0);
	return wWin;
}
