/***********************************************

  CursesAPI for Win32
  v2.1

  Copyright 1996-1997 Ingen Software, Ltd.
  http://www.ingensoft.com
  (281) 922-4222
 
  utl_color.c

  All work contained within this file and the associated
  object-code library represents an unpublished work, and 
  is the property of Ingen Software, Ltd.  

  This file is considered confidential, and is only provided
  for the use of authorized parties that have a software 
  license agreement on file with Ingen Software, Ltd.

  Any unauthorized redistribution of the contents of this file, 
  in whole or in part, is in violation of the software license 
  that permits use of this file and the associated object-code
  library.  Such redistribution may be in violation of local,
  federal, and international laws and/or treaties.
 
************************************************/

#include <curses.h>
#include "./util.h"

// Initialize the curses color pairs.  It creates every
// combination of foreground and background color, ordered
// first by foreground, then by backround. 
void initialize_color(void)
{
	chtype foreground, background;
	int i;

	start_color();	// Initialize curses color system.

	foreground=background=0;

	for(i=0;i<COLORS*COLORS;i++)
	{
					// Add pair to color table.
		init_pair(i,foreground,background);

		foreground++;
		if(foreground>=(chtype)COLORS)
		{
			foreground=0;
			background++;
		}
	}
}
