/***********************************************

  CursesAPI for Win32
  v2.1

  Copyright 1996-1997 Ingen Software, Ltd.
  http://www.ingensoft.com
  (281) 922-4222
 
  sample3.c

  All work contained within this file and the associated
  object-code library represents an unpublished work, and 
  is the property of Ingen Software, Ltd.  

  This file is considered confidential, and is only provided
  for the use of authorized parties that have a software 
  license agreement on file with Ingen Software, Ltd.

  Any unauthorized redistribution of the contents of this file, 
  in whole or in part, is in violation of the software license 
  that permits use of this file and the associated object-code
  library.  Such redistribution may be in violation of local,
  federal, and international laws and/or treaties.
 
************************************************/

#include <curses.h>
#include "../utility/util.h"
#include <time.h>

int draw_all_colors(WINDOW* wWin, chtype cVal, int begrow, int begcol, int width);
void update_copyright();
void update_messages();
WINDOW* drawInfoWindow();
void refreshOverlap(int,WINDOW*);
void refreshAll(int,bool);

static WINDOW* stack[10];
static int iTopWin=-1;

int main (int argc, char* argv[] )
{
	int napval=200;
	int key;
	
		/* do various initializations on the
		   curses system */
	initscr();
	noecho();
	cbreak();

	curs_set(0);	/* hide the cursor */

	initialize_color(); /* init the color array */

		/* draw various colors and attributes
		   on stdscr */

	mvaddstr(0,0,"Normal");
	draw_all_colors(stdscr,'X',0,12,64);

	mvaddstr(1,0,"Underline");
	mvaddch(1,9,ACS_DEGREE);
	draw_all_colors(stdscr,'X'|A_UNDERLINE,1,12,64);

	mvaddstr(2,0,"Reverse");
	draw_all_colors(stdscr,'X'|A_REVERSE,2,12,64);

	mvaddstr(3,0,"Bold");
	draw_all_colors(stdscr,'X'|A_BOLD,3,12,64);

	mvaddstr(4,0,"Blink");
	mvaddch(4,5,ACS_LANTERN);
	draw_all_colors(stdscr,'X'|A_BLINK,4,12,64);

	mvaddstr(5,0,"Dim");
	mvaddch(5,3,ACS_DEGREE);
	draw_all_colors(stdscr,'X'|A_DIM,5,12,64);

	mvaddstr(6,0,"Standout");
	draw_all_colors(stdscr,'X'|A_STANDOUT,6,12,64);

	mvaddch(8,2,ACS_DEGREE);
	mvaddstr(8,3," - NT console mode does not support display of these attributes.");
	mvaddch(9,2,ACS_LANTERN);
	mvaddstr(9,3," - \"Blink\" may blink or have bold background and foreground, depending\n      on your system.");

	attrset(COLOR_ATTR(COLOR_CYAN,COLOR_BLACK)|A_BOLD);
	mvaddstr(22,25,"Press P to Pause, Q to Quit!");


	stack[0]=stdscr;
	wnoutrefresh(stdscr);
	iTopWin=0;

	
	nodelay(stdscr,TRUE); /* don't wait for input */

	key=ERR;

	while(key!='q')
	{
		switch(key)
		{
		case ERR:
			break;
		case 'p':
			{

			WINDOW* wPaused=build_window(5,40,20,20,"Paused!",JUSTIFY_CENTER,COLOR_ATTR(COLOR_WHITE,COLOR_RED),TRUE);
			mvwaddstr(wPaused,2,7,"Press any key to continue.");
				/* wait forever */
			nodelay(wPaused,FALSE);
			wgetch(wPaused);
					/* turn off waiting */
			nodelay(wPaused,TRUE);
			refreshOverlap(iTopWin,wPaused);
			delwin(wPaused);
			doupdate();
			}
		break;
	
		default: 
			beep();
			break;
		}


		update_messages();

		key=tolower(wgetch(stack[iTopWin]));
		update_copyright();
		doupdate();

		napms(napval);
		
	}
	

	endwin();	/* shut down curses */
	return 0;
}


/* 
	Draws every combination of colors on a row,
	with the given character-attribute combo.
*/
int draw_all_colors(WINDOW* wWin, chtype cVal, int begrow, int begcol, int width)
{
	int row=begrow, 
		col=begcol,
		color;

	if(width<=0 || width+begcol>=getmaxx(wWin))
		return ERR;

	wmove(wWin,begrow,begcol);

	for(color=0;color<COLORS*COLORS;color++,row++)
	{
		if(col-begcol>=width)
		{
			col=begcol;
			row++;
			wmove(wWin,row,col);
		}
		waddch(wWin,cVal|COLOR_PAIR(color));
	}
	return OK;
}

/*
	Scrolls copyright info on the bottom of 
	the screen.
*/
void update_copyright()
{
	static char* copyright="CursesAPI Sample Application 3  Copyright 1997 Ingen Software  http://www.ingensoft.com";
	static int pcol=0;
	static WINDOW* wScroll=NULL;
	int srow=getmaxy(stdscr)-1;

	if(wScroll==NULL)
	{
		// create a new pad to scroll text through
		wScroll=newpad(1,COLS*2+strlen(copyright));
		wattrset(wScroll,COLOR_ATTR(COLOR_RED,COLOR_WHITE));
		fillwin(wScroll,' ');
		mvwaddstr(wScroll,0,COLS,copyright);
	}

	if(pcol>getmaxx(wScroll)-COLS)
		pcol=0;

	pnoutrefresh(wScroll,0,pcol,srow,0,srow,COLS-1);

	pcol++;

}


void update_messages()
{
	static int iColorWinIndex=-1;
	static int state=0;

	if(iColorWinIndex>=0)
	{
		/* 
			cycle colors in the 
			"full-color" window
		*/
		int fg=state%COLORS;
		WINDOW* wWin=stack[iColorWinIndex];
		char* zPtr="full-color";

		mvwaddch(wWin,2,2,*zPtr|COLOR_ATTR(fg,COLOR_BLACK)|A_BOLD);
		do {
			zPtr++;
			fg++;
			fg%=COLORS;
			if(*zPtr)
				waddch(wWin,*zPtr|COLOR_ATTR(fg,COLOR_BLACK)|A_BOLD);
		}
		while(*zPtr);
		wnoutrefresh(wWin);
			
	}
		
	
	switch(state)
	{
	case 0:
		iTopWin++;
		stack[iTopWin]=build_window(6,30,10,25,NULL,0,COLOR_ATTR(COLOR_BLACK,COLOR_YELLOW),TRUE);
		wattrset(stack[iTopWin],COLOR_ATTR(COLOR_WHITE,COLOR_YELLOW)|A_BOLD);
		mvwaddstr(stack[iTopWin],2,8,"Yellow Window");
		wnoutrefresh(stack[iTopWin]);
		break;

	case 10:
		iTopWin++;
		stack[iTopWin]=build_window(5,20,15,12,NULL,0,COLOR_ATTR(COLOR_CYAN,COLOR_BLUE)|A_BOLD,TRUE);
		mvwaddstr(stack[iTopWin],2,2,"Blue Window");
		wnoutrefresh(stack[iTopWin]);
		break;

	case 20:
		iTopWin++;
		stack[iTopWin]=build_window(5,16,15,33,NULL,0,COLOR_ATTR(COLOR_GREEN,COLOR_BLACK)|A_BOLD,TRUE);
		mvwaddstr(stack[iTopWin],2,2,"Black Window");
		wnoutrefresh(stack[iTopWin]);
		break;
	
	case 30:
		iTopWin++;
		stack[iTopWin]=build_window(5,20,15,50,NULL,0,COLOR_ATTR(COLOR_RED,COLOR_WHITE),TRUE);
		mvwaddstr(stack[iTopWin],2,2,"White Window");
		wnoutrefresh(stack[iTopWin]);
		break;

	case 36:
	case 37:
	case 38: 
	case 39:
		refreshOverlap(iTopWin-1,stack[iTopWin]);
		delwin(stack[iTopWin]);
		iTopWin--;
		break;

	default:
		break;

	}

	state++;
	state%=40;
}


void refreshOverlap(int iMax, WINDOW* wTst)
{
	int i;
	for(i=0;i<=iMax;i++)
	{
		touchoverlap(wTst,stack[i]);
		wnoutrefresh(stack[i]);
	}

}

void refreshAll(int iMax, bool bTouch)
{
	int i;
	for(i=0;i<=iMax;i++)
	{
		if(bTouch) touchwin(stack[i]);
		wnoutrefresh(stack[i]);
	}
}
