/***********************************************

  CursesAPI for Win32
  v2.1

  Copyright 1996-1997 Ingen Software, Ltd.
  http://www.ingensoft.com
  (281) 922-4222
 
  sample2.c

  All work contained within this file and the associated
  object-code library represents an unpublished work, and 
  is the property of Ingen Software, Ltd.  

  This file is considered confidential, and is only provided
  for the use of authorized parties that have a software 
  license agreement on file with Ingen Software, Ltd.

  Any unauthorized redistribution of the contents of this file, 
  in whole or in part, is in violation of the software license 
  that permits use of this file and the associated object-code
  library.  Such redistribution may be in violation of local,
  federal, and international laws and/or treaties.
 
************************************************/

#include <stdio.h>
#include <stdlib.h>

#include <curses.h>

void initialize_color(void);

// Macro to compute the color attribute for given
// foreground and background color-values.  This
// prevents having to write a color-lookup function.
//
// In order for this to work, the curses color-table
// must be set up so that it contains all combinations
// of color-pairs, ordered first by foreground, then by
// background. 
#define COLOR_ATTR(fg,bg) (COLOR_PAIR((fg)+((bg)*COLORS)))

int main (int argc, char* argv[])
{
	WINDOW* wWin;
	int idx;

	initscr();			// start-up curses

	initialize_color();

	noecho();			// turn off echoing of input
	cbreak();			// turn off processed input mode

		// Create a new window 5x40, centered. 
	wWin=newwin(5,40,(LINES-5)/2, (COLS-40)/2);

		// Set the window's colors to white on blue.
	wattrset(wWin,COLOR_ATTR(COLOR_WHITE,COLOR_BLUE));

		// Fill the window with spaces.  It defaults to
		// blanks, which are black.
	wmove(wWin,0,0);
	for(idx=0;idx<getmaxy(wWin)*getmaxx(wWin);idx++)
		waddch(wWin,' ');

		// Draw a frame around the window.
	box(wWin,0,0);

		// Display "Hello, world!".
	mvwaddstr(wWin,2,2,"Hello, world!");

		// Get user input.  As a side effect, this
		// routine refreshes the window.
	wgetch(wWin);

	delwin(wWin);

	endwin();

	return 0;
}

// Initialize the curses color pairs.  It creates every
// combination of foreground and background color, ordered
// first by foreground, then by backround. 
void initialize_color(void)
{
	chtype foreground, background;
	int i;

	start_color();	// Initialize curses color system.

	foreground=background=0;

	for(i=0;i<COLORS*COLORS;i++)
	{
					// Add pair to color table.
		init_pair(i,foreground,background);

		foreground++;
		if(foreground>=(chtype)COLORS)
		{
			foreground=0;
			background++;
		}
	}
}
