/***********************************************

  CursesAPI for Win32
  v2.1

  Copyright 1996-1997 Ingen Software, Ltd.
  http://www.ingensoft.com
  (281) 922-4222
 
  queue.h

  All work contained within this file and the associated
  object-code library represents an unpublished work, and 
  is the property of Ingen Software, Ltd.  

  This file is considered confidential, and is only provided
  for the use of authorized parties that have a software 
  license agreement on file with Ingen Software, Ltd.

  Any unauthorized redistribution of the contents of this file, 
  in whole or in part, is in violation of the software license 
  that permits use of this file and the associated object-code
  library.  Such redistribution may be in violation of local,
  federal, and international laws and/or treaties.
 
************************************************/

#ifndef __QUEUE_H_INCLUDED
#define __QUEUE_H_INCLUDED

#include <windows.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

typedef struct QUEUE
{
    int cur_size;
    int member_size;
    int increment;
    int top_idx;
    int bottom_idx;
    CRITICAL_SECTION queue_access;
    void* members;
} QUEUE;

#ifndef __CURSES_DYNLOAD

extern LINKSPEC QUEUE* 	new_queue(int,int);
extern LINKSPEC void		queue_allow_grow(QUEUE*,int);
extern LINKSPEC void 	destroy_queue(QUEUE*);
extern LINKSPEC BOOL  	queue_isfull(const QUEUE*);
extern LINKSPEC BOOL		queue_isempty(const QUEUE*);
extern LINKSPEC void		empty_queue(QUEUE*);
extern LINKSPEC int		enqueue_fifo(QUEUE*,const void*);
extern LINKSPEC int   	enqueue_lifo(QUEUE*,const void*);
extern LINKSPEC void*   	serve_queue(QUEUE*,void*);
extern LINKSPEC void*   	peek_queue(QUEUE*,void*);

#else
#define new_queue				((QUEUE*(*) (int,int))curses_proc_map[FXN_new_queue].fpFxn)
#define queue_allow_grow	((void	(*)(QUEUE*,int))curses_proc_map[FXN_queue_allow_grow].fpFxn)
#define destroy_queue		((void (*)(QUEUE*))curses_proc_map[FXN_destroy_queue].fpFxn)
#define queue_isfull			((BOOL (*)(const QUEUE*))curses_proc_map[FXN_queue_isfull].fpFxn)
#define queue_isempty		((BOOL	(*)(const QUEUE*))curses_proc_map[FXN_queue_isempty].fpFxn)
#define empty_queue			((void	(*)(QUEUE*))curses_proc_map[FXN_empty_queue].fpFxn)
#define enqueue_fifo			((int(*) (QUEUE*,const void*))curses_proc_map[FXN_enqueue_fifo].fpFxn)
#define enqueue_lifo			((int  (*) 	(QUEUE*,const void*))curses_proc_map[FXN_enqueue_lifo].fpFxn)
#define serve_queue			((void*  (*) 	(QUEUE*,void*))curses_proc_map[FXN_serve_queue].fpFxn)
#define peek_queue			((void*  (*) 	(QUEUE*,void*))curses_proc_map[FXN_peek_queue].fpFxn)

#define FXN_new_queue				FXN_ALLOC_LAST+1
#define FXN_queue_allow_grow		FXN_new_queue+1
#define FXN_destroy_queue		FXN_queue_allow_grow+1
#define FXN_queue_isfull		FXN_queue_isfull+1
#define FXN_queue_isempty		FXN_queue_isempty+1
#define FXN_empty_queue		FXN_empty_queue+1
#define FXN_enqueue_fifo		FXN_enqueue_fifo+1
#define FXN_enqueue_lifo		FXN_enqueue_lifo+1
#define FXN_serve_queue		FXN_serve_queue+1
#define FXN_peek_queue		FXN_peek_queue+1
#define FXN_QUEUE_LAST		FXN_peek_queue

#endif /* __CURSES_DYNLOAD */

#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __QUEUE_H_INCLUDED */
