/***********************************************

  CursesAPI for Win32
  v2.1

  Copyright 1996-1997 Ingen Software, Ltd.
  http://www.ingensoft.com
  (281) 922-4222
 
  loaded.h

  All work contained within this file and the associated
  object-code library represents an unpublished work, and 
  is the property of Ingen Software, Ltd.  

  This file is considered confidential, and is only provided
  for the use of authorized parties that have a software 
  license agreement on file with Ingen Software, Ltd.

  Any unauthorized redistribution of the contents of this file, 
  in whole or in part, is in violation of the software license 
  that permits use of this file and the associated object-code
  library.  Such redistribution may be in violation of local,
  federal, and international laws and/or treaties.
 
************************************************/

#ifndef __LOADED_H_INCLUDED
#define __LOADED_H_INCLUDED


typedef struct {
	LPCTSTR lpszName;
	FARPROC fpFxn;
} CURSES_PROC_MAP;

extern CURSES_PROC_MAP curses_proc_map[];

#define _getsyx      		((int (*)(int*, int*))curses_proc_map[FXN__getsyx].fpFxn)
#define beep      			((int (*)(void))curses_proc_map[FXN_beep].fpFxn)
#define box      				((void (*)(WINDOW*,chtype,chtype))curses_proc_map[FXN_box].fpFxn)
#define can_change_color   ((bool (*)(void))curses_proc_map[FXN_can_change_color].fpFxn)
#define cbreak      			((void (*)(void))curses_proc_map[FXN_cbreak].fpFxn)
#define clearok      		((void (*)(WINDOW*,bool))curses_proc_map[FXN_clearok].fpFxn)
#define color_content      ((int (*)(int , short* , short* , short* ))curses_proc_map[FXN_color_content].fpFxn)
#define copywin      		((int (*)(WINDOW*,WINDOW*,int,int,int,int,int,int,bool))curses_proc_map[FXN_copywin].fpFxn)
#define curs_set      		((int (*)(int))curses_proc_map[FXN_curs_set].fpFxn)
#define def_prog_mode      ((void (*)(void))curses_proc_map[FXN_def_prog_mode].fpFxn)
#define def_shell_mode     ((void (*)(void))curses_proc_map[FXN_def_shell_mode].fpFxn)
#define delay_output      	((int (*)(int ))curses_proc_map[FXN_delay_output].fpFxn)
#define delwin      			((void (*)(WINDOW*))curses_proc_map[FXN_delwin].fpFxn)
#define doupdate      		((int (*)(void))curses_proc_map[FXN_doupdate].fpFxn)
#define echo      			((void (*)(void))curses_proc_map[FXN_echo].fpFxn)
#define endwin      			((void (*)(void))curses_proc_map[FXN_endwin].fpFxn)	  
#define filter      			((void (*)(void))curses_proc_map[FXN_filter].fpFxn)
#define flash      			((int (*)(void))curses_proc_map[FXN_flash].fpFxn)
#define flushinp      		((int (*)(void))curses_proc_map[FXN_flushinp].fpFxn)
#define garbagedlines      ((void (*)(WINDOW* , int , int ))curses_proc_map[FXN_garbagedlines].fpFxn)
#define halfdelay      		((void (*)(int ))curses_proc_map[FXN_halfdelay].fpFxn)
#define has_colors      	((bool (*)(void))curses_proc_map[FXN_has_colors].fpFxn)
#define idlok      			((void (*)(WINDOW* , bool ))curses_proc_map[FXN_idlok].fpFxn)
#define init_pair      		((int (*)(int , int , int ))curses_proc_map[FXN_init_pair].fpFxn)
extern WINDOW*	initscr();		// initscr loads the module, then calls initscr FARPROC
#define intrflush      		((int (*)(WINDOW*,bool))curses_proc_map[FXN_intrflush].fpFxn)
#define isendwin      		((int (*)())curses_proc_map[FXN_isendwin].fpFxn)
#define keyname      		((char* (*)(int))curses_proc_map[FXN_keyname].fpFxn)
#define keypad      		((int (*)(WINDOW*,bool))curses_proc_map[FXN_keypad].fpFxn)
#define leaveok      		((void (*)(WINDOW*,bool))curses_proc_map[FXN_leaveok].fpFxn)
#define meta      		((int (*)(WINDOW*,bool))curses_proc_map[FXN_meta].fpFxn)
#define mvprintw      		((int (*)(int,int,char*,...))curses_proc_map[FXN_mvprintw].fpFxn)
#define mvscanw      		((int (*)(int,int,char*,...))curses_proc_map[FXN_mvscanw].fpFxn)
#define mvwaddch      		((int (*)(WINDOW* ,int , int , chtype ))curses_proc_map[FXN_mvwaddch].fpFxn)
#define mvwaddnstr      	((int (*)(WINDOW* ,int , int , const char* , int ))curses_proc_map[FXN_mvwaddnstr].fpFxn)
#define mvwaddstr      		((int (*)(WINDOW* ,int , int , const char* ))curses_proc_map[FXN_mvwaddstr].fpFxn)
#define mvwdelch      		((int (*)(WINDOW*,int,int))curses_proc_map[FXN_mvwdelch].fpFxn)
#define mvwgetch      		((int (*)(WINDOW*,int,int))curses_proc_map[FXN_mvwgetch].fpFxn)
#define mvwgetnstr     		((int (*)(WINDOW*,int,int,char*,int))curses_proc_map[FXN_mvwgetnstr].fpFxn)
#define mvwinnstr      		((int (*)(WINDOW*,int,int,char*,int))curses_proc_map[FXN_mvwinnstr].fpFxn)
#define mvwin      		((int (*)(WINDOW* , int , int ))curses_proc_map[FXN_mvwin].fpFxn)
#define mvwinch      		((int (*)(WINDOW*,int,int))curses_proc_map[FXN_mvwinch].fpFxn)
#define mvwinsch      		((int (*)(WINDOW*,int,int,chtype))curses_proc_map[FXN_mvwinsch].fpFxn)
#define mvwprintw      		((int (*)(WINDOW* , int , int , char* ,...))curses_proc_map[FXN_mvwprintw].fpFxn)
#define mvwscanw      		((int (*)(WINDOW*,int,int,char*,...))curses_proc_map[FXN_mvwscanw].fpFxn)
#define napms      		((int (*)(int))curses_proc_map[FXN_napms].fpFxn)
#define newpad      		((WINDOW* (*)(int,int))curses_proc_map[FXN_newpad].fpFxn)
#define newterm      		((SCREEN* (*)(char* , FILE* , FILE* ))curses_proc_map[FXN_newterm].fpFxn)
#define newwin       		((WINDOW* (*)(int , int , int , int ))curses_proc_map[FXN_newwin].fpFxn)
#define nl      		((void (*)(void))curses_proc_map[FXN_nl].fpFxn)
#define nocbreak      		((void (*)(void))curses_proc_map[FXN_nocbreak].fpFxn)
#define nodelay      		((int (*)(WINDOW*,bool))curses_proc_map[FXN_nodelay].fpFxn)
#define noecho      			((void (*)(void))curses_proc_map[FXN_noecho].fpFxn)
#define nonl      			((void (*)(void))curses_proc_map[FXN_nonl].fpFxn)
#define noraw      			((void (*)(void))curses_proc_map[FXN_noraw].fpFxn)
#define overlay      		((int (*)(WINDOW*,WINDOW*))curses_proc_map[FXN_overlay].fpFxn)
#define overwrite      		((int (*)(WINDOW*,WINDOW*))curses_proc_map[FXN_overwrite].fpFxn)
#define pair_content      	((int (*)(int , int*, int*))curses_proc_map[FXN_pair_content].fpFxn)
#define pechochar      		((int (*)(WINDOW*,chtype))curses_proc_map[FXN_pechochar].fpFxn)
#define pnoutrefresh      	((int (*)(WINDOW*,int,int,int,int,int,int))curses_proc_map[FXN_pnoutrefresh].fpFxn)
#define prefresh      		((int (*)(WINDOW*,int,int,int,int,int,int))curses_proc_map[FXN_prefresh].fpFxn)
#define printw      			((int (*)(char*,...))curses_proc_map[FXN_printw].fpFxn)
#define raw      				((void (*)(void))curses_proc_map[FXN_raw].fpFxn)
#define reset_prog_mode    ((void (*)(void))curses_proc_map[FXN_reset_prog_mode].fpFxn)
#define reset_shell_mode   ((void (*)(void))curses_proc_map[FXN_reset_shell_mode].fpFxn)
#define resetty      		((int (*)(void))curses_proc_map[FXN_resetty].fpFxn)
#define restartterm      	((void (*)(char* , int , int* ))curses_proc_map[FXN_restartterm].fpFxn)
#define ripoffline      	((void (*)(int , int (*)()))curses_proc_map[FXN_ripoffline].fpFxn)
#define savetty      		((int (*)(void))curses_proc_map[FXN_savetty].fpFxn)
#define scanw      			((int (*)(char*,...))curses_proc_map[FXN_scanw].fpFxn)
#define scr_dump      		((int (*)(char* filename))curses_proc_map[FXN_scr_dump].fpFxn)
#define scr_init      		((int (*)(char* filename))curses_proc_map[FXN_scr_init].fpFxn)
#define scr_restore      	((int (*)(char* filename))curses_proc_map[FXN_scr_restore].fpFxn)
#define wscrl     	 		((int (*)(WINDOW*))curses_proc_map[FXN_scroll].fpFxn)
#define scrollok      		((int (*)(WINDOW*,bool))curses_proc_map[FXN_scrollok].fpFxn)
#define set_curterm      	((TERMINAL* (*)(TERMINAL* nterm))curses_proc_map[FXN_set_curterm].fpFxn)
#define set_term      		((SCREEN* (*)(SCREEN* new))curses_proc_map[FXN_set_term].fpFxn)
#define setsyx      			((int (*)(int,int))curses_proc_map[FXN_setsyx].fpFxn)
#define setupterm      		((int (*)(char* , int , int* ))curses_proc_map[FXN_setupterm].fpFxn)
#define slk_attroff      	((void (*)(chtype))curses_proc_map[FXN_slk_attroff].fpFxn)
#define slk_attron      	((void (*)(chtype))curses_proc_map[FXN_slk_attron].fpFxn)
#define slk_attrset      	((void (*)(chtype))curses_proc_map[FXN_slk_attrset].fpFxn)
#define slk_clear      		((void (*)(void))curses_proc_map[FXN_slk_clear].fpFxn)
#define slk_init      		((void (*)(int ))curses_proc_map[FXN_slk_init].fpFxn)
#define slk_label      		((char* (*)(int ))curses_proc_map[FXN_slk_label].fpFxn)
#define slk_noutrefresh    ((void (*)(void))curses_proc_map[FXN_slk_noutrefresh].fpFxn)
#define slk_refresh      	((void (*)(void))curses_proc_map[FXN_slk_refresh].fpFxn)
#define slk_restore      	((void (*)(void))curses_proc_map[FXN_slk_restore].fpFxn)
#define slk_set      		((int (*)(int , char* , int ))curses_proc_map[FXN_slk_set].fpFxn)
#define slk_touch      		((void (*)(void))curses_proc_map[FXN_slk_touch].fpFxn)
#define start_color      	((int (*)(void))curses_proc_map[FXN_start_color].fpFxn)
#define subpad      			((WINDOW* (*)(WINDOW*,int,int,int,int))curses_proc_map[FXN_subpad].fpFxn)
#define subwin      			((WINDOW* (*)(WINDOW*,int,int,int,int))curses_proc_map[FXN_subwin].fpFxn)
#define touchline      		((void (*)(WINDOW*,int,int))curses_proc_map[FXN_touchline].fpFxn)
#define touchoverlap      	((void (*)(WINDOW*,WINDOW*))curses_proc_map[FXN_touchoverlap].fpFxn)
#define touchwin      		((void (*)(WINDOW*))curses_proc_map[FXN_touchwin].fpFxn)
#define traceoff      		((void (*)(void))curses_proc_map[FXN_traceoff].fpFxn)
#define traceon      		((void (*)(void))curses_proc_map[FXN_traceon].fpFxn)
#define typeahead      		((int (*)(int ))curses_proc_map[FXN_typeahead].fpFxn)
#define ungetch      		((void (*)(int))curses_proc_map[FXN_ungetch].fpFxn)
#define vwscanw      		((int (*)(WINDOW*,char*,va_list))curses_proc_map[FXN_vwscanw].fpFxn)
#define wattroff      		((int (*)(WINDOW* , chtype ))curses_proc_map[FXN_wattroff].fpFxn)
#define wattron      		((int (*)(WINDOW* , chtype ))curses_proc_map[FXN_wattron].fpFxn)
#define wattrset      		((int (*)(WINDOW* ,chtype ))curses_proc_map[FXN_wattrset].fpFxn)
#define wclear      			((int (*)(WINDOW*))curses_proc_map[FXN_wclear].fpFxn)
#define wclrtobot      		((int (*)(WINDOW*))curses_proc_map[FXN_wclrtobot].fpFxn)
#define wclrtoeol      		((int (*)(WINDOW*))curses_proc_map[FXN_wclrtoeol].fpFxn)
#define wdeleteln      		((int (*)(WINDOW*))curses_proc_map[FXN_wdeleteln].fpFxn)
#define wechochar      		((int (*)(WINDOW*,chtype))curses_proc_map[FXN_wechochar].fpFxn)
#define werase      			((int (*)(WINDOW*))curses_proc_map[FXN_werase].fpFxn)
#define winsertln      		((int (*)(WINDOW*))curses_proc_map[FXN_winsertln].fpFxn)
#define wmove      			((int (*)(WINDOW* , int , int ))curses_proc_map[FXN_wmove].fpFxn)
#define wnoutrefresh      	((int (*)(WINDOW* ))curses_proc_map[FXN_wnoutrefresh].fpFxn)
#define wprintw      		((int (*)(WINDOW* ,char* ,...))curses_proc_map[FXN_wprintw].fpFxn)
#define wrefresh      		((int (*)(WINDOW* ))curses_proc_map[FXN_wrefresh].fpFxn)
#define wscanw      			((int (*)(WINDOW*,char*,...))curses_proc_map[FXN_wscanw].fpFxn)
#define wstandend      		((int (*)(WINDOW*))curses_proc_map[FXN_wstandend].fpFxn)
#define wstandout      		((int (*)(WINDOW*))curses_proc_map[FXN_wstandout].fpFxn)
#define capi_setUsrKeyMapFxn  ((void (*)(WINDOW*,KEY_EVENT_RECORD*,int*))curses_proc_map[FXN_capi_setUsrKeyMapFxn].fpFxn)
#define wtimeout		((void(*)(WINDOW*,int))curses_proc_map[FXN_wtimeout].fpFxn)
#define notimeout		((int(*)(WINDOW*,bool))curses_proc_map[FXN_notimeout].fpFxn)

#define FXN_getGlobalCursesValues 0
#define FXN__getsyx			FXN_getGlobalCursesValues+1
#define FXN_beep				FXN__getsyx+1
#define FXN_box				FXN_beep+1
#define FXN_can_change_color		FXN_box+1
#define FXN_cbreak		FXN_can_change_color+1
#define FXN_clearok		FXN_cbreak+1
#define FXN_color_content		FXN_clearok+1
#define FXN_copywin		FXN_color_content+1
#define FXN_curs_set		FXN_copywin+1
#define FXN_def_prog_mode		FXN_curs_set+1
#define FXN_def_shell_mode		FXN_def_prog_mode+1
#define FXN_delay_output		FXN_def_shell_mode+1
#define FXN_delwin		FXN_delay_output+1
#define FXN_doupdate		FXN_delwin+1
#define FXN_echo		FXN_doupdate+1
#define FXN_endwin	  		FXN_echo+1
#define FXN_filter		FXN_endwin	  +1
#define FXN_flash		FXN_filter+1
#define FXN_flushinp		FXN_flash+1
#define FXN_garbagedlines		FXN_flushinp+1
#define FXN_halfdelay		FXN_garbagedlines+1
#define FXN_has_colors		FXN_halfdelay+1
#define FXN_idlok		FXN_has_colors+1
#define FXN_init_pair		FXN_idlok+1
#define FXN_initscr		FXN_init_pair+1
#define FXN_intrflush		FXN_initscr+1
#define FXN_isendwin		FXN_intrflush+1
#define FXN_keyname		FXN_isendwin+1
#define FXN_keypad		FXN_keyname+1
#define FXN_leaveok		FXN_keypad+1
#define FXN_meta		FXN_leaveok+1
#define FXN_mvprintw		FXN_meta+1
#define FXN_mvscanw		FXN_mvprintw+1
#define FXN_mvwaddch		FXN_mvscanw+1
#define FXN_mvwaddnstr		FXN_mvwaddch+1
#define FXN_mvwaddstr		FXN_mvwaddnstr+1
#define FXN_mvwdelch		FXN_mvwaddstr+1
#define FXN_mvwgetch		FXN_mvwdelch+1
#define FXN_mvwgetnstr		FXN_mvwgetch+1
#define FXN_mvwinnstr		FXN_mvwgetnstr+1
#define FXN_mvwin		FXN_mvwinnstr+1
#define FXN_mvwinch		FXN_mvwin+1
#define FXN_mvwinsch		FXN_mvwinch+1
#define FXN_mvwprintw		FXN_mvwinsch+1
#define FXN_mvwscanw		FXN_mvwprintw+1
#define FXN_napms		FXN_mvwscanw+1
#define FXN_newpad		FXN_napms+1
#define FXN_newterm		FXN_newpad+1
#define FXN_newwin		FXN_newterm+1
#define FXN_nl		FXN_newwin+1
#define FXN_nocbreak		FXN_nl+1
#define FXN_nodelay		FXN_nocbreak+1
#define FXN_noecho		FXN_nodelay+1
#define FXN_nonl		FXN_noecho+1
#define FXN_noraw		FXN_nonl+1
#define FXN_notimeout		FXN_noraw+1
#define FXN_overlay		FXN_notimeout+1
#define FXN_overwrite		FXN_overlay+1
#define FXN_pair_content		FXN_overwrite+1
#define FXN_pechochar		FXN_pair_content+1
#define FXN_pnoutrefresh		FXN_pechochar+1
#define FXN_prefresh		FXN_pnoutrefresh+1
#define FXN_printw		FXN_prefresh+1
#define FXN_raw		FXN_printw+1
#define FXN_reset_prog_mode		FXN_raw+1
#define FXN_reset_shell_mode		FXN_reset_prog_mode+1
#define FXN_resetty		FXN_reset_shell_mode+1
#define FXN_restartterm		FXN_resetty+1
#define FXN_ripoffline		FXN_restartterm+1
#define FXN_savetty		FXN_ripoffline+1
#define FXN_scanw		FXN_savetty+1
#define FXN_scr_dump		FXN_scanw+1
#define FXN_scr_init		FXN_scr_dump+1
#define FXN_scr_restore		FXN_scr_init+1
#define FXN_wscrl		FXN_scr_restore+1
#define FXN_scrollok		FXN_wscrl+1
#define FXN_set_curterm		FXN_scrollok+1
#define FXN_set_term		FXN_set_curterm+1
#define FXN_setsyx		FXN_set_term+1
#define FXN_setupterm		FXN_setsyx+1
#define FXN_slk_attroff		FXN_setupterm+1
#define FXN_slk_attron		FXN_slk_attroff+1
#define FXN_slk_attrset		FXN_slk_attron+1
#define FXN_slk_clear		FXN_slk_attrset+1
#define FXN_slk_init		FXN_slk_clear+1
#define FXN_slk_label		FXN_slk_init+1
#define FXN_slk_noutrefresh		FXN_slk_label+1
#define FXN_slk_refresh		FXN_slk_noutrefresh+1
#define FXN_slk_restore		FXN_slk_refresh+1
#define FXN_slk_set		FXN_slk_restore+1
#define FXN_slk_touch		FXN_slk_set+1
#define FXN_start_color		FXN_slk_touch+1
#define FXN_subpad		FXN_start_color+1
#define FXN_subwin		FXN_subpad+1
#define FXN_touchline		FXN_subwin+1
#define FXN_touchoverlap		FXN_touchline+1
#define FXN_touchwin		FXN_touchoverlap+1
#define FXN_traceoff		FXN_touchwin+1
#define FXN_traceon		FXN_traceoff+1
#define FXN_typeahead		FXN_traceon+1
#define FXN_ungetch		FXN_typeahead+1
#define FXN_vwscanw		FXN_ungetch+1
#define FXN_wattroff		FXN_vwscanw+1
#define FXN_wattron		FXN_wattroff+1
#define FXN_wattrset		FXN_wattron+1
#define FXN_wclear		FXN_wattrset+1
#define FXN_wclrtobot		FXN_wclear+1
#define FXN_wclrtoeol		FXN_wclrtobot+1
#define FXN_wdeleteln		FXN_wclrtoeol+1
#define FXN_wechochar		FXN_wdeleteln+1
#define FXN_werase		FXN_wechochar+1
#define FXN_winsertln		FXN_werase+1
#define FXN_wmove		FXN_winsertln+1
#define FXN_wnoutrefresh		FXN_wmove+1
#define FXN_wprintw		FXN_wnoutrefresh+1
#define FXN_wrefresh		FXN_wprintw+1
#define FXN_wscanw		FXN_wrefresh+1
#define FXN_wstandend		FXN_wscanw+1
#define FXN_wstandout		FXN_wstandend+1
#define FXN_capi_setUsrKeyMapFxn		FXN_wstandout+1
#define FXN_wtimeout		FXN_capi_setUsrKeyMapFxn+1
#define FXN_CURSES_LAST		FXN_wtimeout

#endif /* __LOADED_H_INCLUDED */
