/***********************************************

  CursesAPI for Win32
  v2.1

  Copyright 1996-1997 Ingen Software, Ltd.
  http://www.ingensoft.com
  (281) 922-4222
 
  linked.h

  All work contained within this file and the associated
  object-code library represents an unpublished work, and 
  is the property of Ingen Software, Ltd.  

  This file is considered confidential, and is only provided
  for the use of authorized parties that have a software 
  license agreement on file with Ingen Software, Ltd.

  Any unauthorized redistribution of the contents of this file, 
  in whole or in part, is in violation of the software license 
  that permits use of this file and the associated object-code
  library.  Such redistribution may be in violation of local,
  federal, and international laws and/or treaties.
 
************************************************/

#ifndef __LINKED_H_INCLUDED
#define __LINKED_H_INCLUDED

extern LINKSPEC WINDOW* initscr(void);
extern LINKSPEC void endwin(void);

extern LINKSPEC int start_color(void);
extern LINKSPEC int init_pair(int pair, int fg, int bg);
extern LINKSPEC int pair_content(int pair, int*fg, int* bg);
extern LINKSPEC int color_content(int color, short* r, short* g, short* b);
extern LINKSPEC bool can_change_color(void);
extern LINKSPEC bool has_colors(void);

extern LINKSPEC int wnoutrefresh(WINDOW* wScr);
extern LINKSPEC int wrefresh(WINDOW* wScr);

extern LINKSPEC int prefresh(WINDOW*,int,int,int,int,int,int);
extern LINKSPEC int pnoutrefresh(WINDOW*,int,int,int,int,int,int);
extern LINKSPEC int doupdate(void);

extern LINKSPEC void touchwin(WINDOW*);
extern LINKSPEC void touchline(WINDOW*,int,int);
extern LINKSPEC void touchoverlap(WINDOW*,WINDOW*);
extern LINKSPEC void leaveok(WINDOW*,bool);
extern LINKSPEC void clearok(WINDOW*,bool);

extern LINKSPEC int wmove(WINDOW* wScr, int row, int col);


extern LINKSPEC int wdeleteln(WINDOW*);


extern LINKSPEC int mvwdelch(WINDOW*,int,int);


extern LINKSPEC int mvwinsch(WINDOW*,int,int,chtype);

extern LINKSPEC int winsertln(WINDOW*);

extern LINKSPEC int mvwaddstr(WINDOW* wScr,int row, int col, const char* zStr);

extern LINKSPEC int mvwaddnstr(WINDOW* wScr,int row, int col, const char* zStr, int len);

extern LINKSPEC int mvwprintw(WINDOW* wScr, int row, int col, char* sForm,...);
extern LINKSPEC int wprintw(WINDOW* wScr,char* sForm,...);
extern LINKSPEC int printw(char*,...);
extern LINKSPEC int mvprintw(int,int,char*,...);

extern LINKSPEC int mvwaddch(WINDOW* wScr,int row, int col, chtype c);

extern LINKSPEC int wechochar(WINDOW*,chtype);
extern LINKSPEC int pechochar(WINDOW*,chtype);


extern LINKSPEC int mvwgetch(WINDOW*,int,int);

extern LINKSPEC int mvwgetnstr(WINDOW*,int,int,char*,int);

extern LINKSPEC int mvwinch(WINDOW*,int,int);

extern LINKSPEC int mvwinnstr(WINDOW*,int,int,char*,int);

extern LINKSPEC int copywin(WINDOW*,WINDOW*,int,int,int,int,int,int,bool);
extern LINKSPEC int overlay(WINDOW*,WINDOW*);
extern LINKSPEC int overwrite(WINDOW*,WINDOW*);

extern LINKSPEC void ungetch(int);

extern LINKSPEC int mvwscanw(WINDOW*,int,int,char*,...);
extern LINKSPEC int mvscanw(int,int,char*,...);
extern LINKSPEC int wscanw(WINDOW*,char*,...);
extern LINKSPEC int scanw(char*,...);

extern LINKSPEC int vwscanw(WINDOW*,char*,va_list);


extern LINKSPEC int flushinp(void);

extern LINKSPEC int beep(void);
extern LINKSPEC int flash(void);
extern LINKSPEC int wattron(WINDOW* wScr, chtype attrs);

extern LINKSPEC int wattroff(WINDOW* wScr, chtype attrs);

extern LINKSPEC int wattrset(WINDOW* wScr,chtype attrs);

extern LINKSPEC int wstandout(WINDOW*);

extern LINKSPEC int wstandend(WINDOW*);


extern LINKSPEC WINDOW* newwin(int rows, int cols, int row, int col);
extern LINKSPEC WINDOW* newpad(int,int);
extern LINKSPEC WINDOW* subwin(WINDOW*,int,int,int,int);
extern LINKSPEC WINDOW* subpad(WINDOW*,int,int,int,int);
extern LINKSPEC void delwin(WINDOW*);

extern LINKSPEC void box(WINDOW*,chtype,chtype);

extern LINKSPEC int wclrtoeol(WINDOW*);
extern LINKSPEC int wclrtobot(WINDOW*);
extern LINKSPEC int wclear(WINDOW*);
extern LINKSPEC int werase(WINDOW*);

extern LINKSPEC int mvwin(WINDOW* win, int y, int x);

extern LINKSPEC int meta(WINDOW*,bool);
extern LINKSPEC void cbreak(void);
extern LINKSPEC void nocbreak(void);
extern LINKSPEC void echo(void);
extern LINKSPEC void noecho(void);

extern LINKSPEC int isendwin();

extern LINKSPEC int intrflush(WINDOW*,bool);
extern LINKSPEC int keypad(WINDOW*,bool);
extern LINKSPEC int nodelay(WINDOW*,bool);
extern LINKSPEC int notimeout(WINDOW*,bool);
extern LINKSPEC void wtimeout(WINDOW*,int);
extern LINKSPEC void halfdelay(int tenths);
extern LINKSPEC void raw(void);
extern LINKSPEC void noraw(void);
extern LINKSPEC int curs_set(int);
extern LINKSPEC int napms(int);
extern LINKSPEC int _getsyx(int*, int*);
extern LINKSPEC int setsyx(int,int);

extern LINKSPEC int savetty(void);
extern LINKSPEC int resetty(void);
extern LINKSPEC void def_prog_mode(void);
extern LINKSPEC void def_shell_mode(void);
extern LINKSPEC void reset_prog_mode(void);
extern LINKSPEC void reset_shell_mode(void);
extern LINKSPEC char* keyname(int);


extern LINKSPEC int scrollok(WINDOW*,bool);
extern LINKSPEC int wscrl(WINDOW*,int);
extern LINKSPEC void nl(void);
extern LINKSPEC void nonl(void);
extern LINKSPEC void capi_setUsrKeyMapFxn(BOOL(*)(WINDOW*,KEY_EVENT_RECORD*,int*));


extern LINKSPEC void slk_clear(void);
extern LINKSPEC void slk_init(int format);
extern LINKSPEC char* slk_label(int labelnum);
extern LINKSPEC void slk_noutrefresh(void);
extern LINKSPEC void slk_refresh(void);
extern LINKSPEC void slk_restore(void);
extern LINKSPEC int slk_set(int labelnum, char* label, int format);
extern LINKSPEC void slk_touch(void);
extern LINKSPEC void slk_attron(chtype);
extern LINKSPEC void slk_attroff(chtype);
extern LINKSPEC void slk_attrset(chtype);

extern LINKSPEC void ripoffline(int line, int (*init_func)());

#include "notimp.h"

#endif /* __LINKED_H_INCLUDED */
