/***********************************************

  CursesAPI for Win32
  v2.1

  Copyright 1996-1997 Ingen Software, Ltd.
  http://www.ingensoft.com
  (281) 922-4222
 
  cursmacro.h

  All work contained within this file and the associated
  object-code library represents an unpublished work, and 
  is the property of Ingen Software, Ltd.  

  This file is considered confidential, and is only provided
  for the use of authorized parties that have a software 
  license agreement on file with Ingen Software, Ltd.

  Any unauthorized redistribution of the contents of this file, 
  in whole or in part, is in violation of the software license 
  that permits use of this file and the associated object-code
  library.  Such redistribution may be in violation of local,
  federal, and international laws and/or treaties.
 
************************************************/

#ifndef __CURSMACRO_H_INCLUDED
#define __CURSMACRO_H_INCLUDED


#define refresh()				(wrefresh(stdscr))

#define move(row,col)			(wmove(stdscr,(row),(col)))

#define	deleteln()				(wdeleteln(stdscr))

#define wdelch(win)				(mvwdelch((win),-1,-1))
#define mvdelch(row,col)		(mvwdelch(stdscr,(row),(col)))
#define delch()					(wdelch(stdscr))

#define winsch(win,ch)			(mvwinsch((win),-1,-1,(ch)))
#define mvinsch(row,col,ch)		(mvwinsch(stdscr,(row),(col),(ch)))
#define insch(ch)				(winsch(stdscr,(ch)))

#define insertln()				(winsertln(stdscr))

#define waddstr(win,str)		(mvwaddstr((win),-1,-1,(str)))
#define addstr(str)				(waddstr(stdscr,(str)))
#define mvaddstr(row,col,str)	(mvwaddstr(stdscr,(row),(col),(str)))
#define waddnstr(win,str,len)		(mvwaddnstr((win),-1,-1,(str),(len)))
#define addnstr(str,len)			(waddnstr(stdscr,(str),(len)))
#define mvaddnstr(row,col,str,len)	(mvwaddnstr(stdscr,(row),(col),(str),(len)))

#define waddch(win,ch)			(mvwaddch((win),-1,-1,(ch)))
#define mvaddch(row,col,ch)		(mvwaddch(stdscr,(row),(col),(ch)))
#define addch(ch)				(waddch(stdscr,(ch)))

#define echochar(c)				(wechochar(stdscr,c))

#define wgetch(win)				(mvwgetch((win),-1,-1))
#define mvgetch(row,col)		(mvwgetch(stdscr,(row),(col)))
#define getch()					(wgetch(stdscr))

#define mvwgetstr(win,row,col,buf)	(mvwgetnstr((win),(row),(col),(buf),INFINITE))
#define wgetstr(win,buf)		(mvwgetstr((win),-1,-1,(buf)))
#define mvgetstr(row,col,buf)		(mvwgetstr(stdscr,(row),(col),(buf)))
#define getstr(buf)			(wgetstr(stdscr,(buf)))

#define wgetnstr(win,buf,len)		(mvwgetnstr((win),-1,-1,(buf),(len)))
#define mvgetnstr(row,col,buf,len)	(mvwgetnstr(stdscr,(row),(col),(buf),(len)))
#define getnstr(buf,len)		(wgetnstr(stdscr,(buf),(len)))

#define winch(win)			(mvwinch((win),-1,-1))
#define mvinch(row,col)			(mvwinch(stdscr,(row),(col)))
#define inch()				(winch(stdscr))

#define mvwinstr(win,row,col,buf)	(mvwinnstr((win),(row),(col),(buf),INFINITE))
#define winstr(win,buf)			(mvwinstr((win),-1,-1,(buf)))
#define mvinstr(row,col,buf)		(mvwinstr(stdscr,(row),(col),(buf)))
#define instr(buf)			(winstr(stdscr,(buf)))

#define winnstr(win,buf,len)		(mvwinnstr((win),-1,-1,(buf),(len)))
#define mvinnstr(row,col,buf,len)	(mvwinnstr(stdscr,(row),(col),(buf),(len)))
#define innstr(buf,len)			(winnstr(stdscr,(buf),(len)))

#define attron(attr)			(wattron(stdscr,(attr)))
#define attroff(attr)			(wattroff(stdscr,(attr)))
#define attrset(attr)			(wattrset(stdscr,(attr)))
#define standout()				(wstandout(stdscr))
#define standend()				(wstandend(stdscr))

#define clrtoeol()				(wclrtoeol(stdscr))
#define clrtobot()				(wclrtobot(stdscr))
#define clear()					(wclear(stdscr))
#define erase()					(werase(stdscr))

#define getcury(win)		((win)->_cury)
#define getcurx(win)		((win)->_curx)
#define getbegy(win)		((win)->_begy)
#define getbegx(win)		((win)->_begx)
#define getmaxy(win)		((win)->_maxy)
#define getmaxx(win)		((win)->_maxx)
#define getpary(win)		((win)->_pary)
#define getparx(win)		((win)->_parx)

#define getyx(win,y,x)		((y)=getcury(win), (x)=getcurx(win))
#define getparyx(win,y,x)	((y)=getpary(win), (x)=getparx(win))
#define getmaxyx(win,y,x)	((y)=getmaxy(win), (x)=getmaxx(win))
#define getbegyx(win,y,x)	((y)=getbegy(win), (x)=getbegx(win))

#define draino(ms)				(napms(ms))
#define getsyx(y,x)				(_getsyx(&(y),&(x)))
#define erasechar()		((int)'\b')
#define killchar()		(0)
#define baudrate()		(38400)
#define has_ic()		(TRUE)
#define has_il()		(TRUE)

#define scroll(win)		(wscrl((win),1))

#define wsetscrreg(win,top,bot)	((win)->_tmarg=(top),(win)->_bmarg=(bot))
#define setscrreg(top,bot)		(wsetscrreg(stdscr,(top),(bot)))

#define timeout(delay)		(wtimeout(stdscr,(delay)))

#endif /* __CURSMACRO_H_INCLUDED */
