/***********************************************

  CursesAPI for Win32
  v2.1

  Copyright 1996-1997 Ingen Software, Ltd.
  http://www.ingensoft.com
  (281) 922-4222
 
  curses_loader.c

  All work contained within this file and the associated
  object-code library represents an unpublished work, and 
  is the property of Ingen Software, Ltd.  

  This file is considered confidential, and is only provided
  for the use of authorized parties that have a software 
  license agreement on file with Ingen Software, Ltd.

  Any unauthorized redistribution of the contents of this file, 
  in whole or in part, is in violation of the software license 
  that permits use of this file and the associated object-code
  library.  Such redistribution may be in violation of local,
  federal, and international laws and/or treaties.
 
************************************************/

#include "curses.h"

	/* array to map string names to function pointers */

CURSES_PROC_MAP curses_proc_map[] = {
	{TEXT("getGlobalCursesValues"),NULL},
	{TEXT("_getsyx"),NULL},
	{TEXT("beep"),NULL},
	{TEXT("box"),NULL},
	{TEXT("can_change_color"),NULL},
	{TEXT("cbreak"),NULL},
	{TEXT("clearok"),NULL},
	{TEXT("color_content"),NULL},
	{TEXT("copywin"),NULL},
	{TEXT("curs_set"),NULL},
	{TEXT("def_prog_mode"),NULL},
	{TEXT("def_shell_mode"),NULL},
	{TEXT("delay_output"),NULL},
	{TEXT("delwin"),NULL},
	{TEXT("doupdate"),NULL},
	{TEXT("echo"),NULL},
	{TEXT("endwin"),NULL},
	{TEXT("filter"),NULL},
	{TEXT("flash"),NULL},
	{TEXT("flushinp"),NULL},
	{TEXT("garbagedlines"),NULL},
	{TEXT("halfdelay"),NULL},
	{TEXT("has_colors"),NULL},
	{TEXT("idlok"),NULL},
	{TEXT("init_pair"),NULL},
	{TEXT("initscr"),NULL},
	{TEXT("intrflush"),NULL},
	{TEXT("isendwin"),NULL},
	{TEXT("keyname"),NULL},
	{TEXT("keypad"),NULL},
	{TEXT("leaveok"),NULL},
	{TEXT("meta"),NULL},
	{TEXT("mvprintw"),NULL},
	{TEXT("mvscanw"),NULL},
	{TEXT("mvwaddch"),NULL},
	{TEXT("mvwaddnstr"),NULL},
	{TEXT("mvwaddstr"),NULL},
	{TEXT("mvwdelch"),NULL},
	{TEXT("mvwgetch"),NULL},
	{TEXT("mvwgetnstr"),NULL},
	{TEXT("mvwinnstr"),NULL},
	{TEXT("mvwin"),NULL},
	{TEXT("mvwinch"),NULL},
	{TEXT("mvwinsch"),NULL},
	{TEXT("mvwprintw"),NULL},
	{TEXT("mvwscanw"),NULL},
	{TEXT("napms"),NULL},
	{TEXT("newpad"),NULL},
	{TEXT("newterm"),NULL},
	{TEXT("newwin"),NULL},
	{TEXT("nl"),NULL},
	{TEXT("nocbreak"),NULL},
	{TEXT("nodelay"),NULL},
	{TEXT("noecho"),NULL},
	{TEXT("nonl"),NULL},
	{TEXT("noraw"),NULL},
	{TEXT("notimeout"),NULL},
	{TEXT("overlay"),NULL},
	{TEXT("overwrite"),NULL},
	{TEXT("pair_content"),NULL},
	{TEXT("pechochar"),NULL},
	{TEXT("pnoutrefresh"),NULL},
	{TEXT("prefresh"),NULL},
	{TEXT("printw"),NULL},
	{TEXT("raw"),NULL},
	{TEXT("reset_prog_mode"),NULL},
	{TEXT("reset_shell_mode"),NULL},
	{TEXT("resetty"),NULL},
	{TEXT("restartterm"),NULL},
	{TEXT("ripoffline"),NULL},
	{TEXT("savetty"),NULL},
	{TEXT("scanw"),NULL},
	{TEXT("scr_dump"),NULL},
	{TEXT("scr_init"),NULL},
	{TEXT("scr_restore"),NULL},
	{TEXT("wscrl"),NULL},
	{TEXT("scrollok"),NULL},
	{TEXT("set_curterm"),NULL},
	{TEXT("set_term"),NULL},
	{TEXT("setsyx"),NULL},
	{TEXT("setupterm"),NULL},
	{TEXT("slk_attroff"),NULL},
	{TEXT("slk_attron"),NULL},
	{TEXT("slk_attrset"),NULL},
	{TEXT("slk_clear"),NULL},
	{TEXT("slk_init"),NULL},
	{TEXT("slk_label"),NULL},
	{TEXT("slk_noutrefresh"),NULL},
	{TEXT("slk_refresh"),NULL},
	{TEXT("slk_restore"),NULL},
	{TEXT("slk_set"),NULL},
	{TEXT("slk_touch"),NULL},
	{TEXT("start_color"),NULL},
	{TEXT("subpad"),NULL},
	{TEXT("subwin"),NULL},
	{TEXT("touchline"),NULL},
	{TEXT("touchoverlap"),NULL},
	{TEXT("touchwin"),NULL},
	{TEXT("traceoff"),NULL},
	{TEXT("traceon"),NULL},
	{TEXT("typeahead"),NULL},
	{TEXT("ungetch"),NULL},
	{TEXT("vwscanw"),NULL},
	{TEXT("wattroff"),NULL},
	{TEXT("wattron"),NULL},
	{TEXT("wattrset"),NULL},
	{TEXT("wclear"),NULL},
	{TEXT("wclrtobot"),NULL},
	{TEXT("wclrtoeol"),NULL},
	{TEXT("wdeleteln"),NULL},
	{TEXT("wechochar"),NULL},
	{TEXT("werase"),NULL},
	{TEXT("winsertln"),NULL},
	{TEXT("wmove"),NULL},
	{TEXT("wnoutrefresh"),NULL},
	{TEXT("wprintw"),NULL},
	{TEXT("wrefresh"),NULL},
	{TEXT("wscanw"),NULL},
	{TEXT("wstandend"),NULL},
	{TEXT("wstandout"),NULL},
		// memory functions
	{TEXT("heap_alloc"),NULL},
	{TEXT("heap_free"),NULL},
		// queue functions
	{TEXT("new_queue"),NULL},
	{TEXT("queue_allow_grow"),NULL},
	{TEXT("destroy_queue"),NULL},
	{TEXT("queue_isfull"),NULL},
	{TEXT("queue_isempty"),NULL},
	{TEXT("empty_queue"),NULL},
	{TEXT("enqueue_fifo"),NULL},
	{TEXT("enqueue_lifo"),NULL},
	{TEXT("serve_queue"),NULL},
	{TEXT("peek_queue"),NULL},
		// hook
	{TEXT("capi_setUsrKeyMapFxn"),NULL},
		//
	{TEXT("wtimeout"),NULL},
	
	{NULL,NULL}
};


 WINDOW* stdscr, * curscr;
 int LINES, COLS, COLORS, COLOR_PAIRS;
 char** _unctrl;
 chtype* acs_map;
 

 static HMODULE hCursesLibrary;
 static LPCTSTR lpszLibPath=TEXT("curses_api.dll");

 WINDOW* initscr(void){
	 int i;
	 WINDOW* retval;

	  		// load the DLL
	 hCursesLibrary=LoadLibrary(lpszLibPath);
	 if(hCursesLibrary==NULL) {
		 LPTSTR buf;
		 TCHAR errMsg[1024];
		 FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER|FORMAT_MESSAGE_FROM_SYSTEM,
			NULL,GetLastError(),MAKELANGID(LANG_ENGLISH,SUBLANG_ENGLISH_US),
			(LPTSTR)&buf,256,NULL);
		 sprintf(errMsg,TEXT("Could not load %s!\n%s"),lpszLibPath,buf);
		 LocalFree(buf);
		 MessageBox(NULL,errMsg,TEXT("CursesAPI Error!"),MB_ICONSTOP|MB_OK);
		 return NULL;
	 }

	  		// load the function map
	 for(i=0;curses_proc_map[i].lpszName!=NULL;i++) {
		 curses_proc_map[i].fpFxn=GetProcAddress(hCursesLibrary,curses_proc_map[i].lpszName);
		 if(curses_proc_map[i].fpFxn==NULL) {
			 TCHAR errMsg[256];
			 sprintf(errMsg,TEXT("Error loading function %s from %s!"),curses_proc_map[i].lpszName,lpszLibPath);
			 MessageBox(NULL,errMsg,TEXT("CursesAPI Error!"),MB_ICONSTOP|MB_OK);
			 return NULL;
		 }
	 }

	  		// init curses
	 retval= ((WINDOW* (*) ())curses_proc_map[FXN_initscr].fpFxn)();

			// load the globals
	 ((void (*) (WINDOW**,WINDOW**,char***,chtype**,int*,int*,int*,int*))
		 curses_proc_map[FXN_getGlobalCursesValues].fpFxn) (&stdscr,&curscr,&_unctrl,&acs_map,
												&LINES,&COLS,&COLORS,&COLOR_PAIRS);

	 
	 return retval;

 }
