/***********************************************

  CursesAPI for Win32
  v2.1

  Copyright 1996-1997 Ingen Software, Ltd.
  http://www.ingensoft.com
  (281) 922-4222
 
  curses.h

  All work contained within this file and the associated
  object-code library represents an unpublished work, and 
  is the property of Ingen Software, Ltd.  

  This file is considered confidential, and is only provided
  for the use of authorized parties that have a software 
  license agreement on file with Ingen Software, Ltd.

  Any unauthorized redistribution of the contents of this file, 
  in whole or in part, is in violation of the software license 
  that permits use of this file and the associated object-code
  library.  Such redistribution may be in violation of local,
  federal, and international laws and/or treaties.
 
************************************************/


#ifndef __CURSES_H_INCLUDED__
#define __CURSES_H_INCLUDED__

#include <windows.h>
#include <stdlib.h>
#include <stdio.h>
#include <stddef.h>
#include "linkspec.h"
#include "unctrl.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

typedef struct _win_st	WINDOW;
#ifndef __cplusplus
typedef unsigned char 	bool;
#endif
typedef DWORD chtype;

struct _win_st
{
	short		_cury, _curx;	
	short		_maxy, _maxx;	
	short		_begy, _begx;	
	short		_yoffset;
	unsigned char	_flags;
	bool		_clear,		
				_leaveok;

				
	bool		_scroll;
	bool		_use_idl;
	bool		_use_keypad;
	chtype		_attrs;		
	bool		_notimeout;
	int		_delay;

	chtype		**_y;	
	short		*_firstch;
	short		*_lastch;
	short		_tmarg, _bmarg;	
	
	WINDOW		*_padwin;	

	WINDOW		*_parent;
	short		_pary;
	short		_parx;
	short		_ndescs;

};

struct term {int foo;};
struct screen {int foo;};
typedef struct term TERMINAL;
typedef struct screen SCREEN;


#define ERR		(-1)
#define OK		(0)

#define A_CHARTEXT		0x00000fff
#define A_ATTRIBUTES 	0xfffff000
#define A_COLOR			0x0007f000
#define A_STANDOUT		0x00080000
#define A_UNDERLINE		0x00100000
#define A_REVERSE		0x00200000
#define A_BLINK			0x00400000
#define A_DIM			0x00800000
#define A_BOLD			0x01000000
#define A_ALTCHARSET	0x02000000
#define A_NORMAL		0x04000000
#define A_INVIS			0x08000000
#define A_PROTECT       0x10000000

#define COLOR_PAIR(num)		((num)*(A_CHARTEXT+1))
#define PAIR_NUMBER(attr)	(((attr)&A_COLOR)/(A_CHARTEXT+1))

#define COLOR_BLACK		0x00
#define COLOR_RED		0x01
#define COLOR_GREEN		0x02
#define COLOR_BLUE		0x04
#define COLOR_YELLOW	(COLOR_RED|COLOR_GREEN)
#define COLOR_MAGENTA	(COLOR_RED|COLOR_BLUE)
#define COLOR_CYAN		(COLOR_GREEN|COLOR_BLUE)
#define COLOR_WHITE		(COLOR_GREEN|COLOR_BLUE|COLOR_RED)



#define ACS_BSSB        (acs_map['l'])
#define ACS_SSBB        (acs_map['m'])
#define ACS_BBSS        (acs_map['k'])
#define ACS_SBBS        (acs_map['j'])
#define ACS_SBSS        (acs_map['u'])
#define ACS_SSSB        (acs_map['t'])
#define ACS_SSBS        (acs_map['v'])
#define ACS_BSSS        (acs_map['w'])
#define ACS_BSBS        (acs_map['q'])
#define ACS_SBSB        (acs_map['x'])
#define ACS_SSSS        (acs_map['n'])

#define ACS_ULCORNER	ACS_BSSB
#define ACS_LLCORNER	ACS_SSBB
#define ACS_URCORNER	ACS_BBSS
#define ACS_LRCORNER	ACS_SBBS
#define ACS_RTEE		ACS_SBSS
#define ACS_LTEE		ACS_SSSB
#define ACS_BTEE		ACS_SSBS
#define ACS_TTEE		ACS_BSSS
#define ACS_HLINE		ACS_BSBS
#define ACS_VLINE		ACS_SBSB
#define ACS_PLUS		ACS_SSSS
#define ACS_S1			(acs_map['o'])
#define ACS_S9			(acs_map['s'])
#define ACS_DIAMOND		(acs_map['\''])
#define ACS_CKBOARD		(acs_map['a'])
#define ACS_DEGREE		(acs_map['f'])
#define ACS_PLMINUS		(acs_map['g'])
#define ACS_BULLET		(acs_map['~'])
#define ACS_LARROW		(acs_map[','])
#define ACS_RARROW		(acs_map['+'])
#define ACS_DARROW		(acs_map['.'])
#define ACS_UARROW		(acs_map['-'])
#define ACS_BOARD		(acs_map['h'])
#define ACS_LANTERN		(acs_map['i'])
#define ACS_BLOCK		(acs_map['0'])

#define KEY_MIN		0401		/* Minimum curses key */
#define KEY_BREAK       0401            /* break key (unreliable) */
#define KEY_DOWN        0402            /* The four arrow keys ... */
#define KEY_UP          0403
#define KEY_LEFT        0404
#define KEY_RIGHT       0405            /* ... */
#define KEY_HOME        0406            /* Home key (upward+left arrow) */
#define KEY_BACKSPACE   0407            /* backspace (unreliable) */
#define KEY_F0          0410            /* Function keys.  Space for 64 */
#define KEY_F(n)        (KEY_F0+(n))    /* keys is reserved. */
#define KEY_DL          0510            /* Delete line */
#define KEY_IL          0511            /* Insert line */
#define KEY_DC          0512            /* Delete character */
#define KEY_IC          0513            /* Insert char or enter insert mode */
#define KEY_EIC         0514            /* Exit insert char mode */
#define KEY_CLEAR       0515            /* Clear screen */
#define KEY_EOS         0516            /* Clear to end of screen */
#define KEY_EOL         0517            /* Clear to end of line */
#define KEY_SF          0520            /* Scroll 1 line forward */
#define KEY_SR          0521            /* Scroll 1 line backwards (reverse) */
#define KEY_NPAGE       0522            /* Next page */
#define KEY_PPAGE       0523            /* Previous page */
#define KEY_STAB        0524            /* Set tab */
#define KEY_CTAB        0525            /* Clear tab */
#define KEY_CATAB       0526            /* Clear all tabs */
#define KEY_ENTER       0527            /* Enter or send (unreliable) */
#define KEY_SRESET      0530            /* soft (partial) reset (unreliable) */
#define KEY_RESET       0531            /* reset or hard reset (unreliable) */
#define KEY_PRINT       0532            /* print or copy */
#define KEY_LL          0533            /* home down or bottom (lower left) */

/* The keypad is arranged like this: */
/* a1    up    a3   */
/* left   b2  right  */
/* c1   down   c3   */

#define KEY_A1		0534	/* Upper left of keypad */
#define KEY_A3		0535	/* Upper right of keypad */
#define KEY_B2		0536	/* Center of keypad */
#define KEY_C1		0537	/* Lower left of keypad */
#define KEY_C3		0540	/* Lower right of keypad */
#define KEY_BTAB	0541	/* Back tab key */
#define KEY_BEG		0542	/* beg(inning) key */
#define KEY_CANCEL	0543	/* cancel key */
#define KEY_CLOSE	0544	/* close key */
#define KEY_COMMAND	0545	/* cmd (command) key */
#define KEY_COPY	0546	/* copy key */
#define KEY_CREATE	0547	/* create key */
#define KEY_END		0550	/* end key */
#define KEY_EXIT	0551	/* exit key */
#define KEY_FIND	0552	/* find key */
#define KEY_HELP	0553	/* help key */
#define KEY_MARK	0554	/* mark key */
#define KEY_MESSAGE	0555	/* message key */
#define KEY_MOVE	0556	/* move key */
#define KEY_NEXT	0557	/* next object key */
#define KEY_OPEN	0560	/* open key */
#define KEY_OPTIONS	0561	/* options key */
#define KEY_PREVIOUS	0562	/* previous object key */
#define KEY_REDO	0563	/* redo key */
#define KEY_REFERENCE	0564	/* ref(erence) key */
#define KEY_REFRESH	0565	/* refresh key */
#define KEY_REPLACE	0566	/* replace key */
#define KEY_RESTART	0567	/* restart key */
#define KEY_RESUME	0570	/* resume key */
#define KEY_SAVE	0571	/* save key */
#define KEY_SBEG	0572	/* shifted beginning key */
#define KEY_SCANCEL	0573	/* shifted cancel key */
#define KEY_SCOMMAND	0574	/* shifted command key */
#define KEY_SCOPY	0575	/* shifted copy key */
#define KEY_SCREATE	0576	/* shifted create key */
#define KEY_SDC		0577	/* shifted delete char key */
#define KEY_SDL		0600	/* shifted delete line key */
#define KEY_SELECT	0601	/* select key */
#define KEY_SEND	0602	/* shifted end key */
#define KEY_SEOL	0603	/* shifted clear line key */
#define KEY_SEXIT	0604	/* shifted exit key */
#define KEY_SFIND	0605	/* shifted find key */
#define KEY_SHELP	0606	/* shifted help key */
#define KEY_SHOME	0607	/* shifted home key */
#define KEY_SIC		0610	/* shifted input key */
#define KEY_SLEFT	0611	/* shifted left arrow key */
#define KEY_SMESSAGE	0612	/* shifted message key */
#define KEY_SMOVE	0613	/* shifted move key */
#define KEY_SNEXT	0614	/* shifted next key */
#define KEY_SOPTIONS	0615	/* shifted options key */
#define KEY_SPREVIOUS	0616	/* shifted prev key */
#define KEY_SPRINT	0617	/* shifted print key */
#define KEY_SREDO	0620	/* shifted redo key */
#define KEY_SREPLACE	0621	/* shifted replace key */
#define KEY_SRIGHT	0622	/* shifted right arrow */
#define KEY_SRSUME	0623	/* shifted resume key */
#define KEY_SSAVE	0624	/* shifted save key */
#define KEY_SSUSPEND	0625	/* shifted suspend key */
#define KEY_SUNDO	0626	/* shifted undo key */
#define KEY_SUSPEND	0627	/* suspend key */
#define KEY_UNDO	0630	/* undo key */
#define KEY_MAX		0777	/* Maximum curses key */

extern LINKSPEC chtype* acs_map;
extern LINKSPEC WINDOW* stdscr, *curscr;
extern LINKSPEC int LINES, COLS;
extern LINKSPEC int COLORS;
extern LINKSPEC int COLOR_PAIRS;

#ifndef __CURSES_DYNLOAD
#include "linked.h"
#else
#include "loaded.h"
#endif /* __CURSES_DYNLOAD */

#include "cursmacro.h"

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __CURSES_H_INCLUDED__ */
