#
# GNU-compatible Makefile, CursesAPI v2.1
# Copyright 1997 Ingen Software, Ltd.  
# http://www.ingensoft.com
#

CC=gcc
CCFLAGS=-c -D WIN32 -D _CONSOLE -D __CURSES_DYNLOAD -I ./curses -I ./utility
LD=gcc
LDFLAGS=
LIBMGR=ar
LIBFLAGS=-rv
LIBPREF=lib
LIBEXT=a
OEXT=o


all: sample1 sample2 sample3


# dynamic loader routine 

curses/curses_loader.$(OEXT): curses/curses_loader.c
	$(CC) $(CCFLAGS)  $< -o curses/curses_loader.$(OEXT)

# sample1 application

sample1: sample1.exe

sample1.exe: sample1/sample1.$(OEXT) curses/curses_loader.$(OEXT)
	$(LD) $(LDFLAGS) sample1/sample1.$(OEXT) curses/curses_loader.$(OEXT) -luser32 -o sample1 

sample1/sample1.$(OEXT): sample1/sample1.c
	$(CC) $(CCFLAGS) $< -o sample1/sample1.$(OEXT) 

# sample2 application

sample2: sample2.exe

sample2.exe: sample2/sample2.$(OEXT) curses/curses_loader.$(OEXT)
	$(LD) $(LDFLAGS) sample2/sample2.$(OEXT) curses/curses_loader.$(OEXT) -luser32 -o sample2 

sample2/sample2.$(OEXT): sample2/sample2.c
	$(CC) $(CCFLAGS) $< -o sample2/sample2.$(OEXT) 


# sample3 application

sample3: sample3.exe

sample3.exe: sample3/sample3.$(OEXT) libs/$(LIBPREF)utility.$(LIBEXT) \
		curses/curses_loader.$(OEXT)
	$(LD) $(LDFLAGS) sample3/sample3.$(OEXT) curses/curses_loader.$(OEXT) -Llibs -lutility -luser32 -o sample3 

sample3/sample3.$(OEXT): sample3/sample3.c
	$(CC) $(CCFLAGS) $< -o sample3/sample3.$(OEXT) 

# utility library

libs/$(LIBPREF)utility.$(LIBEXT): utility/utl_color.$(OEXT) utility/utl_windows.$(OEXT)
	$(LIBMGR) $(LIBFLAGS) libs/$(LIBPREF)utility.$(LIBEXT) utility/utl_color.$(OEXT) utility/utl_windows.$(OEXT)

utility/utl_color.$(OEXT): utility/utl_color.c
	$(CC) $(CCFLAGS) $< -o utility/utl_color.$(OEXT) 

utility/utl_windows.$(OEXT): utility/utl_windows.c
	$(CC) $(CCFLAGS) $< -o utility/utl_windows.$(OEXT) 

	
