UNIT demo;

(* This component requires that environment variable "Break On Exception"
	 be turned off, when running a decryption program within the Delphi
	 environment! *)


INTERFACE


USES
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
	StdCtrls, AwkGbls, AwkMain, AwkTypes, ExtCtrls, Buttons, ZipKey;

TYPE
	TForm1 = CLASS( TForm )
    Label1: TLabel;
	  Label2: TLabel;
    Label3: TLabel;
	  Button1: TButton;
	  Button2: TButton;
	  lblPassword: TLabel;
    CurFilename: TLabel;

	  FileSpec: TEdit;
	  ArchiveFile: TEdit;
	  StartPassword: TEdit;

    bbDir: TBitBtn;
	  ZipKey1: TZipKey;
    OpenDialog1: TOpenDialog;
	  RadioGroup1: TRadioGroup;

	  PROCEDURE FormCreate( Sender: TObject );
	  PROCEDURE bbDirClick( Sender: TObject );
	  PROCEDURE Button1Click( Sender: TObject );
	  PROCEDURE Button2Click( Sender: TObject );
	  PROCEDURE ZipKey1Change( Sender: TObject; Password: STRING );
	  PROCEDURE ZipKey1Found( Sender: TObject; Password: STRING );
	  PROCEDURE ZipKey1Begin( Sender: TObject; FN: STRING; RecNum: Integer;
		 VAR Extract: Boolean );
	PRIVATE
	  { Private declarations }
  PUBLIC
    { Public declarations }
	END;

VAR
  Form1: TForm1;

IMPLEMENTATION

{$R *.DFM}


{---------------------------------------------}
PROCEDURE TForm1.FormCreate( Sender: TObject );
BEGIN
	ArchiveFile.Text 		:= ZipKey1.ArchiveFile;
	RadioGroup1.ItemIndex:= Ord( ZipKey1.CharType );
	StartPassword.Text 	:= ZipKey1.StartPassword;
	FileSpec.Text 			:= ZipKey1.FileSpec;
END;
{---------------------------------------------}
PROCEDURE TForm1.Button1Click( Sender: TObject );
BEGIN
	ZipKey1.ArchiveFile := ArchiveFile.Text;
	ZipKey1.FileSpec    := FileSpec.Text;
	ZipKey1.CharType    := TCharType( RadioGroup1.ItemIndex );
	ZipKey1.StartPassword := StartPassword.Text;
	ZipKey1.ExtractDir  := 'c:\hold1';
	ZipKey1.Activate;
	StartPassword.setfocus;
END;
{---------------------------------------------}
PROCEDURE TForm1.Button2Click( Sender: TObject );
BEGIN
	BreakLoop := true;
END;
{---------------------------------------------}
PROCEDURE TForm1.bbDirClick( Sender: TObject );
BEGIN
	IF OpenDialog1.Execute THEN
  BEGIN
  	ZipKey1.ArchiveFile := OpenDialog1.FileName;

     IF ( ZipKey1.ArcType IN [ atZip,
     									atZipExe,
                                atZip250,
                                atZip250Exe ] ) THEN
        ArchiveFile.Text := ZipKey1.ArchiveFile
     ELSE BEGIN
        MessageDlg( 'Unsupported archive type', mtInformation, [ mbOK ], 0 );
        ArchiveFile.Text := '';
     END;
  END;
END;
{---------------------------------------------}
PROCEDURE TForm1.ZipKey1Change( Sender: TObject; Password: STRING );
BEGIN
  StartPassword.Text := Password;
END;
{---------------------------------------------}
PROCEDURE TForm1.ZipKey1Found( Sender: TObject; Password: STRING );
BEGIN
	MessageDlg( 'Password = ' + Password, mtInformation, [ mbOK ], 0 );
END;
{---------------------------------------------}
PROCEDURE TForm1.ZipKey1Begin( Sender: TObject; FN: STRING; RecNum: Integer;
		VAR Extract: Boolean );
BEGIN
	CurFilename.Caption := ExtractFilename( FN );
END;
{---------------------------------------------}




END.

