UNIT Demo;

(*
	This is a simple demo on the usage of ExtractToMemoryStream &
  ExtractToFileStream methods.

  In this demo, we use ExtractToMemoryStream to extract graphic images
  and text files from an archive and display them in their respective
  control.  Image control for the images, and a memo control for
  displaying text files.

  We use the ExtractToFileStream to extract an archive from within an
  archive to the windows temp directory.  This really doesn't show usage
  of how to use a file stream, but is an easy to understand method of
  demonstrating the its usage.

  -

  In this demo, we also demonstrate how to extract archives from within
  an archive and display its contents.  Example:  say BHDEMO.ZIP is stored
  in an archive named ZTV120r3.ZIP, and we'd like to see the contents of
  the BHDEMO.ZIP file.  Double-click on the BHDEMO.ZIP file and its contents
  will be displayed.  Pressing ESC closes BHDEMO.ZIP and returns to the
  previously displayed archive... which in this case is ZTV120r3.ZIP

	-

  No portion of this ExtractToMem demonstration program holds any copyrights.
  It is available to use, in whole or part in any application the user
  wishes to include it.  The TZipTV component package however, is
  copyrighted material.  The inclusion of it, either in whole or in part,
  in any business, commercial, or governmental application requires
  registration. For futher information see accompaning documentation. *)



INTERFACE


USES
	Windows, SysUtils, Classes, Controls, Forms, Dialogs, Menus, ClipBrd,
  StdCtrls, ComCtrls, ExtCtrls, ZipTV, UnARC, AwkMain, AwkGbls, AwkTypes,
  Err_Msgs, UnBH, UnGZIP, UnTar, UnCAB, UnZoo, UnZIP, UnLHA, UnARJ;


TYPE
	TForm1 = CLASS( TForm )

		OpenDialog1	 : TOpenDialog;
    	ListView1	 : TListView;
    	Image1		 : TImage;
    	Memo1			 : TMemo;

    	Label1		 : TLabel;
    	Label2		 : TLabel;

    	Panel1		 : TPanel;
    	Panel2		 : TPanel;
    	Panel3		 : TPanel;

		MainMenu1	 : TMainMenu;
		File1			 : TMenuItem;
		Open1			 : TMenuItem;
		Filespec1	 : TMenuItem;
		Exit1			 : TMenuItem;
    	Edit1			 : TMenuItem;
		StretchImage1: TMenuItem;
    	CopyToClipboard1: TMenuItem;

		ZipTV1		 : TZipTV;
		UnBH1			 : TUnBH;
		UnARJ1		 : TUnARJ;
		UnARC1		 : TUnARC;
		UnCAB1		 : TUnCAB;
    	UnGZIP1		 : TUnGZIP;
		UnLHA1		 : TUnLHA;
    	UnTAR1		 : TUnTAR;
		UnZOO1		 : TUnZOO;
		UnZIP1		 : TUnZIP;

		PROCEDURE Open1Click( Sender: TObject );
		PROCEDURE Exit1Click( Sender: TObject );
		PROCEDURE ExtractFiles( Sender: TObject );
		PROCEDURE Filespec1Click( Sender: TObject );
		PROCEDURE UnCAB1NextCabinet( Sender: TObject; FN, VolumeID: STRING; VAR Cancel: BOOLEAN );

		PROCEDURE ZipTV1Activate( Sender: TObject );
		PROCEDURE ZipTV1Read( Sender: TObject; Offset, Filenum: Integer );
		PROCEDURE ZipTV1Deactivate( Sender: TObject );
		PROCEDURE ZipTV1Error( Sender: TObject; FN, VolumeID: STRING; ECode: INTEGER );

		PROCEDURE UnZIP1Activate( Sender: TObject );
		PROCEDURE UnZIP1Deactivate( Sender: TObject );
		PROCEDURE UnZIP1Begin( Sender: TObject; FN: STRING; RecNum: INTEGER; VAR Extract: BOOLEAN );
		PROCEDURE UnZIP1End( Sender: TObject; FN: STRING; CRC_PASS: BOOLEAN );
		PROCEDURE UnZIP1Progress( Sender: TObject; FN: STRING; Progress: BYTE );
		PROCEDURE UnZIP1GetPassword( Sender: TObject; FN: STRING;	VAR Password: STRING;
				VAR TryAgain: BOOLEAN );

		PROCEDURE FormCreate( Sender: TObject );
    	PROCEDURE FormClose( Sender: TObject; VAR Action: TCloseAction );
    	PROCEDURE StretchImage1Click(Sender: TObject);
    	PROCEDURE CopyToClipboard1Click(Sender: TObject);
    	PROCEDURE FormKeyDown(Sender: TObject; var Key: Word;	Shift: TShiftState);

	PRIVATE
	PUBLIC
	END;




VAR
	Form1: TForm1;
	TmpList: TStringList;


CONST
	CRLF = #13#13;
	SupportedArchives: STRING  = ( '.ARC.BH.EXE.ZIP.ZOO.ARJ.GZ.TAR.LZH.LHA' );


IMPLEMENTATION


USES Unit2, Unit3, Unit4;


{$R *.DFM}

{ -------------------------------------------------------------- }
(* Menu item 'Open' *)
PROCEDURE TForm1.Open1Click( Sender: TObject );
VAR
	i: WORD;
BEGIN

	OpenDialog1.Filter := LoadStr( F_TZIPTV );  (* see F_TZIPTV in err_msgs.rc and err_msgs.pas *)
	OpenDialog1.Options := [ofHideReadOnly, ofFileMustExist, ofPathMustExist];

	IF OpenDialog1.Execute THEN
	BEGIN

										(* Delete any created temporary files *)
		IF TmpList.Count > 1 THEN
		BEGIN

			FOR i := 1 TO TmpList.Count - 1 DO
				IF FileExists( TmpList.Strings[ i ] ) THEN
					DeleteFile( TmpList.Strings[ i ] );

		END;
  	TmpList.Clear;
     TmpList.Add( OpenDialog1.Filename );

		ListView1.Items.Clear;
		Form1.Caption 	:= OpenDialog1.FileName;
		ZipTV1.ArchiveFile  := OpenDialog1.FileName;
		ZipTV1.Activate;

	END;

END;
{ -------------------------------------------------------------- }
(* Menu option close *)
PROCEDURE TForm1.Exit1Click( Sender: TObject );
BEGIN
	Close;
END;
{ -------------------------------------------------------------- }
(* TZipTV OnActivate Event *)
PROCEDURE TForm1.ZipTV1Activate( Sender: TObject );
BEGIN
	Screen.Cursor := crHourGlass;
	ListView1.Items.BeginUpdate;
END;
{ -------------------------------------------------------------- }
(* TZipTV OnDeactivate Event *)
PROCEDURE TForm1.ZipTV1Deactivate( Sender: TObject );
BEGIN
	ListView1.Items.EndUpdate;
	Screen.Cursor := crDefault;
END;
{ -------------------------------------------------------------- }
(* TZipTV OnRead Event / fill listbox with detailed compressed file info *)
PROCEDURE TForm1.ZipTV1Read( Sender: TObject; Offset, Filenum: Integer );

VAR
	NewItem : TListItem;

BEGIN

	NewItem := ListView1.Items.Add;

	With NewItem DO
	BEGIN
										(* Store the offset to the items DATA property
											( for future use ) *)
		Data := POINTER( Offset );

		ImageIndex := ZipTV1.ImageIndex;
		Caption := ExtractFilename( ZipTV1.Filename );
	END;

END;
{ -------------------------------------------------------------- }
PROCEDURE TForm1.ExtractFiles( Sender: TObject );
VAR
	ExtractComponent: TUnBase;	(* All TUn??? components derive from TUnBASE *)
	Ext, {FileType,} TmpFilename  : STRING;
	//BytesCopied	 : LONGINT;

  FileStream	 : TFileStream;
  MemoryStream : TMemoryStream;
	//ExtractPtr	 : POINTER;
  HoldArchiveFile  : STRING;

BEGIN
                             (* Breathing room *)
	Application.ProcessMessages;

	Memo1.Text := '';
	Panel2.Caption := '';
	IF ( ZipTV1.ArchiveFile = '' ) OR ( ListView1.Selected = NIL ) THEN EXIT;


                          	(* Assign the TUn??? component *)
										(* ...see not above about TUnBase *)
  CASE ZipTV1.ArcType OF

     atArc,
     atArcExe		: ExtractComponent := UnARC1;

     atArj,
     atArjExe		: ExtractComponent := UnARJ1;

     atBH,
     atBHExe		: ExtractComponent := UnBH1;

     atCAB			: ExtractComponent := UnCAB1;

     atGZIP		: ExtractComponent := UnGZIP1;

     atLHA,
     atLhaExe,
     atLZH,
     atLzhExe		: ExtractComponent := UnLHA1;

		atTar			: ExtractComponent := UnTAR1;

     atZip,
     atZipExe,
     atZip250,
     atZip250Exe	: BEGIN
                       ExtractComponent := UnZIP1;
                       ExtractComponent.ZipCmntBufSize := ZipTV1.ZipCmntBufSize;
                   END;


     atZoo			: ExtractComponent := UnZOO1;

  ELSE

     BEGIN

        MessageDlg( 'Extraction not supported for this filetype.', mtInformation, [mbOK], 0 );
			EXIT;

     END;

  END;

                          	(* Assign extraction component ArchiveFile
                             	property *)

  ExtractComponent.ArchiveFile := ZipTV1.ArchiveFile;

  TRY

  									(* Create the memory stream object
                                to extract the data to *)

     MemoryStream := TMemoryStream.Create;

     TRY

        (***************************************************************)
        (* Fill the memo & image control with file extracted to memory *)
        (***************************************************************)

			//FileType := ExtractComponent.GetFileType( ListView1.Selected.Caption );
			Ext := ExtractFileExt( ListView1.Selected.Caption );

           						(* Fill the Memo control with text *)

			//IF ( CompareText( FileType, 'Text Document' ) THEN
			IF ( CompareText( Ext, '.TXT' ) = 0 ) OR
				 ( CompareText( Ext, '.BAT' ) = 0 ) OR
				 ( CompareText( Ext, '.C' ) = 0 ) OR
				 ( CompareText( Ext, '.PAS' ) = 0 ) THEN
			BEGIN

				(* Extract to untyped pointer *)
				{
				GetMem( ExtractPtr, ZipTV1.GetFileUnpackedSize( ListView1.Selected.Caption ) + 2 );
				TRY
					ExtractComponent.ExtractToPointer( ListView1.Selected.Caption, ExtractPtr );
				FINALLY
					 Memo1.Lines.Add( PCHAR( ExtractPtr ) ); *)

					FreeMem( ExtractPtr );
					ExtractPtr := NIL;
				END;
				}

										(* Call ExtractToMemorySteam method to extract
                             	the file to memory stream created above *)
				ExtractComponent.ExtractToMemoryStream( ListView1.Selected.Caption, MemoryStream );

										(* Memo component max size exceeded, display only
                             	last portion *)

				IF MemoryStream.Size > 64000 THEN
					MemoryStream.Position := MemoryStream.Size - 64000;


				Memo1.Lines.LoadFromStream( MemoryStream );

			END ELSE	IF (CompareText( Ext, '.ICO' ) = 0 ) THEN
        BEGIN

        							(* Call ExtractToMemoryStream method to extract
                             	the file to memory stream created above *)

				ExtractComponent.ExtractToMemoryStream( ListView1.Selected.Caption, MemoryStream );

        							(* Fill Image control with icon *)

				Image1.Picture.Icon.LoadFromStream( MemoryStream )

			END ELSE IF CompareText( Ext, '.BMP' ) = 0 THEN
        BEGIN

        							(* Call ExtractToMemoryStream method to extract
                             	the file to memory stream created above *)

				ExtractComponent.ExtractToMemoryStream( ListView1.Selected.Caption, MemoryStream );

        							(* Fill Image control with bitmap *)

				Image1.Picture.BitMap.LoadFromStream( MemoryStream )

			END ELSE IF CompareText( Ext, '.WMF' ) = 0 THEN
        BEGIN

        							(* Call ExtractToMemoryStream method to extract
                             	the file to memory stream created above *)

				ExtractComponent.ExtractToMemoryStream( ListView1.Selected.Caption, MemoryStream );

        							(* Fill Image control with metafile *)

				Image1.Picture.Metafile.LoadFromStream( MemoryStream );

        END ELSE BEGIN

           (* Following is an example of extracting and displaying and archive
              within an archive in the TZipTV control *)
        	IF Pos( Uppercase( Ext ), SupportedArchives ) > 0 THEN
           BEGIN

              (* Define filename to extract to (windows\temp dir) *)
              TmpFilename := ZipTV1.GetTmpDirectory + ListView1.Selected.Caption;
              IF TmpFilename = '' THEN EXIT;

              FileStream := TFileStream.Create(
                    TmpFilename,
                    fmCreate OR
                    fmOpenRead OR
                    fmShareDenyWrite OR
                    fmShareDenyNone );


              TRY
                 ExtractComponent.ExtractToFileStream( ListView1.Selected.Caption, FileStream );
              FINALLY
						FileStream.Free;
						FileStream := NIL;
						IF FileStream = NIL THEN ;	(* Satisfy compiler *)
					END;


              HoldArchiveFile := ZipTV1.ArchiveFile;
              ZipTV1.ArchiveFile := TmpFilename;
              IF ( ZipTV1.ArcType IN [ atNA,
                                         atUnsupported,
                                         atFileError,
                                         atUnknown ] ) THEN
              BEGIN

              	(* Since we're not adding file to TmpList, delete it *)
              	DeleteFile( TmpFilename );

                 ZipTV1.ArchiveFile := HoldArchiveFile;
                 EXIT;
              END;

              Form1.Caption 	:= ListView1.Selected.Caption;
              ListView1.Items.Clear;
              ZipTV1.Activate;

              TmpList.Add( TmpFilename );

           END;

        END;


		FINALLY

        							(* Free the extracted file from memory *)

			MemoryStream.Free;
			MemoryStream := NIL;
			IF MemoryStream = NIL THEN ; 	(* Satisfy compiler *)

     END;

  EXCEPT
  END;

END;
{ -------------------------------------------------------------- }
(* TUn??? OnActivate event *)
PROCEDURE TForm1.UnZIP1Activate( Sender: TObject );
BEGIN
										(* Display the ProgressBar form *)
	fProgressBar.Show;
	Application.ProcessMessages;

END;
{ -------------------------------------------------------------- }
(* TUn??? OnBegin event *)
PROCEDURE TForm1.UnZIP1Begin( Sender: TObject; FN: STRING; RecNum: INTEGER;
	VAR Extract: BOOLEAN );
BEGIN

	fProgressBar.Caption := ExtractFilename( FN );

END;
{ -------------------------------------------------------------- }
(* TUn??? OnDeactivate event *)
PROCEDURE TForm1.UnZIP1Deactivate( Sender: TObject );
BEGIN
										(* Hide the ProgressBar form *)
	fProgressBar.Hide;

END;
{ -------------------------------------------------------------- }
(* TUn??? OnEnd event *)
PROCEDURE TForm1.UnZIP1End( Sender: TObject; FN: STRING; CRC_PASS: BOOLEAN );
BEGIN
										(* All TZipTV / TBlakHole components derive from
											TZipCommon. *)
	IF fProgressBar.Cancel THEN
		TZipCommon( Sender ).Cancel := TRUE;

	IF NOT CRC_PASS THEN
		MessageDlg( FN + #13'Extract failed'#13#13'OnEnd Event...', mtInformation, [mbOk], 0 );

END;
{ -------------------------------------------------------------- }
(* TUn??? OnGetPassword event, request password from user *)
PROCEDURE TForm1.UnZIP1GetPassword( Sender: TObject; FN: STRING; VAR Password:
		STRING; VAR TryAgain: BOOLEAN );
BEGIN

	PasswordDlg.Caption := ExtractFilename( FN );
	IF PasswordDlg.ShowModal = mrOK THEN
		Password := PasswordDlg.Edit1.Text
	ELSE
		TryAgain := FALSE;

END;
{ -------------------------------------------------------------- }
(* OnError event...
	 TZipTV & components error messages:
		1 ) ERROR CODES range from ( starting at E_BASE ) 25000 to 25999
		2 ) GENERAL MESSAGING range from ( starting at M_BASE ) 26000 to 27000

	 See package files Err_Msg.PAS & Err_Msg.RC *)

PROCEDURE TForm1.ZipTV1Error( Sender: TObject; FN, VolumeID: STRING; ECode: INTEGER );
VAR
	Msg: STRING;
BEGIN

	Msg := FN + CRLF;

	CASE ECode OF
		E_BASE..E_WIN32:
				Msg := Msg + 'Error#: ' + IntToStr( Ecode ) + CRLF +
								 'Error: ' + LoadStr( Ecode ) + CRLF;

		M_BASE..M_PASSWORDFAILED:
				Msg := Msg + 'General Message: ' + IntToStr( Ecode ) + CRLF +
								 'Messge: ' + LoadStr( Ecode ) + CRLF;
	ELSE

		EXIT;		(* <- no msg *)

	END;

	Msg := Msg + 'OnError event...';
	MessageDlg( Msg, mtInformation, [mbOk], 0 );

END;
{ -------------------------------------------------------------- }
(* Menu item 'File Spec', redisplay matching files *)
PROCEDURE TForm1.Filespec1Click( Sender: TObject );
BEGIN

	fFileSpec.Edit1.text := ZipTV1.Filespec;

	IF fFileSpec.ShowModal = mrOK THEN
	BEGIN

		IF fFileSpec.Edit1.Text <> '' THEN
		BEGIN

			ZipTV1.FileSpec := fFileSpec.Edit1.Text;

			IF ZipTV1.ArchiveFile <> '' THEN
			BEGIN

                             (* Clear archive info *)
           ListView1.Items.Clear;

           						(* Clear totals *)

        (* The ArchiveFile property must be assigned before EACH
           call to the	Activate method... this resets the file pointer
           to the correct beginning byte location within the archive.

           An error occurs if Activate is called a second time without
           first assigning ArchiveFile, even if the value of ArchiveFile
           is unchanged. *)

     		ZipTV1.ArchiveFile := ZipTV1.ArchiveFile;
				ZipTV1.Activate;

			END;

		END;

	END;

END;
{ -------------------------------------------------------------- }
(* TUn??? OnProgress event - Update the progress meter *)
PROCEDURE TForm1.UnZIP1Progress( Sender: TObject; FN: STRING; Progress: BYTE );
BEGIN

	Application.ProcessMessages;
	fProgressBar.ProgressBar1.Position := Progress;

END;
{ -------------------------------------------------------------- }
(* Microsoft CABinet files... disk change *)
PROCEDURE TForm1.UnCAB1NextCabinet( Sender: TObject; FN, VolumeID: STRING;
	VAR Cancel: BOOLEAN );

VAR
	Msg: STRING;

BEGIN

	Msg := 'Insert disk containing file: ' + FN + CRLF +
			 'Volume ID:' + VolumeID + CRLF +
			 'OnNextVolume event...';

	IF MessageDlg( Msg, mtInformation, [mbOk, mbCancel], 0 ) = mrCancel THEN
		Cancel := TRUE;

END;
{ -------------------------------------------------------------- }
(* Initialize the system-image-list when form is created *)
PROCEDURE TForm1.FormCreate( Sender: TObject );
CONST
	CRLF = #13#10;
BEGIN

  Label2.Caption := 'Open an archive, click any .bmp .ico .wmf .c .pas .txt .bat file to view their contents.' +
        CRLF +
        'Select archive within an archive to display its compressed file info (esc for prev).';

										(* Initialize system icons for the
                             	ListView control *)
	InitializeImageList( Self, ListView1 );

										(* Create a temporary string list to
											store any temporary filenames that
											we create in the demo *)
	TmpList := TStringList.Create;


END;
{ -------------------------------------------------------------- }
(* Remove the system-image-list from memory when form is closed *)
PROCEDURE TForm1.FormClose( Sender: TObject; VAR Action: TCloseAction );
VAR
	i: WORD;
BEGIN
										(* Free the system icons *)
	DestroyImageList( ListView1 );

										(* Cleanup temp files *)
	IF TmpList.Count > 1 THEN
		FOR i := 1 TO TmpList.Count - 1 DO
			IF ( TmpList.Strings[ i ] <> '' ) AND
					FileExists( TmpList.Strings[ i ] ) THEN
				DeleteFile( TmpList.Strings[ i ] );

	TmpList.Free;

END;
{ -------------------------------------------------------------- }
(* Menu item 'Stretch Image' *)
PROCEDURE TForm1.StretchImage1Click(Sender: TObject);
BEGIN

	StretchImage1.Checked := NOT StretchImage1.Checked;
	Image1.Stretch := StretchImage1.Checked;

END;
{ -------------------------------------------------------------- }
(* Menu item 'Copy to clipboard' *)
(* copy the contents of the image control to the clipboard object *)
PROCEDURE TForm1.CopyToClipboard1Click(Sender: TObject);
BEGIN
	ClipBoard.Assign( Image1.Picture );
END;
{ -------------------------------------------------------------- }
(* Here we use the ESC key to return to the previous archive,
	 when displaying an archive within an archive *)
PROCEDURE TForm1.FormKeyDown(Sender: TObject; VAR Key: Word;
	Shift: TShiftState);
VAR
	FN: STRING;
BEGIN

  IF Key = 27 THEN
  BEGIN

     IF TmpList.Count > 1 THEN
     BEGIN

     	FN := TmpList.Strings[ TmpList.Count - 2 ];
     	ZipTV1.ArchiveFile := FN;
        IF ( ZipTV1.ArcType IN [ atNA,
        									atUnsupported,
                                   atFileError,
                                   atUnknown ] ) THEN
        	EXIT;

        Form1.Caption := ExtractFilename( FN );
			ListView1.Items.Clear;
        ZipTV1.Activate;

        							(* Delete last item added *)
			TmpList.Delete( TmpList.Count - 1 );

		END;

	END;

END;
{ -------------------------------------------------------------- }
{PROCEDURE DelTempFiles;
VAR
	i: WORD;
BEGIN

	IF TmpList.Count > 1 THEN
		FOR i := 1 TO TmpList.Count - 1 DO
			IF FileExists( TmpList.Strings[ i ] ) THEN
				DeleteFile( TmpList.Strings[ i ] );

	TmpList.Free;

END;}
{ -------------------------------------------------------------- }


END.

