UNIT Main;

INTERFACE

USES
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ExtCtrls, AwkMain, ZipCheck, Err_Msgs;

TYPE
  TForm3 = CLASS(TForm)
    OpenDialog1		: TOpenDialog;
    ZipCheck1			: TZipCheck;
    ListBox1			: TListBox;
    Panel1				: TPanel;

    btnOpenArchive	: TBitBtn;
    btnOK				: TBitBtn;
    btnClose			: TBitBtn;

    Label2				: TLabel;
    Label3				: TLabel;
    edtArchiveFile	: TEdit;
    edtFileSpec		: TEdit;

    PROCEDURE btnCloseClick(Sender: TObject);
    PROCEDURE btnOpenArchiveClick(Sender: TObject);
    PROCEDURE FormActivate(Sender: TObject);
    PROCEDURE btnOKClick(Sender: TObject);
    PROCEDURE edtArchiveFileChange(Sender: TObject);
    PROCEDURE ZipCheck1Status(Sender: TObject; FN: STRING; PassFail: Boolean);
    PROCEDURE ZipCheck1Error(Sender: TObject; FN, VolumeID: STRING; ECode: Integer);
    PROCEDURE ZipCheck1GetPassword(Sender: TObject; FN: STRING; VAR Password: STRING;
    			VAR TryAgain: Boolean);
  PRIVATE
    { Private declarations }
  PUBLIC
    { Public declarations }
  END;


VAR
  Form3: TForm3;


IMPLEMENTATION



USES Unit2;

{$R *.DFM}


{-------------------------------------------------------------}
PROCEDURE TForm3.btnOpenArchiveClick(Sender: TObject);
BEGIN

	OpenDialog1.Filter := LoadStr( F_TZIPTV );  (* see F_TZIPTV in err_msgs.rc and err_msgs.pas *)
	OpenDialog1.Options := [ ofHideReadOnly, ofFileMustExist, ofPathMustExist ];

	IF OpenDialog1.Execute THEN
		edtArchiveFile.Text := OpenDialog1.Filename;

END;
{-------------------------------------------------------------}
PROCEDURE TForm3.FormActivate(Sender: TObject);
BEGIN
	edtFileSpec.Text := ZipCheck1.FileSpec;
END;
{-------------------------------------------------------------}
(* Ok button click event *)
PROCEDURE TForm3.btnOKClick(Sender: TObject);
BEGIN

	Screen.Cursor := crHourGlass;
  ListBox1.Items.Clear;
  Application.ProcessMessages;

  TRY

     ZipCheck1.FileSpec := edtFileSpec.Text;
     ZipCheck1.ArchiveFile := edtArchiveFile.Text;

     IF ZipCheck1.IsArcDecompressable( ZipCheck1.ArcType ) THEN
        ZipCheck1.Activate
     ELSE
        MessageDlg( 'Unsupported archive type', mtInformation, [ mbOK ], 0 );

     edtArchiveFile.SetFocus;

  FINALLY

  	Screen.Cursor := crDefault;

  END;

END;
{-------------------------------------------------------------}
PROCEDURE TForm3.btnCloseClick(Sender: TObject);
BEGIN
	Close;
END;
{-------------------------------------------------------------}
PROCEDURE TForm3.edtArchiveFileChange(Sender: TObject);
BEGIN
	btnOK.Enabled := edtArchiveFile.Text <> '';
END;
{-------------------------------------------------------------}
(* TZipCheck OnStatus Event - display validation pass/fail *)
PROCEDURE TForm3.ZipCheck1Status(Sender: TObject; FN: STRING; PassFail: BOOLEAN);

VAR
	s: STRING;

BEGIN

	IF PassFail THEN
  	s := FN + ' ...Ok'
  ELSE
  	s := FN + ' ...Failed';

	ListBox1.Items.Add(s);

END;
{-------------------------------------------------------------}
(* TZipCheck OnError event *)
PROCEDURE TForm3.ZipCheck1Error(Sender: TObject; FN, VolumeID: STRING;
  ECode: INTEGER);
BEGIN
	MessageDlg( LoadStr( ECode ), mtInformation, [ mbOk ], 0 );
END;
{-------------------------------------------------------------}
(* TZipCheck OnGetPassword event - request password from user *)
PROCEDURE TForm3.ZipCheck1GetPassword(Sender: TObject; FN: STRING;
  VAR Password: STRING; VAR TryAgain: Boolean);
BEGIN

	PasswordDlg.Caption := ExtractFilename( FN );

	IF PasswordDlg.ShowModal = mrOK THEN
		Password := PasswordDlg.edtPassword.Text
	ELSE
		TryAgain := FALSE;

END;
{-------------------------------------------------------------}



END.

