#include <windows.h>
#include <direct.h>
#include <string.h>
#include "wsftptst.h"
#include "..\wsftpdll\wsftpdll.h"


LPCINFO pC;
HINSTANCE hInst;
char szHostName[256];
int nPort=21;
char szUserID[256];
char szPassword[256];
char szLocalName[256];
char szRemoteName[256];
char szCommand[256];
char szDir[256];
BOOL bBinary=1;

int GetFileNames(LPSTR pSrc,LPSTR pN1,LPSTR pN2)
{
  LPSTR pS;
  *pN1=0;
  *pN2=0;
  if((pS=strchr(pSrc,' '))!=NULL)
  {
    while(*pS==' ') *pS++ = 0;
    strcpy(pN2,pS);
  }
  strcpy(pN1,pSrc);
  if(strlen(pN2)==0)
    strcpy(pN2,pN1);
  return 0;
}

int DoCommand(LPCINFO pCI,LPSTR pCommand,HWND hMsgWnd)
{
  char szBuf[256];
  char szBuf1[256];
  LPWSFTPDINFO pDInfo;
  LPWSFTPFINFO pFInfo;

  WSFTP_AddTextToWindow(hMsgWnd,pCommand);

  if(strnicmp(pCommand,"bget ",5)==0)
  {
    GetFileNames(pCommand+5,szRemoteName,szLocalName);
    WSFTP_RecvFile(pCI,szRemoteName,szLocalName,bBinary);
  } else if(strnicmp(pCommand,"bput ",5)==0)
  {
    GetFileNames(pCommand+5,szLocalName,szRemoteName);
    WSFTP_SendFile(pCI,szLocalName,szRemoteName,bBinary);
#ifdef WIN32    
  } else if(strnicmp(pCommand,"tget ",5)==0)
  {
    GetFileNames(pCommand+5,szRemoteName,szLocalName);
    WSFTP_RecvFileThread(pCI,szRemoteName,szLocalName,bBinary,WM_USER+322);
  } else if(strnicmp(pCommand,"tput ",5)==0)
  {
    GetFileNames(pCommand+5,szLocalName,szRemoteName);
    WSFTP_SendFileThread(pCI,szLocalName,szRemoteName,bBinary,WM_USER+322);
#endif    
  } else if(strnicmp(pCommand,"get ",4)==0)
  {
    GetFileNames(pCommand+4,szRemoteName,szLocalName);
    WSFTP_RecvFileAsync(pCI,szRemoteName,szLocalName,bBinary,WM_USER+322);
  } else if(strnicmp(pCommand,"put ",4)==0)
  {
    GetFileNames(pCommand+4,szLocalName,szRemoteName);
    WSFTP_SendFileAsync(pCI,szLocalName,szRemoteName,bBinary,WM_USER+322);
#ifdef WIN32
  } else if(strnicmp(pCommand,"adir",3)==0)
  {
    if(pCommand[3]==' ')
      WSFTP_GetDirectoryAsync(pCI,pCommand+4,WM_USER+320);
    else
      WSFTP_GetDirectoryAsync(pCI,NULL,WM_USER+320);
#endif  
  } else if(strnicmp(pCommand,"dir",4)==0)
  {
    if(pCommand[4]==' ')
      pDInfo=WSFTP_GetDirectory(pCI,pCommand+5);
    else
      pDInfo=WSFTP_GetDirectory(pCI,NULL);
    if(pDInfo)
    {
      pFInfo=pDInfo->pFirstFile;
      while(pFInfo)
      {
        wsprintf(szBuf,"%u %-20.20s %04u%02u%02u %02u:%02u %10u",
          pFInfo->nType,
          pFInfo->szFileName,
          pFInfo->nYear,
          pFInfo->nMonth,
          pFInfo->nDay,
          pFInfo->nHour,
          pFInfo->nMinute,
          pFInfo->dwSize);
        WSFTP_AddTextToWindow(hMsgWnd,szBuf);
        pFInfo=pFInfo->pNext;
      }
      wsprintf(szBuf,"Host: %s Dir: %s Files: %u Dirs: %u Links: %u",
        pDInfo->szHostName,
        pDInfo->szDirName,
        pDInfo->nFiles,
        pDInfo->nDirs,
        pDInfo->nLinks);
      WSFTP_AddTextToWindow(hMsgWnd,szBuf);
      pDInfo=WSFTP_FreeDirectory(pDInfo);
    }
  } else if(strnicmp(pCommand,"ldir",4)==0)
  {
    if(pCommand[4]==' ')
      pDInfo=WSFTP_GetLocalDirectory(pCI,pCommand+5);
    else
      pDInfo=WSFTP_GetLocalDirectory(pCI,NULL);
    if(pDInfo)
    {
      pFInfo=pDInfo->pFirstFile;
      while(pFInfo)
      {
        wsprintf(szBuf,"%u %-20.20s %04u%02u%02u %02u:%02u %10u",
          pFInfo->nType,
          pFInfo->szFileName,
          pFInfo->nYear,
          pFInfo->nMonth,
          pFInfo->nDay,
          pFInfo->nHour,
          pFInfo->nMinute,
          pFInfo->dwSize);
        WSFTP_AddTextToWindow(hMsgWnd,szBuf);
        pFInfo=pFInfo->pNext;
      }
      wsprintf(szBuf,"Host: %s Dir: %s Files: %u Dirs: %u Links: %u",
        pDInfo->szHostName,
        pDInfo->szDirName,
        pDInfo->nFiles,
        pDInfo->nDirs,
        pDInfo->nLinks);
      WSFTP_AddTextToWindow(hMsgWnd,szBuf);
      pDInfo=WSFTP_FreeDirectory(pDInfo);
    }
  } else if(strnicmp(pCommand,"ls",2)==0)
  {
    if(pCommand[2]==' ')
      wsprintf(szBuf,"NLST %s",pCommand+3);
    else
      strcpy(szBuf,"NLST");
    WSFTP_RecvDsp(pCI,hMsgWnd,szBuf,NULL);
  } else if(strnicmp(pCommand,"display ",8)==0)
  {
    WSFTP_RecvDsp(pCI,hMsgWnd,"RETR",pCommand+8);
  } else if(strnicmp(pCommand,"ASC",3)==0)
  {
    bBinary=0;
    WSFTP_AddTextToWindow(hMsgWnd,"ASCII transfer mode");
  } else if(strnicmp(pCommand,"BIN",3)==0)
  {
    bBinary=1;
    WSFTP_AddTextToWindow(hMsgWnd,"BINARY transfer mode");
  } else if(strnicmp(pCommand,"PASSIVE",7)==0)
  {

    pCI->bPassive ^= 1;
    if(pCI->bPassive)
      WSFTP_AddTextToWindow(hMsgWnd,"Passive transfer mode");
    else
      WSFTP_AddTextToWindow(hMsgWnd,"Normal transfer mode");
  } else if(strnicmp(pCommand,"QUOTE ",6)==0)
  {
    WSFTP_SendCommandAsync(pCI,pCommand+6,WM_USER+330);
  } else if(strnicmp(pCommand,"USER ",5)==0)
  {
    WSFTP_SendCommandAsync(pCI,pCommand,WM_USER+330);
  } else if(strnicmp(pCommand,"PASS ",5)==0)
  {
    WSFTP_SendCommandAsync(pCI,pCommand,WM_USER+330);
  } else if(strnicmp(pCommand,"ACCT ",5)==0)
  {
    WSFTP_SendCommandAsync(pCI,pCommand,WM_USER+330);
  } else if(strnicmp(pCommand,"PWD",3)==0)
  {
    WSFTP_SendCommandAsync(pCI,pCommand,WM_USER+330);
    //WSFTP_DoCmd(pCI,pCommand,NULL);
  } else if(strnicmp(pCommand,"CD ",3)==0)
  {
    wsprintf(szBuf,"CWD %s",pCommand+3);
    WSFTP_SendCommandAsync(pCI,szBuf,WM_USER+330);
  } else if(strnicmp(pCommand,"RD ",3)==0)
  {
    wsprintf(szBuf,"RMD %s",pCommand+3);
    WSFTP_SendCommandAsync(pCI,szBuf,WM_USER+330);
  } else if(strnicmp(pCommand,"MD ",3)==0)
  {
    WSFTP_CreateDirectory(pCI,pCommand+3);
  } else if(strnicmp(pCommand,"DELETE ",7)==0)
  {
    wsprintf(szBuf,"DELE %s",pCommand+7);
    WSFTP_SendCommandAsync(pCI,szBuf,WM_USER+330);
  } else if(strnicmp(pCommand,"DEL ",4)==0)
  {
    wsprintf(szBuf,"DELE %s",pCommand+4);
    WSFTP_SendCommandAsync(pCI,szBuf,WM_USER+330);
  } else if(strnicmp(pCommand,"HELP",4)==0)
  {
    WSFTP_AddTextToWindow(hMsgWnd,"ASCII");
    WSFTP_AddTextToWindow(hMsgWnd,"BINARY");
    WSFTP_AddTextToWindow(hMsgWnd,"BYE");
    WSFTP_AddTextToWindow(hMsgWnd,"CD remote_directory");
    WSFTP_AddTextToWindow(hMsgWnd,"DELETE filename");
    WSFTP_AddTextToWindow(hMsgWnd,"[b]DIR [args]");
    WSFTP_AddTextToWindow(hMsgWnd,"DISPLAY remotename");
    WSFTP_AddTextToWindow(hMsgWnd,"[b|t]GET remotename [localname]");
    WSFTP_AddTextToWindow(hMsgWnd,"HELP");
    WSFTP_AddTextToWindow(hMsgWnd,"LCD local_directory");
    WSFTP_AddTextToWindow(hMsgWnd,"LDIR [mask]");
    WSFTP_AddTextToWindow(hMsgWnd,"LS [args]");
    WSFTP_AddTextToWindow(hMsgWnd,"LPWD");
    WSFTP_AddTextToWindow(hMsgWnd,"MD remote_directory");
    WSFTP_AddTextToWindow(hMsgWnd,"PASSIVE");
    WSFTP_AddTextToWindow(hMsgWnd,"[b|t]PUT localname [remotename]");
    WSFTP_AddTextToWindow(hMsgWnd,"PWD");
    WSFTP_AddTextToWindow(hMsgWnd,"RD remote_directory");
    WSFTP_AddTextToWindow(hMsgWnd,"QUOTE remote_command");
  } else if(strnicmp(pCommand,"BYE",3)==0)
  {
    WSFTP_DoCmd(pC,"QUIT",NULL);
    WSFTP_CloseConnect(pC,0);
  } else if(strnicmp(pCommand,"LPWD",4)==0)
  {
    getcwd(szBuf,256);
    wsprintf(szBuf1,"Local dir is \"%s\"",(LPSTR)szBuf);
    WSFTP_AddTextToWindow(hMsgWnd,szBuf1);
  } else if(strnicmp(pCommand,"LCD ",4)==0)
  {
    chdir(pCommand+4);
    getcwd(szBuf,256);
    wsprintf(szBuf1,"Local dir is \"%s\"",(LPSTR)szBuf);
    WSFTP_AddTextToWindow(hMsgWnd,szBuf1);
  } else if(strnicmp(pCommand,"INFO",4)==0)
  {
    wsprintf(szBuf,"last error=%s",WSFTP_ReturnLastErrorString(pC));
    WSFTP_AddTextToWindow(hMsgWnd,szBuf);
    wsprintf(szBuf,"last line=%s",WSFTP_ReturnLastLineString(pC));
    WSFTP_AddTextToWindow(hMsgWnd,szBuf);
    wsprintf(szBuf,"last error int=%u",WSFTP_ReturnLastErrorInt(pC));
    WSFTP_AddTextToWindow(hMsgWnd,szBuf);
    wsprintf(szBuf,"current host=%s",WSFTP_ReturnCurrentHostString(pC));
    WSFTP_AddTextToWindow(hMsgWnd,szBuf);
    wsprintf(szBuf,"current userid=%s",WSFTP_ReturnCurrentUserIDString(pC));
    WSFTP_AddTextToWindow(hMsgWnd,szBuf);
    wsprintf(szBuf,"current hosttype=%u",WSFTP_ReturnCurrentHostTypeInt(pC));
    WSFTP_AddTextToWindow(hMsgWnd,szBuf);
    wsprintf(szBuf,"current hosttype=%s",WSFTP_ReturnCurrentHostTypeString(pC));
    WSFTP_AddTextToWindow(hMsgWnd,szBuf);
  } else
  {
    wsprintf(szBuf1,"unknown command: %s",pCommand);
    WSFTP_AddTextToWindow(hMsgWnd,szBuf1);
  }
  return 0;
}

void UpdInfo(HWND hDlg,LPCINFO pC)
{
  if(pC)
  {
    SetDlgItemText(hDlg,IDC_EDIT6,pC->pLastLine);
    SetDlgItemText(hDlg,IDC_EDIT7,pC->pLastMsg);
    SetDlgItemInt(hDlg,IDC_EDIT8,pC->nHostType,FALSE);
    SetDlgItemInt(hDlg,IDC_EDIT10,pC->nErr,FALSE);
  }
}

BOOL WINAPI MainDlgProc(HWND hDlg,UINT msg,WPARAM wParam,LPARAM lParam)
{
  char szBuf[256];
  
  switch(msg)
  {
    case WM_USER+330:
      UpdInfo(hDlg,pC);
      if(pC->nErr!=0)
        WSFTP_StopAsync(pC);
      break;

    case WM_USER+331:    // read callback for 330
      UpdInfo(hDlg,pC);
      WSFTP_AddTextToWindow(GetDlgItem(hDlg,IDC_EDIT3),pC->pLastLine);
      //WSFTP_StopAsync(pC);
      break;

    case WM_USER+320:
      {
        LPWSFTPFINFO pFInfo;

        if(lParam)
        {
          pFInfo=((LPWSFTPDINFO)lParam)->pFirstFile;
          while(pFInfo)
          {
            wsprintf(szBuf,"%u %-20.20s %04u%02u%02u %02u:%02u %10u",
              pFInfo->nType,
              pFInfo->szFileName,
              pFInfo->nYear,
              pFInfo->nMonth,
              pFInfo->nDay,
              pFInfo->nHour,
              pFInfo->nMinute,
              pFInfo->dwSize);
            WSFTP_AddTextToWindow(GetDlgItem(hDlg,IDC_EDIT3),szBuf);
            pFInfo=pFInfo->pNext;
          }
          wsprintf(szBuf,"Host: %s Dir: %s Files: %u Dirs: %u Links: %u",
            ((LPWSFTPDINFO)lParam)->szHostName,
            ((LPWSFTPDINFO)lParam)->szDirName,
            ((LPWSFTPDINFO)lParam)->nFiles,
            ((LPWSFTPDINFO)lParam)->nDirs,
            ((LPWSFTPDINFO)lParam)->nLinks);
          WSFTP_AddTextToWindow(GetDlgItem(hDlg,IDC_EDIT3),szBuf);
          WSFTP_FreeDirectory((LPWSFTPDINFO)lParam);
        }
      }
      UpdInfo(hDlg,pC);
      return TRUE;

    case WM_USER+321:
      SetDlgItemInt(hDlg,IDC_EDIT9,wParam,FALSE);
      UpdInfo(hDlg,pC);
      return TRUE;

    case WM_USER+322:
      wsprintf(szBuf,
        "File transfer complete %s, %u bytes",
        ((wParam/100)==2 ? "succeeded" : "failed"),
        lParam);
      WSFTP_AddTextToWindow(GetDlgItem(hDlg,IDC_EDIT3),szBuf);  
      UpdInfo(hDlg,pC);
      return TRUE;

    case WM_USER+323:    // read callback for 322
      UpdInfo(hDlg,pC);
      WSFTP_AddTextToWindow(GetDlgItem(hDlg,IDC_EDIT3),pC->pLastLine);
      //WSFTP_StopAsync(pC);
      break;

    case WM_USER+325:
      if(wParam)
        wsprintf(szBuf,
          "Connected. Last FTP Code=%u",lParam);
      else
        wsprintf(szBuf,
          "Connect failed. %s",WSFTP_ReturnErrorString((UINT)lParam,NULL));
      WSFTP_AddTextToWindow(GetDlgItem(hDlg,IDC_EDIT3),szBuf);
      UpdInfo(hDlg,pC);
      return TRUE;

    case WM_USER+326:    // read callback for 325
      UpdInfo(hDlg,pC);
      WSFTP_AddTextToWindow(GetDlgItem(hDlg,IDC_EDIT3),pC->pLastLine);
      //WSFTP_StopAsync(pC);
      break;

    case WM_INITDIALOG:
      SendDlgItemMessage(hDlg,IDC_EDIT3,WM_SETFONT,
               (WPARAM)GetStockObject(ANSI_FIXED_FONT),0);
      SetDlgItemText(hDlg,IDC_EDIT1,"ftp2.ipswitch.com");
      SetDlgItemText(hDlg,IDC_EDIT4,"anonymous");
      SetDlgItemText(hDlg,IDC_EDIT5,"wsftptst@unknown");

      pC=WSFTP_InitCINFO(hDlg,GetDlgItem(hDlg,IDC_EDIT3),
                         WM_USER+321,WSFTPF_INITWINSOCK);
      UpdInfo(hDlg,pC);
      break;

    case WM_DESTROY:
      pC=WSFTP_FreeCINFO(pC);
      UpdInfo(hDlg,pC);
      break;
    case WM_COMMAND:
      switch(LOWORD(wParam))
      {
        case BTN_CONNECT:
          SetDlgItemText(hDlg,IDC_EDIT3,"");
          GetDlgItemText(hDlg,IDC_EDIT1,szHostName,250);
          GetDlgItemText(hDlg,IDC_EDIT4,szUserID,256);
          GetDlgItemText(hDlg,IDC_EDIT5,szPassword,256);
          pC->nHostType=HOST_TYPE_AUTO;
#ifndef XXXWIN32          
          WSFTP_ConnectAsync(pC,szHostName,LOWORD(nPort),
                           szUserID,szPassword,WM_USER+325);
#else
          WSFTP_Connect(pC,szHostName,LOWORD(nPort),
                           szUserID,szPassword);
#endif                           
          UpdInfo(hDlg,pC);
          SendDlgItemMessage(hDlg,IDC_EDIT2,EM_SETSEL,
            (WPARAM)(int)0,(LPARAM)(int)-1);
          SetFocus(GetDlgItem(hDlg,IDC_EDIT2));
          break;

        case BTN_GO:
          pC->nHostType=GetDlgItemInt(hDlg,IDC_EDIT8,NULL,FALSE);
          GetDlgItemText(hDlg,IDC_EDIT2,szCommand,256);
          DoCommand(pC,szCommand,GetDlgItem(hDlg,IDC_EDIT3));
          UpdInfo(hDlg,pC);
          SendDlgItemMessage(hDlg,IDC_EDIT2,EM_SETSEL,
            (WPARAM)(int)0,(LPARAM)(int)-1);
          SetFocus(GetDlgItem(hDlg,IDC_EDIT2));

          break;

        case BTN_CLOSE:
          WSFTP_DoCmd(pC,"QUIT",NULL);
          WSFTP_CloseConnect(pC,0);
          UpdInfo(hDlg,pC);
          break;

        case BTN_CANCEL:
          WSFTP_CancelAction(pC);
          break;

        case IDCANCEL:
          pC=WSFTP_FreeCINFO(pC);
          EndDialog(hDlg,TRUE);
          return TRUE;
      }
      break;
  }
  return 0;
}

int WINAPI WinMain(HINSTANCE hI,HINSTANCE hIP,LPSTR lpC,int nC)
{
  hInst=hI;

  DialogBox(hI,"DLG_MAIN",NULL,MainDlgProc);

  return 0;
}
