unit dbexed;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, DBExplor,DsgnIntf, ExtCtrls;

  const NodeTypeMap : array[0..3] of TDBExNodeType = (
    ntNullNode, ntDataSetNode, ntLinkNode, ntCustomNode);

type
  TDBExEditorForm = class(TForm)
    TVItems: TTreeView;
    BClose: TButton;
    BHelp: TButton;
    ImageList: TImageList;
    BNew: TButton;
    BNewSub: TButton;
    BDelete: TButton;
    NB: TNotebook;
    RGType: TRadioGroup;
    CBType: TComboBox;
    Label1: TLabel;
    procedure FormShow(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure BApplyClick(Sender: TObject);
    procedure BCancelClick(Sender: TObject);
    procedure BCloseClick(Sender: TObject);
    procedure BNewClick(Sender: TObject);
    procedure BDeleteClick(Sender: TObject);
    procedure BNewSubClick(Sender: TObject);
    procedure TVItemsClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure CBTypeChange(Sender: TObject);
    procedure TVItemsDragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure TVItemsStartDrag(Sender: TObject;
      var DragObject: TDragObject);
    procedure TVItemsDragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure TVItemsDblClick(Sender: TObject);
    procedure TVItemsChange(Sender: TObject; Node: TTreeNode);
    procedure BHelpClick(Sender: TObject);
  private
    { Private declarations }
    Nodes : TDBExNodes;
    CurrNode : TDBExNode;
    FInserting : boolean;
    DragItem:TTreeNode;

    procedure CopyNodes;
    procedure ScanNodes( FirstExNode : TDBExNode; ParentTVNode :TTreeNode);
//    function UniqueNodeName( Node : TDBExNode ):string;
    procedure UpdateButtons;
    procedure UpdateSelectedText(Sender : TComponent);
    procedure copytree(oldnode,newnode:TTreeNode);
  public
    { Public declarations }
    DBEx  : TCustomDBExplorer;
    Dirty : boolean;
    Applyed : boolean;
    FormDesigner  : TFormDesigner;
    Accept:Boolean;
  end;

var
  DBExEditorForm: TDBExEditorForm;

implementation
uses DBExNLEd;
{$R *.DFM}

procedure TDBExEditorForm.FormShow(Sender: TObject);
begin
//    Nodes.Name:='NEWNODES';
    Nodes:=DBEx.Nodes;
    CopyNodes;
    Nodes.FOnTextChange:=UpdateSelectedText;
    FInserting := False;
    TVItems.FullExpand;
    TVItems.Selected:=TVItems.Items.GetFirstNode;
    TVItemsClick( TVItems );
end;

procedure TDBExEditorForm.CopyNodes;
begin
    FInserting:=true;
    Nodes.DisableLinkNodes:=true;
    TVItems.Items.Clear;

    ScanNodes(DBEx.Nodes.GetFirstNode,nil);

    DBEx.Nodes.DisableLinkNodes := false;
    FInserting:=False;
end;

procedure TDBExEditorForm.ScanNodes( FirstExNode : TDBExNode; ParentTVNode :TTreeNode);
var
   ExParent,EXNode, NewNode : TDBExNode;
   TVNode : TTreeNode;
begin
    ExNode:=FirstExNode;
    while ExNode <> nil do
    begin
//        TVNode:=ParentTVNode;
        if ParentTVNode=nil then
        begin
//            NewNode := Nodes.Add( ExNode.NodeType,nil,'');
//            ExNode.CopyTo( NewNode );
//TRACE(Format('AddObject(%p)',[Pointer(ExNode)]));
            TVNode:=TVItems.Items.AddObject(nil, ExNode.Text, ExNode);
        end
        else
        begin
//            ExParent:=TDBExNode(TVNode.Data);
//            NewNode := Nodes.AddChild( ExNode.NodeType,ExParent,'');
//            ExNode.CopyTo( NewNode );
            TVNode:=TVItems.Items.AddChildObject(ParentTVNode,ExNode.Text, ExNode);
        end;
        case ExNode.NodeType of
            ntNullNode  : TVNode.ImageIndex:=0;
            ntDataSetNode : TVNode.ImageIndex:=1;
            ntLinkNode : TVNode.ImageIndex:=2;
            ntCustomNode : TVNode.ImageIndex:=3;
        end;
        TVNode.SelectedIndex:=TVNode.ImageIndex;
        ScanNodes(ExNode.GetFirstChild, TVNode);
        ExNode:=ExNode.GetNextSibling;
    end;
end;

procedure TDBExEditorForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
    {$IFNDEF TESTING}
    if not (csDestroying in DBEx.ComponentState) then
       FormDesigner.SelectComponent(DBEx);
    {$ENDIF}
    Action := caFree;
    DBEx.Nodes.CloseEditor;
//    if Nodes<> nil then Nodes.Free;
end;

procedure TDBExEditorForm.BApplyClick(Sender: TObject);
//var
//   OldNodes : TDBExNodes;
begin
    Nodes.FOnTextChange:=nil;
{    OldNodes:=DBEx.Nodes;
    DBEx.SetNodes(Nodes);
    Nodes:=OldNodes;
    Nodes.OwnerEx:=nil;
    Nodes.Clear;
    CopyNodes;              }
    TVItemsClick( TVItems );
    Nodes.InitShow;
{$IFNDEF TESTING}
    FormDesigner.Modified;
{$ENDIF}

//    TVItems.FullExpand;

end;

procedure TDBExEditorForm.BCloseClick(Sender: TObject);
begin
    BApplyClick(Sender);
    Close;
end;

procedure TDBExEditorForm.BCancelClick(Sender: TObject);
begin
    Close;
end;

//function TDBExEditorForm.UniqueNodeName( Node : TDBExNode ):string;
//begin
{$IFNDEF TESTING}
//    Result:=Nodes.UniqueName( Node.ClassName );
{$ELSE}
//    Result:='Node1';
{$ENDIF}
//end;

procedure TDBExEditorForm.BNewClick(Sender: TObject);
var
    ExNode : TDBExNode;
    TN : TTreeNode;
begin
    FInserting := true;
    ExNode := Nodes.Add( NodeTypeMap[RGType.ItemIndex], nil, 'NewItem');
//    ExNode.Name := UniqueNodeName(ExNode);
    ExNode.Text := ExNode.Name;
    TN:=TVItems.Items.AddObject(nil,ExNode.Text,ExNode);
    case ExNode.NodeType of
        ntNullNode  : TN.ImageIndex:=0;
        ntDataSetNode : TN.ImageIndex:=1;
        ntLinkNode : TN.ImageIndex:=2;
        ntCustomNode : TN.ImageIndex:=3;
    end;
    TN.SelectedIndex:=TN.ImageIndex;
    TVItems.Selected := TN;
    TVItemsClick( TVItems );
    TVItems.SetFocus;
    Nodes.InitShow;
    FInserting := false;
end;


procedure TDBExEditorForm.BDeleteClick(Sender: TObject);
var
    ToDelete : TDBExNode;
    TN,OldTN : TTreeNode;
begin
    ToDelete := CurrNode;
    CurrNode:=nil;
    Nodes.Remove( ToDelete );
    ToDelete.Free;
    OldTN:=TVItems.Selected;
    TN:=OldTN.GetPrev;
    if TN=nil then
        TN:=OldTN.GetNext;
    TVItems.Items.Delete(OldTN);
    TVItems.Selected:=TN;
    TVItemsClick( TVItems );
    TVItems.SetFocus;
    Nodes.InitShow;
    UpdateButtons;
end;

procedure TDBExEditorForm.UpdateButtons;
begin
    BDelete.Enabled:=( (CurrNode <> nil) and (
                                        (CurrNode.GetFirstChild=nil) or
                                        (CurrNode is TDBExLinkNode) )
                     );
    BNewSub.Enabled:=( (CurrNode <> nil ) and not (CurrNode is TDBExLinkNode));
end;

procedure TDBExEditorForm.BNewSubClick(Sender: TObject);
var
    ExNode : TDBExNode;
    TN : TTreeNode;
begin
    FInserting := true;
    ExNode := Nodes.AddChild( NodeTypeMap[RGType.ItemIndex], CurrNode , 'NewItem');
//    ExNode.Name := UniqueNodeName(ExNode);
    ExNode.Text := ExNode.Name;
    TN:=TVItems.Items.AddChildObject(TVItems.Selected,ExNode.Text,ExNode);
    case ExNode.NodeType of
        ntNullNode  : TN.ImageIndex:=0;
        ntDataSetNode : TN.ImageIndex:=1;
        ntLinkNode : TN.ImageIndex:=2;
        ntCustomNode : TN.ImageIndex:=3;
    end;
    TN.SelectedIndex:=TN.ImageIndex;
    TVItems.Selected :=TN;
    TVItemsClick( TVItems );
    TVItems.SetFocus;
    Nodes.InitShow;
    UpdateButtons;
    FInserting := False;
end;

procedure TDBExEditorForm.TVItemsClick(Sender: TObject);
begin
     if TVItems.Selected<>nil then
     begin
//TRACE('ItemsClick - enter');
//         showmessage('Click');
         CurrNode:=TDBExNode(TVItems.Selected.Data);
//TRACE(Format('TVItems.Selected.Data=%p',[Pointer(TVItems.Selected.Data)]));
         RGType.ItemIndex:=Integer(CurrNode.NodeType);
     end
     else
         CurrNode:=nil;
//TRACE('Before U_B');
     UpdateButtons;
    {$IFNDEF TESTING}
       FormDesigner.SelectComponent(CurrNode);
    {$ENDIF}
end;
procedure TDBExEditorForm.UpdateSelectedText(Sender : TComponent);
begin
    try
    if (not FInserting) and  (TVItems.Selected<>nil) then
    begin
        TVItems.Selected.Text:=CurrNode.Text;
//        TRACE('Curr Node '+Format('%p',[Pointer(CurrNode)]));
        Nodes.InitShow;
    end;
    except
    end;
end;
procedure TDBExEditorForm.Button1Click(Sender: TObject);
begin
    if NB.PageIndex=0 then
       NB.PageIndex:=1
    else
       NB.PageIndex:=0;
end;

procedure TDBExEditorForm.CBTypeChange(Sender: TObject);
begin
    RGType.ItemIndex:=CBType.ItemIndex;
end;

procedure TDBExEditorForm.TVItemsDragOver(Sender, Source: TObject; X,
  Y: Integer; State: TDragState; var Accept: Boolean);
begin
accept:=false;
if tvitems.getnodeat(x,y)<>nil then
  if (dragitem.level=tvitems.getnodeat(x,y).level)
    or (dragitem.level=tvitems.getnodeat(x,y).level+1)
  then
    accept:=true;
end;

procedure TDBExEditorForm.TVItemsStartDrag(Sender: TObject;
  var DragObject: TDragObject);
begin
  DragItem:=TVItems.Selected;
end;

procedure TDBExEditorForm.copytree(oldnode,newnode:TTreeNode);
var i:integer;
   node:TTreeNode;
begin
  if not oldnode.HasChildren then exit;
  for i:=0 to oldnode.count-1 do
  begin
    node:=newnode.owner.addchildobject
      (newnode,oldnode.item[i].text,oldnode.item[i].Data);
    node.ImageIndex:=oldnode.item[i].ImageIndex;
    Node.SelectedIndex:=Node.ImageIndex;
    copytree(oldnode.item[i],node);
  end;
end;

procedure TDBExEditorForm.TVItemsDragDrop(Sender, Source: TObject; X,
  Y: Integer);
var
   TargetNode,SourceNode:TTreeNode;
   node:TTreeNode;
   index:integer;
   Parent:TDBExNode;
begin
  SourceNode:=DragItem;
  TargetNode:=tvitems.getnodeat(x,y);
  if (TargetNode=SourceNode) then exit;
  FInserting:=True;
  Nodes.DisableLinkNodes:=true;
{        }
  if (TDBExNode(SourceNode.Data).ParentNode = TDBExNode(TargetNode.Data).ParentNode)
  then
  begin
    Parent:=TDBExNode(SourceNode.Data).ParentNode;
    if Parent.FChildren.IndexOf(SourceNode.Data)<Parent.FChildren.IndexOf(TargetNode.Data)
    then
      Parent.FChildren.Move(Parent.FChildren.IndexOf(SourceNode.Data),Parent.FChildren.IndexOf(TargetNode.Data)-1)
    else
      Parent.FChildren.Move(Parent.FChildren.IndexOf(SourceNode.Data),Parent.FChildren.IndexOf(TargetNode.Data))
  end
  else
  begin
{  }
//   
    Parent:=TDBExNode(SourceNode.Data).ParentNode;
    index:=Parent.FChildren.IndexOf(SourceNode.Data);
    Parent.FChildren.delete(index);

  {      }
    if (SourceNode.level=TargetNode.level+1) then
    begin
      TDBExNode(SourceNode.Data).FParentNode:=TDBExNode(TargetNode.Data);
      TDBExNode(TargetNode.Data).FChildren.add(SourceNode.Data);
    end
    else
    begin
      TDBExNode(SourceNode.Data).FParentNode:=TDBExNode(TargetNode.Data).ParentNode;
      TDBExNode(TargetNode.Data).ParentNode.FChildren.insert(TDBExNode(TargetNode
             .Data).ParentNode.FChildren.indexof(TargetNode.Data),SourceNode.Data);
    end;
  end;
  { TVnode}
  if (SourceNode.level<>TargetNode.level+1)
  then
  begin
    node:=TVitems.Items.insertobject(TargetNode,SourceNode.text,SourceNode.data)
  end
  else
  begin
    node:=TVitems.Items.addchildobject(TargetNode,SourceNode.text,SourceNode.data);
  end;
  node.ImageIndex:=SourceNode.ImageIndex;
  Node.SelectedIndex:=Node.ImageIndex;
  copytree(SourceNode,node);
  tvitems.Items.delete(SourceNode);
  TVItems.FullExpand;
  Nodes.DisableLinkNodes := false;
  FInserting:=False;
end;

procedure TDBExEditorForm.TVItemsDblClick(Sender: TObject);
var
    NodeLinksEditorForm : TNodeLinksEditorForm;
begin
    if (TVItems.Selected<>nil) and
       (TDBExNode(TVItems.Selected.Data)is TDBExDataNode) then
    begin
        NodeLinksEditorForm:=TNodeLinksEditorForm.Create(Application);
        NodeLinksEditorForm.SetNode(TDBExDataNode(TVItems.Selected.Data));
        NodeLinksEditorForm.ShowModal;
    end;
end;

procedure TDBExEditorForm.TVItemsChange(Sender: TObject; Node: TTreeNode);
begin
   TVItemsClick(Sender);
end;

procedure TDBExEditorForm.BHelpClick(Sender: TObject);
begin
    WinHelp( Handle,'dbexp.hlp',HELP_CONTEXT,11001);
end;

end.
