unit dbexnled;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, StdCtrls,DBExplor, db, dbtables, ExtCtrls;
const
    cDirectValue = '<DIRECT>';
type
  TNodeLinksEditorForm = class(TForm)
    BClose: TButton;
    GroupBox1: TGroupBox;
    LNode: TLabel;
    CBNode: TComboBox;
    CBMasterField: TComboBox;
    LMasterField: TLabel;
    Label3: TLabel;
    CBDetailField: TComboBox;
    BAdd: TButton;
    LBLinks: TListBox;
    BRemove: TButton;
    BHelp: TButton;
    LDetailField: TLabel;
    NBHelp: TNotebook;
    Image1: TImage;
    LPLink: TLabel;
    LMDLink: TLabel;
    LFLink: TLabel;
    Image2: TImage;
    Image3: TImage;
    procedure CBNodeChange(Sender: TObject);
    procedure BAddClick(Sender: TObject);
    procedure CBMasterFieldChange(Sender: TObject);
    procedure LBLinksClick(Sender: TObject);
    procedure BRemoveClick(Sender: TObject);
    procedure BCloseClick(Sender: TObject);
    procedure BCancelClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure BHelpClick(Sender: TObject);
  private
    Node : TDBExDataNode;
    Lock : boolean;

    function LinkTypeAsString( lt : TDBExLinkType ):string;
    procedure LinkTypeHelp( lt : TDBExLinkType );
  public
    { Public declarations }
    procedure SetNode( ANode :TDBExDataNode );
    procedure UpdateLink;
  end;

var
  NodeLinksEditorForm: TNodeLinksEditorForm;

implementation
{$R *.DFM}

function TNodeLinksEditorForm.LinkTypeAsString( lt : TDBExLinkType ):string;
begin
    if (lt=ltUnknown) and (ltMaster in Node.PossibleLinks) then
        lt := ltMaster;
    case lt of
       ltFilter : Result := 'Filter';
       ltMaster : Result := 'M-D';
       ltParam : Result := 'Param';
    else
       Result := '?';
    end;
end;

procedure TNodeLinksEditorForm.LinkTypeHelp( lt : TDBExLinkType );
begin
    if (lt=ltUnknown) and (ltMaster in Node.PossibleLinks) then
        lt := ltMaster;
    NBHelp.Visible := True;
    {LPLink.Visible := False;
    LFLink.Visible := False;
    LMDLink.Visible := False;}
    case lt of
       ltFilter : {LFLink.Visible := True}NBHelp.PageIndex:=1;
       ltMaster : {LMDLink.Visible := True}NBHelp.PageIndex:=0;
       ltParam : {LPLink.Visible := True}NBHelp.PageIndex:=2;
    end;
end;


procedure TNodeLinksEditorForm.SetNode( ANode :TDBExDataNode );
var
    N : TDBExNode;
//    Item : TListItem;
//    lt : TDBExLinkType;
    {OriginalLink, Link : TDBExNodeLink;}
    SN : string;
    i : integer;
//    DS : TDataSet;
begin
    Node := ANode;
    if (Node=nil) or (Node.Links=nil) then Exit;

    NBHelp.Visible := False;
//TRACE('SetNode enter');
    Caption := Caption + ' : '+Node.Name;
    N := Node.ParentNode;
    CBNode.Clear;
    while (N<>ANode.OwnerNodes.RootNode) and (N<>nil) do
    begin
        if N is TDBExDataNode then
            CBNode.Items.AddObject(N.Name, N);
        N := N.ParentNode;
    end;
    CBNode.Items.AddObject(cDirectValue, nil);
//    if CBNode.Items.Count > 0 then
//        CBNode.ItemIndex := 0;
    LBLinks.Clear;
    for i:=0 to Node.Links.Count-1 do
    begin
//        Link := TDBExNodeLink.Create;
//        Node.Links.Items[i].CopyTo( Link );
        if Node.Links.Items[i].MasterNode<>nil then
            SN := Node.Links.Items[i].MasterNode.Name
        else
            SN := cDirectValue;
        LBLinks.Items.AddObject(
                       SN+'.'+Node.Links.Items[i].MasterField+#9+
                       ' -> '+Node.Links.Items[i].DetailField+#9+
                       ' ['+LinkTypeAsString(Node.Links.Items[i].LinkType)+']'
                       , Node.Links.Items[i]);
    end;
    CBDetailField.Clear;
    for i:=0 to Node.ParamCount-1 do
            CBDetailField.Items.AddObject( Node.ParamName(i)+' [param]', Pointer( ltParam));
    for i:=0 to Node.FieldCount-1 do
    begin
      CBDetailField.Items.AddObject( Node.FieldName(i)+' [field]', Pointer( ltFilter));
    end;
end;

procedure TNodeLinksEditorForm.UpdateLink;
var
    Link : TDBExNodeLink;
    N : TDBExDataNode;
    S,SN : String;
    i : integer;
begin
    if Lock or (LBLinks.ItemIndex=-1) or
       (CBNode.ItemIndex=-1) then Exit;

    i := LBLinks.ItemIndex;
    Link := TDBExNodeLink(LBLinks.Items.Objects[ LBLinks.ItemIndex ]);
    N:= TDBExDataNode( CBNode.Items.Objects[ CBNode.ItemIndex ]);
    Link.MasterNode := N;
    Link.MasterField := CBMasterField.Text;
    Link.DetailField := Copy(CBDetailField.Text, 0,Length(CBDetailField.Text)-8);
    if {(Link.MasterField<>'') and}
       (Link.DetailField<>'') then
    begin
        Link.LinkType := TDBExLinkType(CBDetailField.Items.Objects[ CBDetailField.ItemIndex ]);
        S:=LinkTypeAsString(Link.LinkType);
    end
    else
        S:='';
    if N<>nil then
        SN:=N.Name
    else
        SN:=cDirectValue;
    LBLinks.Items.Strings[i]:=SN+
                  '.'+Link.MasterField+#9+
                  ' -> '+Link.DetailField+#9+
                  ' ['+S+']';
    LinkTypeHelp(Link.LinkType);
    LBLinks.ItemIndex:=i;
end;


procedure TNodeLinksEditorForm.CBNodeChange(Sender: TObject);
var
    N : TDBExDataNode;
    DS : TDataSet;
    i : integer;
    Found : boolean;
    L:TStringList;
begin
    if CBNode.ItemIndex = -1 then Exit;
    if CBNode.Items.Objects[CBNode.ItemIndex]=nil then
    begin
        if  CBNode.Items.Strings[CBNode.ItemIndex]=cDirectValue then
        begin
            CBMasterField.Style := csDropDown;
            CBMasterField.Text := '';
            UpdateLink;
        end;
    end
    else
    begin
        CBMasterField.Style := csDropDownList;
        {LFLink.Visible := False;
        LPLink.Visible := False;
        LMDLink.Visible := False;}
        N := TDBExDataNode( CBNode.Items.Objects[CBNode.ItemIndex]);
        Node.GetPossibleLinks;
        Found := False;
        for i:=0 to Node.Links.Count-1 do
            if (Node.Links.Items[i].LinkType = ltMaster) and
               (Node.Links.Items[i].MasterNode=N) then
                Found := True;

        if (Found) or
           (Node.PossibleLinks=[]) then
        begin
            CBMasterField.Enabled:=False;
            CBDetailField.Enabled:=False;
//        BAdd.Enabled:=False;
//        if (ltMaster in Node.PossibleLinks) then
//            LMDLink.Visible := True;
        end
        else
        begin

            if (N is TCustomDBExDataSetNode) then
            begin
                CBMasterField.Enabled:=True;
                CBDetailField.Enabled:=True;

                if not ((Node is TDBEXCustomNode) and (LBLinks.Items.Count>0)) then
                  BAdd.Enabled:=True;

                CBMasterField.Clear;
                if ltParam in Node.PossibleLinks then
                begin
                    if (TCustomDBExDataSetNode(N).DataSource<>nil) and
                       (TCustomDBExDataSetNode(N).DataSource.DataSet<>nil) then
                    begin
                        DS := TCustomDBExDataSetNode(N).DataSource.DataSet;
                        if (DS is TQuery) then
                            for i:=0 to TQuery(DS).ParamCount-1 do
                                CBMasterField.Items.Add( TQuery(DS).Params[i].Name);
                        if (DS is TStoredProc) then
                            for i:=0 to TStoredProc(DS).ParamCount-1 do
                                CBMasterField.Items.Add( TStoredProc(DS).Params[i].Name);
                    end;
                end;
                if ltFilter in Node.PossibleLinks then
                begin

                    if (TCustomDBExDataSetNode(N).DataSource<>nil) and
                       (TCustomDBExDataSetNode(N).DataSource.DataSet<>nil) then
                    begin
                        DS := TCustomDBExDataSetNode(N).DataSource.DataSet;
//    =0     
                        if DS.FieldCount<>0 then
                        begin
                          for i:=0 to DS.FieldCount-1 do
                              CBMasterField.Items.Add( DS.Fields[i].FieldName);
                        end
                        else
                        begin
                           L:=TStringList.Create;
                           DS.getfieldnames(L);
                           for i:=0 to L.Count-1 do
                              CBMasterField.Items.Add( L.Strings[i]);
                           L.Free;
                        end;
                    end;
                end;
            end;

            if (N is TDBExCustomNode) then
            begin
                CBMasterField.Enabled:=True;
                CBDetailField.Enabled:=True;

                if not ((Node is TDBEXCustomNode) and (LBLinks.Items.Count>0)) then
                  BAdd.Enabled:=True;

                CBMasterField.Clear;

                if ltFilter in Node.PossibleLinks then
                begin
                  CBMasterField.Items.Add('ParentKey');
                  CBMasterField.Items.Add('Key');
                  CBMasterField.Items.Add('Label');
                end;
            end;

        end;
        UpdateLink;
    end;
end;

procedure TNodeLinksEditorForm.BAddClick(Sender: TObject);
var
    Link : TDBExNodeLink;
begin
    if (Node is TDBEXCustomNode) and (LBLinks.Items.Count>0) then
    begin
      BAdd.Enabled:=False;
      Exit;
    end;

    Link := Node.Links.Add;
//    Link.LinkType := ltUnknown;
    LBLinks.ItemIndex := LBLinks.Items.AddObject('',Link);
    CBNode.Enabled:=True;
    CBNode.ItemIndex:=0;
    CBNode.Enabled:=True;
    CBMasterField.Enabled:=True;
    CBDetailField.Enabled:=True;
    BRemove.Enabled := True;
    CBNodeChange( CBNode );
    UpdateLink;

end;

procedure TNodeLinksEditorForm.CBMasterFieldChange(Sender: TObject);
begin
    UpdateLink;
end;

procedure TNodeLinksEditorForm.LBLinksClick(Sender: TObject);
var
    Link : TDBExNodeLink;
    i : integer;
    N : TDBExNode;
    SN : string;
begin
    Lock := True;
    Link := TDBExNodeLink(LBLinks.Items.Objects[LBLinks.ItemIndex]);
    i:=0;
    N := Link.MasterNode;
    if N<>nil then
        SN := N.Name
    else
        SN := cDirectValue;
    while (i<CBNode.Items.Count-1) and (CBNode.Items[i]<> SN) do
        inc(i);
    CBNode.ItemIndex:=i;
    CBNodeChange( CBNode );
    i:=0;
    if N<> nil then
    begin
        while (i<CBMasterField.Items.Count) and (CBMasterField.Items[i]<>Link.MasterField) do
            inc(i);
        CBMasterField.ItemIndex:=i;
    end
    else
    begin
        CBMasterField.Text := Link.MasterField;
        CBMasterFieldChange(CBMasterField);
    end;
    i:=0;
    while (i<CBDetailField.Items.Count) and (
       Copy(CBDetailField.Items[i],0, Length(CBDetailField.Items[i])-8)<>Link.DetailField) do
        inc(i);
    CBDetailField.ItemIndex:=i;
    LinkTypeHelp(Link.LinkType);
    CBNode.Enabled := True;
    if Link.LinkType=ltMaster then
    begin
        CBNode.Enabled := False;
        CBMasterField.Enabled:=False;
        CBDetailField.Enabled:=False;
        BRemove.Enabled := False;
    end
    else
    begin
        CBNode.Enabled := True;
        CBMasterField.Enabled := True;
        CBDetailField.Enabled := True;
        BRemove.Enabled := True;
    end;
    Lock:=False;
end;

procedure TNodeLinksEditorForm.BRemoveClick(Sender: TObject);
begin
    if LBLinks.ItemIndex<>-1 then
    begin
        TDBExNodeLink(LBLinks.Items.Objects[LBLinks.ItemIndex]).Free;
        LBLinks.Items.Delete(LBLinks.ItemIndex);
        CBNode.ItemIndex := -1;
        CBMasterField.Clear;
//        CBDetailField.Clear;
        CBNode.Enabled := False;
        CBMasterField.Enabled := False;
        CBDetailField.Enabled := False;

        if (Node is TDBEXCustomNode) and (LBLinks.Items.Count=0) then
        begin
          BAdd.Enabled:=True;
        end;

    end;
end;

procedure TNodeLinksEditorForm.BCloseClick(Sender: TObject);
//var
//    Link : TDBExNodeLink;
//    i : integer;
begin
    {while Node.Links.Count<>0 do
    begin
        Link :=Node.Links.Items[0];
        Node.Links.Remove(0);
        Link.Free;
    end;}
//    Node.Links.Clear;
//    for i:=0 to LBLinks.Items.Count-1 do
//        Node.Links.Add.Assign( TDBExNodeLink( LBLinks.Items.Objects[i] ) );
end;

procedure TNodeLinksEditorForm.BCancelClick(Sender: TObject);
//var
//    i : integer;
begin
//    for i:=0 to LBLinks.Items.Count-1 do
//        TDBExNodeLink( LBLinks.Items.Objects[i] ).Free;
end;

procedure TNodeLinksEditorForm.FormShow(Sender: TObject);
const
    TabStops : array[1..3] of char=(#50,#100,#150);
begin
    Lock := False;
//    LBLinks.Perform( LB_SETTABSTOPS, 3, LongInt(@TabStops));

    if (Node is TDBEXCustomNode) and (LBLinks.Items.Count>0) then
    begin
      BAdd.Enabled:=False;
    end

end;

procedure TNodeLinksEditorForm.BHelpClick(Sender: TObject);
begin
    WinHelp( Handle,'dbexp.hlp',HELP_CONTEXT,11002);
end;

end.
