unit Datamod;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  DBTables, DB;

type
  TMastData = class(TDataModule)
    MastDB: TDatabase;
    Orders: TTable;
    Customer: TQuery;
    DSOrders: TDataSource;
    DSCustomer: TDataSource;
    OrdersOrderNo: TFloatField;
    OrdersCustNo: TFloatField;
    OrdersSaleDate: TDateTimeField;
    OrdersShipDate: TDateTimeField;
    OrdersEmpNo: TIntegerField;
    OrdersShipToContact: TStringField;
    OrdersShipToAddr1: TStringField;
    OrdersShipToAddr2: TStringField;
    OrdersShipToCity: TStringField;
    OrdersShipToState: TStringField;
    OrdersShipToZip: TStringField;
    OrdersShipToCountry: TStringField;
    OrdersShipToPhone: TStringField;
    OrdersShipVIA: TStringField;
    OrdersPO: TStringField;
    OrdersTerms: TStringField;
    OrdersPaymentMethod: TStringField;
    OrdersItemsTotal: TCurrencyField;
    OrdersTaxRate: TFloatField;
    OrdersFreight: TCurrencyField;
    OrdersAmountPaid: TCurrencyField;
    CustomerCustNo: TFloatField;
    CustomerCompany: TStringField;
    CustomerAddr1: TStringField;
    CustomerAddr2: TStringField;
    CustomerCity: TStringField;
    CustomerState: TStringField;
    CustomerZip: TStringField;
    CustomerCountry: TStringField;
    CustomerPhone: TStringField;
    CustomerFAX: TStringField;
    CustomerTaxRate: TFloatField;
    CustomerContact: TStringField;
    CustomerLastInvoiceDate: TDateTimeField;
    Parts: TTable;
    PartsPartNo: TFloatField;
    PartsVendorNo: TFloatField;
    PartsDescription: TStringField;
    PartsOnHand: TFloatField;
    PartsOnOrder: TFloatField;
    PartsCost: TCurrencyField;
    PartsListPrice: TCurrencyField;
    DSParts: TDataSource;
    Vendors: TTable;
    DSVendors: TDataSource;
    DSitems: TDataSource;
    States: TQuery;
    DSStates: TDataSource;
    items: TQuery;
    DSBriefParts: TDataSource;
    BriefParts: TQuery;
    VendorsVendorNo: TFloatField;
    VendorsVendorName: TStringField;
    VendorsAddress1: TStringField;
    VendorsAddress2: TStringField;
    VendorsCity: TStringField;
    VendorsState: TStringField;
    VendorsZip: TStringField;
    VendorsCountry: TStringField;
    VendorsPhone: TStringField;
    VendorsFAX: TStringField;
    VendorsPreferred: TBooleanField;
    BriefPartsPartNo: TFloatField;
    BriefPartsVendorName: TStringField;
    BriefPartsDescription: TStringField;
    OrdersOrderLabel: TStringField;
    DSProjects: TDataSource;
    Projects: TTable;
    ProjectsPr_id: TIntegerField;
    ProjectsPr_parent: TIntegerField;
    ProjectsPr_name: TStringField;
    ProjectsPr_bdate: TDateField;
    ProjectsPr_edate: TDateField;
    ProjectsPr_info: TMemoField;
    procedure OrdersCalcFields(DataSet: TDataSet);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MastData: TMastData;

implementation

{$R *.DFM}
procedure TMastData.OrdersCalcFields(DataSet: TDataSet);
begin
    OrdersOrderLabel.AsString := Format('%10s - %10s',[OrdersOrderNo.AsString, OrdersSaleDate.AsString]);
end;

end.
