unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  DB, Grids, DBGrids, DBCtrls, ExtCtrls, ComCtrls, DBExplor, StdCtrls,
  Menus;

type
  TForm1 = class(TForm)
    DBExplorer1: TDBExplorer;
    Panel1: TPanel;
    DBNavigator1: TDBNavigator;
    DBGrid1: TDBGrid;
    ExDS: TDataSource;
    dVendors: TDBExDataSetNode;
    dParts: TDBExDataSetNode;
    ImageList1: TImageList;
    nCustomers: TDBExNode;
    dAllCustomers: TDBExDataSetNode;
    dCustStates: TDBExDataSetNode;
    lCustByState: TDBExLinkNode;
    dOrders: TDBExDataSetNode;
    dOrdItems: TDBExDataSetNode;
    cNode: TDBExCustomNode;
    lVendor: TDBExLinkNode;
    dProjects: TDBExDataSetNode;
    lProjects: TDBExLinkNode;
    Panel2: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    procedure cNodeFirst(Sender: TDBExCustomNode);
    procedure cNodeNext(Sender: TDBExCustomNode);
    procedure cNodeEndCheck(Sender: TDBExCustomNode; var IsEnd: Boolean);
    procedure cNodeGetData(Sender: TDBExCustomNode; var Key, ParentKey,
      LabelValue: string);
    procedure Exit1Click(Sender: TObject);
    procedure Label8Click(Sender: TObject);
    procedure dProjectsCreateItem(Sender: TDBExDataNode; Node: TTreeNode);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure GotoURL( URL : string );
  end;

var
  Form1: TForm1;

implementation

uses Datamod,ShellAPI;

const
   A :    array [1..4] of String = ('Easy To Use','Remarkable','Super Cool','ReallyBad');
   B :    array [1..4] of String = ('11518','12301','5349',    '5324');

{$R *.DFM}


procedure TForm1.cNodeFirst(Sender: TDBExCustomNode);
begin
    Sender.Tag:=1;
end;

procedure TForm1.cNodeNext(Sender: TDBExCustomNode);
begin
    Sender.Tag:=Sender.Tag+1;
end;

procedure TForm1.cNodeEndCheck(Sender: TDBExCustomNode;
  var IsEnd: Boolean);
begin
    IsEnd := (Sender.Tag > 4);
end;


procedure TForm1.cNodeGetData(Sender: TDBExCustomNode; var Key, ParentKey,
  LabelValue: string);
begin
    Key := IntToStr(Sender.Tag);
    ParentKey := B[Sender.Tag];
    LabelValue := A[Sender.Tag];
end;

procedure TForm1.Exit1Click(Sender: TObject);
begin
    Application.Terminate;
end;

procedure TForm1.Label8Click(Sender: TObject);
begin
    GotoURL( TLabel(Sender).Caption );
end;

procedure TForm1.GotoURL( URL : string );
var
   FullURL : string;
begin
  if Copy(URL,1,4)='http' then
     FullURL:='http://www.rsd.pp.ru/cgi-bin/link.pl?source=DBEXDEMO&target='+URL
  else
     FullURL:=URL;
  try
    ShellExecute( 0, PCHAR('open'),PChar(FullURL), Nil, Nil,SW_RESTORE);
  except
  end;
end;

procedure TForm1.dProjectsCreateItem(Sender: TDBExDataNode;
  Node: TTreeNode);
begin
    Node.Text := UpperCase( Node.Text )+' [Root]';
end;

end.
