unit Sample;
{*****************************************************************
Important information for use with the
PKWARE Data Compression Library (R) for Win32
Copyright 1991,1992,1994,1995,1996 PKWARE Inc. All Rights Reserved
PKWARE Data Compression Library Reg. U.S. Pat. and Tm. Off.
******************************************************************}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, PKCmp;

type
  TCompressor = class(TForm)
    ExplodeButton: TButton;
    ImplodeButton: TButton;
    ClearButton: TButton;
    Label1: TLabel;
    Label2: TLabel;
    InputCRC: TEdit;
    OutputCRC: TEdit;
    procedure ImplodeButtonClick(Sender: TObject);
    procedure ExplodeButtonClick(Sender: TObject);
    procedure ClearButtonClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    InStream, OutStream : TFileStream;
    InCRC, OutCRC       : Longint;
    Compressing         : Boolean;
  end;

var
  Compressor: TCompressor;

  cmp_buff : array [1..CMP_BUFFER_SIZE] of char;
  exp_buff : array [1..EXP_BUFFER_SIZE] of char;

implementation
{$R *.DFM}

  function ReadBuff(var buffer; var size :Integer; var Param):Integer;cdecl;
   var read_size : Integer;
  begin
    try
       with TObject(Param) as TCompressor do
       begin
            read_size :=InStream.Read(buffer,size);
            if (read_size > 0) AND Compressing then
               InCRC := crc32(buffer,read_size,InCRC);
            ReadBuff := read_size;
       end;
    except
            ReadBuff := 0;
    end;
  end;

  procedure WriteBuff(var buffer; var size :Integer; var Param);cdecl;
  begin
    try
       with TObject(Param) as TCompressor do
       begin
            OutStream.Write(buffer,size);
            if (size > 0) AND NOT Compressing then
               OutCRC := crc32(buffer,size,OutCRC);
       end;
    except
    end;
  end;


procedure TCompressor.ImplodeButtonClick(Sender: TObject);
 var cmp_type,dsize : Integer;
begin
     cmp_type := CMP_BINARY;
     dsize    := CMP_DICT_SIZE3;
     Compressing := TRUE;
     InCRC := -1;
     InputCRC.Text:='';
     try
          InStream  := TFileStream.Create('PKTEST.IN',fmOpenRead or fmShareExclusive);
          OutStream := TFileStream.Create('PKTEST.OUT',fmCreate or fmShareExclusive);
          PKCmp.implode(ReadBuff,WriteBuff,cmp_buff,self,cmp_type,dsize);
     finally
        InStream.Free;
        OutStream.Free;
     end;
     InCRC := Not InCRC;

     InputCRC.Text := ' '+IntToHex(InCRC,8);
end;

procedure TCompressor.ExplodeButtonClick(Sender: TObject);
begin
     Compressing := FALSE;
     OutCRC := -1;
     OutputCRC.Text:='';
     try
        InStream  := TFileStream.Create('PKTEST.OUT',fmOpenRead or fmShareExclusive);
        OutStream := TFileStream.Create('PKTEST.NEW',fmCreate or fmShareExclusive);
        PKCmp.explode(ReadBuff,WriteBuff,exp_buff,self);
     finally
        InStream.Free;
        OutStream.Free;
     end;
     OutCRC := Not OutCRC;
     OutputCRC.Text := ' '+IntToHex(OutCRC,8);
end;

procedure TCompressor.ClearButtonClick(Sender: TObject);
begin
     InputCRC.Text:='';
     OutputCRC.Text:='';
end;

end.
