import java.lang.Math;

public class PLine extends PObject
{
  public PVector p1=null;
  public PVector p2=null;
  public double A=0,B=0,C=0;  

  PLine (PVector P1,PVector P2)
  {
      super(1);
	  p1=new PVector(P1.xarg(),P1.yarg());
	  p2=new PVector(P2.xarg(),P2.yarg());
      PVector a=p2.Subtract(p1);
	  double len=a.Length();
      a.MultL(1/len);
	  A=-a.yarg();
	  B=a.xarg();
	  C=-(p1.xarg()*A+p1.yarg()*B);
  }
  PLine(double x1,double y1,double x2,double y2)
  {
	  super(1);
	  p1=new PVector(x1,y1);
	  p2=new PVector(x2,y2);
	  PVector a=p2.Subtract(p1);
	  double len=a.Length();
      a.MultL(1/len);
	  A=-a.yarg();
	  B=a.xarg();
	  C=-(p1.xarg()*A+p1.yarg()*B);
  }
  public double Funct(double X,double Y)
  {
    return (A*X+B*Y+C);
  }
  public PVector Normal()
  {
    return new PVector(A,B);
  }
  public PVector Tangent()
  {
    return new PVector(p2.x-p1.x,p2.y-p1.y);
  }
  public void ReInit(double x1,double y1,double x2,double y2)
  {
	  
	  p1.ReInit(x1,y1);
	  p2.ReInit(x2,y2);
	  PVector a=p2.Subtract(p1);
	  double len=a.Length();
      a.MultL(1/len);
	  A=-a.yarg();
	  B=a.xarg();
	  C=-(p1.xarg()*A+p1.yarg()*B);
  }
   public void ReInit(PVector P1,PVector P2)
  {
	  
	  p1.ReInit(P1.x,P1.y);
	  p2.ReInit(P2.x,P2.y);
	  PVector a=p2.Subtract(p1);
	  double len=a.Length();
      a.MultL(1/len);
	  A=-a.yarg();
	  B=a.xarg();
	  C=-(p1.xarg()*A+p1.yarg()*B);
  }

  public void PointOn(double T,PVector pnt)
  {
    pnt.ReInit(p1.x*(1-T)+p2.x*T,p1.y*(1-T)+p2.y*T);
  }	
}
