import java.lang.Math;

public class PEllipse extends PObject
{
	public PVector center;
	public double radius_a;
	public double radius_b;
	public double angle_a;
	//===============================================
    PVector exis_A;
	PVector exis_B;
	double A_x;
    double A_y;
    double B_x;
    double B_y;

   //===============================================
   //
   //                X*A*X'+B*X'+C=0;
   //
   //===============================================
    double A[][]=new double [2][2];
	PVector B;
	double C;
	//===============================================
	PEllipse(PVector Center,double a,double b,double Angle)
	{
		super(3);
		center=new PVector(Center.x,Center.y);
		radius_a=a;
		radius_b=b;
		angle_a=Angle;
		
		exis_A=new PVector(Math.cos(Angle),Math.sin(Angle));
        exis_B=new PVector(-exis_A.y,exis_A.x);
        /////////////////////////////////////////////////
        A_x=exis_A.x*radius_a;
        A_y=exis_A.y*radius_a;
        B_x=exis_B.x*radius_b;
        B_y=exis_B.y*radius_b;
        /////////////////////////////////////////////////
		A[0][0]=exis_A.x*exis_A.x/(radius_a*radius_a)+
            exis_B.x*exis_B.x/(radius_b*radius_b);
	    A[0][1]=exis_A.x*exis_A.y/(radius_a*radius_a)+
            exis_B.x*exis_B.y/(radius_b*radius_b);
	    A[1][0]=exis_A.x*exis_A.y/(radius_a*radius_a)+
            exis_B.x*exis_B.y/(radius_b*radius_b);
        A[1][1]=exis_A.y*exis_A.y/(radius_a*radius_a)+
            exis_B.y*exis_B.y/(radius_b*radius_b);
        //==================================================
        B=new PVector((-2)*(center.x*A[0][0]+center.y*A[1][0]),
			          (-2)*(center.x*A[0][1]+center.y*A[1][1]));
	    //==================================================
	    
		C=A[0][0]*(center.x*center.x)+2*A[1][0]*(center.y*center.x)+
		  A[1][1]*(center.y*center.y)-1.0;		 
	}
    void  pntXY_HCurve(PVector pntXY,double H,double t)
    {
	  double x,y,x_prim,y_prim,x_norm,y_norm,len;
	  double cos_t=Math.cos(t),sin_t=Math.sin(t);
  	  x=A_x*cos_t+B_x*sin_t+center.x;
      y=A_y*cos_t+B_y*sin_t+center.y;
	  x_prim=-A_x*sin_t+B_x*cos_t;
      y_prim=-A_y*sin_t+B_y*cos_t;
	  x_norm=y_prim;
      y_norm=-x_prim;
	  len=Math.sqrt(x_norm*x_norm+y_norm*y_norm);
	  pntXY.x=x+x_norm/len*H;
      pntXY.y=y+y_norm/len*H;
    }
    void DpntXY_HCurve(PVector pntXprimYprim,double H,double t)
    {
	  double x_prim,y_prim,x_norm,y_norm,len,
	         x_prim_prim,y_prim_prim,x_norm_prim,y_norm_prim,len_prim;
      double sin_t=Math.sin(t),cos_t=Math.cos(t);
	  x_prim=-A_x*sin_t+B_x*cos_t;
      y_prim=-A_y*sin_t+B_y*cos_t;
	  x_prim_prim=-A_x*cos_t-B_x*sin_t;
      y_prim_prim=-A_y*cos_t-B_y*sin_t;
	  x_norm=y_prim;
      y_norm=-x_prim;
	  x_norm_prim=y_prim_prim;
      y_norm_prim=-x_prim_prim;
	  len=Math.sqrt(x_norm*x_norm+y_norm*y_norm);
	  len_prim=(radius_a*radius_a-radius_b*radius_b)*sin_t*cos_t/len;
	  pntXprimYprim.ReInit(x_prim+(x_norm_prim-x_norm/len*len_prim)*H/len,
	                            y_prim+(y_norm_prim-y_norm/len*len_prim)*H/len);
   }
   //==========================================================================
   double x_prim0(double t)
   {
	return  (A_x*Math.cos(t)+B_x*Math.sin(t)+center.x);
   }
   double y_prim0(double t)
   {
	return  (A_y*Math.cos(t)+B_y*Math.sin(t)+center.y);
   }
   double x_prim1(double t)
   {
	return  (-A_x*Math.sin(t)+B_x*Math.cos(t));
   }
   double y_prim1(double t)
   {
	return  (-A_y*Math.sin(t)+B_y*Math.cos(t));
   }
   double x_prim2(double t)
   {
	return  -(A_x*Math.cos(t)+B_x*Math.sin(t));
   }
   double y_prim2(double t)
   {
	return  -(A_y*Math.cos(t)+B_y*Math.sin(t));
   }
   //////////////////////////////////////////////
   //========================================================
double Funct(double X,double Y)
{   
	return (A[0][0]*X*X+(A[0][1]+A[1][0])*X*Y+A[1][1]*Y*Y+
		    B.x*X+B.y*Y + C);	
}
void gradFunct(PVector grad,double X,double Y)
{
	grad.x=2*(A[0][0]*X+(A[0][1]+A[1][0])*Y)+B.x;
	grad.y=2*(A[1][1]*Y+(A[0][1]+A[1][0])*X)+B.y;
}
double FunctPrimX(double X,double Y)
{
	return (2*(A[0][0]*X+(A[1][0]+A[0][1])*Y)+B.x);
}
double FunctPrimY(double X,double Y)
{
	return (2*(A[1][1]*Y+(A[1][0]+A[0][1])*X)+B.y);
}

double FunctPrimXX()
{
	return 2*A[0][0];
}
double FunctPrimXY()
{
	return (A[0][1]+A[1][0]);
}
double FunctPrimYY()
{
	return 2*A[1][1];
}
//===================================================
}
