/*	
 *
 *
 *	This example application demonstrates how to extend bCAD functionality
 *	using its Java API. This program draws a coordinate plane and then plots
 *      several function graphs on it.
 *
 * 	Copyright 1997 ProPro Group. All Rights Reserved.
 *
 * 	Developed by Alexey Balagansky 
 *
 */


 
/*
 Class FucntionPlot is a main one in our program. It extends bCAD class and
 provides all functionality of our application.
*/

class FunctionPlot extends bCAD
{
	//Declaring constants
    public static final float k = 100f;             	//ratio
    public static final float l = 3f;               	//ratio

    boolean DrawGrid = true;				//draw the grid?
    float GridStep = 10f;				//coordinate grid step
    float PlotStep = 5f;                            	//plotting accuracy
    Point LeftBottom = new Point(0f,0f,0f);         	//left bottom corner of the plot
    Point RightTop = new Point(400f,300f,0f);       	//right top -"-

	public FunctionPlot()	// constructor
    {
    }/*FunctionPlot*/

	   public void bcadmain(long ctxt, float x, float y, float z) // entry point
    {
		//create new instance of the class FunctionPlot	
		FunctionPlot fplot = new FunctionPlot();
		//and make him do the job
        fplot.run(ctxt);
    }/*bcadmain*/

		
	public static void main(String []argv)
	{
		//Inform user, if he tries to run this program outside bCAD

		System.out.println("This program is an extension module for bCAD.");
		System.out.println("It will not run as a stand-alone application.");
	}/*main*/


	public void run(long ctxt)
    {
		Point point1 = new Point();
        Point point2 = new Point();
		
		float left = LeftBottom.getX();
		float right = RightTop.getX();
	        float bottom = LeftBottom.getY();
        	float top = RightTop.getY();

		//Saving editor state				
		holdEditor(ctxt);
				
				
        if (DrawGrid == true)
		//Draw grid
        {
			setLineWidth(ctxt, 0.5f);
			setColor(ctxt, 5);

            	//Horizontal lines
            bottom = LeftBottom.getY() + (top - LeftBottom.getY())/2;
            while (bottom  < RightTop.getY()) 
            {
				point1.assign(left, bottom, 0);
                point2.assign(right, bottom, 0);
                createLine(ctxt, point1.value, point2.value);
                bottom+=GridStep;
            }
            bottom = LeftBottom.getY() + (top - LeftBottom.getY())/2;
            while (bottom > LeftBottom.getY())
            {
				point1.assign(left, bottom, 0);
                point2.assign(right, bottom, 0);
                createLine(ctxt, point1.value, point2.value);
                bottom-=GridStep;
            }
            //Vertical lines
            bottom = LeftBottom.getY();
            while (left < RightTop.getX())
            {
	            point1.assign(left, top, 0);
                point2.assign(left, bottom, 0);
                createLine(ctxt, point1.value, point2.value);
                left+=GridStep;
			}

			//Notify bCAD to keep our drawing
			fixState(ctxt);
        }


		//Draw coordinate axes
		left = LeftBottom.getX();
        right = RightTop.getX();
        bottom = LeftBottom.getY();
        top = RightTop.getY();
		setLineWidth(ctxt, 1.5f);
		setColor(ctxt, 0);
			
        point1.assign(left, top, 0);
        createLine(ctxt, LeftBottom.value, point1.value);

        //draw small arrow on y-axis
        point2.assign(point1);
        point2.add(-5,-5,0);
        createLine(ctxt, point2.value, point1.value);
        point2.assign(point1);
        point2.add(5,-5,0);
        createLine(ctxt, point2.value, point1.value);

		point1.assign(right, bottom + ((top - bottom)/2) ,0);
        point2.assign(left, bottom + ((top - bottom)/2) ,0);
        createLine(ctxt, point1.value, point2.value);

		//draw small arrow on x-axis
        point2.assign(point1);
        point2.add(-5,-5,0);
		createLine(ctxt, point2.value, point1.value);
        point2.assign(point1);
        point2.add(-5,5,0);
        createLine(ctxt, point2.value, point1.value);
        fixState(ctxt);

		//Draw axes names
		point1.assign(LeftBottom.getX(), RightTop.getY(),0);
		point1.add(-10,0,0);
		createText2D(ctxt, point1.value,"U");

		point1.assign(RightTop.getX(), LeftBottom.getY(), 0);
		point1.add(0,-10,0);
		createText2D(ctxt, point1.value,"t");
		fixState(ctxt);


		//Plot a graph
		setLineWidth(ctxt, 2f);
		setColor(ctxt, 1);

		left = LeftBottom.getX();
        right = RightTop.getX();
        bottom = LeftBottom.getY();
        top = RightTop.getY();
        float x = 0;
		//Remember that argument must be in radians. Also keep in mind
		//that you must explicitly convert double result of Math functions
		//to float.
        float y = k*(float)Math.sin(l*3.1415926*x/90);
        point1.assign(x + left, y + (top + bottom)/2, 0);
        while (x < (right - left))
        {
			x+=PlotStep;
            y = k*(float)Math.sin(l*3.1415926*x/90);
            point2.assign(x + left, y + (top + bottom)/2,0);
            createLine(ctxt,point1.value, point2.value);
            point1.assign(point2);
        }
        fixState(ctxt);

		//Plot one more graph on same plane
		setLineWidth(ctxt, 2f);
		setColor(ctxt, 13);

		left = LeftBottom.getX();
        right = RightTop.getX();
        bottom = LeftBottom.getY();
        top = RightTop.getY();
        x = 0;
		//Remember that argument must be in radians. Also keep in mind
		//that you must explicitly convert double result of Math function
		//to float.
        y =(float) (k*Math.cos(l*3.1415926*x/90)*Math.random()); 
		point1.assign(x + left, y + (top + bottom)/2, 0);
        while (x < (right - left))
        {
			x+=PlotStep;
            y =(float) (k*Math.cos(l*3.1415926*x/90)*Math.random());
            point2.assign(x + left, y + (top + bottom)/2,0);
            createLine(ctxt,point1.value, point2.value);
            point1.assign(point2);
        }
        fixState(ctxt);

		//And last but not the least - we plot a descriptive message above the plane

		setLineWidth(ctxt, 1f);
		setColor(ctxt, 1);
		point1.assign(left, top + 20, 0);
		createText2D(ctxt, point1.value, "Example of function plotting in bCAD");

		//Restore editor state
		fetchEditor(ctxt);
    }/*run*/

}/*class FunctionPlot*/

/** 
 Class Point defines a point with 3 coordinates. It implements several
 methods for  manipulating point coordinates and also returns float[] data
 for bCAD API methods. Such classes are usually called "class wrappers"
 */

class Point
{
	public float value[] = new float[3];	// value necessary for bCAD API calls

	public Point()							// constructor
	{
		this(0,0,0);
	}

	public Point(float x, float y, float z)	// constructor
	{
		value[0] = x;
		value[1] = y;
		value[2] = z;
	}

	public void assign(float x, float y, float z)	// assigns coordinates
	{
		value[0] = x;
		value[1] = y;
		value[2] = z;
	}
	
	public void assign(Point p)	// gets coordinates from another Point
	{
		value[0] = p.getX();
		value[1] = p.getY();
		value[2] = p.getZ();
	}
	
	public void add(float dx, float dy, float dz) // adjust existing values
	{
		value[0] += dx;
		value[1] += dy;
		value[2] += dz;
	}
	
	public float getX()	// returns X coordinate
	{
		return value[0];
	}
	
	public float getY()	// returns Y coordinate
	{
		return value[1];
	}
	
	public float getZ() // returns Z coordinate
	{
		return value[2];
	}

}/*class Point*/

