/*	file	:	Hello.java
 *	author	:	Oleg Ovechkin
 *	date	:	18 April 1997
 *
 *	desc	:	Example application demonstrates the technique to
 *				program bCAD by Java means
 *
 *	remark	:	It seems giving the name "Hello" used to be a good old 
 *				tradition in programmer's practice :)
 */

/*	Attention!!!
 *	All angular values defined in radians
 */

class Hello extends bCAD	/* derive class from bCAD class	*/
{

	public Hello(){};		/* constructor must be public	*/

	public void bcadmain(long ctxt, float x, float y, float z)	/*	entry point			*/
	{

	int color = 0;
	setColor(ctxt, color++);

/*	2D primitives creation  */

		float[] start	= {45.0F, 35.0F, 0.0F};
		float[] end		= {45.0F, 95.0F, 0.0F};

		/*	Lets create line segment starting at <start> and 
			ending at <end>	*/
		createLine(ctxt, start, end);

		/*	Fixing the state guarantees that even something wrong
			will happen later this portion of drawing is fixed by bCAD	*/
		fixState(ctxt);

		float[] base = {70.0F, 50.0F, 0.0F};
		float length = 40.0F;

		/*	Line parallel to <start> - <end> vector starting at <base> with 
			<length> length	*/
		createLineP(ctxt, base, length, start, end);
		fixState(ctxt);

		/*	Line orthogonal to <start> - <end> vector starting at <base>
			with -<length> length */
		createLineO(ctxt, base, -length, start, end);
		fixState(ctxt);

		/*	Polyline...	*/
		float[] vertices_triples = {
						 20.0F,  20.0F, 50.0F,	/*	first vertex	*/
						 30.0F, 120.0F, 50.0F,	/*	second vertex	*/
						120.0F, 120.0F, 50.0F,	/*	third vertex	*/
						130.0F,  20.0F, 50.0F,	/*	fourth vertex	*/
						 20.0F,  20.0F, 50.0F	/*	last vertex		*/
		};

	setColor(ctxt, color++);

		createPLine(ctxt, vertices_triples);
		fixState(ctxt);

		/*	Rectangle..	*/
		float[] ld = {148.0F, 28.0F, 0.0F};	/*	Left down corner		*/
		float	w = 54F;					/*	wigth, may be negative	*/
		float	h = 44F;					/*	height, may be negative too	*/

		createRect(ctxt, ld, w, h);
		fixState(ctxt);

		/*	Create some Regular polygons...	*/
		float[] c = {180.0F, 50.0F, 0.0F};	/*	center 	*/
		float	r = 30.0F;					/*	radius	*/
		float	a = 0.0F;					/*	first vertex will be placed 
											 *	in <a> angle relatively 0X 
											 *	axis
											 */

		for (int i = 0; i < 5; ++i)
		{
			c[0] += 60F;
			createRegularP(ctxt, c, r, a + i * 0.3F, i + 3);
			fixState(ctxt);
		}

		/*	Okay, the next figure is Circle...	*/
		float[] circle_center = {165.0F, 110.0F, 0.0F};
		float	circle_radius = 33;

	setColor(ctxt, color++);

		/*	Circle by center and radius...	*/
		createCircleA(ctxt, circle_center, circle_radius);
		fixState(ctxt);

		float[] v0 = {210.0F, 110.0F, 0.0F};
		float[] v1 = {270.0F,  90.0F, 0.0F};
		float[] v2 = {240.0F,  80.0F, 0.0F};
	
		/*	Circle by free vertices...	*/
		createCircleB(ctxt, v0, v1, v2);
		fixState(ctxt);

	setColor(ctxt, color++);

	setLineWidth(ctxt, 3.0F);

		/*	Ellipse...	*/
		float[] ellipse_center = {350.0F,  120.0F, 0.0F};
		float	ellipse_radius0 = 60F;
		float	ellipse_radius1	= 25F;
		float	ellipse_angle	= 0.3F;	/*	angle between 0X axis and the 
										 *	axis of the ellipse corresponding
										 *	<ellipse_radius0>, in this case
										 */

		createEllipse(ctxt, ellipse_center, 
					ellipse_radius0, ellipse_radius1, ellipse_angle);
		fixState(ctxt);

		/*	Arc...	*/
		float[]	arc_center = {450.0F,  100.0F, 0.0F};
		float	arc_radius = 40F;
		float	arc_start_angle	= 0.5F;
		float	arc_end_angle	= 2.5F;

		createArcA(ctxt, arc_center, arc_radius, 
				arc_start_angle, arc_end_angle);
		fixState(ctxt);

		/*	Lets "type" some text...	*/
		float[]	text_start = {20.0F,  170.0F, 0.0F};
		createText2D(ctxt, text_start, 
				"The Quick Brown Fox Jumps Over The Lazy Dog. 1234567890");
		fixState(ctxt);

/* 3D primitives creation	*/

	setColor(ctxt, color++);

		/*	Box...	*/
		float[]	box_start = {100.0F,  200.0F, -50.0F};
		float	box_width	= -70.0F;
		float	box_height	= 30.0F;
		float	box_depth	= 100.0F;
		int		box_width_detail	= 2;
		int		box_height_detail	= 1;
		int		box_depth_detail	= 4;

		createBox(ctxt, box_start, box_width, box_height, box_depth,
					box_width_detail, box_height_detail, box_depth_detail);
		fixState(ctxt);

		/*	Plane...	*/
		float[]	plane_start		= {120.0F,  200.0F, 0.0F};
		float	plane_width		= 80.0F;
		float	plane_height	= 45.0F;
		int		plane_width_detail	= 5;
		int		plane_height_detail	= 6;

		createPlane(ctxt, plane_start, plane_width, plane_height,
					plane_width_detail, plane_height_detail);
		fixState(ctxt);

		/*	Sphere...	*/
		float[]	sphere_center	=	{250.0F,  230.0F, 0.0F};
		float	sphere_radius	=	35.0F;
		int		sphere_M		=	12;
		int		sphere_N		=	24;

		createSphere(ctxt, sphere_center, sphere_radius,
				sphere_M, sphere_N);
		fixState(ctxt);

	setColor(ctxt, color++);

		/*	Dome...	*/
		float[]	dome_center	=	{330.0F,  230.0F, 0.0F};
		float	dome_radius	=	35.0F;
		int		dome_M		=	7;
		int		dome_N		=	7;
		int		dome_cap	=	1;	/*	1 - create cap; 0 - do NOT create	*/

		createDome(ctxt, dome_center, dome_radius, 
					dome_M, dome_N, dome_cap);
		fixState(ctxt);

	setColor(ctxt, color++);

		/*	Dish...	*/
		float[]	dish_center	=	{410.0F,  230.0F, 0.0F};
		float	dish_radius	=	35.0F;
		int		dish_M		=	15;
		int		dish_N		=	15;
		int		dish_cap	=	0;	/*	1 - create cap; 0 - do NOT create	*/

		createDish(ctxt, dish_center, dish_radius, 
					dish_M, dish_N, dish_cap);
		fixState(ctxt);

	setColor(ctxt, color++);

		/*	Cone...	*/
		float[]	cone_start_axis = { 20.0F, 280.0F, -10.0F};
		float[]	cone_end_axis	= {100.0F, 310.0F,  10.0F};
		float	cone_start_radius	= 10.0F;
		float	cone_end_radius		= 40.0F;
		int		cone_start_cap		= 1;
		int		cone_end_cap		= 0;
		int		cone_N				= 24;

		createCone(ctxt, cone_start_axis, cone_end_axis, 
			cone_start_radius, cone_end_radius, 
			cone_start_cap, cone_end_cap, cone_N);
		fixState(ctxt);

	setColor(ctxt, color++);

		/*	Torus...	*/
		float[]	torus_center = {190.0F, 310.0F,  10.0F};
		float	torus_big_radius	= 30.0F;
		float	torus_small_radius	= 15.0F;
		int		torus_M				= 8;
		int		torus_N				= 16;

		createTorus(ctxt, torus_center, torus_big_radius, torus_small_radius,
					torus_M, torus_N);
		fixState(ctxt);


	setColor(ctxt, color++);

		/* Mesh by array of verices...	*/
		float[] mesh_array_of_vertices = {	

						/*	N == 1	*/
						300.0F,	300.0F,    0.0F,	/* M == 1	*/
						320.0F, 300.0F,   20.0F,	/* M == 2	*/ 
						340.0F, 300.0F,   10.0F,	/* M == 3	*/ 
						360.0F, 300.0F,    5.0F,	/* M == 4	*/ 

						/*	N == 2	*/
						300.0F,	320.0F,	  -5.0F,	/* M == 1	*/
						320.0F, 320.0F,   10.0F,	/* M == 2	*/ 
						340.0F, 320.0F,   10.0F,	/* M == 3	*/ 
						360.0F, 320.0F,   -5.0F, 	/* M == 4	*/

						/*	N == 3	*/
						300.0F,	340.0F,	  10.0F,	/* M == 1	*/
						320.0F, 340.0F,    5.0F, 	/* M == 2	*/
						340.0F, 340.0F,   10.0F, 	/* M == 3	*/
						360.0F, 340.0F,    0.0F, 	/* M == 4	*/

						/*	N == 4	*/
						300.0F,	360.0F,	   0.0F,	/* M == 1	*/
						320.0F, 360.0F,   10.0F, 	/* M == 2	*/
						340.0F, 360.0F,   30.0F, 	/* M == 3	*/
						360.0F, 360.0F,    0.0F, 	/* M == 4	*/
					};
		int		mesh_M	= 4;
		int		mesh_N	= 4;

		createMesh(ctxt, mesh_array_of_vertices ,mesh_M, mesh_N);
		fixState(ctxt);

		fetchEditor(ctxt);
	}
}