/*
 * (c) Copyright 1996, KL GROUP INC.
 * ALL RIGHTS RESERVED
 *
 * This file is provided for demonstration and educational uses only.
 * Permission to use, copy, modify and distribute this file for
 * any purpose and without fee is hereby granted, provided that the
 * above copyright notice and this permission notice appear in all
 * copies, and that the name of KL Group not be used in advertising
 * or publicity pertaining to this material without the specific,
 * prior written permission of an authorized representative of
 * KL Group.
 *
 * KL GROUP MAKES NO REPRESENTATIONS AND EXTENDS NO WARRANTIES, EX-
 * PRESS OR IMPLIED, WITH RESPECT TO THE SOFTWARE, INCLUDING, BUT
 * NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR ANY PARTICULAR PURPOSE, AND THE WARRANTY AGAINST IN-
 * FRINGEMENT OF PATENTS OR OTHER INTELLECTUAL PROPERTY RIGHTS.  THE
 * SOFTWARE IS PROVIDED "AS IS", AND IN NO EVENT SHALL KL GROUP OR
 * ANY OF ITS AFFILIATES BE LIABLE FOR ANY DAMAGES, INCLUDING ANY
 * LOST PROFITS OR OTHER INCIDENTAL OR CONSEQUENTIAL DAMAGES
 * RELATING TO THE USE OF THIS SOFTWARE.
 */

//   RCSID -- $RCSfile: JCTitlePanel.java $ $Revision: 1.1 $
//            $Date: 1996/12/30 02:02:52 $  $Locker: $  KL Group Inc.

package jclass.contrib;
import java.awt.*;

/**
 * JCTitlePanel is an implementation of a panel that comes with
 * an outline and a title. It is small, and produces a good display.
 * To use JCTitlePanel, create a JCTitlePanel object, then
 * add items to the JCTitlePanel.drawArea. The following is an example:
 * <PRE>
   JCTitlePanel top = new JCTitlePanel("Cell Values", null);
   top.drawArea.setLayout(new JCRowColLayout(1, -1));
   top.drawArea.add(new Label("This is inside the panel"));
 * </PRE>
 */
public class JCTitlePanel extends Panel {
	/**
	 * The panel that should be used by users for drawing.
	 */
	public JCOutlinePanel drawArea = null;

/**
 * This is the constructor.
 *
 * @param title the title of the title panel
 * @param align the alignment of the title; if the alignment is
 *              "Right", the title is right-justified, otherwise,
 *              the title is left-justified
 */
public JCTitlePanel(String title, String align) {
	setLayout(new JCRowColLayout(2, -1));
	Label tl = new Label(title);
	if (align != null && align.equals("Right")) {
		tl.setAlignment(Label.RIGHT);
	}
	add(tl);
	drawArea = new JCOutlinePanel();
	add(drawArea);
}

/**
 * A convenience function for creating a title panel that is either laid out
 * vertically or horizontally. It saves on the .class file size.
 * This was used in the creation of the spreadsheet demo, in particular, with
 * the vertical and horizontal radio button groups.
 *
 * @param parent the parent panel
 * @param title the title of the panel
 * @param horz if true, the panel is laid out horizontally; otherwise,
 *             it is laid out vertically
 */
public static JCTitlePanel
makeTitlePanel(Panel parent, String title, boolean horz) {
    JCTitlePanel p = new JCTitlePanel(title, null);
    if (horz) {
        p.drawArea.setLayout(new JCRowColLayout(1, -1, 5, 5));
    }
    else {
        p.drawArea.setLayout(new JCRowColLayout(-1, 1, 5, 5));
    }
    parent.add(p);
    return p;
}

}
