/*****************************************************************************
 *
 * (c) Copyright 1996, KL GROUP INC.
 * ALL RIGHTS RESERVED
 *
 *  THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED
 * AND COPIED ONLY IN ACCORDANCE WITH THE TERMS OF SUCH LICENSE AND
 * WITH THE INCLUSION OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR
 * ANY OTHER COPIES THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE
 * AVAILABLE TO ANY OTHER PERSON.  NO TITLE TO AND OWNERSHIP OF THE
 * SOFTWARE IS HEREBY TRANSFERRED.
 *
 *  THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT
 * NOTICE AND SHOULD NOT BE CONSTRUED AS A COMMITMENT BY KL GROUP INC.
 * OR ITS THIRD PARTY SUPPLIERS.
 *
 *  KL GROUP INC. AND ITS THIRD PARTY SUPPLIERS, ASSUME NO RESPONSIBILITY
 * FOR THE USE OR INABILITY TO USE ANY OF ITS SOFTWARE.   THIS SOFTWARE IS
 * PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, AND KL GROUP INC. EXPRESSLY
 * DISCLAIMS ALL IMPLIED WARRANTIES, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 * Notice:  Notwithstanding any other lease or license that may pertain to,
 * or accompany the delivery of, this computer software, the rights of the
 * Government regarding its use, reproduction and disclosure are as set
 * forth in Section 52.227-19 of the FARS Computer Software-Restricted
 * Rights clause.
 *
 * (c) Copyright 1996 KL Group Inc.  Unpublished - all
 * rights reserved under the Copyright laws of the United States.
 *
 * RESTRICTED RIGHTS NOTICE:  Use, duplication, or disclosure by the
 * Government is subject to the restrictions as set forth in subparagraph
 * (c)(1)(ii) of the Rights in Technical Data and Computer Software clause
 * at DFARS 52.227-7013.
 *
 * KL Group Inc.
 * 260 King Street East
 * Suite 300
 * Toronto, Ontario
 * Canada M5A 1K3
 * (416) 594-1026
 * (416) 594-1919 (FAX)
 *
 * RESTRICTED RIGHTS LEGEND:  This computer software is submitted with
 * "restricted rights."  Use, duplication or disclosure is subject to the
 * restrictions as set forth in NASA FAR SUP 18-52.227-79 (April 1985)
 * "Commercial Computer Software- Restricted Rights (April 1985)."  KL Group
 * Inc., 300-260 King Street E., Toronto, Ontario, Canada M5A 1K3.  If
 * the contract contains the Clause at 18-52.227-74 "Rights in Data General"
 * then the "Alternate III" clause applies.
 *
 * (c) Copyright 1996 KL Group Inc.
 * ALL RIGHTS RESERVED
 *
 *****************************************************************************/

//   RCSID -- $RCSfile: JCSpreadLabel.java $ $Revision: 1.2 $
//            $Date: 1997/02/14 14:49:50 $  $Locker: $  KL Group Inc.
package jclass.contrib;

/** JCSpreadLabel contains routines to create a spreadsheet label, for use
 * by JClass LiveTable's JCLabelValueListener
 * @see jclass.table.JCLabelValueListener
 */
public class JCSpreadLabel {

static String symbols = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";

/**
 *  Print a base26 number, with 'length' digits.
 *  These are filled with 'A', the zero value.
 */
private static void
base26(StringBuffer cp, int length, int depth, int value) {
	if (value > 25)	{
		base26(cp, length, depth+1, value/26);
	}
	else {
		while (depth++ < length)
			cp.append(symbols.charAt(0));
	}
	cp.append(symbols.charAt(value%26));
}

/**
 * Make a spreadsheet column label. There are 26 labels of length 1,
 * 26*26 of length 2, etc. In proper base 26, there are 26 of length 1,
 * 26*26-26 of length 2, 26*26*26-26*26+26 of length 3, etc.  This
 * algorithm shifts the number back into the proper range,
 *  calls base26 to format it with the correct number of digits.
 */
private static String
column_label(int value) {
	int i, num;
	StringBuffer buffer = new StringBuffer();

	for (i=0, num=0; value >= 26*(num+1); num=26*(num+1), i++)
		;
	base26(buffer, i+1, 1, value - num);
	return buffer.toString();
}

/**
 * Create a row or column-style spreadsheet label. Rows start at
 * 1, and columns start at A.  Set row to a negative number to
 * convert column values and vice versa.
 * @param row the row number to convert
 * @param column the column number to convert
 * @return Spreadsheet-style row or column label
 */
public static String
create(int row, int column) {
	/* Row label */
	if (column < 0)
		return Integer.toString(row+1);

	/* Column label */
	else
		return column_label(column);
}

}





