
//   RCSID -- $RCSfile: JCRelativeLayout.java $ $Revision: 1.1 $
//            $Date: 1996/12/30 02:02:47 $  $Locker: $  KL Group Inc.

package jclass.contrib;

import java.awt.* ;
import java.util.* ;

/**
Author Jean-Claude Dufourd
Version 3
Date 18.01.96
--------------------------------------
This is for placing components relatively to each other or to the parent
panel with an offset. The offset direction depends intuitively on the
relative position required. 

Relative positions are :
- above
- under
- left
- right
- aboveRight
- underRight
- leftBottom
- rightBottom
- upperLeftCorner
- upperRightCorner
- lowerRightCorner
- lowerLeftCorner
- insideUpperLeft
- insideUpperRight
- insideLowerRight
- insideLowerLeft
- aboveLeft
- underLeft
- leftTop
- rightTop
- insideTop
- insideBottom
- insideRight
- insideLeft
all of which are named after what they implement. Above is centered above the
reference, aboveLeft is same left-aligned...
*************************/

import java.awt.*;
import java.applet.*;

class JCRelativeConstraint {
    Component reference;
    int position, dx, dy;
    
    JCRelativeConstraint( Component ref, char where, int x, int y ) {
	reference = ref;
	position = where;
	dx = x;
	dy = y;
    }
}

public class JCRelativeLayout implements LayoutManager {
    public final static char above = 'A';
    public final static char under = 'B';
    public final static char left = 'C';
    public final static char right = 'D';
    public final static char aboveRight = 'E';
    public final static char underRight = 'F';
    public final static char leftBottom = 'G';
    public final static char rightBottom = 'H';
    public final static char upperLeftCorner = 'I';
    public final static char upperRightCorner = 'J';
    public final static char lowerRightCorner = 'K';
    public final static char lowerLeftCorner = 'L';
    public final static char insideUpperLeft = 'M';
    public final static char insideUpperRight = 'N';
    public final static char insideLowerRight = 'O';
    public final static char insideLowerLeft = 'P';
    public final static char aboveLeft = 'Q';
    public final static char underLeft = 'R';
    public final static char leftTop = 'S';
    public final static char rightTop = 'T';
    public final static char insideTop = 'U';
    public final static char insideBottom = 'V';
    public final static char insideRight = 'W';
    public final static char insideLeft = 'X';

    Dimension d;
    Vector components = new Vector(10,10);
    Vector constraints = new Vector(10,10);

    public JCRelativeLayout(Dimension dim) {
	d = dim;
    }

    public void addLayoutComponent(String name, Component comp) {
	components.addElement( comp );
	constraints.addElement( null );
    }

    public void removeLayoutComponent(Component comp) {
	int i = components.indexOf( comp );
	if (i != -1) {
	    components.removeElementAt( i );
	    constraints.removeElementAt( i );
	}
    }

    public Dimension minimumLayoutSize(Container target) {
	return d;
    }
    
    public Dimension preferredLayoutSize(Container target) {
	return d;
    }

    public void setConstraint( Component self, Component ref, char where, int dx, int dy ) {
	int i = components.indexOf( self );
	// ignore unknown components
	if (i != -1) {
	    JCRelativeConstraint c = new JCRelativeConstraint( ref, where, dx, dy );
	    constraints.setElementAt( c, i );
	}
    }

    public void layoutContainer(Container target) {
	Enumeration e = components.elements();
	Rectangle oneBounds, referenceBounds, targetBounds = target.bounds();
	Insets insets = target.insets();
	JCRelativeConstraint constr;
	Dimension d;
	Component c;
	int i = -1;
	targetBounds.x = targetBounds.x + insets.left ;
	targetBounds.y = targetBounds.y + insets.top ;
	while (e.hasMoreElements()) {
	    i = i + 1;
	    constr = (JCRelativeConstraint)constraints.elementAt( i );
	    c = (Component)e.nextElement();
	    d = c.preferredSize();
	    oneBounds = c.bounds();
	    if (constr.reference == null) referenceBounds = targetBounds;
	    else referenceBounds = constr.reference.bounds();
	    switch (constr.position) {
	      case above:
		c.reshape( referenceBounds.x + referenceBounds.width/2 - oneBounds.width/2 + constr.dx, 
			   referenceBounds.y - constr.dy - oneBounds.height,
			   d.width, d.height ); 
		break;
	      case under:
		c.reshape( referenceBounds.x + referenceBounds.width/2 - oneBounds.width/2 + constr.dx, 
			   referenceBounds.y + constr.dy + referenceBounds.height,
			   d.width, d.height ); 
		break;
	      case left:
		c.reshape( referenceBounds.x - constr.dx - oneBounds.width, 
			   referenceBounds.y + referenceBounds.height/2 - oneBounds.height/2 + constr.dy,
			   d.width, d.height ); 
		break;
	      case right:
		c.reshape( referenceBounds.x + constr.dx + referenceBounds.width, 
			   referenceBounds.y + referenceBounds.height/2 - oneBounds.height/2 + constr.dy,
			   d.width, d.height ); 
		break;
	      case aboveRight:
		c.reshape( referenceBounds.x + referenceBounds.width - oneBounds.width - constr.dx, 
			   referenceBounds.y - constr.dy - oneBounds.height,
			   d.width, d.height );
		break;
	      case underRight:
		c.reshape( referenceBounds.x + referenceBounds.width - oneBounds.width - constr.dx, 
			   referenceBounds.y + constr.dy + referenceBounds.height,
			   d.width, d.height );
		break;
	      case leftBottom:
		c.reshape( referenceBounds.x - constr.dx - oneBounds.width, 
			   referenceBounds.y + referenceBounds.height - oneBounds.height - constr.dy,
			   d.width, d.height ); 
		break;
	      case rightBottom:
		c.reshape( referenceBounds.x + constr.dx + referenceBounds.width, 
			   referenceBounds.y + referenceBounds.height - oneBounds.height - constr.dy,
			   d.width, d.height ); 
		break;
	      case upperLeftCorner:
		c.reshape( referenceBounds.x - constr.dx - oneBounds.width, 
			   referenceBounds.y - constr.dy - oneBounds.height,
			   d.width, d.height );
		break;
	      case upperRightCorner:
		c.reshape( referenceBounds.x + referenceBounds.width + constr.dx, 
			   referenceBounds.y - constr.dy - oneBounds.height,
			   d.width, d.height );
		break;
	      case lowerRightCorner:
		c.reshape( referenceBounds.x + referenceBounds.width + constr.dx, 
			   referenceBounds.y + constr.dy + referenceBounds.height,
			   d.width, d.height );
		break;
	      case lowerLeftCorner:
		c.reshape( referenceBounds.x - oneBounds.width - constr.dx, 
			   referenceBounds.y + constr.dy + referenceBounds.height,
			   d.width, d.height );
		break;
	      case insideUpperLeft:
		c.reshape( referenceBounds.x + constr.dx,
			   referenceBounds.y + constr.dy,
			   d.width, d.height ); 
		break;
	      case insideUpperRight:
		c.reshape( referenceBounds.x + referenceBounds.width - oneBounds.width - constr.dx,
			   referenceBounds.y + constr.dy,
			   d.width, d.height );
		break;
	      case insideLowerRight:
		c.reshape( referenceBounds.x + referenceBounds.width - oneBounds.width - constr.dx,
			   referenceBounds.y + referenceBounds.height - oneBounds.height - constr.dy,
			   d.width, d.height ); 
		break;
	      case insideLowerLeft:
		c.reshape( referenceBounds.x + constr.dx,
			   referenceBounds.y + referenceBounds.height - oneBounds.height - constr.dy,
			   d.width, d.height ); 
		break;
	      case aboveLeft:
		c.reshape( referenceBounds.x + constr.dx, 
			   referenceBounds.y - constr.dy - oneBounds.height,
			   d.width, d.height ); 
		break;
	      case underLeft:
		c.reshape( referenceBounds.x + constr.dx,
			   referenceBounds.y + constr.dy + referenceBounds.height,
			   d.width, d.height ); 
		break;
	      case leftTop:
		c.reshape( referenceBounds.x - constr.dx - oneBounds.width,
			   referenceBounds.y + constr.dy,
			   d.width, d.height ); 
		break;
	      case rightTop:
		c.reshape( referenceBounds.x + constr.dx + referenceBounds.width,
			   referenceBounds.y + constr.dy,
			   d.width, d.height ); 
		break;
	      case insideTop:
		c.reshape( referenceBounds.x + referenceBounds.width/2 - oneBounds.width/2 + constr.dx, 
			   referenceBounds.y + constr.dy,
			   d.width, d.height ); 
		break;
	      case insideBottom:
		c.reshape( referenceBounds.x + referenceBounds.width/2 - oneBounds.width/2 + constr.dx, 
			   referenceBounds.y - constr.dy + referenceBounds.height - oneBounds.height,
			   d.width, d.height ); 
		break;
	      case insideLeft:
		c.reshape( referenceBounds.x + constr.dx, 
			   referenceBounds.y + referenceBounds.height/2 - oneBounds.height/2 + constr.dy,
			   d.width, d.height ); 
		break;
	      case insideRight:
		c.reshape( referenceBounds.x - constr.dx + referenceBounds.width - oneBounds.width, 
			   referenceBounds.y + referenceBounds.height/2 - oneBounds.height/2 + constr.dy,
			   d.width, d.height ); 
		break;
	      default:
		c.reshape( 0, 0, d.width, d.height );
		break;
	    }
	}
    }
}


