/*
 * (c) Copyright 1996, KL GROUP INC.
 * ALL RIGHTS RESERVED
 *
 * This file is provided for demonstration and educational uses only.
 * Permission to use, copy, modify and distribute this file for
 * any purpose and without fee is hereby granted, provided that the
 * above copyright notice and this permission notice appear in all
 * copies, and that the name of KL Group not be used in advertising
 * or publicity pertaining to this material without the specific,
 * prior written permission of an authorized representative of
 * KL Group.
 *
 * KL GROUP MAKES NO REPRESENTATIONS AND EXTENDS NO WARRANTIES, EX-
 * PRESS OR IMPLIED, WITH RESPECT TO THE SOFTWARE, INCLUDING, BUT
 * NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR ANY PARTICULAR PURPOSE, AND THE WARRANTY AGAINST IN-
 * FRINGEMENT OF PATENTS OR OTHER INTELLECTUAL PROPERTY RIGHTS.  THE
 * SOFTWARE IS PROVIDED "AS IS", AND IN NO EVENT SHALL KL GROUP OR
 * ANY OF ITS AFFILIATES BE LIABLE FOR ANY DAMAGES, INCLUDING ANY
 * LOST PROFITS OR OTHER INCIDENTAL OR CONSEQUENTIAL DAMAGES
 * RELATING TO THE USE OF THIS SOFTWARE.
 */
//   RCSID -- $RCSfile: JCChoice.java $ $Revision: 1.1 $
//            $Date: 1996/12/30 02:02:44 $  $Locker: $  KL Group Inc.

package jclass.contrib;
import java.awt.Choice;

/**
 * JCChoice extends the AWT Choice class to associate values
 * with the chosen items. The following is an example of how
 * it can be used: <P>
 * <PRE>
 *  String bTypeStrings[] = { "Shadow In", "Shadow Out", "Etched In" };
 *  JCChoice bTypeC;
 *  int bTypeValues[] = { JCEnum.BORDER_IN, JCEnum.BORDER_OUT,
 *                        JCEnum.BORDER_ETCHED_IN };
 *
 *  bTypeC = new JCChoice(bTypeStrings, bTypeValues);
 *  bTypeC.setCurrent(JCEnum.BORDER_OUT);
 * </PRE>
 */
public class JCChoice extends Choice {

/** An array of values in the choice. */
int values[] = null;

/** Constructs an empty Component. */
public JCChoice() {
	super();
}

/**
 * This constructor takes an array of strings for the individual
 * items and an array of values to associate with the strings.
 *
 * @param items an array of strings to appear in the choice
 * @param vals  the values to be associated with each choice
 */
public JCChoice(String items[], int vals[]) {
	super();
	if (vals != null)
		values = new int[Math.min(items.length, vals.length)];
	for (int i = 0; i < items.length; i++) {
		addItem(items[i]);
		if (vals != null)
			values[i] = vals[i];
	}
}

/**
 * When a JCChoice is created, it is given an array of values to
 * associate with each choice string. This function takes a
 * value and sets the current item in the choice to be the
 * item associated with the value.
 */
public void setValue(int value) {
	if (values == null) return;

	int i = 0;
	for (i = 0; i < values.length; i++)
		if (values[i] == value) break;
	if (i < values.length)
		select(i);
}

/** Returns the value corresponding to the current choice. */
public int getValue() {
	// Let it throw errors
	return values[getSelectedIndex()];
}

}
