/*
 * (c) Copyright 1997, KL GROUP INC.  
 * ALL RIGHTS RESERVED 
 *
 * This file is provided for demonstration and educational uses only.
 * Permission to use, copy, modify and distribute this file for
 * any purpose and without fee is hereby granted, provided that the
 * above copyright notice and this permission notice appear in all
 * copies, and that the name of KL Group not be used in advertising
 * or publicity pertaining to this material without the specific,
 * prior written permission of an authorized representative of
 * KL Group.
 *
 * KL GROUP MAKES NO REPRESENTATIONS AND EXTENDS NO WARRANTIES, EX-
 * PRESS OR IMPLIED, WITH RESPECT TO THE SOFTWARE, INCLUDING, BUT
 * NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR ANY PARTICULAR PURPOSE, AND THE WARRANTY AGAINST IN-
 * FRINGEMENT OF PATENTS OR OTHER INTELLECTUAL PROPERTY RIGHTS.  THE
 * SOFTWARE IS PROVIDED "AS IS", AND IN NO EVENT SHALL KL GROUP OR
 * ANY OF ITS AFFILIATES BE LIABLE FOR ANY DAMAGES, INCLUDING ANY
 * LOST PROFITS OR OTHER INCIDENTAL OR CONSEQUENTIAL DAMAGES 
 * RELATING TO THE USE OF THIS SOFTWARE.
 */
//   RCSID -- $RCSfile: ContribDialog.java $ $Revision: 1.1 $  $Date: 1997/02/12 15:48:39 $ $Locker: $  KL Group Inc.

package jclass.contrib;
import java.awt.*;

/**
 * ContribDialog is a Dialog subclass which responds to WINDOW_CLOSE events,
 * and sets the focus to its first child.
 * The default layout for a dialog is BorderLayout.
 */
public class ContribDialog extends Dialog {

/**
 * Constructs an initially invisible Dialog. A modal
 * Dialog grabs all the input from the user.
 * @param parent the owner of the dialog
 * @param modal if true, dialog blocks input to other windows when shown
 */
public ContribDialog(Frame parent, boolean modal) {
	super(parent, modal);
}

/**
 * Constructs an initially invisible Dialog with a title. 
 * A modal Dialog grabs all the input from the user.
 * @param parent the owner of the dialog
 * @param title the title of the dialog
 * @param modal if true, dialog blocks input to other windows when shown
 */
public ContribDialog(Frame parent, String title, boolean modal) {
	super(parent, title, modal);
}

/** 
 * Adds the specified component to this dialog in the "Center" position.
 */
public Component add(Component comp) {
	Component c = super.add(comp);
	if (getLayout() instanceof BorderLayout)
	    getLayout().addLayoutComponent("Center", comp);
	return c;
}

/** Returns true if the component is traversable. */
private static boolean isTraversable(Component comp) {
	if (comp instanceof Scrollbar)
		return false;
	else if (comp instanceof Container) {
		Component[] child = ((Container)comp).getComponents();
		for (int i=0; i < child.length; i++)
			if (isTraversable(child[i])) 
				return true;
		return false;
	}
	else 
		return comp.isShowing() && comp.isEnabled();
}

/** Returns the first child which can accept keyboard focus. */
public Component getFirstChild() {
	return getFirstChild(this);
}

/** Returns the first child which can accept keyboard focus. */
private static Component getFirstChild(Container comp) {
	if (!comp.isVisible())
		return null;
	Component[] child = comp.getComponents();
	for (int i=0; i < child.length; i++) {
		if (child[i] instanceof Container) {
			Component c = getFirstChild((Container)child[i]);
			if (c != null) return c;
		}
		else
			if (isTraversable(child[i])) return child[i];
	}
	return null;
}

/** Sets the focus to the first child. */
public synchronized void show() {
    super.show();
	Component child = getFirstChild(this);
	if (child != null)
		child.requestFocus();
}

/** Calls hide if a WINDOW_DESTROY event is passed.
 */
public boolean handleEvent(Event ev) {
	if (ev.id == Event.WINDOW_DESTROY) {
		hide();
		return true;
	}
	return super.handleEvent(ev);
}

}
