/*
 * (c) Copyright 1997, KL GROUP INC.  
 * ALL RIGHTS RESERVED 
 *
 * This file is provided for demonstration and educational uses only.
 * Permission to use, copy, modify and distribute this file for
 * any purpose and without fee is hereby granted, provided that the
 * above copyright notice and this permission notice appear in all
 * copies, and that the name of KL Group not be used in advertising
 * or publicity pertaining to this material without the specific,
 * prior written permission of an authorized representative of
 * KL Group.
 *
 * KL GROUP MAKES NO REPRESENTATIONS AND EXTENDS NO WARRANTIES, EX-
 * PRESS OR IMPLIED, WITH RESPECT TO THE SOFTWARE, INCLUDING, BUT
 * NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR ANY PARTICULAR PURPOSE, AND THE WARRANTY AGAINST IN-
 * FRINGEMENT OF PATENTS OR OTHER INTELLECTUAL PROPERTY RIGHTS.  THE
 * SOFTWARE IS PROVIDED "AS IS", AND IN NO EVENT SHALL KL GROUP OR
 * ANY OF ITS AFFILIATES BE LIABLE FOR ANY DAMAGES, INCLUDING ANY
 * LOST PROFITS OR OTHER INCIDENTAL OR CONSEQUENTIAL DAMAGES 
 * RELATING TO THE USE OF THIS SOFTWARE.
 */
// RCSID -- $RCSfile: scrolledWindow.java $ $Revision: 1.5 $ $Date: 1997/02/24 15:16:38 $ $Locker: $  KL Group Inc.

package jclass.bwt.examples;
import jclass.bwt.BWTEnum;
import jclass.bwt.JCActionEvent;
import jclass.bwt.JCActionListener;
import jclass.bwt.JCArrowButton;
import jclass.bwt.JCAlignerLayout;
import jclass.bwt.JCButton;
import jclass.bwt.JCContainer;
import jclass.bwt.JCLabel;
import jclass.bwt.JCGroupBox;
import jclass.bwt.JCScrolledWindow;
import jclass.bwt.JCScrollbar;
import jclass.bwt.JCTextField;
import jclass.contrib.ContribFrame;
import jclass.util.JCString;
import java.awt.*;

/**
 * This example demonstrates the use of a JCScrolledWindow.
 */
public class scrolledWindow extends java.applet.Applet 
implements JCActionListener {

JCScrolledWindow window;

public void init() {
	setBackground(Color.lightGray);
	setLayout(null);

	JCContainer main_panel = new JCContainer();
	main_panel.setLayout(new BorderLayout());
	main_panel.setInsets(new Insets(0, 10, 0,10));

	JCLabel label = new JCLabel(null, "../images/klg_logo.gif", this, 0);
	label.setPreferredSize(BWTEnum.NOVALUE, 100);
	main_panel.add("North", label);

	Panel panel = new Panel();
	panel.setLayout(new JCAlignerLayout(2, 10, 10));
	panel.add(new JCLabel("Name:"));
	panel.add(new JCTextField("Harry"));
	panel.add(new JCLabel("Address:"));
	panel.add(new JCTextField("260 King Street"));
	panel.add(new JCLabel("Phone:"));
	panel.add(new JCTextField("416-594-1026"));
	main_panel.add("Center", panel);

	panel = new Panel();
	panel.add(new Button("An AWT button"));
	panel.add(new JCButton(
		   JCString.parse(this, "A [color=red]BWT[color=default] button")));
	main_panel.add("South", panel);

	window = new JCScrolledWindow();
	window.setScrollbarDisplay(BWTEnum.DISPLAY_ALWAYS);
	window.add(main_panel);

	add(window);
	window.reshape(0, 0, 200, 200);

	JCGroupBox nav_box = new JCGroupBox();
	nav_box.setTitle("Navigator", JCGroupBox.CENTER);
	nav_box.setInsets(new Insets(10, 20, 10, 10));
	nav_box.setBackground(Color.lightGray);
	nav_box.setLayout(new jclass.bwt.JCGridLayout(3, 3));

	JCArrowButton arrow[] = new JCArrowButton[4];
	int orient[] = { BWTEnum.UP, BWTEnum.LEFT, BWTEnum.RIGHT, BWTEnum.DOWN };

	for (int i=0; i < 4; i++) {
		arrow[i] = new JCArrowButton(orient[i]);
		arrow[i].addActionListener(this);
		arrow[i].setInitialRepeatDelay(50);
		arrow[i].setPreferredSize(12, 12);
		nav_box.add(new Label());
		nav_box.add(arrow[i]);
	}

	add(nav_box);
	nav_box.reshape(window.size().width+50, 50, 100, 110);
	resize(window.size().width + nav_box.size().width + 50,
		   window.size().height + nav_box.size().height);
}

public void actionPerformed(JCActionEvent ev) {
	JCArrowButton btn = (JCArrowButton) ev.getSource();

	switch (btn.getOrientation()) {
	case BWTEnum.RIGHT:
	case BWTEnum.LEFT:
		JCScrollbar sb = window.getHorizScrollbar();
		int incr = sb.getUnitIncrement();
		if (btn.getOrientation() == BWTEnum.LEFT) 
			incr = -incr;
		window.scrollHorizontal(sb.getValue() + incr);
		break;
	case BWTEnum.DOWN:
	case BWTEnum.UP:
		sb = window.getVertScrollbar();
		incr = sb.getUnitIncrement();
		if (btn.getOrientation() == BWTEnum.UP) 
			incr = -incr;
		window.scrollVertical(sb.getValue() + incr);
	}
}

public Dimension preferredSize() { 
	return new Dimension(super.preferredSize().width, 200);
}

public static void main(String args[]) {
	ContribFrame frame = new ContribFrame("ScrolledWindow");
	scrolledWindow s = new scrolledWindow();
	s.init();

	frame.add(s);
	frame.pack();
	frame.show();
}
}

