/*
 * (c) Copyright 1997, KL GROUP INC.  
 * ALL RIGHTS RESERVED 
 *
 * This file is provided for demonstration and educational uses only.
 * Permission to use, copy, modify and distribute this file for
 * any purpose and without fee is hereby granted, provided that the
 * above copyright notice and this permission notice appear in all
 * copies, and that the name of KL Group not be used in advertising
 * or publicity pertaining to this material without the specific,
 * prior written permission of an authorized representative of
 * KL Group.
 *
 * KL GROUP MAKES NO REPRESENTATIONS AND EXTENDS NO WARRANTIES, EX-
 * PRESS OR IMPLIED, WITH RESPECT TO THE SOFTWARE, INCLUDING, BUT
 * NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR ANY PARTICULAR PURPOSE, AND THE WARRANTY AGAINST IN-
 * FRINGEMENT OF PATENTS OR OTHER INTELLECTUAL PROPERTY RIGHTS.  THE
 * SOFTWARE IS PROVIDED "AS IS", AND IN NO EVENT SHALL KL GROUP OR
 * ANY OF ITS AFFILIATES BE LIABLE FOR ANY DAMAGES, INCLUDING ANY
 * LOST PROFITS OR OTHER INCIDENTAL OR CONSEQUENTIAL DAMAGES 
 * RELATING TO THE USE OF THIS SOFTWARE.
 */
// RCSID -- $RCSfile: scrollbar.java $ $Revision: 1.5 $ $Date: 1997/02/03 21:19:50 $ $Locker: $  KL Group Inc.

package jclass.bwt.examples;
import jclass.bwt.BWTEnum;
import jclass.bwt.JCAdjustmentEvent;
import jclass.bwt.JCAdjustmentListener;
import jclass.bwt.JCLabel;
import jclass.bwt.JCScrollbar;
import jclass.contrib.ContribFrame;
import jclass.util.JCUtilConverter;
import java.awt.*;

/**
 * This example demonstrates the use of a JCScrollbar as a scale.
 */
public class scrollbar extends java.applet.Applet implements JCAdjustmentListener {

JCLabel label;

public void adjustmentValueChanged(JCAdjustmentEvent ev) {
	label.setLabel(""+ev.getValue());
}

public void init() {
	setBackground(Color.lightGray);
	setLayout(new BorderLayout());
	label = new JCLabel();
	label.setAlignment(JCLabel.BOTTOMCENTER);
	add("Center", label);

	JCScrollbar sb = new JCScrollbar(JCScrollbar.HORIZONTAL, 0, 10, 0, 110);
	sb.setPreferredSize(200, BWTEnum.NOVALUE);
	sb.addAdjustmentListener(this);
	sb.setValue(50, true);
	add("South", sb);
}

public Insets insets() {
	return new Insets(5,5,5,5);
}

public static void main(String args[]) {
	ContribFrame frame = new ContribFrame("Scrollbar");
	scrollbar s = new scrollbar();

	s.init();
	frame.add(s);
	frame.pack();
	frame.show();
}
}

