/*
 * (c) Copyright 1997, KL GROUP INC.  
 * ALL RIGHTS RESERVED 
 *
 * This file is provided for demonstration and educational uses only.
 * Permission to use, copy, modify and distribute this file for
 * any purpose and without fee is hereby granted, provided that the
 * above copyright notice and this permission notice appear in all
 * copies, and that the name of KL Group not be used in advertising
 * or publicity pertaining to this material without the specific,
 * prior written permission of an authorized representative of
 * KL Group.
 *
 * KL GROUP MAKES NO REPRESENTATIONS AND EXTENDS NO WARRANTIES, EX-
 * PRESS OR IMPLIED, WITH RESPECT TO THE SOFTWARE, INCLUDING, BUT
 * NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR ANY PARTICULAR PURPOSE, AND THE WARRANTY AGAINST IN-
 * FRINGEMENT OF PATENTS OR OTHER INTELLECTUAL PROPERTY RIGHTS.  THE
 * SOFTWARE IS PROVIDED "AS IS", AND IN NO EVENT SHALL KL GROUP OR
 * ANY OF ITS AFFILIATES BE LIABLE FOR ANY DAMAGES, INCLUDING ANY
 * LOST PROFITS OR OTHER INCIDENTAL OR CONSEQUENTIAL DAMAGES 
 * RELATING TO THE USE OF THIS SOFTWARE.
 */
// RCSID -- $RCSfile: outliner.java $ $Revision: 1.6 $ $Date: 1997/02/12 15:48:58 $ $Locker: $  KL Group Inc.

package jclass.bwt.examples;
import jclass.bwt.BWTEnum;
import jclass.bwt.JCItemEvent;
import jclass.bwt.JCOutliner;
import jclass.bwt.JCOutlinerEvent;
import jclass.bwt.JCOutlinerFolderNode;
import jclass.bwt.JCOutlinerListener;
import jclass.bwt.JCOutlinerNode;
import jclass.bwt.JCOutlinerNodeStyle;
import jclass.contrib.ContribFrame;
import jclass.util.JCUtilConverter;
import jclass.util.JCVector;
import java.awt.*;

/**
 * This example demonstrates the use of a JCOutliner and its events.
 */
public class outliner extends java.applet.Applet implements JCOutlinerListener {

final static String[] column_labels = { 
	"Name", "Title", "Address", "Phone", "Salary" 
};

final static String dept[] = { "Management", "Accounting", "R&D" };

final static String mgmt_items[] = {
"John Kricfalusi|President|983 Nickelodeon Street, Rexdale Ontario|(414) 999-9876|$10,000",
"Hikaru Takei|VP|134 Adelaide Street, Suite 204, Toronto Ontario|(416) 594-1026|$23K",
"James Q. Doohan|Director|1701 Planetia Blvd., Anytown, U.S.A.||$245,000"
};

final static String accounting_items[] = {
"Hikaru I. Takei|Payroll|134 Adelaide Street E., Suite 204, Anytown, U.S.A.|(999) 594-1026",
"Melissa A. Truman|Receivable|475 Woodview Line, Anytown, U.S.A.|(999) 555-9030|$50,250",
"Stephanie L. Truman|Payroll|388 Appleby Road, Anytown, U.S.A.|(999) 555-2642|$85,750"
};

final static String rd_items[] = {
"James Q. Doohan|Engineer|1701 Planetia Blvd., Anytown, U.S.A.||$245,000",
"John F. Kricfalusi|Physicist|983 Nickelodeon Street, Anytown, U.S.A.|(999) 555-9876|$10,000",
"Marc Lenard|Engineer|6 Gene Crescent, Anytown, U.S.A.|(999) 555-1212|$10/hr.",
"Hikaru I. Takei|Musician|134 Adelaide Street E., Suite 204, Anytown, U.S.A.|(999) 594-1026|50%",
"Melissa A. Truman|QA|475 Woodview Line, Anytown, U.S.A.|(999) 555-9030|$50,250",
"Stephanie L. Truman|Technical Writer|388 Appleby Road, Anytown, U.S.A.|(999) 555-2642|$85,750",
"Bill West|System Analyst|1001 Spumco Way, Anytown, U.S.A.|(999) 555-9966|$17,500"
};

final static String[][] item_data = { mgmt_items, accounting_items, rd_items };
Image content_icon;

/** 
 * JCOutlinerListener methods
 */

/*
 * Adds items to a folder if it is opened, and destroys them
 * when it is closed.
 * It simulates the reading of the data from a database.
 */
public void outlinerFolderStateChangeBegin(JCOutlinerEvent ev) {
	JCOutlinerFolderNode folder = (JCOutlinerFolderNode) ev.getNode();
	JCOutliner outliner = (JCOutliner) ev.getSource();

	// Ignore root node
	if (folder == outliner.getRootNode()) 
		return;

	// Create and add children to folder
	else if (ev.getNewState() == BWTEnum.FOLDER_OPEN_ALL) {
		if (folder.getChildren() != null) 
			return;
		int pos = ((Integer)folder.getUserData()).intValue();
		String[] items = item_data[pos];

		JCOutlinerNodeStyle style = new JCOutlinerNodeStyle();
		style.setItemIcon(content_icon);

		for (int i=0; i < items.length; i++) {
			JCVector label = outliner.getConverter()
				.toVector(this, items[i], '|', false);
			JCOutlinerNode newItem = new JCOutlinerNode(label); 
			newItem.setStyle(style);
			folder.addNode(newItem);
		}
	}

	// Destroy folder's nodes
	else if (ev.getNewState() == BWTEnum.FOLDER_CLOSED) {
		folder.setChildren(null);
	}

	outliner.folderChanged(folder);
}

public void outlinerFolderStateChangeEnd(JCOutlinerEvent ev) {}

public void outlinerNodeSelectBegin(JCOutlinerEvent ev) {}
public void outlinerNodeSelectEnd(JCOutlinerEvent ev) {}

public void itemStateChanged(JCItemEvent ev) {}

public void init() {
	Image folder_opened = JCUtilConverter.toImage(this, "../images/foldero.gif");
	Image folder_closed = JCUtilConverter.toImage(this, "../images/folderc.gif");
	Image top = JCUtilConverter.toImage(this, "../images/top.gif");
	content_icon = JCUtilConverter.toImage(this, "../images/content.gif");
	
	// Force outliner to be same size as applet
	setLayout(new GridLayout(1,1));
	setBackground(Color.lightGray);

	JCOutlinerNodeStyle style = new JCOutlinerNodeStyle();
	style.setFolderOpenIcon(top);
	style.setFolderClosedIcon(top);

	JCOutlinerFolderNode root = new JCOutlinerFolderNode(null, "Personnel");
	root.setStyle(style);

	JCOutlinerNodeStyle folder_style = new JCOutlinerNodeStyle();
	folder_style.setFolderClosedIcon(folder_closed);
	folder_style.setFolderOpenIcon(folder_opened);
	folder_style.setShortcut(true);

	JCOutlinerFolderNode f = null;
	for (int i=0; i < dept.length; i++) {
		f = new JCOutlinerFolderNode(null, BWTEnum.FOLDER_CLOSED, dept[i]);
		f.setUserData(new Integer(i));
		f.setStyle(folder_style);
		root.addNode(f);
	}

	JCOutliner outliner = new JCOutliner(root);
	outliner.getOutliner().setBackground(Color.white);
	outliner.setPreferredSize(400, 300);
	outliner.setColumnButtons(column_labels);
	outliner.setNumColumns(column_labels.length);
	outliner.getDefaultNodeStyle().setShortcut(true);
	outliner.addItemListener(this);

	// Open last folder
	outliner.setNodeState(f, BWTEnum.FOLDER_OPEN_ALL, true);

	add(outliner);
}
 
public Insets insets() {
	return new Insets(5,5,5,5);
}

public static void main(String args[]) {
	ContribFrame frame = new ContribFrame("Outliner");
	outliner o = new outliner();

	o.init();
	frame.add(o);
	frame.pack();
	frame.show();
}
}

