/*
 * (c) Copyright 1997, KL GROUP INC.  
 * ALL RIGHTS RESERVED 
 *
 * This file is provided for demonstration and educational uses only.
 * Permission to use, copy, modify and distribute this file for
 * any purpose and without fee is hereby granted, provided that the
 * above copyright notice and this permission notice appear in all
 * copies, and that the name of KL Group not be used in advertising
 * or publicity pertaining to this material without the specific,
 * prior written permission of an authorized representative of
 * KL Group.
 *
 * KL GROUP MAKES NO REPRESENTATIONS AND EXTENDS NO WARRANTIES, EX-
 * PRESS OR IMPLIED, WITH RESPECT TO THE SOFTWARE, INCLUDING, BUT
 * NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR ANY PARTICULAR PURPOSE, AND THE WARRANTY AGAINST IN-
 * FRINGEMENT OF PATENTS OR OTHER INTELLECTUAL PROPERTY RIGHTS.  THE
 * SOFTWARE IS PROVIDED "AS IS", AND IN NO EVENT SHALL KL GROUP OR
 * ANY OF ITS AFFILIATES BE LIABLE FOR ANY DAMAGES, INCLUDING ANY
 * LOST PROFITS OR OTHER INCIDENTAL OR CONSEQUENTIAL DAMAGES 
 * RELATING TO THE USE OF THIS SOFTWARE.
 */
// RCSID -- $RCSfile: multiColumnList.java $ $Revision: 1.5 $ $Date: 1997/02/24 15:16:36 $ $Locker: $  KL Group Inc.

package jclass.bwt.examples;
import jclass.bwt.BWTEnum;
import jclass.bwt.JCMultiColumnList;
import jclass.contrib.ContribFrame;
import java.awt.*;
import java.applet.Applet;

public class multiColumnList extends java.applet.Applet {

final static String[] column_labels = { 
	"Title", "Author", "Price", "Pages", "Publisher"
};

final static int[] alignments = {
	BWTEnum.LEFT, BWTEnum.LEFT, BWTEnum.RIGHT, BWTEnum.RIGHT, BWTEnum.LEFT, 
};

final static String[] data = {
"Presenting Java|"+
"John December|"+
"[color=red]$25.00|"+
"207|"+
"Sams.net",

"The Official Internet World\n60 Minute Guide to Java|"+
"Ed Tittel\n"+
"Mark Gaither|"+
"[color=red]$19.99|"+
"256|"+
"IDG Books",

"Hooked on Java|"+
"Arthur van Hoff\n"+
"Sami Shaio\n"+
"Orca Starbuck|"+
"[color=red]$29.95|"+
"300|"+
"Addison-Wesley",

"Teach Yourself Java in 21 Days|"+
"Laura Lemay\n"+
"Charles L. Perkins|"+
"[color=red]$39.99|"+
"527|"+
"Sams.net",

"Programming with Java!|"+
"Tim Ritchey|"+
"[color=red]$35.00|"+
"389|"+
"New Riders",

"Java in a Nutshell: \nA Desktop Quick Reference\nfor Java Programmers|"+
"David Flanagan|"+
"[color=red]$14.95|"+
"450|"+
"O'Reilly",

"Java Primer Plus|"+
"Paul Tyma\n"+
"Gabriel Torok\n"+
"Troy Downing|"+
"[color=red]$39.99|"+
"600|"+
"Waite Group Press",

"Web Site Programming With Java|"+
"David Harms\n"+
"Barton Fiske\n"+
"Jeffrey Rice|"+
"[color=red]$39.95|"+
"578|"+
"McGraw-Hill",

"Java for C/C++ Programmers|"+
"Michael C. Daconta|"+
"[color=red]$39.95|"+
"500|"+
"John Wiley & Sons, Inc.",

"The Java Sourcebook|"+
"Ed Anuff|"+
"[color=red]$9.95|"+
"450|"+
"John Wiley & Sons, Inc.",

"Active Java|"+
"Adam Freeman\n"+
"Darrel Ince|"+
"[color=red]$25.95|"+
"235|"+
"Addison-Wesley",

"Essential Java:\nDeveloping Interactive Applets|"+
"Jason Manger|"+
"[color=red]$39.95|"+
"352|"+
"McGraw-Hill",

"Java By Example|"+
"Jerry Jackson\n"+
"Alan L. McClellan|"+
"[color=red]$34.95|"+
"345|"+
"SunSoft Press",

"Instant Java|"+
"John A. Pew|"+
"[color=red]$29.95|"+
"340|"+
"SunSoft Press",

"The Java Handbook|"+
"Patrick Naughton|"+
"[color=red]$27.95|"+
"450|"+
"Osborne/McGraw-Hill",

"Core Java|"+
"Gary Cornell\n"+
"Cay S. Horstmann|"+
"[color=red]$39.95|"+
"600|"+
"SunSoft Press",

"Programming JavaScript\nfor Netscape 2.0|"+
"Tim Ritchey|"+
"[color=red]$35.00|"+
"300|"+
"New Riders",

"Teach Yourself Java for Macintosh\nin 21 Days|"+
"Laura Lemay\n"+
"Charles L. Perkins\n"+
"with Timothy Webster|"+
"[color=red]$40.00|"+
"500|"+
"Hayden",

"Java Programming EXplorer|"+
"Neil Bartlett\n"+
"Alex Leslie\n"+
"Steve Simkin|"+
"[color=red]$39.99|"+
"848|"+
"Coriolis Group Books",

"Java Unleashed|"+
"Michael Morrison, et al.|"+
"[color=red]$49.99|"+
"1000|"+
"Sams.net",

"Java Programmer's Library|"+
"Suleiman Lalani\n"+
"Kris Jamsa|"+
"[color=red]$49.95|"+
"556|"+
"Jamsa Press",

"The Complete Idiot's Guide\nto JavaScript|"+
"Aaron Weiss\n"+
"Scott J. Walter|"+
"[color=red]$19.99|"+
"5|"+
"Que",

"The Java Programming Language|"+
"Ken Arnold\n"+
"James Gosling|"+
"[color=red]$34.50|"+
"334|"+
"Addison-Wesley",

"Special Edition: Using Java|"+
"Alex Newman, et al.|"+
"[color=red]$49.99|"+
"869|"+
"Que",

"Java Programming Basics|"+
"Edith Au\n"+
"Dave Makower\n"+
"Pencom Web Works|"+
"[color=red]$34.95|"+
"352|"+
"MIS:Press/M&T Books",

"Java Manual of Style|"+
"Nathan Gurewich\n"+
"Ori Gurewich|"+
"[color=red]$24.99|"+
"200|"+
"Ziff-Davis",

"Teach Yourself JavaScript In A Week|"+
"Arman Damesh|"+
"[color=red]$35.99|"+
"100|"+
"Sams.net",

"Java Essentials\nFor C & C++ Programmers|"+
"Boone Barry|"+
"[color=red]$29.95|"+
"222|"+
"Addison-Wesley",

"The Java Programming Language|"+
"David H. Friedel, Jr.\n"+
"Anthony Potts|"+
"[color=red]$24.99|"+
"300|"+
"Coriolis Group Books",

"Java Programming for the Internet|"+
"Michael D. Thomas\n"+
"Pratik R. Patel\n"+
"Alan D. Hudson\n"+
"Donald A. Ball|"+
"[color=red]$49.95|"+
"760|"+
"Ventana Press",

"Writing Java Applets|"+
"John Rodley|"+
"[color=red]$39.99|"+
"450|"+
"Coriolis Group Books",

"Making Sense of Java:\nA Guide for Managers\nand the Rest of Us|"+
"Bruce Simpson\n"+
"John Mitchell\n"+
"Brian Christeson\n"+
"Rehan Zaidi\n"+
"Jonathan Levine|"+
"[color=red]$29.95|"+
"1500|"+
"Prentice Hall",

"Danny Goodman's JavaScript Handbook|"+
"Danny Goodman|"+
"[color=red]$34.99|"+
"544|"+
"IDG Books",

"JavaScript for the Macintosh|"+
"Matt Shobe\n"+
"Tim Ritchey|"+
"[color=red]$40.00|"+
"300|"+
"Hayden",

"Creating Cool Web Applets with Java|"+
"Paul J. Perry|"+
"[color=red]$29.99|"+
"300|"+
"IDG Books",

"JavaScript & Netscape 2 Wizardry|"+
"Dan Shafer|"+
"[color=red]$34.99|"+
"500|"+
"Coriolis Group Books",
};

JCMultiColumnList list = new JCMultiColumnList();

public void init() {
	// Force list to be same size as applet
	setLayout(new GridLayout(1,1));
	setBackground(Color.lightGray);

	list.getList().setBackground(Color.white);
	list.setVisibleRows(15);
	list.setSpacing(10);
	list.setRowHeight(BWTEnum.VARIABLE);
	for (int i=0; i < data.length; i++) 
		list.addItem(data[i], '|');
	list.setColumnButtons(column_labels);
	list.setColumnAlignments(alignments);
	list.getHeader().setColumnAlignments(alignments);
	add(list);
}

public Insets insets() {
	return new Insets(5,5,5,5);
}

public static void main(String args[]) {
	ContribFrame frame = new ContribFrame("MultiColumnList");
	multiColumnList l = new multiColumnList();
	l.init();

	frame.add(l);
	frame.pack();
	frame.show();
}
}

